/*
 * Decompiled with CFR 0.152.
 */
package com.jmupdf.pdf;

import com.jmupdf.JmuPdf;
import com.jmupdf.interfaces.DictionaryTypes;
import com.jmupdf.pdf.PdfDocument;
import java.io.File;

public class PdfInformation
extends JmuPdf
implements DictionaryTypes {
    private PdfDocument pdfDoc;
    private String fileName;
    private String path;
    private String title;
    private String author;
    private String producer;
    private String creator;
    private String subject;
    private String keywords;
    private String createdDate;
    private String modifiedDate;
    private String version;
    private String trapped;

    public PdfInformation(PdfDocument pdfDoc) {
        this.pdfDoc = pdfDoc;
        File pdfFile = new File(pdfDoc.getDocumentName());
        this.fileName = pdfFile.getName();
        this.path = pdfFile.getParent();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.pdfDoc.getInfo("Title");
        }
        return this.title;
    }

    public String getAuthor() {
        if (this.author == null) {
            this.author = this.pdfDoc.getInfo("Author");
        }
        return this.author;
    }

    public String getProducer() {
        if (this.producer == null) {
            this.producer = this.pdfDoc.getInfo("Producer");
        }
        return this.producer;
    }

    public String getCreator() {
        if (this.creator == null) {
            this.creator = this.pdfDoc.getInfo("Creator");
        }
        return this.creator;
    }

    public String getSubject() {
        if (this.subject == null) {
            this.subject = this.pdfDoc.getInfo("Subject");
        }
        return this.subject;
    }

    public String getKeywords() {
        if (this.keywords == null) {
            this.keywords = this.pdfDoc.getInfo("Keywords");
        }
        return this.keywords;
    }

    public String getCreatedDate() {
        if (this.createdDate == null) {
            this.createdDate = PdfInformation.convertDate(this.pdfDoc.getInfo("CreationDate"));
        }
        return this.createdDate;
    }

    public String getModifiedDate() {
        if (this.modifiedDate == null) {
            this.modifiedDate = PdfInformation.convertDate(this.pdfDoc.getInfo("ModDate"));
        }
        return this.modifiedDate;
    }

    public String getVersion() {
        if (this.version == null) {
            int v = PdfInformation.muPdfVersion(this.pdfDoc.getHandle());
            this.version = String.valueOf(v / 10) + "." + v % 10;
        }
        return this.version;
    }

    public String isTrapped() {
        String s;
        if (this.trapped == null && (s = this.pdfDoc.getInfo("Trapped")) == null) {
            this.trapped = "";
        }
        return this.trapped;
    }

    private static String convertDate(String pdfDate) {
        String value = null;
        if (pdfDate != null && pdfDate.trim().length() > 0) {
            String yy = pdfDate.substring(2, 6);
            String mm = pdfDate.substring(6, 8);
            String dd = pdfDate.substring(8, 10);
            int hh = Integer.valueOf(pdfDate.substring(10, 12));
            String mn = pdfDate.substring(12, 14);
            String ss = pdfDate.substring(14, 16);
            String ap = "AM";
            if (hh >= 12) {
                ap = "PM";
                if (hh > 12) {
                    hh -= 12;
                }
            }
            value = String.valueOf(mm) + "/" + dd + "/" + yy + " " + hh + ":" + mn + ":" + ss + " " + ap;
        }
        return value;
    }
}

