/*
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
#include <StubPreamble.h>
#include <javaString.h>

#include "CubbyHole.h"

long CubbyHole_get(struct HCubbyHole *this) {
    while (unhand(this)->available == 0) {
	monitorWait(obj_monitor(this));
    }
    unhand(this)->available = 0;
    monitorNotify(obj_monitor(this));
    return unhand(this)->seq;
}

void CubbyHole_put(struct HCubbyHole *this, long value) {
    while (unhand(this)->available > 0) {
        monitorWait(obj_monitor(this));
    }
    unhand(this)->seq = value;
    unhand(this)->available = 1;
    monitorNotify(obj_monitor(this));
}
