/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SplitPanePanel
extends JPanel {
    protected JSplitPane splitPane;
    protected GridComponent leftGrid;
    protected GridComponent rightGrid;
    protected SwingSet swing;

    public SplitPanePanel(SwingSet swingSet) {
        this.swing = swingSet;
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.createSplitPane();
        this.createInformationControls();
    }

    protected void createSplitPane() {
        this.leftGrid = new GridComponent(4);
        this.leftGrid.setPreferredSize(10);
        this.rightGrid = new GridComponent(4);
        this.rightGrid.setPreferredSize(10);
        this.splitPane = new JSplitPane(1, this.leftGrid, this.rightGrid);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setPreferredSize(new Dimension(400, 100));
        this.splitPane.getAccessibleContext().setAccessibleName("Split pane example");
        this.add((Component)this.splitPane, "Center");
    }

    protected void createInformationControls() {
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        Box box = new Box(0);
        jPanel.setLayout(new GridLayout(0, 1));
        JRadioButton jRadioButton = new JRadioButton("Vertically split");
        jRadioButton.setMnemonic('V');
        jRadioButton.addActionListener(new 1());
        buttonGroup.add(jRadioButton);
        box.add(jRadioButton);
        jRadioButton = new JRadioButton("Horizontally split");
        jRadioButton.setMnemonic('r');
        jRadioButton.setSelected(true);
        jRadioButton.addActionListener(new 2());
        buttonGroup.add(jRadioButton);
        box.add(jRadioButton);
        JCheckBox jCheckBox = new JCheckBox("Continuous Layout");
        jCheckBox.setMnemonic('C');
        jCheckBox.setSelected(true);
        jCheckBox.addChangeListener(new 3());
        box.add(jCheckBox);
        jCheckBox = new JCheckBox("One-Touch expandable");
        jCheckBox.setMnemonic('O');
        jCheckBox.setSelected(false);
        jCheckBox.addChangeListener(new 4());
        box.add(jCheckBox);
        jPanel.add(box);
        JTextField jTextField = new JTextField();
        jTextField.setText(new Integer(this.splitPane.getDividerSize()).toString());
        jTextField.setColumns(5);
        jTextField.getAccessibleContext().setAccessibleName("Divider Size");
        jTextField.addActionListener(new 5());
        JLabel jLabel = new JLabel("Divider Size");
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        jLabel.setLabelFor(jTextField);
        jLabel.setDisplayedMnemonic('z');
        jPanel.add(jPanel2);
        jTextField = new JTextField(String.valueOf(this.leftGrid.getPreferredSize().width));
        jTextField.setColumns(5);
        jTextField.getAccessibleContext().setAccessibleName("First Component minimum size");
        jTextField.addActionListener(new 6());
        jLabel = new JLabel("First Components Minimum Size");
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        jLabel.setLabelFor(jTextField);
        jLabel.setDisplayedMnemonic('i');
        jPanel.add(jPanel2);
        jTextField = new JTextField(String.valueOf(this.rightGrid.getPreferredSize().width));
        jTextField.setColumns(5);
        jTextField.getAccessibleContext().setAccessibleName("Second Component minimum size");
        jTextField.addActionListener(new 7());
        jLabel = new JLabel("Second Components Minimum Size");
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(jTextField);
        jLabel.setLabelFor(jTextField);
        jLabel.setDisplayedMnemonic('n');
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "South");
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SplitPanePanel.this.splitPane.setOrientation(0);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            SplitPanePanel.this.splitPane.setOrientation(1);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            SplitPanePanel.this.splitPane.setContinuousLayout(((JCheckBox)changeEvent.getSource()).isSelected());
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            SplitPanePanel.this.splitPane.setOneTouchExpandable(((JCheckBox)changeEvent.getSource()).isSelected());
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = ((JTextField)actionEvent.getSource()).getText();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n > 0) {
                SplitPanePanel.this.splitPane.setDividerSize(n);
                return;
            }
            JOptionPane.showMessageDialog(SplitPanePanel.this.splitPane, "Invalid Divider Size", "Error", 0);
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = ((JTextField)actionEvent.getSource()).getText();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n > 10) {
                SplitPanePanel.this.leftGrid.setPreferredSize(n);
                return;
            }
            JOptionPane.showMessageDialog(SplitPanePanel.this.splitPane, "Invalid Minimum Size, must be greater than 10", "Error", 0);
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = ((JTextField)actionEvent.getSource()).getText();
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = -1;
            }
            if (n > 10) {
                SplitPanePanel.this.rightGrid.setPreferredSize(n);
                return;
            }
            JOptionPane.showMessageDialog(SplitPanePanel.this.splitPane, "Invalid Minimum Size, must be greater than 10", "Error", 0);
        }

        /* synthetic */ 7() {
        }
    }
}

