/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import java.awt.Dimension;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameUI;

class MacDesktopManager
extends DefaultDesktopManager
implements Serializable {
    boolean isAdjusting = false;
    static final String maxProp = "MacInternalFrame.isMax";
    static final String preIconSizeProp = "MacInternalFrame.preIconSize";
    static final String prevSizeProp = "MacInternalFrame.prevSize";

    MacDesktopManager() {
    }

    public void beginResizingFrame(JComponent jComponent, int n) {
        super.beginResizingFrame(jComponent, n);
        jComponent.putClientProperty(maxProp, Boolean.FALSE);
    }

    public void deiconifyFrame(JInternalFrame jInternalFrame) {
        if (!this.isAdjusting) {
            Border border = UIManager.getBorder("InternalFrame.border");
            jInternalFrame.setBorder(border);
            Dimension dimension = (Dimension)jInternalFrame.getClientProperty(preIconSizeProp);
            if (dimension != null) {
                jInternalFrame.setSize(dimension);
            } else {
                jInternalFrame.pack();
            }
        }
    }

    void handleMax(JInternalFrame jInternalFrame) {
        if (jInternalFrame.getClientProperty(maxProp) != Boolean.TRUE) {
            if (!jInternalFrame.isIcon()) {
                jInternalFrame.putClientProperty(prevSizeProp, jInternalFrame.getSize());
            }
            jInternalFrame.pack();
            jInternalFrame.putClientProperty(maxProp, Boolean.TRUE);
        } else {
            Dimension dimension = (Dimension)jInternalFrame.getClientProperty(prevSizeProp);
            if (dimension != null) {
                jInternalFrame.setSize(dimension);
                jInternalFrame.putClientProperty(maxProp, Boolean.FALSE);
            }
        }
        jInternalFrame.setBorder(UIManager.getBorder("InternalFrame.border"));
        try {
            jInternalFrame.setIcon(false);
        }
        catch (Exception exception) {}
    }

    public void iconifyFrame(JInternalFrame jInternalFrame) {
        jInternalFrame.putClientProperty(preIconSizeProp, jInternalFrame.getSize());
        BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)jInternalFrame.getUI();
        JComponent jComponent = basicInternalFrameUI.getNorthPane();
        Dimension dimension = jComponent.getSize();
        Border border = UIManager.getBorder("InternalFrame.windowShadeBorder");
        Insets insets = border.getBorderInsets(jInternalFrame);
        dimension.height += insets.top + insets.bottom - 1;
        dimension.width += insets.left + insets.right - 2;
        jInternalFrame.setBorder(border);
        jInternalFrame.setSize(dimension);
    }

    public void maximizeFrame(JInternalFrame jInternalFrame) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.handleMax(jInternalFrame);
            try {
                jInternalFrame.setMaximum(false);
            }
            catch (Exception exception) {}
            this.isAdjusting = false;
        }
    }

    public void minimizeFrame(JInternalFrame jInternalFrame) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.handleMax(jInternalFrame);
            this.isAdjusting = false;
        }
    }
}

