/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacLookAndFeel;
import com.sun.java.swing.plaf.mac.MacScrollButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class MacScrollBarUI
extends BasicScrollBarUI {
    private static Color pressedThumbLightHighlightColor;
    private static Color pressedThumbHighlightColor;
    private static Color pressedThumbLightShadowColor;
    private static Color pressedThumbDarkShadowColor;
    private static Color pressedThumbColor;
    private static Color thumbLightHighlightColor;
    private static Color trackLightHighlightColor;
    private static Color trackShadowColor;
    private static Color trackDarkShadowColor;
    protected MacScrollButton increaseButton;
    protected MacScrollButton decreaseButton;
    protected int thumbLength;
    protected int scrollBarWidth;
    MouseListener thumbListener;
    boolean thumbPressed = false;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    protected void configureScrollBarColors() {
        thumbLightHighlightColor = UIManager.getColor("ScrollBar.thumbLightHighlight");
        this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        this.thumbLightShadowColor = UIManager.getColor("ScrollBar.thumbShadow");
        this.thumbDarkShadowColor = UIManager.getColor("ScrollBar.thumbDarkShadow");
        this.thumbColor = UIManager.getColor("ScrollBar.thumb");
        pressedThumbLightHighlightColor = UIManager.getColor("ScrollBar.pressedThumbLightHighlight");
        pressedThumbHighlightColor = UIManager.getColor("ScrollBar.pressedThumbHighlight");
        pressedThumbLightShadowColor = UIManager.getColor("ScrollBar.pressedThumbShadow");
        pressedThumbDarkShadowColor = UIManager.getColor("ScrollBar.pressedThumbDarkShadow");
        pressedThumbColor = UIManager.getColor("ScrollBar.pressedThumb");
        this.trackColor = UIManager.getColor("ScrollBar.track");
        this.trackHighlightColor = UIManager.getColor("ScrollBar.trackHighlight");
        trackLightHighlightColor = UIManager.getColor("ScrollBar.trackLightHighlight");
        trackShadowColor = UIManager.getColor("ScrollBar.trackShadow");
        trackDarkShadowColor = UIManager.getColor("ScrollBar.trackDarkShadow");
    }

    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new MacScrollButton(n, this.scrollBarWidth);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new MacScrollButton(n, this.scrollBarWidth);
        return this.increaseButton;
    }

    protected MouseListener createThumbListener() {
        return new ThumbListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MacScrollBarUI();
    }

    protected Dimension getMaximumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.thumbLength);
        }
        return new Dimension(this.thumbLength, this.scrollBarWidth);
    }

    protected Dimension getMinimumThumbSize() {
        return this.getMaximumThumbSize();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = this.scrollbar.getInsets();
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth + insets.left + insets.right, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth + insets.top + insets.bottom);
    }

    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        this.thumbLength = this.scrollBarWidth + 3;
        super.installDefaults();
        if (this.scrollbar.getBackground() == null || this.scrollbar.getBackground() instanceof UIResource) {
            this.scrollbar.setBackground(UIManager.getColor("ScrollBar.background"));
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.thumbListener = this.createThumbListener();
        if (this.thumbListener != null) {
            this.scrollbar.addMouseListener(this.thumbListener);
        }
    }

    JScrollBar macGetScrollBar() {
        return this.scrollbar;
    }

    Rectangle macGetThumbBounds() {
        return this.getThumbBounds();
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (this.scrollbar.isEnabled()) {
            int n;
            int n2 = this.scrollbar.getOrientation();
            int n3 = n2 == 1 ? rectangle.width : rectangle.width - 2;
            int n4 = n = n2 == 1 ? rectangle.height - 2 : rectangle.height;
            if (n2 == 1) {
                graphics.translate(rectangle.x, rectangle.y + 1);
            } else {
                graphics.translate(rectangle.x + 1, rectangle.y);
            }
            graphics.setColor(this.thumbPressed ? pressedThumbColor : this.thumbColor);
            graphics.fillRect(0, 0, n3, n);
            graphics.setColor(this.thumbPressed ? pressedThumbHighlightColor : this.thumbHighlightColor);
            graphics.drawLine(1, 0, n3 - 2, 0);
            graphics.drawLine(0, 1, 0, n - 2);
            graphics.setColor(this.thumbPressed ? pressedThumbLightShadowColor : this.thumbLightShadowColor);
            graphics.drawLine(1, n - 1, n3 - 1, n - 1);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n - 1);
            graphics.setColor(this.thumbPressed ? pressedThumbLightHighlightColor : thumbLightHighlightColor);
            graphics.drawLine(0, 0, 0, 0);
            if (n2 == 1) {
                graphics.drawLine(3, 3, 3, 3);
                graphics.drawLine(3, 5, 3, 5);
                graphics.drawLine(3, 7, 3, 7);
                graphics.drawLine(3, 9, 3, 9);
                graphics.setColor(this.thumbPressed ? pressedThumbHighlightColor : this.thumbHighlightColor);
                graphics.drawLine(4, 3, 9, 3);
                graphics.drawLine(4, 5, 9, 5);
                graphics.drawLine(4, 7, 9, 7);
                graphics.drawLine(4, 9, 9, 9);
                graphics.setColor(this.thumbPressed ? pressedThumbDarkShadowColor : this.thumbDarkShadowColor);
                graphics.drawLine(4, 4, 10, 4);
                graphics.drawLine(4, 6, 10, 6);
                graphics.drawLine(4, 8, 10, 8);
                graphics.drawLine(4, 10, 10, 10);
                graphics.setColor(MacLookAndFeel.getBlack());
                graphics.drawLine(0, -1, n3 - 1, -1);
                graphics.drawLine(0, n, n3 - 1, n);
            } else {
                graphics.drawLine(3, 3, 3, 3);
                graphics.drawLine(5, 3, 5, 3);
                graphics.drawLine(7, 3, 7, 3);
                graphics.drawLine(9, 3, 9, 3);
                graphics.setColor(this.thumbPressed ? pressedThumbHighlightColor : this.thumbHighlightColor);
                graphics.drawLine(3, 4, 3, 9);
                graphics.drawLine(5, 4, 5, 9);
                graphics.drawLine(7, 4, 7, 9);
                graphics.drawLine(9, 4, 9, 9);
                graphics.setColor(this.thumbPressed ? pressedThumbDarkShadowColor : this.thumbDarkShadowColor);
                graphics.drawLine(4, 4, 4, 10);
                graphics.drawLine(6, 4, 6, 10);
                graphics.drawLine(8, 4, 8, 10);
                graphics.drawLine(10, 4, 10, 10);
                graphics.setColor(MacLookAndFeel.getBlack());
                graphics.drawLine(-1, 0, -1, n - 1);
                graphics.drawLine(n3, 0, n3, n - 1);
            }
            if (n2 == 1) {
                graphics.translate(-rectangle.x, -(rectangle.y + 1));
            } else {
                graphics.translate(-(rectangle.x + 1), -rectangle.y);
            }
        }
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!this.scrollbar.isEnabled()) {
            graphics.setColor(MacLookAndFeel.getGray0());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        int n = this.scrollbar.getOrientation();
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        Rectangle rectangle2 = this.getThumbBounds();
        int n4 = rectangle2.y + rectangle2.height - 1 - rectangle.y;
        int n5 = rectangle2.x + rectangle2.width - 1 - rectangle.x;
        graphics.translate(rectangle.x, rectangle.y);
        graphics.setColor(this.trackColor);
        graphics.fillRect(0, 0, n2, n3);
        if (n == 1) {
            graphics.setColor(MacLookAndFeel.getBlack());
            graphics.drawLine(0, 0, n2 - 1, 0);
            graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
            graphics.setColor(trackLightHighlightColor);
            graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 2);
            graphics.setColor(this.trackHighlightColor);
            graphics.drawLine(n2 - 2, 2, n2 - 2, n3 - 2);
            graphics.setColor(trackShadowColor);
            graphics.drawLine(1, 2, n2 - 3, 2);
            graphics.drawLine(1, 2, 1, n3 - 2);
            graphics.drawLine(1, n4 + 2, n2 - 3, n4 + 2);
            graphics.setColor(trackDarkShadowColor);
            graphics.drawLine(0, 1, n2 - 2, 1);
            graphics.drawLine(0, 1, 0, n3 - 2);
            graphics.drawLine(0, n4 + 1, n2 - 2, n4 + 1);
        } else {
            graphics.setColor(MacLookAndFeel.getBlack());
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 1);
            graphics.setColor(trackLightHighlightColor);
            graphics.drawLine(1, n3 - 1, n2 - 2, n3 - 1);
            graphics.setColor(this.trackHighlightColor);
            graphics.drawLine(2, n3 - 2, n2 - 2, n3 - 2);
            graphics.setColor(trackShadowColor);
            graphics.drawLine(2, 1, n2 - 2, 1);
            graphics.drawLine(2, 1, 2, n3 - 3);
            graphics.drawLine(n5 + 2, 1, n5 + 2, n3 - 3);
            graphics.setColor(trackDarkShadowColor);
            graphics.drawLine(1, 0, 1, n3 - 2);
            graphics.drawLine(1, 0, n2 - 2, 0);
            graphics.drawLine(n5 + 1, 0, n5 + 1, n3 - 2);
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        if (this.thumbRect.x == n && this.thumbRect.y == n2 && this.thumbRect.width == n3 && this.thumbRect.height == n4) {
            return;
        }
        int n5 = Math.min(n, this.thumbRect.x);
        int n6 = Math.min(n2, this.thumbRect.y);
        int n7 = Math.max(n + n3, this.thumbRect.x + this.thumbRect.width);
        int n8 = Math.max(n2 + n4, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(n, n2, n3, n4);
        this.scrollbar.repaint(n5, n6, n7 - n5 + 3, n8 - n6 + 3);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.thumbListener != null) {
            this.scrollbar.removeMouseListener(this.thumbListener);
        }
    }

    class ThumbListener
    extends MouseAdapter {
        ThumbListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (MacScrollBarUI.this.macGetThumbBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
                MacScrollBarUI.this.thumbPressed = true;
                MacScrollBarUI.this.macGetScrollBar().repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MacScrollBarUI.this.thumbPressed = false;
            MacScrollBarUI.this.macGetScrollBar().repaint();
        }
    }
}

