/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;

public class Stylepad
extends Notepad {
    private static ResourceBundle resources;
    static final JTextComponent.KeyBinding[] hebrewBindings;
    static final Action[] hebrewActions;
    static final JTextComponent.KeyBinding[] arabicBindings;
    static final Action[] arabicActions;

    public static void main(String[] stringArray) {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.1.2") < 0) {
            System.out.println("!!!WARNING: Swing must be run with a 1.1.2 or higher version VM!!!");
        }
        JFrame jFrame = new JFrame();
        jFrame.setTitle(resources.getString("Title"));
        ((Component)jFrame).setBackground(Color.lightGray);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add("Center", new Stylepad());
        jFrame.addWindowListener(new Notepad.AppCloser());
        jFrame.pack();
        ((Component)jFrame).setSize(600, 480);
        jFrame.show();
    }

    public Action[] getActions() {
        Action[] actionArray = new Action[]{new NewAction(), new OpenAction(), new SaveAction(), new ChangeKeymapAction("English"), new ChangeKeymapAction("Hebrew"), new ChangeKeymapAction("Arabic")};
        Action[] actionArray2 = TextAction.augmentList(super.getActions(), actionArray);
        actionArray2 = TextAction.augmentList(actionArray2, hebrewActions);
        actionArray2 = TextAction.augmentList(actionArray2, arabicActions);
        return actionArray2;
    }

    protected String getResourceString(String string) {
        String string2;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = super.getResourceString(string);
        }
        return string2;
    }

    protected JTextComponent createEditor() {
        StyleContext styleContext = new StyleContext();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument(styleContext);
        this.initDocument(defaultStyledDocument, styleContext);
        JTextPane jTextPane = new JTextPane(defaultStyledDocument);
        Keymap keymap = jTextPane.getKeymap();
        Keymap keymap2 = JTextComponent.addKeymap("English", keymap);
        Keymap keymap3 = JTextComponent.addKeymap("Hebrew", keymap);
        JTextComponent.loadKeymap(keymap3, hebrewBindings, hebrewActions);
        Keymap keymap4 = JTextComponent.addKeymap("Arabic", keymap);
        JTextComponent.loadKeymap(keymap4, arabicBindings, arabicActions);
        jTextPane.setKeymap(keymap2);
        return jTextPane;
    }

    protected JMenu createMenu(String string) {
        if (string.equals("color")) {
            return this.createColorMenu();
        }
        return super.createMenu(string);
    }

    JMenu createColorMenu() {
        JMenu jMenu = new JMenu(this.getResourceString("colorLabel"));
        JMenuItem jMenuItem = new JMenuItem(resources.getString("Red"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setIcon(new ColoredSquare(Color.red));
        StyledEditorKit.ForegroundAction foregroundAction = new StyledEditorKit.ForegroundAction("set-foreground-red", Color.red);
        jMenuItem.addActionListener(foregroundAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resources.getString("Green"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setIcon(new ColoredSquare(Color.green));
        foregroundAction = new StyledEditorKit.ForegroundAction("set-foreground-green", Color.green);
        jMenuItem.addActionListener(foregroundAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(resources.getString("Blue"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setIcon(new ColoredSquare(Color.blue));
        foregroundAction = new StyledEditorKit.ForegroundAction("set-foreground-blue", Color.blue);
        jMenuItem.addActionListener(foregroundAction);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    void initDocument(DefaultStyledDocument defaultStyledDocument, StyleContext styleContext) {
        Wonderland wonderland = new Wonderland(defaultStyledDocument, styleContext);
        new ImageIcon(resources.getString("aliceGif"));
        wonderland.loadDocument();
    }

    JComboBox createFamilyChoices() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        String[] stringArray = this.getToolkit().getFontList();
        int n = 0;
        while (n < stringArray.length) {
            jComboBox.addItem(stringArray[n]);
            ++n;
        }
        return jComboBox;
    }

    static {
        try {
            resources = ResourceBundle.getBundle("resources.Stylepad", Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Stylepad.properties not found");
            System.exit(0);
        }
        hebrewBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('a'), "insert-me \u05e9"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('b'), "insert-me \u05e0"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('c'), "insert-me \u05d1"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('d'), "insert-me \u05d2"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('e'), "insert-me \u05e7"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('f'), "insert-me \u05db"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('g'), "insert-me \u05e2"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('h'), "insert-me \u05d9"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('i'), "insert-me \u05df"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('j'), "insert-me \u05d7"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('k'), "insert-me \u05dc"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('l'), "insert-me \u05da"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('m'), "insert-me \u05e6"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('n'), "insert-me \u05de"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('o'), "insert-me \u05dd"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('p'), "insert-me \u05e4"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('q'), "insert-me /"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('r'), "insert-me \u05e8"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('s'), "insert-me \u05d3"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('t'), "insert-me \u05d0"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('u'), "insert-me \u05d5"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('v'), "insert-me \u05d4"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('w'), "insert-me '"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('x'), "insert-me \u05e1"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('y'), "insert-me \u05d8"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('z'), "insert-me \u05d6")};
        hebrewActions = new Action[]{new InsertMeAction("\u05d6"), new InsertMeAction("\u05d8"), new InsertMeAction("\u05e1"), new InsertMeAction("'"), new InsertMeAction("\u05d4"), new InsertMeAction("\u05d5"), new InsertMeAction("\u05d0"), new InsertMeAction("\u05d3"), new InsertMeAction("\u05e8"), new InsertMeAction("/"), new InsertMeAction("\u05e4"), new InsertMeAction("\u05dd"), new InsertMeAction("\u05de"), new InsertMeAction("\u05e6"), new InsertMeAction("\u05da"), new InsertMeAction("\u05dc"), new InsertMeAction("\u05d7"), new InsertMeAction("\u05df"), new InsertMeAction("\u05d9"), new InsertMeAction("\u05e2"), new InsertMeAction("\u05db"), new InsertMeAction("\u05e7"), new InsertMeAction("\u05d2"), new InsertMeAction("\u05d1"), new InsertMeAction("\u05e0"), new InsertMeAction("\u05e9")};
        arabicBindings = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('a'), "insert-me \u0634"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('b'), "insert-me \u0644\u0627"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('c'), "insert-me \u0624"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('d'), "insert-me \u064a"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('e'), "insert-me \u062b"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('f'), "insert-me \u0628"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('g'), "insert-me \u0644"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('h'), "insert-me \u0627"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('i'), "insert-me \u0647"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('j'), "insert-me \u062a"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('k'), "insert-me \u0646"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('l'), "insert-me \u0645"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('m'), "insert-me \u0629"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('n'), "insert-me \u0649"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('o'), "insert-me \u062e"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('p'), "insert-me \u062d"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('q'), "insert-me \u0636"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('r'), "insert-me \u0642"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('s'), "insert-me \u0633"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('t'), "insert-me \u0641"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('u'), "insert-me \u0639"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('v'), "insert-me \u0631"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('w'), "insert-me \u0635"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('x'), "insert-me \u0621"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('y'), "insert-me \u063a"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke('z'), "insert-me \u0626")};
        arabicActions = new Action[]{new InsertMeAction("\u0634"), new InsertMeAction("\u0644\u0627"), new InsertMeAction("\u0624"), new InsertMeAction("\u064a"), new InsertMeAction("\u062b"), new InsertMeAction("\u0628"), new InsertMeAction("\u0644"), new InsertMeAction("\u0627"), new InsertMeAction("\u0647"), new InsertMeAction("\u062a"), new InsertMeAction("\u0646"), new InsertMeAction("\u0645"), new InsertMeAction("\u0629"), new InsertMeAction("\u0649"), new InsertMeAction("\u062e"), new InsertMeAction("\u062d"), new InsertMeAction("\u0636"), new InsertMeAction("\u0642"), new InsertMeAction("\u0633"), new InsertMeAction("\u0641"), new InsertMeAction("\u0639"), new InsertMeAction("\u0631"), new InsertMeAction("\u0635"), new InsertMeAction("\u0621"), new InsertMeAction("\u063a"), new InsertMeAction("\u0626")};
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super("open");
            Stylepad.this = Stylepad.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = Stylepad.this.getFrame();
            if (Stylepad.this.fileDialog == null) {
                Stylepad.this.fileDialog = new FileDialog(frame);
            }
            Stylepad.this.fileDialog.setMode(0);
            Stylepad.this.fileDialog.show();
            String string = Stylepad.this.fileDialog.getFile();
            if (string == null) {
                return;
            }
            String string2 = Stylepad.this.fileDialog.getDirectory();
            File file = new File(string2, string);
            if (file.exists()) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                    Document document = (Document)objectInputStream.readObject();
                    Stylepad.this.getEditor().setDocument(document);
                    frame.setTitle(string);
                    Stylepad.this.validate();
                    return;
                }
                catch (IOException iOException) {
                    System.err.println("IOException: " + iOException.getMessage());
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Class not found: " + classNotFoundException.getMessage());
                    return;
                }
            }
            System.err.println("No such file: " + file);
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("save");
            Stylepad.this = Stylepad.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = Stylepad.this.getFrame();
            if (Stylepad.this.fileDialog == null) {
                Stylepad.this.fileDialog = new FileDialog(frame);
            }
            Stylepad.this.fileDialog.setMode(1);
            Stylepad.this.fileDialog.show();
            String string = Stylepad.this.fileDialog.getFile();
            if (string == null) {
                return;
            }
            String string2 = Stylepad.this.fileDialog.getDirectory();
            File file = new File(string2, string);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(Stylepad.this.getEditor().getDocument());
                objectOutputStream.flush();
                return;
            }
            catch (IOException iOException) {
                System.err.println("IOException: " + iOException.getMessage());
                return;
            }
        }
    }

    class NewAction
    extends AbstractAction {
        NewAction() {
            super("new");
            Stylepad.this = Stylepad.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Stylepad.this.getEditor().getDocument() != null) {
                Stylepad.this.getEditor().getDocument().removeUndoableEditListener(Stylepad.this.undoHandler);
            }
            Stylepad.this.getEditor().setDocument(new DefaultStyledDocument());
            Stylepad.this.getEditor().getDocument().addUndoableEditListener(Stylepad.this.undoHandler);
            Stylepad.this.validate();
        }
    }

    class ColoredSquare
    implements Icon {
        Color color;

        public ColoredSquare(Color color) {
            Stylepad.this = Stylepad.this;
            this.color = color;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            graphics.fill3DRect(n, n2, this.getIconWidth(), this.getIconHeight(), true);
            graphics.setColor(color);
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }
    }

    static class ChangeKeymapAction
    extends TextAction {
        private String keymapName;

        public ChangeKeymapAction(String string) {
            super("change-keymap-" + string);
            this.keymapName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Keymap keymap;
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null && (keymap = JTextComponent.getKeymap(this.keymapName)) != null) {
                jTextComponent.setKeymap(keymap);
            }
        }
    }

    static class InsertMeAction
    extends TextAction {
        private String s;

        public InsertMeAction(String string) {
            super("insert-me " + string);
            this.s = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                jTextComponent.replaceSelection(this.s);
            }
        }
    }
}

