/*
 * @(#)MacTextFieldUI.java	1.1 99/01/08
 *
 * Copyright 1997, 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * Mac look and feel for a JTextField.
 *
 * @version 1.1 01/08/99
 * @author Steve Wilson
 */
public class MacTextFieldUI extends BasicTextFieldUI {

	FocusListener macFocusHandler;

	/**
	 * Creates a UI for a JTextField.
	 *
	 * @param c the text field
	 * @return the UI
	 */
	public static ComponentUI createUI(JComponent c) {
		return new MacTextFieldUI();
	}

	/**
	 * Creates a new MacTextFieldUI.
	 */
	public MacTextFieldUI() {
		super();
	}

	protected void installListeners() {
		macFocusHandler = new MacFocusHandler();
		getComponent().addFocusListener(macFocusHandler);
	}

	protected void uninstallListeners() {
		getComponent().removeFocusListener(macFocusHandler);
	}

   // gross hack for compiler protected bug yuck!
   protected JTextComponent myGetCompontent() {
      return getComponent();
   }


	class MacFocusHandler implements FocusListener {
		public void focusGained(FocusEvent e) {
			myGetCompontent().repaint();
		}

		public void focusLost(FocusEvent e) {
			myGetCompontent().repaint();
		}

	}
}
