/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.parser;

import org.w3c.css.sac.LexicalUnit;

public abstract class CSSLexicalUnit
implements LexicalUnit {
    protected short lexicalUnitType;
    protected LexicalUnit nextLexicalUnit;
    protected LexicalUnit previousLexicalUnit;

    protected CSSLexicalUnit(short s2, LexicalUnit lexicalUnit) {
        this.lexicalUnitType = s2;
        this.previousLexicalUnit = lexicalUnit;
        if (lexicalUnit != null) {
            ((CSSLexicalUnit)lexicalUnit).nextLexicalUnit = this;
        }
    }

    public static CSSLexicalUnit createDimension(float f2, String string, LexicalUnit lexicalUnit) {
        return new DimensionLexicalUnit(f2, string, lexicalUnit);
    }

    public static CSSLexicalUnit createFloat(short s2, float f2, LexicalUnit lexicalUnit) {
        return new FloatLexicalUnit(s2, f2, lexicalUnit);
    }

    public static CSSLexicalUnit createFunction(String string, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new FunctionLexicalUnit(string, lexicalUnit, lexicalUnit2);
    }

    public static CSSLexicalUnit createInteger(int n2, LexicalUnit lexicalUnit) {
        return new IntegerLexicalUnit(n2, lexicalUnit);
    }

    public static CSSLexicalUnit createPredefinedFunction(short s2, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new PredefinedFunctionLexicalUnit(s2, lexicalUnit, lexicalUnit2);
    }

    public static CSSLexicalUnit createSimple(short s2, LexicalUnit lexicalUnit) {
        return new SimpleLexicalUnit(s2, lexicalUnit);
    }

    public static CSSLexicalUnit createString(short s2, String string, LexicalUnit lexicalUnit) {
        return new StringLexicalUnit(s2, string, lexicalUnit);
    }

    public String getDimensionUnitText() {
        throw new IllegalStateException();
    }

    public float getFloatValue() {
        throw new IllegalStateException();
    }

    public String getFunctionName() {
        throw new IllegalStateException();
    }

    public int getIntegerValue() {
        throw new IllegalStateException();
    }

    public short getLexicalUnitType() {
        return this.lexicalUnitType;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    public LexicalUnit getParameters() {
        throw new IllegalStateException();
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    public String getStringValue() {
        throw new IllegalStateException();
    }

    public LexicalUnit getSubValues() {
        throw new IllegalStateException();
    }

    public void setNextLexicalUnit(LexicalUnit lexicalUnit) {
        this.nextLexicalUnit = lexicalUnit;
    }

    public void setPreviousLexicalUnit(LexicalUnit lexicalUnit) {
        this.previousLexicalUnit = lexicalUnit;
    }

    protected static class SimpleLexicalUnit
    extends CSSLexicalUnit {
        public SimpleLexicalUnit(short s2, LexicalUnit lexicalUnit) {
            super(s2, lexicalUnit);
        }
    }

    protected static class IntegerLexicalUnit
    extends CSSLexicalUnit {
        protected int value;

        public IntegerLexicalUnit(int n2, LexicalUnit lexicalUnit) {
            super((short)13, lexicalUnit);
            this.value = n2;
        }

        public int getIntegerValue() {
            return this.value;
        }
    }

    protected static class FloatLexicalUnit
    extends CSSLexicalUnit {
        protected float value;

        public FloatLexicalUnit(short s2, float f2, LexicalUnit lexicalUnit) {
            super(s2, lexicalUnit);
            this.value = f2;
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    protected static class DimensionLexicalUnit
    extends CSSLexicalUnit {
        protected float value;
        protected String dimension;

        public DimensionLexicalUnit(float f2, String string, LexicalUnit lexicalUnit) {
            super((short)42, lexicalUnit);
            this.value = f2;
            this.dimension = string;
        }

        public String getDimensionUnitText() {
            return this.dimension;
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    protected static class FunctionLexicalUnit
    extends CSSLexicalUnit {
        protected String name;
        protected LexicalUnit parameters;

        public FunctionLexicalUnit(String string, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
            super((short)41, lexicalUnit2);
            this.name = string;
            this.parameters = lexicalUnit;
        }

        public String getFunctionName() {
            return this.name;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class PredefinedFunctionLexicalUnit
    extends CSSLexicalUnit {
        protected LexicalUnit parameters;

        public PredefinedFunctionLexicalUnit(short s2, LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
            super(s2, lexicalUnit2);
            this.parameters = lexicalUnit;
        }

        public LexicalUnit getParameters() {
            return this.parameters;
        }
    }

    protected static class StringLexicalUnit
    extends CSSLexicalUnit {
        protected String value;

        public StringLexicalUnit(short s2, String string, LexicalUnit lexicalUnit) {
            super(s2, lexicalUnit);
            this.value = string;
        }

        public String getStringValue() {
            return this.value;
        }
    }
}

