/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import electric.util.encoding.Encodings;
import electric.util.log.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class Streams {
    private static final int CHUNK_SIZE = 10000;
    private static final byte[] NO_BYTES = new byte[0];

    public static Reader getReader(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = Streams.readUpTo((InputStream)fileInputStream, 100);
        fileInputStream.close();
        String string = Encodings.getJavaEncoding(byArray);
        return new InputStreamReader((InputStream)new FileInputStream(file), string);
    }

    public static Reader getReader(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(100);
        byte[] byArray = Streams.readUpTo(inputStream, 100);
        inputStream.reset();
        String string = Encodings.getJavaEncoding(byArray);
        return new InputStreamReader(inputStream, string);
    }

    public static Writer getWriter(File file, String string) throws IOException, UnsupportedEncodingException {
        return Streams.getWriter(new FileOutputStream(file), string);
    }

    public static Writer getWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        string = Encodings.getJavaEncoding(string);
        return new OutputStreamWriter(outputStream, string);
    }

    public static byte[] readFully(File file) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        return byArray;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        Streams.readFully(inputStream, byArray, n, n2, -1L);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2, long l) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException("expected " + n2 + " bytes of content, got " + n3);
            }
            if (l > -1L && Log.isLogging((long)l)) {
                Log.log((long)l, (Object)new String(byArray, n + n3, n4));
            }
            n3 += n4;
        }
    }

    public static byte[] readFully(InputStream inputStream, int n) throws IOException {
        return Streams.readFully(inputStream, n, -1L);
    }

    public static byte[] readFully(InputStream inputStream, int n, long l) throws IOException {
        if (n == -1) {
            return Streams.readFully(inputStream, l);
        }
        if (n == 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        Streams.readFully(inputStream, byArray, 0, n, l);
        return byArray;
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        return Streams.readFully(inputStream, -1L);
    }

    public static byte[] readFully(InputStream inputStream, long l) throws IOException {
        int n;
        byte[] byArray = new byte[10000];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byArray = byteArrayOutputStream.toByteArray();
        if (l > -1L && Log.isLogging((long)l)) {
            Log.log((long)l, (Object)new String(byArray));
        }
        return byArray;
    }

    public static int readUpTo(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) break;
            n3 += n4;
        }
        return n3;
    }

    public static byte[] readUpTo(InputStream inputStream, int n) throws IOException {
        if (n <= 0) {
            return NO_BYTES;
        }
        byte[] byArray = new byte[n];
        int n2 = Streams.readUpTo(inputStream, byArray, 0, n);
        if (n2 < n) {
            byte[] byArray2 = byArray;
            byArray = new byte[n2];
            System.arraycopy(byArray2, 0, byArray, 0, n2);
        }
        return byArray;
    }

    public static byte[] readUpTo(InputStream inputStream, byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.copy(inputStream, (OutputStream)byteArrayOutputStream, byArray, -1L);
        return byteArrayOutputStream.toByteArray();
    }

    public static String readLine(InputStream inputStream) throws IOException {
        return Streams.readLine(inputStream, Encodings.getSystemEncoding());
    }

    public static String readLine(InputStream inputStream, String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        boolean bl = false;
        int n;
        while ((n = inputStream.read()) != -1) {
            if (n == 13) {
                n = inputStream.read();
                if (n == 10) {
                    return new String(byteArrayOutputStream.toByteArray(), string);
                }
                byteArrayOutputStream.write(13);
                byteArrayOutputStream.write(n);
                continue;
            }
            if (n == 10) {
                return new String(byteArrayOutputStream.toByteArray(), string);
            }
            byteArrayOutputStream.write(n);
        }
        return !bl ? null : new String(byteArrayOutputStream.toByteArray(), string);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n, int n2, long l) throws IOException {
        int n3;
        int n4;
        byte[] byArray = new byte[n == -1 ? n2 : Math.min(n2, n)];
        int n5 = 0;
        while ((n4 = Streams.readUpTo(inputStream, byArray, 0, n3 = n == -1 ? n2 : Math.min(n2, n - n5))) != 0) {
            if (l > -1L && Log.isLogging((long)l)) {
                Log.log((long)l, (Object)new String(byArray, 0, n4));
            }
            outputStream.write(byArray, 0, n4);
            if (n == -1 || (n5 += n4) < n) continue;
            break;
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, int n, int n2) throws IOException {
        Streams.copy(inputStream, outputStream, n, n2, -1L);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, byte[] byArray, long l) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        byte by = byArray[0];
        block0: while (true) {
            int n;
            if ((n = inputStream.read()) != by) {
                outputStreamWriter.write(n);
                continue;
            }
            int n2 = 1;
            while (n2 < byArray.length) {
                n = inputStream.read();
                if (n != byArray[n2]) {
                    int n3 = 0;
                    while (n3 < byArray.length) {
                        outputStreamWriter.write(byArray[n3]);
                        ++n3;
                    }
                    outputStreamWriter.write(n);
                    continue block0;
                }
                ++n2;
            }
            break;
        }
        outputStreamWriter.flush();
    }
}

