/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.BorderArrangement;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.title.Title;
import org.jfree.ui.Size2D;

public class CompositeTitle
extends Title {
    private BlockContainer container;

    public CompositeTitle() {
        this(new BlockContainer(new BorderArrangement()));
    }

    public CompositeTitle(BlockContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("Null 'container' argument.");
        }
        this.container = container;
    }

    public BlockContainer getContainer() {
        return this.container;
    }

    public void setTitleContainer(BlockContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("Null 'container' argument.");
        }
        this.container = container;
    }

    public Size2D arrange(Graphics2D g2, RectangleConstraint constraint) {
        RectangleConstraint contentConstraint = this.toContentConstraint(constraint);
        return this.container.arrange(g2, contentConstraint);
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        area = this.trimMargin(area);
        this.drawBorder(g2, area);
        area = this.trimBorder(area);
        area = this.trimPadding(area);
        this.container.draw(g2, area);
    }
}

