/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.beans;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CDigitalClock
extends JComponent {
    private ClockThread clockThread = new ClockThread();
    private String delimiter = ":";
    private boolean showDate = true;

    public CDigitalClock() {
        this.clockThread.start();
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public void setShowDate(boolean bl) {
        this.showDate = bl;
        this.repaint();
    }

    private Font findFont(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics;
        int n3 = 6;
        Font font = new Font(this.getFont().getName(), this.getFont().getStyle(), n3);
        while ((fontMetrics = graphics.getFontMetrics(font)).getHeight() <= n2 && fontMetrics.stringWidth(string) <= n) {
            font = new Font(this.getFont().getName(), this.getFont().getStyle(), ++n3);
        }
        return font;
    }

    public void paint(Graphics graphics) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        double d = this.showDate ? 0.5 : 0.8;
        Dimension dimension = this.getSize();
        graphics.clearRect(0, 0, dimension.width, dimension.height);
        simpleDateFormat.applyPattern("HH" + this.delimiter + "mm");
        String string = simpleDateFormat.format(gregorianCalendar.getTime());
        Font font = this.findFont(graphics, string, (int)(dimension.getWidth() * 0.8), (int)(dimension.getHeight() * d));
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = (dimension.width - fontMetrics.stringWidth(string)) / 2;
        int n2 = (int)((dimension.getHeight() * d - (double)fontMetrics.getHeight()) / 2.0 + dimension.getHeight() * 0.1) + fontMetrics.getAscent();
        graphics.setFont(font);
        graphics.drawString(string, n, n2);
        if (this.showDate) {
            simpleDateFormat.applyPattern("EEEE, dd MMMM yyyy");
            String string2 = simpleDateFormat.format(gregorianCalendar.getTime());
            font = this.findFont(graphics, string2, (int)(dimension.getWidth() * 0.8), (int)(dimension.getHeight() * 0.3));
            fontMetrics = graphics.getFontMetrics(font);
            n = (dimension.width - fontMetrics.stringWidth(string2)) / 2;
            n2 = (int)((dimension.getHeight() * 0.3 - (double)fontMetrics.getHeight()) / 2.0 + dimension.getHeight() * 0.6) + fontMetrics.getAscent();
            graphics.setFont(font);
            graphics.drawString(string2, n, n2);
        }
    }

    public static void main(String[] stringArray) {
        CDigitalClock cDigitalClock = new CDigitalClock();
        JFrame jFrame = new JFrame("Digital Clock");
        jFrame.setContentPane(cDigitalClock);
        jFrame.setDefaultCloseOperation(3);
        ((Component)jFrame).setSize(300, 300);
        ((Component)jFrame).setLocation(300, 300);
        jFrame.show();
    }

    private class ClockThread
    extends Thread {
        private ClockThread() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        CDigitalClock.this.delimiter = CDigitalClock.this.delimiter != ":" ? ":" : " ";
                        CDigitalClock.this.repaint();
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

