/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.db.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import org.comedia.db.view.CTableBox;
import org.comedia.ui.CEncodedIcon;

public class CTableLink
extends JComponent
implements FocusListener,
MouseListener {
    public static final int NORMAL_LINK = 0;
    public static final int JOIN_LINK = 1;
    public static final int UNKNOWN_RELATION = 0;
    public static final int ONE_RELATION = 1;
    public static final int MANY_RELATION = 2;
    private CTableBox leftTable = null;
    private CTableBox rightTable = null;
    private int leftFieldIndex = -1;
    private int rightFieldIndex = -1;
    private int leftLinkType = 0;
    private int rightLinkType = 0;
    private int leftRelation = 0;
    private int rightRelation = 0;
    private Point leftStart = new Point();
    private Point leftEnd = new Point();
    private Point rightStart = new Point();
    private Point rightEnd = new Point();
    private boolean draw = false;
    private boolean updated = false;
    private static final int LINE_SIZE = 17;
    private static final int MAX_DIST = 3;

    public CTableLink() {
        this.setSize(65, 65);
        this.setForeground(Color.gray);
        this.setOpaque(false);
        this.setRequestFocusEnabled(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public CTableBox getLeftTable() {
        return this.leftTable;
    }

    public void setLeftTable(CTableBox cTableBox) {
        if (this.leftTable != cTableBox) {
            if (this.leftTable != null) {
                this.leftTable.removeLink(this);
            }
            this.leftTable = cTableBox;
            if (cTableBox != null) {
                cTableBox.addLink(this);
            }
            this.updated = false;
            this.updateShape();
        }
    }

    public CTableBox getRightTable() {
        return this.rightTable;
    }

    public void setRightTable(CTableBox cTableBox) {
        if (this.rightTable != cTableBox) {
            if (this.rightTable != null) {
                this.rightTable.removeLink(this);
            }
            this.rightTable = cTableBox;
            if (cTableBox != null) {
                cTableBox.addLink(this);
            }
            this.updated = false;
            this.updateShape();
        }
    }

    public int getLeftFieldIndex() {
        return this.leftFieldIndex;
    }

    public void setLeftFieldIndex(int n) {
        if (this.leftFieldIndex != n) {
            this.leftFieldIndex = n;
            this.updateShape();
        }
    }

    public int getRightFieldIndex() {
        return this.rightFieldIndex;
    }

    public void setRightFieldIndex(int n) {
        if (this.rightFieldIndex != n) {
            this.rightFieldIndex = n;
            this.updateShape();
        }
    }

    public int getLeftLinkType() {
        return this.leftLinkType;
    }

    public void setLeftLinkType(int n) {
        if (this.leftLinkType != n) {
            this.leftLinkType = n;
            this.repaint();
        }
    }

    public int getRightLinkType() {
        return this.rightLinkType;
    }

    public void setRightLinkType(int n) {
        if (this.rightLinkType != n) {
            this.rightLinkType = n;
            this.repaint();
        }
    }

    public int getLeftRelation() {
        return this.leftRelation;
    }

    public void setLeftRelation(int n) {
        if (this.leftRelation != n) {
            this.leftRelation = n;
            this.repaint();
        }
    }

    public int getRightRelation() {
        return this.rightRelation;
    }

    private void setSelectedColor(boolean bl) {
        if (bl) {
            this.setForeground(Color.black);
        } else {
            this.setForeground(Color.gray);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setSelectedColor(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setSelectedColor(false);
    }

    public void setRightRelation(int n) {
        if (this.rightRelation != n) {
            this.rightRelation = n;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.draw) {
            CEncodedIcon cEncodedIcon;
            graphics.setColor(this.getForeground());
            graphics.drawLine(this.leftStart.x, this.leftStart.y - 1, this.leftEnd.x, this.leftEnd.y - 1);
            graphics.drawLine(this.leftStart.x, this.leftStart.y, this.leftEnd.x, this.leftEnd.y);
            graphics.drawLine(this.leftStart.x, this.leftStart.y + 1, this.leftEnd.x, this.leftEnd.y + 1);
            graphics.drawLine(this.leftEnd.x, this.leftEnd.y, this.rightStart.x, this.rightStart.y);
            graphics.drawLine(this.rightStart.x, this.rightStart.y - 1, this.rightEnd.x, this.rightEnd.y - 1);
            graphics.drawLine(this.rightStart.x, this.rightStart.y, this.rightEnd.x, this.rightEnd.y);
            graphics.drawLine(this.rightStart.x, this.rightStart.y + 1, this.rightEnd.x, this.rightEnd.y + 1);
            if (this.leftLinkType == 1) {
                if (this.leftStart.x < this.leftEnd.x) {
                    cEncodedIcon = CEncodedIcon.SMALL_LEFT_ARROW;
                    cEncodedIcon.setColor(this.getForeground());
                    cEncodedIcon.paintIcon(this, graphics, this.leftStart.x, this.leftStart.y - 3);
                } else {
                    cEncodedIcon = CEncodedIcon.SMALL_RIGHT_ARROW;
                    cEncodedIcon.setColor(this.getForeground());
                    cEncodedIcon.paintIcon(this, graphics, this.leftEnd.x + 11, this.leftEnd.y - 3);
                }
            }
            if (this.leftRelation == 1) {
                cEncodedIcon = CEncodedIcon.ONE_SIGN;
                cEncodedIcon.setColor(this.getForeground());
                cEncodedIcon.paintIcon(this, graphics, (this.leftStart.x + this.leftEnd.x) / 2 - 1, this.leftStart.y - 9);
            }
            if (this.leftRelation == 2) {
                cEncodedIcon = CEncodedIcon.MANY_SIGN;
                cEncodedIcon.setColor(this.getForeground());
                cEncodedIcon.paintIcon(this, graphics, (this.leftStart.x + this.leftEnd.x) / 2 - 6, this.leftStart.y - 9);
            }
            if (this.rightLinkType == 1) {
                if (this.rightStart.x > this.rightEnd.x) {
                    cEncodedIcon = CEncodedIcon.SMALL_LEFT_ARROW;
                    cEncodedIcon.setColor(this.getForeground());
                    cEncodedIcon.paintIcon(this, graphics, this.rightEnd.x, this.rightEnd.y - 3);
                } else {
                    cEncodedIcon = CEncodedIcon.SMALL_RIGHT_ARROW;
                    cEncodedIcon.setColor(this.getForeground());
                    cEncodedIcon.paintIcon(this, graphics, this.rightStart.x + 11, this.rightStart.y - 3);
                }
            }
            if (this.rightRelation == 1) {
                cEncodedIcon = CEncodedIcon.ONE_SIGN;
                cEncodedIcon.setColor(this.getForeground());
                cEncodedIcon.paintIcon(this, graphics, (this.rightStart.x + this.rightEnd.x) / 2 - 1, this.rightStart.y - 9);
            }
            if (this.rightRelation == 2) {
                cEncodedIcon = CEncodedIcon.MANY_SIGN;
                cEncodedIcon.setColor(this.getForeground());
                cEncodedIcon.paintIcon(this, graphics, (this.rightStart.x + this.rightEnd.x) / 2 - 6, this.rightStart.y - 9);
            }
        }
    }

    private Rect getBoundRect(Component component) {
        Point point = component.getLocationOnScreen();
        if (this.getParent() != null) {
            Point point2 = this.getParent().getLocationOnScreen();
            point.x -= point2.x;
            point.y -= point2.y;
        }
        return new Rect(point.x - 17, point.y, point.x + component.getWidth() + 17, point.y + component.getHeight());
    }

    private Point convertParentToOwn(Point point) {
        if (this.getParent() != null) {
            point.x -= this.getLocationOnScreen().x - this.getParent().getLocationOnScreen().x;
            point.y -= this.getLocationOnScreen().y;
        }
        return point;
    }

    public void updateShape() {
        if (!this.isShowing()) {
            return;
        }
        if (this.leftTable != null && this.rightTable != null) {
            Rect rect = this.getBoundRect(this.leftTable);
            Rect rect2 = this.getBoundRect(this.rightTable);
            Rect rect3 = new Rect(0, 0, 0, 0);
            if (rect.left <= rect2.left) {
                rect3.left = Math.min(rect.right - 17, rect2.left);
                rect3.right = Math.max(rect.right, rect2.left + 17);
            } else {
                rect3.left = Math.min(rect.left, rect2.right - 17);
                rect3.right = Math.max(rect.left + 17, rect2.right);
            }
            rect3.left = rect3.left;
            rect3.right = rect3.right;
            rect3.top = Math.min(rect.top, rect2.top);
            rect3.bottom = Math.max(rect.bottom, rect2.bottom);
            this.setLocation(rect3.left, rect3.top);
            this.setSize(rect3.right - rect3.left, rect3.bottom - rect3.top);
            this.leftEnd.y = this.leftStart.y = this.leftTable.getItemPos(this.leftFieldIndex);
            this.rightEnd.y = this.rightStart.y = this.rightTable.getItemPos(this.rightFieldIndex);
            if (rect.left <= rect2.left) {
                this.leftStart.x = rect.right - 17;
                this.leftEnd.x = rect.right;
                this.rightStart.x = rect2.left;
                this.rightEnd.x = rect2.left + 17;
            } else {
                this.leftStart.x = rect.left + 17;
                this.leftEnd.x = rect.left;
                this.rightStart.x = rect2.right;
                this.rightEnd.x = rect2.right - 17;
            }
            this.leftStart = this.convertParentToOwn(this.leftStart);
            this.leftEnd = this.convertParentToOwn(this.leftEnd);
            this.rightStart = this.convertParentToOwn(this.rightStart);
            this.rightEnd = this.convertParentToOwn(this.rightEnd);
            this.draw = true;
        } else {
            this.draw = false;
        }
        this.updated = true;
        this.repaint();
    }

    private boolean checkInterval(double d, double d2, double d3) {
        if (d <= d2) {
            return d <= d3 && d2 >= d3;
        }
        return d2 <= d3 && d >= d3;
    }

    private boolean checkLine(Point point, Point point2, Point point3) {
        double d = point.x;
        double d2 = point.y;
        double d3 = point2.x;
        double d4 = point2.y;
        double d5 = point3.x;
        double d6 = point3.y;
        double d7 = d4 - d2;
        double d8 = -(d3 - d);
        double d9 = d7 * d3 + d8 * d4;
        double d10 = d3 - d;
        double d11 = d4 - d2;
        double d12 = d10 * d5 + d11 * d6;
        double d13 = (d12 * d8 - d9 * d11) / (d10 * d8 - d7 * d11);
        double d14 = d8 != 0.0 ? (d9 - d7 * d13) / d8 : d6;
        double d15 = Math.sqrt(Math.pow(d5 - d13, 2.0) + Math.pow(d6 - d14, 2.0));
        return d15 <= 3.0 && this.checkInterval(d, d3, d13) && this.checkInterval(d2, d4, d14);
    }

    private boolean checkOver(Point point) {
        return this.checkLine(this.leftStart, this.leftEnd, point) || this.checkLine(this.leftEnd, this.rightStart, point) || this.checkLine(this.rightStart, this.rightEnd, point);
    }

    public boolean contains(int n, int n2) {
        return this.checkOver(new Point(n, n2));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private class Rect {
        public int left;
        public int right;
        public int top;
        public int bottom;

        public Rect(int n, int n2, int n3, int n4) {
            this.left = n;
            this.right = n3;
            this.top = n2;
            this.bottom = n4;
        }
    }
}

