/*
 * Decompiled with CFR 0.152.
 */
package org.comedia.ui;

import java.awt.Component;
import java.awt.Font;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class CConsole
extends JScrollPane {
    private JTextPane text = new JTextPane();

    public CConsole() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.text.setFont(new Font("Monospaced", 0, 12));
        this.text.setEditable(false);
        this.setViewportView(this.text);
    }

    public JTextPane getTextPane() {
        return this.text;
    }

    public synchronized void print(String string) {
        Document document = this.text.getDocument();
        try {
            document.insertString(document.getLength(), string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void println(String string) {
        Document document = this.text.getDocument();
        try {
            document.insertString(document.getLength(), string + '\n', null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void print(String string, AttributeSet attributeSet) {
        Document document = this.text.getDocument();
        try {
            document.insertString(document.getLength(), string, attributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void println(String string, AttributeSet attributeSet) {
        Document document = this.text.getDocument();
        try {
            document.insertString(document.getLength(), string + '\n', attributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void copy(InputStream inputStream) {
        PrintThread printThread = new PrintThread(inputStream);
        printThread.start();
    }

    public void clear() {
        this.text.setText("");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Console");
        CConsole cConsole = new CConsole();
        jFrame.setContentPane(cConsole);
        ((Component)jFrame).setSize(400, 300);
        ((Component)jFrame).setLocation(300, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.show();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        int n = 0;
        while (n < 10) {
            Style style2 = cConsole.getTextPane().addStyle("new" + n, style);
            StyleConstants.setFontSize(style2, 10 + n);
            cConsole.println("Hello World!", style2);
            ++n;
        }
    }

    private class PrintThread
    extends Thread {
        private InputStream in;

        public PrintThread(InputStream inputStream) {
            this.in = inputStream;
        }

        public void run() {
            byte[] byArray = new byte[512];
            try {
                int n;
                while ((n = this.in.read(byArray, 0, 512)) > -1) {
                    CConsole.this.print(new String(byArray, 0, n));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

