/*
 * Decompiled with CFR 0.152.
 */
package org.merlin.beans.font;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.util.Vector;
import org.merlin.beans.font.FontEvent;
import org.merlin.beans.font.FontListener;
import org.merlin.beans.font.FontSelectorBean;

public class FontDialogBean
extends Container
implements ActionListener,
ItemListener {
    protected Window dialog;
    protected Label sample;
    protected FontSelectorBean selector;
    public Button change;
    protected Vector listeners = new Vector();
    static /* synthetic */ Class class$java$awt$Component;

    public FontDialogBean() {
        this.sample = new Label("abcABC012...");
        this.change = new Button("Change...");
        this.setLayout(new BorderLayout());
        this.add("Center", this.sample);
        this.add("East", this.change);
        this.change.addActionListener(this);
    }

    public void setStyle(Font f) {
        this.sample.setFont(f);
    }

    public Font getStyle() {
        return this.sample.getFont();
    }

    public void removeNotify() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
        super.removeNotify();
    }

    public void actionPerformed(ActionEvent e) {
        this.createDialog();
        this.selector.setStyle(this.sample.getFont());
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    protected synchronized void createDialog() {
        if (this.dialog == null) {
            Container c = this;
            while (c.getParent() != null) {
                c = c.getParent();
            }
            this.dialog = c instanceof Frame ? new Dialog((Frame)c, "Select a Font", true) : new Frame("Select Font");
            try {
                this.selector = (FontSelectorBean)Beans.instantiate(this.getClass().getClassLoader(), "org.merlin.beans.font.FontSelectorBean");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.dialog.add("Center", (Component)Beans.getInstanceOf(this.selector, class$java$awt$Component == null ? (class$java$awt$Component = FontDialogBean.class$("java.awt.Component")) : class$java$awt$Component));
            this.selector.addItemListener(this);
            this.dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    FontDialogBean.this.dialog.dispose();
                }
            });
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.dialog.dispose();
        if (e.getStateChange() == 1) {
            this.sample.setFont((Font)e.getItem());
            this.fireFontEvent();
        }
    }

    public void addFontListener(FontListener l) {
        this.listeners.addElement(l);
    }

    public void removeFontListener(FontListener l) {
        this.listeners.removeElement(l);
    }

    protected void fireFontEvent() {
        FontEvent event = new FontEvent(this, 2000, this.getStyle());
        Vector listeners = (Vector)this.listeners.clone();
        int i = 0;
        while (i < listeners.size()) {
            ((FontListener)listeners.elementAt(i)).fontSelected(event);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

