/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class OSXAdapter {
    private Class applicationClass = Class.forName("com.apple.eawt.Application");
    private Object application;
    private Method setHandled;
    private boolean preferencesEnabled = false;
    private boolean aboutEnabled = false;

    public OSXAdapter() throws Exception {
        Class<?> appListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
        Object appListener = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{appListenerClass}, (InvocationHandler)new Invoker());
        Method getApplication = this.applicationClass.getMethod("getApplication", null);
        this.application = getApplication.invoke(null, null);
        Method addListener = this.applicationClass.getMethod("addApplicationListener", appListenerClass);
        addListener.invoke(this.application, appListener);
        Class<?> eventClass = Class.forName("com.apple.eawt.ApplicationEvent");
        this.setHandled = eventClass.getMethod("setHandled", Boolean.TYPE);
    }

    public void setEnabledPreferencesMenu(boolean enable) throws Exception {
        this.setEnabled("PreferencesMenu", enable);
        this.preferencesEnabled = enable;
    }

    public void setEnabledAboutMenu(boolean enable) throws Exception {
        this.setEnabled("AboutMenu", enable);
        this.aboutEnabled = enable;
    }

    private void setEnabled(String name, boolean enable) throws Exception {
        Method setEnabled = this.applicationClass.getMethod("setEnabled" + name, Boolean.TYPE);
        setEnabled.invoke(this.application, enable);
    }

    protected void handleAbout() {
    }

    protected void handlePreferences() {
    }

    protected void handleQuit() {
    }

    class Invoker
    implements InvocationHandler {
        Invoker() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("handlePreferences".equals(method.getName()) && OSXAdapter.this.preferencesEnabled) {
                OSXAdapter.this.handlePreferences();
                OSXAdapter.this.setHandled.invoke(args[0], Boolean.TRUE);
            } else if ("handleAbout".equals(method.getName()) && OSXAdapter.this.aboutEnabled) {
                OSXAdapter.this.handleAbout();
                OSXAdapter.this.setHandled.invoke(args[0], Boolean.TRUE);
            } else if ("handleQuit".equals(method.getName())) {
                OSXAdapter.this.handleQuit();
                OSXAdapter.this.setHandled.invoke(args[0], Boolean.TRUE);
            }
            return null;
        }
    }
}

