/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.application.document;

import com.l2fprod.common.application.document.AbstractWorkspace;
import com.l2fprod.common.application.document.VisualWorkspaceDocument;
import com.l2fprod.common.application.document.WorkspaceDocument;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedWorkspace
extends AbstractWorkspace {
    private JTabbedPane pane = new JTabbedPane();

    public TabbedWorkspace() {
        this.pane.setTabLayoutPolicy(1);
        this.pane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    TabbedWorkspace.super.setSelected(TabbedWorkspace.this.getDocument(TabbedWorkspace.this.pane.getSelectedComponent()));
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    public Component getVisualComponent() {
        return this.pane;
    }

    public void setSelected(WorkspaceDocument document) throws PropertyVetoException {
        super.setSelected(document);
        if (document instanceof VisualWorkspaceDocument) {
            int index = this.getIndex((VisualWorkspaceDocument)document);
            this.pane.setSelectedIndex(index);
        }
    }

    protected void documentOpened(WorkspaceDocument document) {
        if (document instanceof VisualWorkspaceDocument) {
            VisualWorkspaceDocument ui = (VisualWorkspaceDocument)document;
            this.pane.addTab(ui.getTitle(), ui.getIcon(), ui.getVisualComponent());
        }
    }

    protected void documentClosed(WorkspaceDocument document) {
        if (document instanceof VisualWorkspaceDocument) {
            Component ui = ((VisualWorkspaceDocument)document).getVisualComponent();
            this.pane.remove(ui);
        }
    }

    protected void documentChanged(WorkspaceDocument document, PropertyChangeEvent event) {
        if (event.getSource() instanceof VisualWorkspaceDocument) {
            VisualWorkspaceDocument ui = (VisualWorkspaceDocument)event.getSource();
            int index = this.getIndex(ui);
            if ("title".equals(event.getPropertyName())) {
                this.pane.setTitleAt(index, document.getTitle());
            } else if ("icon".equals(event.getPropertyName())) {
                this.pane.setIconAt(index, ui.getIcon());
            }
        }
    }

    private VisualWorkspaceDocument getDocument(Component component) {
        WorkspaceDocument[] documents = this.getDocuments();
        VisualWorkspaceDocument result = null;
        int c = documents.length;
        for (int i = 0; i < c; ++i) {
            if (!(documents[i] instanceof VisualWorkspaceDocument) || ((VisualWorkspaceDocument)documents[i]).getVisualComponent() != component) continue;
            result = (VisualWorkspaceDocument)documents[i];
        }
        return result;
    }

    private int getIndex(VisualWorkspaceDocument document) {
        return this.pane.indexOfComponent(document.getVisualComponent());
    }
}

