/*
 * Decompiled with CFR 0.152.
 */
package net.janino;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.janino.Descriptor;
import net.janino.IClass;

public class IClassLoader {
    private static final boolean DEBUG = false;
    public IClass VOID;
    public IClass BYTE;
    public IClass CHAR;
    public IClass DOUBLE;
    public IClass FLOAT;
    public IClass INT;
    public IClass LONG;
    public IClass SHORT;
    public IClass BOOLEAN;
    public IClass OBJECT;
    public IClass STRING;
    public IClass CLASS;
    public IClass THROWABLE;
    public IClass RUNTIME_EXCEPTION;
    public IClass ERROR;
    public IClass CLONEABLE;
    public IClass SERIALIZABLE;
    private final Map loadedIClasses = new HashMap();
    private final Set unloadableIClasses = new HashSet();

    protected void defineIClass(IClass iClass) {
        String string = iClass.getDescriptor();
        IClass iClass2 = (IClass)this.loadedIClasses.get(string);
        if (iClass2 != null) {
            if (iClass2 == iClass) {
                return;
            }
            throw new RuntimeException("Non-identical definition of IClass \"" + string + "\"");
        }
        this.loadedIClasses.put(string, iClass);
    }

    protected IClass findIClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException("Type \"" + string + "\" not defined");
    }

    public IClass getLoadedIClass(String string) {
        return (IClass)this.loadedIClasses.get(string);
    }

    public final IClass loadArrayIClass(IClass iClass) {
        try {
            return this.loadIClass(String.valueOf('[') + iClass.getDescriptor());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("S.N.O.: Cannot determine array type of \"" + iClass.toString() + "\"");
        }
    }

    public final IClass loadIClass(String string) throws ClassNotFoundException {
        IClass iClass = (IClass)this.loadedIClasses.get(string);
        if (iClass != null) {
            return iClass;
        }
        if (this.unloadableIClasses.contains(string)) {
            throw new ClassNotFoundException(string);
        }
        if (Descriptor.isArrayReference(string)) {
            IClass iClass2 = this.loadIClass(Descriptor.getComponentDescriptor(string));
            IClass iClass3 = this.getLoadedIClass(string);
            if (iClass3 != null) {
                return iClass3;
            }
            iClass3 = IClass.createArrayIClass(iClass2, this.OBJECT);
            this.loadedIClasses.put(string, iClass3);
            return iClass3;
        }
        try {
            iClass = this.findIClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.unloadableIClasses.add(string);
            throw classNotFoundException;
        }
        if (!iClass.getDescriptor().equalsIgnoreCase(string)) {
            throw new RuntimeException("\"findIClass()\" returned \"" + iClass.getDescriptor() + "\" instead of \"" + string + "\"");
        }
        return iClass;
    }

    protected final void postConstruct() throws ClassNotFoundException {
        this.VOID = this.loadIClass("V");
        this.BYTE = this.loadIClass("B");
        this.CHAR = this.loadIClass("C");
        this.DOUBLE = this.loadIClass("D");
        this.FLOAT = this.loadIClass("F");
        this.INT = this.loadIClass("I");
        this.LONG = this.loadIClass("J");
        this.SHORT = this.loadIClass("S");
        this.BOOLEAN = this.loadIClass("Z");
        this.OBJECT = this.loadIClass("Ljava/lang/Object;");
        this.STRING = this.loadIClass("Ljava/lang/String;");
        this.CLASS = this.loadIClass("Ljava/lang/Class;");
        this.THROWABLE = this.loadIClass("Ljava/lang/Throwable;");
        this.RUNTIME_EXCEPTION = this.loadIClass("Ljava/lang/RuntimeException;");
        this.ERROR = this.loadIClass("Ljava/lang/Error;");
        this.CLONEABLE = this.loadIClass("Ljava/lang/Cloneable;");
        this.SERIALIZABLE = this.loadIClass("Ljava/io/Serializable;");
    }
}

