/*
 * Decompiled with CFR 0.152.
 */
package net.janino.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.janino.util.resource.ResourceFinder;

public class ZipFileResourceFinder
implements ResourceFinder {
    private final ZipFile zipFile;

    public ZipFileResourceFinder(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public URL findResource(String string) {
        if (this.zipFile.getEntry(string) == null) {
            return null;
        }
        try {
            return new URL("zip", null, String.valueOf(this.zipFile.getName().replace(File.separatorChar, '/')) + '!' + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException();
        }
    }

    public InputStream findResourceAsStream(String string) {
        ZipEntry zipEntry = this.zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        try {
            return this.zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String toString() {
        return "zip:" + this.zipFile.getName();
    }
}

