/*
 * Decompiled with CFR 0.152.
 */
package org.openabacus.jfreechart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Calendar;
import java.util.Date;
import javax.swing.border.Border;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.openabacus.jfreechart.JAChartPanel;

public class JAGanttChart
extends JAChartPanel {
    private String defaultTitle = null;
    private JFreeChart chart;
    private CategoryPlot categoryplot;
    private IntervalCategoryDataset dataset;
    public static int VERTICAL = 0;
    public static int HORIZONTAL = 1;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private CategoryItemRenderer categoryitemrenderer;

    public JAGanttChart() {
        this.defaultTitle = new String("No Title");
        this.dataset = this.createSampleDataset();
        this.chart = this.createChart(this.dataset);
        this.setChart(this.chart);
    }

    public void setTitle(String title) {
        this.defaultTitle = title;
        this.chart.setTitle(this.defaultTitle);
    }

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public void setFont(Font chartFont) {
        if (this.categoryitemrenderer != null) {
            this.categoryitemrenderer.setItemLabelFont(chartFont);
        }
    }

    public Font getFont() {
        if (this.categoryitemrenderer != null) {
            return this.categoryitemrenderer.getItemLabelFont();
        }
        return null;
    }

    public void set3DChart(boolean bFlag) {
        this.b3DChart = bFlag;
    }

    public boolean get3DChart(boolean bFlag) {
        return this.b3DChart;
    }

    public void setBorder(Border chartBorder) {
        super.setBorder(chartBorder);
    }

    public Border getBorder() {
        return super.getBorder();
    }

    public void setGridLinesVisible(boolean bFlag) {
        if (this.categoryplot != null) {
            this.categoryplot.setDomainGridlinesVisible(bFlag);
        }
    }

    public boolean getGridLinesVisible(boolean bFlag) {
        return this.categoryplot.isDomainGridlinesVisible();
    }

    public void setOrientation(int iOrientation) {
        this.orientation = iOrientation == VERTICAL ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
        this.categoryplot.setOrientation(this.orientation);
    }

    public int getOrientation() {
        int iOrientation = 0;
        iOrientation = this.orientation == PlotOrientation.VERTICAL ? VERTICAL : HORIZONTAL;
        return iOrientation;
    }

    private IntervalCategoryDataset createSampleDataset() {
        TaskSeries s1 = new TaskSeries("Scheduled");
        s1.add(new Task("Write Proposal", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(1, 3, 2005), JAGanttChart.date(5, 3, 2005))));
        s1.add(new Task("Obtain Approval", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(9, 3, 2005), JAGanttChart.date(9, 3, 2005))));
        s1.add(new Task("Requirements Analysis", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(10, 3, 2005), JAGanttChart.date(5, 4, 2005))));
        s1.add(new Task("Design Phase", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(6, 4, 2005), JAGanttChart.date(30, 4, 2005))));
        s1.add(new Task("Design Signoff", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(2, 5, 2005), JAGanttChart.date(2, 5, 2005))));
        s1.add(new Task("Alpha Implementation", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(3, 5, 2005), JAGanttChart.date(31, 6, 2005))));
        s1.add(new Task("Design Review", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(1, 7, 2005), JAGanttChart.date(8, 7, 2005))));
        s1.add(new Task("Revised Design Signoff", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(10, 7, 2005), JAGanttChart.date(10, 7, 2005))));
        s1.add(new Task("Beta Implementation", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(12, 7, 2005), JAGanttChart.date(12, 8, 2005))));
        s1.add(new Task("Testing", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(13, 8, 2005), JAGanttChart.date(31, 9, 2005))));
        s1.add(new Task("Final Implementation", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(1, 10, 2005), JAGanttChart.date(15, 10, 2005))));
        s1.add(new Task("Signoff", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(28, 10, 2005), JAGanttChart.date(30, 10, 2005))));
        TaskSeries s2 = new TaskSeries("Actual");
        s2.add(new Task("Write Proposal", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(1, 3, 2005), JAGanttChart.date(5, 3, 2005))));
        s2.add(new Task("Obtain Approval", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(9, 3, 2005), JAGanttChart.date(9, 3, 2005))));
        s2.add(new Task("Requirements Analysis", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(10, 3, 2005), JAGanttChart.date(15, 4, 2005))));
        s2.add(new Task("Design Phase", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(15, 4, 2005), JAGanttChart.date(17, 5, 2005))));
        s2.add(new Task("Design Signoff", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(30, 5, 2005), JAGanttChart.date(30, 5, 2005))));
        s2.add(new Task("Alpha Implementation", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(1, 6, 2005), JAGanttChart.date(12, 8, 2005))));
        s2.add(new Task("Design Review", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(12, 8, 2005), JAGanttChart.date(22, 8, 2005))));
        s2.add(new Task("Revised Design Signoff", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(25, 8, 2005), JAGanttChart.date(27, 8, 2005))));
        s2.add(new Task("Beta Implementation", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(27, 8, 2005), JAGanttChart.date(30, 9, 2005))));
        s2.add(new Task("Testing", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(31, 9, 2005), JAGanttChart.date(17, 10, 2005))));
        s2.add(new Task("Final Implementation", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(18, 10, 2005), JAGanttChart.date(5, 11, 2005))));
        s2.add(new Task("Signoff", (TimePeriod)new SimpleTimePeriod(JAGanttChart.date(10, 11, 2005), JAGanttChart.date(11, 11, 2005))));
        TaskSeriesCollection collection = new TaskSeriesCollection();
        collection.add(s1);
        collection.add(s2);
        return collection;
    }

    private static Date date(int i, int j, int k) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(k, j, i);
        Date date1 = calendar.getTime();
        return date1;
    }

    private JFreeChart createChart(IntervalCategoryDataset intervalcategorydataset) {
        JFreeChart localChart = ChartFactory.createGanttChart((String)this.defaultTitle, (String)"Task", (String)"Date", (IntervalCategoryDataset)intervalcategorydataset, (boolean)true, (boolean)true, (boolean)false);
        this.categoryplot = (CategoryPlot)localChart.getPlot();
        this.categoryitemrenderer = this.categoryplot.getRenderer();
        this.categoryitemrenderer.setSeriesPaint(0, (Paint)Color.red);
        return localChart;
    }
}

