/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseMessages;
import com.microsoft.jdbc.base.BaseSQLException;
import com.microsoft.util.UtilDebug;
import com.microsoft.util.UtilException;
import java.sql.SQLException;

public final class BaseExceptions {
    private static final String footprint = "$Revision:   1.9.1.0  $";
    private static final String generalErrorSqlState = "HY000";
    protected BaseMessages baseMessages;
    protected boolean useUnsyncLogging = false;
    public static final int ADD_AT_BEGINNING = 0;
    public static final int ADD_AT_END = 1;

    public BaseExceptions(String string) throws SQLException {
        this.baseMessages = new BaseMessages(string);
    }

    private SQLException chainExceptions(SQLException sQLException, SQLException sQLException2, int n) {
        SQLException sQLException3 = sQLException2;
        if (sQLException != null) {
            if (n == 0) {
                sQLException2.setNextException(sQLException);
                sQLException3 = sQLException2;
            } else {
                UtilDebug.assert((String)"Bad chain value specified", (n == 1 ? 1 : 0) != 0);
                sQLException.setNextException(sQLException2);
                sQLException3 = sQLException;
            }
        }
        return sQLException3;
    }

    private SQLException createException(String string, String string2) {
        if (this.useUnsyncLogging) {
            return new BaseSQLException(string, string2);
        }
        return new SQLException(string, string2);
    }

    private SQLException createException(String string, String string2, int n) {
        if (this.useUnsyncLogging) {
            return new BaseSQLException(string, string2, n);
        }
        return new SQLException(string, string2, n);
    }

    public SQLException getException(int n) {
        SQLException sQLException = this.createException(this.baseMessages.getMessage(n, null, false), generalErrorSqlState);
        return sQLException;
    }

    public SQLException getException(int n, String string) {
        SQLException sQLException = this.createException(this.baseMessages.getMessage(n, null, false), string);
        return sQLException;
    }

    public SQLException getException(int n, String[] stringArray) {
        SQLException sQLException = this.createException(this.baseMessages.getMessage(n, stringArray, false), generalErrorSqlState);
        return sQLException;
    }

    public SQLException getException(int n, String[] stringArray, String string) {
        SQLException sQLException = this.createException(this.baseMessages.getMessage(n, stringArray, false), string);
        return sQLException;
    }

    public SQLException getException(int n, String[] stringArray, String string, int n2) {
        SQLException sQLException = this.createException(this.baseMessages.getMessage(n, stringArray, true), string, n2);
        return sQLException;
    }

    public SQLException getException(Exception exception) {
        SQLException sQLException = exception instanceof UtilException && ((UtilException)((Object)exception)).getReason() == 1018 ? this.getException(exception, "08S01") : this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), generalErrorSqlState);
        return sQLException;
    }

    public SQLException getException(Exception exception, String string) {
        SQLException sQLException = this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), string);
        return sQLException;
    }

    public SQLException getException(Exception exception, String string, int n) {
        SQLException sQLException = this.createException(this.baseMessages.formatMessage(exception.getMessage(), null, false), string, n);
        return sQLException;
    }

    public SQLException getException(SQLException sQLException, int n) {
        return this.getException(sQLException, 0, n);
    }

    public SQLException getException(SQLException sQLException, int n, int n2) {
        SQLException sQLException2 = this.createException(this.baseMessages.getMessage(n2, null, false), generalErrorSqlState);
        return this.chainExceptions(sQLException, sQLException2, n);
    }

    public SQLException getException(SQLException sQLException, int n, int n2, String string) {
        SQLException sQLException2 = this.createException(this.baseMessages.getMessage(n2, null, false), string);
        return this.chainExceptions(sQLException, sQLException2, n);
    }

    public SQLException getException(SQLException sQLException, int n, int n2, String[] stringArray) {
        SQLException sQLException2 = this.createException(this.baseMessages.getMessage(n2, stringArray, false), generalErrorSqlState);
        return this.chainExceptions(sQLException, sQLException2, n);
    }

    public SQLException getException(SQLException sQLException, int n, int n2, String[] stringArray, String string) {
        SQLException sQLException2 = this.createException(this.baseMessages.getMessage(n2, stringArray, false), string);
        return this.chainExceptions(sQLException, sQLException2, n);
    }

    public SQLException getException(SQLException sQLException, int n, int n2, String[] stringArray, String string, int n3) {
        SQLException sQLException2 = this.createException(this.baseMessages.getMessage(n2, stringArray, true), string, n3);
        return this.chainExceptions(sQLException, sQLException2, n);
    }

    public SQLException getException(SQLException sQLException, int n, String string) {
        return this.getException(sQLException, 0, n, string);
    }

    public SQLException getException(SQLException sQLException, int n, String[] stringArray) {
        return this.getException(sQLException, 0, n, stringArray);
    }

    public SQLException getException(SQLException sQLException, int n, String[] stringArray, String string) {
        return this.getException(sQLException, 0, n, stringArray, string);
    }

    public SQLException getException(SQLException sQLException, int n, String[] stringArray, String string, int n2) {
        return this.getException(sQLException, 0, n, stringArray, string, n2);
    }

    public boolean getUnsyncLogExceptions() {
        return this.useUnsyncLogging;
    }

    public void setUnsyncLogExceptions(boolean bl) {
        this.useUnsyncLogging = bl;
    }
}

