/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.images;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;

public class ImageLoader {
    public static ImageIcon getImageIcon(String relUrl) {
        try {
            return new ImageIcon(ImageLoader.getAbsoluteImageUrl(relUrl));
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static Image getImage(String relUrl) {
        return Toolkit.getDefaultToolkit().getImage(ImageLoader.getAbsoluteImageUrl(relUrl));
    }

    public static String getAbsoluteImagePath(String relUrl) {
        try {
            return ImageLoader.class.getResource(relUrl).getPath();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public static URL getAbsoluteImageUrl(String relUrl) {
        assert (relUrl != null);
        URL url = ImageLoader.class.getResource(relUrl);
        if (url == null) {
            System.err.println("ImageLoader Resource '" + relUrl + "' is not available !!!");
        }
        return url;
    }

    public static ImageIcon getCatalogIcon(String _Name) {
        return ImageLoader.getImageIcon("catalog/" + _Name);
    }

    public static void main(String[] s) {
        System.out.println("XXX: path of Glp_exit.png: " + ImageLoader.getAbsoluteImagePath("Glp_exit.png"));
        System.out.println("XXX: ImageIconObject Glp_exit.png: " + ImageLoader.getImageIcon("Glp_exit.png"));
        System.out.println("XXX: ImageIconObject not found: " + ImageLoader.getImageIcon("not_be_found"));
        System.out.println("XXX: getAbsoluteImagePath not found: " + ImageLoader.getAbsoluteImagePath("not_be_found"));
        System.out.println("XXX: getAbsoluteImageUrl not found: " + ImageLoader.getAbsoluteImageUrl("not_be_found"));
        System.out.println("XXX: getImage glp_standard.png: " + ImageLoader.getImage("glp_standard.png"));
        System.out.println("XXX: getImage not found: " + ImageLoader.getImage("not_found"));
    }
}

