/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui;

import ch.abacus.lib.ui.JALayeredPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class JAScrollingPanel
extends JALayeredPane
implements Scrollable,
ComponentListener,
ContainerListener {
    private boolean bExpansionState = false;
    private Dimension dimSavedSize;
    private Dimension dimSavedScrPaneSize;
    private Dimension ViewportSize;
    private JScrollPane theScrollPane;
    private ComponentSpaceAdministrator theSpaceAdministrator = new ComponentSpaceAdministrator();
    private int VerticalScrollableUnitIncrement = 1;
    private int HorizontalScrollableUnitIncrement = 1;
    private int VerticalScrollableBlockIncrement = 1;
    private int HorizontalScrollableBlockIncrement = 1;

    public JScrollPane getScrollPane() {
        return this.theScrollPane;
    }

    public void setScrollPane(JScrollPane theScrollPane) {
        this.theScrollPane = theScrollPane;
    }

    public JAScrollingPanel(int verticalScrollableUnitIncrement, int horizontalScrollableUnitIncrement, int verticalScrollableBlockIncrement, int horizontalScrollableBlockIncrement) {
        this.VerticalScrollableUnitIncrement = verticalScrollableUnitIncrement;
        this.HorizontalScrollableUnitIncrement = horizontalScrollableUnitIncrement;
        this.VerticalScrollableBlockIncrement = verticalScrollableBlockIncrement;
        this.HorizontalScrollableBlockIncrement = horizontalScrollableBlockIncrement;
        this.init();
    }

    public JAScrollingPanel() {
        this.init();
    }

    void init() {
        this.addComponentListener(this);
        this.addContainerListener(this);
    }

    public int getVerticalScrollableUnitIncrement() {
        return this.VerticalScrollableUnitIncrement;
    }

    public void setVerticalScrollableUnitIncrement(int verticalScrollableUnitIncrement) {
        this.VerticalScrollableUnitIncrement = verticalScrollableUnitIncrement;
    }

    public int getHorizontalScrollableUnitIncrement() {
        return this.HorizontalScrollableUnitIncrement;
    }

    public void setHorizontalScrollableUnitIncrement(int horizontalScrollableUnitIncrement) {
        this.HorizontalScrollableUnitIncrement = horizontalScrollableUnitIncrement;
    }

    public int getVerticalScrollableBlockIncrement() {
        return this.VerticalScrollableBlockIncrement;
    }

    public void setVerticalScrollableBlockIncrement(int verticalScrollableBlockIncrement) {
        this.VerticalScrollableBlockIncrement = verticalScrollableBlockIncrement;
    }

    public int getHorizontalScrollableBlockIncrement() {
        return this.HorizontalScrollableBlockIncrement;
    }

    public void setHorizontalScrollableBlockIncrement(int horizontalScrollableBlockIncrement) {
        this.HorizontalScrollableBlockIncrement = horizontalScrollableBlockIncrement;
    }

    public void componentAdded(ContainerEvent event) {
        Component child = event.getChild();
        if (child != null) {
            ComponentSpace theSpace = this.theSpaceAdministrator.addComponentSpace(child);
            theSpace.dimSize = child.getSize();
            theSpace.ptLocation = child.getLocation();
            theSpace.bVisible = child.isVisible();
        }
    }

    public void componentRemoved(ContainerEvent event) {
        Component child = event.getChild();
        if (child != null) {
            this.theSpaceAdministrator.removeComponentSpace(child);
        }
    }

    public void componentResized(ComponentEvent event) {
        ComponentSpace theSpace = this.theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.dimSize = event.getComponent().getSize();
            theSpace.ptLocation = event.getComponent().getLocation();
        }
    }

    public void componentMoved(ComponentEvent event) {
        ComponentSpace theSpace = this.theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.dimSize = event.getComponent().getSize();
            theSpace.ptLocation = event.getComponent().getLocation();
        }
    }

    public void componentHidden(ComponentEvent event) {
        ComponentSpace theSpace = this.theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.bVisible = false;
        }
    }

    public void componentShown(ComponentEvent event) {
        ComponentSpace theSpace = this.theSpaceAdministrator.getComponentSpace(event.getComponent());
        if (theSpace != null) {
            theSpace.bVisible = true;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimPreferredSize = super.getPreferredSize();
        Dimension dimRequiredSize = this.theSpaceAdministrator.calculateNecessaryRectangle();
        if (dimRequiredSize.width > dimPreferredSize.width) {
            dimPreferredSize.width = dimRequiredSize.width;
        }
        if (dimRequiredSize.height > dimPreferredSize.height) {
            dimPreferredSize.height = dimRequiredSize.height;
        }
        return dimPreferredSize;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimRequiredSize = this.theSpaceAdministrator.calculateNecessaryRectangle();
        return dimRequiredSize;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.getVerticalScrollableUnitIncrement();
        }
        return this.getHorizontalScrollableUnitIncrement();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.getVerticalScrollableBlockIncrement();
        }
        return this.getHorizontalScrollableBlockIncrement();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getExpansionState() {
        return this.bExpansionState;
    }

    public void expand() {
        Dimension dimViewportSize;
        JViewport theViewport;
        Dimension dimSavedSize = this.getSize();
        if (this.getScrollPane() != null && (theViewport = this.getScrollPane().getViewport()) != null) {
            dimSavedSize = theViewport.getSize();
            this.dimSavedScrPaneSize = this.getScrollPane().getSize();
        }
        if ((dimViewportSize = this.getViewportSize()) != null && !dimViewportSize.equals(new Dimension(0, 0))) {
            if (dimViewportSize.width < dimSavedSize.width) {
                dimSavedSize.width = dimViewportSize.width;
            }
            if (dimViewportSize.height < dimSavedSize.height) {
                dimSavedSize.height = dimViewportSize.height;
            }
        }
        this.dimSavedSize = dimSavedSize;
        Dimension dimNewSize = this.getPreferredSize();
        this.setSize(dimNewSize);
        this.bExpansionState = true;
        if (this.getScrollPane() != null) {
            Insets theInsets = this.getScrollPane().getInsets();
            dimNewSize.height += theInsets.top + theInsets.bottom;
            dimNewSize.width += theInsets.left + theInsets.right;
            this.getScrollPane().setSize(dimNewSize);
            JViewport theViewport2 = this.getScrollPane().getViewport();
            theViewport2.setView(this);
        }
    }

    public Dimension getViewportSize() {
        return this.ViewportSize;
    }

    public void setViewportSize(Dimension dim) {
        this.ViewportSize = dim;
    }

    public void reduce() {
        if (this.dimSavedSize != null) {
            this.setSize(this.dimSavedSize);
            if (this.getScrollPane() != null) {
                this.getScrollPane().setSize(this.dimSavedScrPaneSize);
                JViewport theViewport = this.getScrollPane().getViewport();
                theViewport.setView(this);
            }
        }
        this.bExpansionState = false;
    }

    class ComponentSpaceAdministrator {
        ArrayList theComponents = new ArrayList(0);

        ComponentSpaceAdministrator() {
        }

        ComponentSpace getComponentSpace(Component comp) {
            for (int i = 0; i < this.theComponents.size(); ++i) {
                ComponentSpace thisComponentSpace = (ComponentSpace)this.theComponents.get(i);
                if (!thisComponentSpace.comp.equals(comp)) continue;
                return thisComponentSpace;
            }
            return null;
        }

        ComponentSpace addComponentSpace(Component comp) {
            ComponentSpace newComponentSpace = new ComponentSpace(comp);
            this.theComponents.add(newComponentSpace);
            return newComponentSpace;
        }

        boolean removeComponentSpace(Component comp) {
            for (int i = 0; i < this.theComponents.size(); ++i) {
                ComponentSpace thisComponentSpace = (ComponentSpace)this.theComponents.get(i);
                if (!thisComponentSpace.comp.equals(comp)) continue;
                this.theComponents.remove(i);
                return true;
            }
            return false;
        }

        Dimension calculateNecessaryRectangle() {
            Dimension dimRetVal = new Dimension(0, 0);
            for (int i = 0; i < this.theComponents.size(); ++i) {
                ComponentSpace thisComponentSpace = (ComponentSpace)this.theComponents.get(i);
                if (!thisComponentSpace.bVisible) continue;
                int cx = thisComponentSpace.ptLocation.x + thisComponentSpace.dimSize.width;
                int cy = thisComponentSpace.ptLocation.y + thisComponentSpace.dimSize.height;
                if (cx > dimRetVal.width) {
                    dimRetVal.width = cx;
                }
                if (cy <= dimRetVal.height) continue;
                dimRetVal.height = cy;
            }
            return dimRetVal;
        }
    }

    class ComponentSpace {
        Dimension dimSize = new Dimension(0, 0);
        Point ptLocation = new Point(0, 0);
        boolean bVisible = false;
        Component comp = null;

        public ComponentSpace(Component comp) {
            this.comp = comp;
        }

        void setLocation(Point pt) {
            this.ptLocation = pt;
        }

        void setSize(Dimension size) {
            this.dimSize = size;
        }

        void setHidden() {
            this.bVisible = false;
        }

        void setVisible() {
            this.bVisible = true;
        }
    }
}

