/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.entry;

import ch.abacus.lib.ui.EventListenerContainer;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.vorgaben.ApplicationSettingsInterface;
import ch.abacus.lib.util.GlobalInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;

public class JAEntry
extends JComponent
implements ApplicationSettingsInterface,
KeyListener {
    private static final String mUIClassID = "EntryUI";
    public static final int ENTRYSTATE_NORMAL = 0;
    public static final int ENTRYSTATE_BROWSEONLY = 1;
    public static final int ENTRYSTATE_READONLY = 2;
    public static final int SIMPLE_VALUE_CHECK = 0;
    public static final int EXACT_VALUE_CHECK = 1;
    public static final int NO_INVALIDS_VALUE_CHECK = 2;
    public static final int NO_UPDATE_ON_EXIT = 1;
    public static final int UPDATE_ONLY_IF_MODIFIED = 2;
    protected int mFocusLostBehavior = 0;
    protected int mExitUpdateBehavior = 2;
    private String mSettingName = "";
    private EventListenerContainer mNavigationListenerContainer;
    private EventListenerContainer mKeyListenerContainer;
    private EventListenerContainer mValueChangedContainer;
    private EventListenerContainer mAllowNavigationContainer;
    private EventListenerContainer mEntryModificationContainer;
    private EditorFocusListener mEditorFocusListener;
    protected GlobalInterface mGlobalInterface = null;
    protected int mEntryState = 0;
    protected boolean mShowCaption = true;
    protected boolean mShowSpinner = true;
    protected boolean mShowDateButton = false;
    protected boolean mShowPromptButton = false;
    protected boolean mShowValue = true;
    protected String mCaptionText;
    protected Icon mCaptionIcon;
    protected Object mEditor;
    protected JAEntryLabel mCaption;
    protected Object mValueRenderer;
    protected Object mOldEntryValue = null;
    protected JAEntry mEntryTo;
    protected JAEntry mEntryFrom;
    protected Object mModel = null;
    protected Object mData = null;
    protected Object mLookupData = null;
    protected boolean mUseDataFlexSort = true;
    protected boolean mUppercaseSort = false;
    protected int mLateAction = 0;
    protected Object mUserValue;
    protected boolean mIsUserEntry;
    protected Runnable mPromptCallback;
    protected boolean mModified = false;
    protected boolean mPerformBrowseOperation = true;
    private String m_DataColumnName;
    private boolean m_AutoAbaDisplaySameColumns = true;
    private EventListenerContainer m_CFWEventListeners = new EventListenerContainer();
    private ArrayList m_CFWDataSources = new ArrayList();
    private Color m_BackgroundEditor = null;
    private Color m_ForegroundEditor = null;
    protected boolean mFireEntryModificationEvents = true;
    protected boolean mAbaDisplayTriggersModifications = false;
    protected boolean mForceStringValue = false;
    private Cursor mAppCursor;
    protected Object mEventDispatcher;
    protected boolean mIsCellEditor = false;
    protected JTable mCellEditorParent;
    protected Object mContValHandler;
    private boolean m_HistoryEnabled = false;
    private Object m_HistoryPopup;
    protected boolean mQuickSearchEnabled = false;
    protected Object mQuickSearch;
    protected Object mQuickSearchIdentifier;

    public static JAEntry createEntry(GlobalInterface global, String caption, String editorWidth, boolean showPrompt, boolean showSpin, boolean showValue) {
        JAEntry entry = new JAEntry(global, caption, 100, 100, showPrompt, showSpin, showValue);
        entry.setWidthCaption(caption);
        entry.setWidthEdit(editorWidth);
        return entry;
    }

    protected JAEntry() {
    }

    public JAEntry(GlobalInterface global) {
        this.mGlobalInterface = global;
        this.updateUI();
        this.init();
    }

    public JAEntry(GlobalInterface global, Object data) {
        this(global);
    }

    public JAEntry(GlobalInterface global, String caption, int capWidth, int editorWidth, boolean showPrompt, boolean showSpin, boolean showValue) {
        this(global);
        this.setCaption(caption);
        this.setWidthCaption(capWidth);
        this.setWidthEdit(editorWidth);
        this.setShowPromptButton(showPrompt);
        this.setShowSpinButtons(showSpin);
        this.setShowValue(showValue);
    }

    public JAEntry(GlobalInterface global, Object data, String caption, int capWidth, int editorWidth, boolean showPrompt, boolean showSpin, boolean showValue) {
        this(global, data);
        this.setCaption(caption);
        this.setWidthCaption(capWidth);
        this.setWidthEdit(editorWidth);
        this.setShowPromptButton(showPrompt);
        this.setShowSpinButtons(showSpin);
        this.setShowValue(showValue);
    }

    protected void init() {
        this.getCaptionComponent();
    }

    public String getSettingName() {
        return this.mSettingName;
    }

    public void setSettingName(String newName) {
        this.mSettingName = newName;
        if (this.m_HistoryEnabled) {
            this.setHistroyEnabled(false);
            this.setHistroyEnabled(true);
        }
    }

    public boolean getShowCaption() {
        return this.mShowCaption;
    }

    public void setShowCaption(boolean showCaption) {
        boolean oldValue = this.mShowCaption;
        this.mShowCaption = showCaption;
        this.firePropertyChange("Caption.visible", oldValue, this.mShowCaption);
    }

    public boolean getShowSpinButtons() {
        return this.mShowSpinner;
    }

    public void setShowSpinButtons(boolean showSpinner) {
        boolean oldValue = this.mShowSpinner;
        this.mShowSpinner = showSpinner;
        this.firePropertyChange("Spinner.visible", oldValue, this.mShowSpinner);
    }

    public boolean getShowDateButton() {
        return this.mShowDateButton;
    }

    public void setShowDateButton(boolean showDateButton) {
        boolean oldValue = this.mShowDateButton;
        this.mShowDateButton = showDateButton;
        this.firePropertyChange("Date.visible", oldValue, this.mShowDateButton);
    }

    public boolean getShowPromptButton() {
        return this.mShowPromptButton;
    }

    public void setShowPromptButton(boolean showPromptButton) {
        boolean oldValue = this.mShowPromptButton;
        this.mShowPromptButton = showPromptButton;
        this.firePropertyChange("Prompt.visible", oldValue, this.mShowPromptButton);
    }

    public boolean getShowValue() {
        return this.mShowValue;
    }

    public void setShowValue(boolean showValue) {
        boolean oldValue = this.mShowValue;
        this.mShowValue = showValue;
        this.firePropertyChange("Value.visible", oldValue, this.mShowValue);
    }

    public void setWidthCaption(int newWidth) {
        if (newWidth <= 0) {
            this.setShowCaption(false);
        }
        this.firePropertyChange("Caption.width", 0, newWidth);
    }

    public void setWidthCaption(String maxString) {
        JALabel l = new JALabel(maxString);
        this.setWidthCaption((int)l.getPreferredSize().getWidth());
    }

    public void setWidthEdit(int newWidth) {
        this.firePropertyChange("Editor.width", 0, newWidth);
    }

    public void setWidthEdit(String maxString) {
        JALabel l = new JALabel(maxString);
        this.setWidthEdit((int)l.getPreferredSize().getWidth() + 6);
    }

    public void setWidthValue(int newWidth) {
        if (newWidth <= 0) {
            this.setShowValue(false);
        }
        this.firePropertyChange("Value.width", 0, newWidth);
    }

    public void setEnabled(boolean setting) {
        super.setEnabled(setting);
        this.firePropertyChange("enabled", null, null);
    }

    protected void underlineCaption(boolean underline) {
        this.mCaption.setText(this.mCaptionText);
    }

    public Object getEntryData() {
        return this.mData;
    }

    public Object getModel() {
        return this.mModel;
    }

    public void setLookupModel(Object data) {
        this.mLookupData = data;
    }

    public Object getLookupModel() {
        return this.mLookupData;
    }

    public Object getEntryValue() {
        return null;
    }

    public void setEntryValue(Object value) {
    }

    public void setEntryValue(String value) {
        this.setEntryValue((Object)value);
    }

    public void setEntryValue(Integer value) {
        this.setEntryValue((Object)value);
    }

    public void setEntryValue(Long value) {
        this.setEntryValue((Object)value);
    }

    public void setEntryValue(Boolean value) {
        this.setEntryValue((Object)value);
    }

    public void setForceStringValue(boolean forceStringValue) {
        this.mForceStringValue = forceStringValue;
    }

    public void setEditor(Object editor) {
    }

    public Object getEditor() {
        return this.mEditor;
    }

    public void setEditorProperty(String propertyName, Object setting) {
    }

    public void setFocusLostBehavior(int behavior) {
        this.mFocusLostBehavior = behavior;
    }

    public void setExitBehavior(int behavior) {
        this.mExitUpdateBehavior = behavior;
    }

    public int getExitBehavior() {
        return this.mExitUpdateBehavior;
    }

    public boolean requestFocusInWindow() {
        return false;
    }

    public int getEntryState() {
        return this.mEntryState;
    }

    public void setEntryState(int entryState) {
    }

    public String getCaption() {
        return this.mCaptionText;
    }

    public void setCaption(String newCaption) {
        String oldValue = this.getCaption();
        this.mCaptionText = newCaption;
        this.firePropertyChange("Caption.text", oldValue, this.mCaptionText);
    }

    protected void setCaptionIcon(Icon _Icon) {
        Icon oldValue = this.mCaptionIcon;
        this.mCaptionIcon = _Icon;
        if (this.mCaption != null) {
            this.mCaption.setHorizontalTextPosition(10);
            this.mCaption.setIcon(this.mCaptionIcon);
        }
        this.firePropertyChange("Caption.icon", oldValue, this.mCaptionIcon);
    }

    public JComponent getCaptionComponent() {
        return this.mCaption;
    }

    public void setCaptionOrientation(int orientation) {
        this.firePropertyChange("Caption.orientation", 0, orientation);
    }

    public void setCaptionHorizontalAlignment(int alignment) {
        this.firePropertyChange("Caption.alignment", 0, alignment);
    }

    public void setUnderlineCaption(boolean underline) {
        this.setCaption(this.getCaption());
    }

    public void setValue(String value) {
    }

    public String getValue() {
        return null;
    }

    public Object getValueComponent() {
        return null;
    }

    public void setValueRenderer(Object renderer) {
    }

    public void setEntryFrom(JAEntry newEntryFrom) {
        this.mEntryFrom = newEntryFrom;
    }

    public JAEntry getEntryFrom() {
        return this.mEntryFrom;
    }

    public void setEntryTo(JAEntry newEntryTo) {
        this.mEntryTo = newEntryTo;
    }

    public JAEntry getEntryTo() {
        return this.mEntryTo;
    }

    public void updateFromTo() {
        this.updateEntryFrom();
        this.updateEntryTo();
    }

    protected void updateEntryFrom() {
    }

    protected void updateEntryTo() {
    }

    protected void setWaitCursor() {
    }

    protected void setHandCursor() {
    }

    protected void setDefaultCursor() {
    }

    public void setPerformBrowseOperation(boolean setting) {
        this.mPerformBrowseOperation = setting;
    }

    public void first() {
    }

    protected void firstMain() {
    }

    protected void firstLookup() {
    }

    public void last() {
    }

    protected void lastMain() {
    }

    protected void lastLookup() {
    }

    public void browsePrior() {
    }

    protected void browsePriorMain() {
    }

    protected void browsePriorLookup() {
    }

    public void browseNext() {
    }

    protected void browseNextMain() {
    }

    protected void browseNextLookup() {
    }

    protected void findNearest(boolean updateFromTo) {
    }

    protected void findNearestMain() {
    }

    protected void findNearestLookup() {
    }

    public boolean executeFindNearestLookup() {
        return false;
    }

    public void findNearest() {
    }

    public void findBySysKey(String syskey) {
    }

    protected void findBySysKeyMain(String syskey) {
    }

    protected void findBySysKeyLookup(String syskey) {
    }

    protected Object getCalendarPopupInstance() {
        return null;
    }

    protected Object getMonthPopupInstance() {
        return null;
    }

    public void calendarAction() {
    }

    public Object getMonthPopup() {
        return null;
    }

    public void setMonthPopup(Object monthPopup) {
    }

    public Object getCalendarPopup() {
        return null;
    }

    public void setCalendarPopup(Object calendarPopup) {
    }

    public void promptCaption(Runnable callback) {
    }

    public void prompt(Runnable callback) {
    }

    protected void promptExecute(Runnable callback) {
    }

    protected void promptExecute2() {
    }

    private Window findContainingWindow() {
        Container component = this.mIsCellEditor ? this.mCellEditorParent : this;
        while (!((component = component.getParent()) instanceof Window)) {
        }
        return (Window)component;
    }

    public boolean isPromptInitialized() {
        return false;
    }

    public void setF4BaseDialog(Object dialog) {
    }

    public Object getF4ListBaseDialog() {
        return null;
    }

    public void setExtendedF4BaseDialog(Object dialog) {
    }

    public void initPrompt(Object data) {
    }

    public void initExtendedPrompt(Object data) {
    }

    public void initPrompt(Object model, Object data, Object def) {
    }

    public void initExtendedPrompt(Object data, Object def) {
    }

    public void initPromptWithModel() {
    }

    public void initExtendedPromptWithModel() {
    }

    public void resetPrompt() {
    }

    public void resetExtendedPrompt() {
    }

    public void initPromptWithModel(Object def) {
    }

    public void initExtendedPromptWithModel(Object def) {
    }

    public void setShiftF4ListListener(ActionListener listener) {
    }

    public void setEntryToF4ListSynch(Object synch) {
    }

    public void removeStandardListener(Object l) {
    }

    public void addStandardListener(Object l) {
    }

    public void abaDisplay() {
    }

    protected void refreshEntryData() {
    }

    protected void abaDisplayMain() {
    }

    private boolean entryValueEqualsValue(Object entryValue, Object lookupEntryValue) {
        return false;
    }

    protected void abaDisplayLookupValue() {
    }

    public void abaUpdate() {
    }

    protected void abaUpdateLookup() {
    }

    public void abaClear() {
    }

    public void abaValidate() {
    }

    public void requestEnter(Component context) {
    }

    public void requestExit(Component context) {
    }

    public void fireKeyTyped(KeyEvent e) {
        if (this.mKeyListenerContainer == null) {
            return;
        }
        Iterator i = this.mKeyListenerContainer.iterator();
        while (i.hasNext()) {
            ((KeyListener)i.next()).keyTyped(e);
        }
    }

    public void fireKeyPressed(KeyEvent e) {
    }

    public void fireKeyReleased(KeyEvent e) {
    }

    public void removeKeyListener(KeyListener l) {
    }

    public void addKeyListener(KeyListener l) {
    }

    public void removeFocusListener(FocusListener l) {
    }

    public void addFocusListener(FocusListener l) {
    }

    public Object getDispatcher() {
        return null;
    }

    public boolean isCellEditor() {
        return this.mIsCellEditor;
    }

    public void setIsCellEditor(boolean isCellEditor, JTable table) {
    }

    public void setTiggerModificationEventsOnDisplay(boolean setting) {
        this.mAbaDisplayTriggersModifications = setting;
    }

    public boolean isUppercaseSort() {
        return this.mUppercaseSort;
    }

    public void setUppercaseSort(boolean uppercaseSort) {
        this.mUppercaseSort = uppercaseSort;
    }

    public boolean isUseDataFlexSort() {
        return this.mUseDataFlexSort;
    }

    public void setUseDataFlexSort(boolean useDataFlexSort) {
        this.mUseDataFlexSort = useDataFlexSort;
    }

    public Component getFirstFocusableComponent() {
        return null;
    }

    public void setWeight(long weight) {
    }

    public long getWeight() {
        return 0L;
    }

    public int getComponentPos(Component comp) {
        return 0;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        this.mModified = true;
    }

    public boolean isEntryModified() {
        return this.mModified;
    }

    public void setEntryModified(boolean modified) {
        this.mModified = modified;
    }

    public boolean isEntryValueModified() {
        return !this.mOldEntryValue.equals(this.getEntryValue());
    }

    public void abaDisplay(Object _Sender, Object _Parameters) {
        this.abaDisplay();
        this.fireCFWAbaDisplay(_Sender, _Parameters);
    }

    public String getDataColumnName() {
        return this.m_DataColumnName;
    }

    public void setDataColumnName(String _Name) {
        this.m_DataColumnName = _Name;
    }

    public void valueChanged(Object _Sender) {
        this.fireCFWComponentValueChanged(_Sender);
    }

    public void handleMessage(Object _Sender, Object _Message, Object _Parameters) {
        this.fireCFWHandleMessage(_Sender, _Message, _Parameters);
    }

    public boolean isModified() {
        return this.isEntryModified();
    }

    public void setModified(boolean _Value) {
        this.setEntryModified(_Value);
    }

    public void setAutoSynchronizeSameColumns(boolean _value) {
        this.m_AutoAbaDisplaySameColumns = _value;
    }

    public boolean getAutoSynchronizeSameColumns() {
        return this.m_AutoAbaDisplaySameColumns;
    }

    public void synchronizeSameColumns(Object _Parameter) {
    }

    public void fireCFWComponentValueChanged(Object _Sender) {
    }

    public void fireCFWAbaDisplay(Object _Sender, Object _Parameters) {
    }

    public void fireCFWHandleMessage(Object _Sender, Object _Message, Object _Parameters) {
    }

    public Object getMainDataSource() {
        return null;
    }

    public int getDataSourceCount() {
        return this.m_CFWDataSources.size();
    }

    public void setBackgroundEditor(Color bg) {
        this.m_BackgroundEditor = bg;
        this.setEditorColors();
    }

    public void setForegroundEditor(Color fg) {
        this.m_ForegroundEditor = fg;
        this.setEditorColors();
    }

    public void setEditorColors() {
    }

    public Color getBackgroundEditor() {
        return this.m_BackgroundEditor;
    }

    public Color getForegroundEditor() {
        return this.m_ForegroundEditor;
    }

    public void setHistroyEnabled(boolean enabled) {
    }

    public boolean isHistoryEnabled() {
        return this.m_HistoryEnabled;
    }

    public boolean isQuickSearchEnabled() {
        return this.mQuickSearchEnabled;
    }

    public void removeQuickSearch() {
    }

    public void initQuickSearch(String alias, String file, String appChar, String fieldName) {
    }

    public void reInitQuickSearch(String fieldName) {
    }

    public void reInitQuickSearch(String alias, String file, String appChar, String fieldName) {
    }

    protected class EditorFocusListener
    extends FocusAdapter {
        protected EditorFocusListener() {
        }
    }

    public class JAEntryLabel
    extends JALabel {
        public JAEntryLabel() {
        }

        public JAEntryLabel(String text) {
            super(text);
        }

        public void abaDisplay() {
        }

        public void abaClear() {
        }

        public void abaUpdate() {
        }

        public void abaValidate() {
        }

        public void requestEnter(Component context) {
        }

        public void requestExit(Component context) {
        }

        public void removeActionListener(ActionListener l) {
        }

        public void addActionListener(ActionListener l) {
        }

        public Object getDispatcher() {
            return null;
        }
    }
}

