/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.ArrayList;

public class ColumnLayout
implements LayoutManager2 {
    public static final int NO_VARIABLE_COLUMN = -1;
    public static final String FULL_LINE = "line";
    private int mHgap;
    private int mVgap;
    private final int mColumnCount;
    private final int mVariableColumn;
    private final ArrayList<LineItem> mComponentLines = new ArrayList();
    private Point mCurrentPoint;
    private Insets mInsets = new Insets(0, 0, 0, 0);

    public ColumnLayout(int columnCount) {
        this(columnCount, columnCount - 1, 20, 5);
    }

    public ColumnLayout(int columnCount, int hgap, int vgap) {
        this(columnCount, columnCount - 1, hgap, vgap);
    }

    public ColumnLayout(int columnCount, int variableColumn, int hgap, int vgap) {
        if (columnCount < 1) {
            throw new IllegalArgumentException("columncount must be greater than zero");
        }
        if (variableColumn < -1 || variableColumn >= columnCount) {
            throw new IllegalArgumentException("variable column must be a valid column or -1");
        }
        this.mColumnCount = columnCount;
        this.mVariableColumn = variableColumn;
        this.mHgap = hgap;
        this.mVgap = vgap;
        this.mCurrentPoint = new Point(0, 0);
    }

    public int getHgap() {
        return this.mHgap;
    }

    public void setHgap(int hgap) {
        this.mHgap = hgap;
    }

    public int getVgap() {
        return this.mVgap;
    }

    public void setVgap(int vgap) {
        this.mVgap = vgap;
    }

    public int getColumnCount() {
        return this.mColumnCount;
    }

    public int getVariableColumn() {
        return this.mVariableColumn;
    }

    public Insets getInsets() {
        return this.mInsets;
    }

    public void setInsets(int top, int left, int bottom, int right) {
        this.mInsets.top = top;
        this.mInsets.left = left;
        this.mInsets.bottom = bottom;
        this.mInsets.right = right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints != null && !(constraints instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)constraints, comp);
        }
    }

    private Component getComponent(Point point) {
        if (point.y >= this.mComponentLines.size()) {
            return null;
        }
        LineItem line = this.mComponentLines.get(point.y);
        if (line == null) {
            return null;
        }
        return line.isSingle() ? line.get() : line.get(point.x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(String name, Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (name == null) {
                for (int i = this.mComponentLines.size(); i <= this.mCurrentPoint.y; ++i) {
                    this.mComponentLines.add(null);
                }
                LineItem line = this.mComponentLines.get(this.mCurrentPoint.y);
                if (line == null) {
                    line = new LineItem();
                    this.mComponentLines.set(this.mCurrentPoint.y, line);
                }
                line.set(this.mCurrentPoint.x, comp);
                do {
                    ++this.mCurrentPoint.x;
                    if (this.mCurrentPoint.x < this.mColumnCount) continue;
                    this.mCurrentPoint.x = 0;
                    ++this.mCurrentPoint.y;
                } while (this.getComponent(this.mCurrentPoint) != null);
            } else if (FULL_LINE.equals(name)) {
                if (this.mCurrentPoint.x != 0) {
                    ++this.mCurrentPoint.y;
                }
                this.mCurrentPoint.x = 0;
                for (int i = this.mComponentLines.size(); i <= this.mCurrentPoint.y; ++i) {
                    this.mComponentLines.add(null);
                }
                this.mComponentLines.set(this.mCurrentPoint.y++, new LineItem(comp));
                while (this.getComponent(this.mCurrentPoint) != null) {
                    ++this.mCurrentPoint.x;
                    if (this.mCurrentPoint.x < this.mColumnCount) continue;
                    this.mCurrentPoint.x = 0;
                    ++this.mCurrentPoint.y;
                }
            } else {
                int line;
                int pos = name.indexOf(44);
                int column = -1;
                if (pos == -1) {
                    try {
                        line = Integer.parseInt(name);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("cannot add to layout: " + name + " cannot be interpreted as linenumber use a number");
                    }
                }
                try {
                    column = Integer.parseInt(name.substring(0, pos));
                    line = Integer.parseInt(name.substring(pos + 1));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("cannot add to layout: " + name + " cannot be interpreted as coordinate, specify something like 1,2");
                }
                if (line < 0) {
                    throw new IllegalArgumentException("cannot add to layout at line " + line + ": line cannot be negative");
                }
                for (int i = this.mComponentLines.size(); i <= line; ++i) {
                    this.mComponentLines.add(null);
                }
                if (column == -1) {
                    this.mComponentLines.set(line, new LineItem(comp));
                } else {
                    if (column < 0) {
                        throw new IllegalArgumentException("cannot add to layout at column " + column + ": column cannot be negative");
                    }
                    if (column >= this.mColumnCount) {
                        throw new IllegalArgumentException("cannot add to layout at column " + column + ": maximum column is " + (this.mColumnCount - 1) + " ");
                    }
                    LineItem lineItem = this.mComponentLines.get(line);
                    if (lineItem == null) {
                        lineItem = new LineItem(comp);
                        this.mComponentLines.set(line, lineItem);
                    }
                    lineItem.set(column, comp);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            for (LineItem line : this.mComponentLines) {
                if (line == null) continue;
                line.remove(comp);
            }
        }
    }

    private boolean isVariableColumn(int ix) {
        return ix == this.mVariableColumn;
    }

    public boolean hasVariableColumn() {
        return this.mVariableColumn != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int i;
            int[] widths = new int[this.mColumnCount];
            int[] heights = new int[this.mComponentLines.size()];
            int fullLineWidth = 0;
            for (int i2 = 0; i2 < this.mComponentLines.size(); ++i2) {
                LineItem line = this.mComponentLines.get(i2);
                if (line == null) continue;
                if (!line.isSingle()) {
                    for (int ix = 0; ix < Math.min(line.size(), this.mColumnCount); ++ix) {
                        Component c = line.get(ix);
                        if (c == null) continue;
                        Dimension d = c.getMinimumSize();
                        if (d.width > widths[ix]) {
                            widths[ix] = d.width;
                        }
                        if (d.height <= heights[i2]) continue;
                        heights[i2] = d.height;
                    }
                    continue;
                }
                Dimension d = line.get().getMinimumSize();
                if (d.width > fullLineWidth) {
                    fullLineWidth = d.width;
                }
                if (d.height <= heights[i2]) continue;
                heights[i2] = d.height;
            }
            Dimension dim = new Dimension(0, 0);
            for (i = 0; i < widths.length; ++i) {
                dim.width += widths[i];
                if (i == 0) continue;
                dim.width += this.mHgap;
            }
            if (fullLineWidth > dim.width) {
                dim.width = fullLineWidth;
            }
            for (i = 0; i < heights.length; ++i) {
                dim.height += heights[i];
                if (i == 0) continue;
                dim.height += this.mVgap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.mInsets.left + this.mInsets.right;
            dim.height += insets.top + insets.bottom + this.mInsets.top + this.mInsets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int i;
            int[] widths = new int[this.mColumnCount];
            int[] heights = new int[this.mComponentLines.size()];
            int fullLineWidth = 0;
            for (int i2 = 0; i2 < this.mComponentLines.size(); ++i2) {
                LineItem line = this.mComponentLines.get(i2);
                if (line == null) continue;
                if (!line.isSingle()) {
                    for (int ix = 0; ix < Math.min(line.size(), this.mColumnCount); ++ix) {
                        Component c = line.get(ix);
                        if (c == null) continue;
                        Dimension d = c.getPreferredSize();
                        if (d.width > widths[ix]) {
                            widths[ix] = d.width;
                        }
                        if (d.height <= heights[i2]) continue;
                        heights[i2] = d.height;
                    }
                    continue;
                }
                Dimension d = line.get().getPreferredSize();
                if (d.width > fullLineWidth) {
                    fullLineWidth = d.width;
                }
                if (d.height <= heights[i2]) continue;
                heights[i2] = d.height;
            }
            Dimension dim = new Dimension(0, 0);
            for (i = 0; i < widths.length; ++i) {
                dim.width += widths[i];
                if (i == 0) continue;
                dim.width += this.mHgap;
            }
            if (fullLineWidth > dim.width) {
                dim.width = fullLineWidth;
            }
            for (i = 0; i < heights.length; ++i) {
                dim.height += heights[i];
                if (i == 0) continue;
                dim.height += this.mVgap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.mInsets.left + this.mInsets.right;
            dim.height += insets.top + insets.bottom + this.mInsets.top + this.mInsets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension maximumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int i;
            int[] widths = new int[this.mColumnCount];
            int[] heights = new int[this.mComponentLines.size()];
            int fullLineWidth = 0;
            for (int i2 = 0; i2 < this.mComponentLines.size(); ++i2) {
                LineItem line = this.mComponentLines.get(i2);
                if (line == null) continue;
                if (!line.isSingle()) {
                    for (int ix = 0; ix < Math.min(line.size(), this.mColumnCount); ++ix) {
                        Component c = line.get(ix);
                        if (c == null) continue;
                        Dimension d = c.getMaximumSize();
                        if (d.width > widths[ix]) {
                            widths[ix] = d.width;
                        }
                        if (d.height <= heights[i2]) continue;
                        heights[i2] = d.height;
                    }
                    continue;
                }
                Dimension d = line.get().getMaximumSize();
                if (d.width > fullLineWidth) {
                    fullLineWidth = d.width;
                }
                if (d.height <= heights[i2]) continue;
                heights[i2] = d.height;
            }
            Dimension dim = new Dimension(0, 0);
            for (i = 0; i < widths.length; ++i) {
                dim.width += widths[i];
                if (i == 0) continue;
                dim.width += this.mHgap;
            }
            if (fullLineWidth > dim.width) {
                dim.width = fullLineWidth;
            }
            for (i = 0; i < heights.length; ++i) {
                dim.height += heights[i];
                if (i == 0) continue;
                dim.height += this.mVgap;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.mInsets.left + this.mInsets.right;
            dim.height += insets.top + insets.bottom + this.mInsets.top + this.mInsets.bottom;
            return dim;
        }
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
        for (int i = this.mComponentLines.size() - 1; i >= 0; --i) {
            LineItem line = this.mComponentLines.get(i);
            if (line == null) {
                this.mComponentLines.remove(i);
                continue;
            }
            if (!line.isSingle()) {
                boolean doRemove = true;
                for (int ii = line.size() - 1; ii >= 0; --ii) {
                    if (line.get(ii) == null) continue;
                    if (ii == line.size() - 1) {
                        this.mCurrentPoint.y = i + 1;
                        this.mCurrentPoint.x = 0;
                    } else {
                        this.mCurrentPoint.y = i;
                        this.mCurrentPoint.x = ii + 1;
                    }
                    doRemove = false;
                    break;
                }
                if (!doRemove) break;
                this.mComponentLines.remove(i);
                continue;
            }
            this.mCurrentPoint.y = i;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int top = insets.top + this.mInsets.top;
            int[] widths = new int[this.mColumnCount];
            int[] heights = new int[this.mComponentLines.size()];
            for (int iy = 0; iy < this.mComponentLines.size(); ++iy) {
                LineItem line = this.mComponentLines.get(iy);
                if (line == null) continue;
                if (!line.isSingle()) {
                    for (int ix = 0; ix < Math.min(line.size(), this.mColumnCount); ++ix) {
                        Component c = line.get(ix);
                        if (c == null) continue;
                        Dimension d = c.getPreferredSize();
                        if (!this.isVariableColumn(ix)) {
                            widths[ix] = Math.max(d.width, widths[ix]);
                        }
                        heights[iy] = Math.max(d.height, heights[iy]);
                    }
                    continue;
                }
                Dimension d = line.get().getPreferredSize();
                heights[iy] = d.height;
            }
            int leftWidth = target.getWidth() - insets.right - insets.left - this.mInsets.right - this.mInsets.left;
            if (this.hasVariableColumn()) {
                for (int i = 0; i < widths.length; ++i) {
                    if (i != 0) {
                        leftWidth -= this.mHgap;
                    }
                    leftWidth -= widths[i];
                }
            }
            for (int iy = 0; iy < this.mComponentLines.size(); ++iy) {
                int left = insets.left + this.mInsets.left;
                LineItem line = this.mComponentLines.get(iy);
                if (line == null) continue;
                if (!line.isSingle()) {
                    for (int ix = 0; ix < Math.min(line.size(), this.mColumnCount); ++ix) {
                        Component c = line.get(ix);
                        if (!this.isVariableColumn(ix)) {
                            if (c != null) {
                                c.setBounds(left, top, widths[ix], heights[iy]);
                            }
                            left += widths[ix] + this.mHgap;
                            continue;
                        }
                        if (c != null) {
                            c.setBounds(left, top, leftWidth, heights[iy]);
                        }
                        left += leftWidth + this.mHgap;
                    }
                } else {
                    line.get().setBounds(left, top, target.getWidth() - insets.right - insets.left - this.mInsets.right - this.mInsets.left, heights[iy]);
                }
                top += heights[iy] + this.mVgap;
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[columncount=" + this.mColumnCount + ",variablecolumn=" + this.mVariableColumn + ",hgap=" + this.mHgap + ",vgap=" + this.mVgap + "]";
    }

    public void removeLine(int line) {
        if (line >= 0 && line < this.mComponentLines.size()) {
            this.mComponentLines.remove(line);
        }
        this.invalidateLayout(null);
    }

    public Component[] getLine(int line) {
        LineItem lineItem;
        if (line >= 0 && line < this.mComponentLines.size() && (lineItem = this.mComponentLines.get(line)) != null) {
            return lineItem.getComponentArray();
        }
        return new Component[0];
    }

    public int getLineCount() {
        return this.mComponentLines.size();
    }

    class LineItem {
        private Component mSingleComponent;
        private ArrayList<Component> mComponents;

        public LineItem(Component singleComponent) {
            this.mSingleComponent = singleComponent;
        }

        public LineItem() {
        }

        boolean isSingle() {
            return this.mSingleComponent != null;
        }

        Component get(int index) {
            if (index >= this.mComponents.size()) {
                return null;
            }
            return this.mComponents.get(index);
        }

        Component get() {
            return this.mSingleComponent;
        }

        void set(int index, Component component) {
            if (this.mSingleComponent != null || this.mComponents == null) {
                this.mComponents = new ArrayList();
            }
            this.mSingleComponent = null;
            for (int i = 0; i <= index; ++i) {
                this.mComponents.add(null);
            }
            this.mComponents.set(index, component);
        }

        void set(Component component) {
            this.mComponents = null;
            this.mSingleComponent = component;
        }

        void remove(Component component) {
            if (this.mSingleComponent == component) {
                this.mSingleComponent = null;
            }
            if (this.mComponents != null) {
                for (int i = this.mComponents.size() - 1; i >= 0; --i) {
                    Component c = this.mComponents.get(i);
                    if (c != component) continue;
                    this.mComponents.remove(i);
                }
            }
        }

        public int size() {
            assert (this.mSingleComponent == null);
            return this.mComponents != null ? this.mComponents.size() : 0;
        }

        Component[] getComponentArray() {
            Component[] componentArray;
            if (this.mSingleComponent != null) {
                Component[] componentArray2 = new Component[1];
                componentArray = componentArray2;
                componentArray2[0] = this.mSingleComponent;
            } else {
                componentArray = this.mComponents != null ? this.mComponents.toArray(new Component[this.mComponents.size()]) : new Component[]{};
            }
            return componentArray;
        }
    }
}

