/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.menu.Catalog;
import ch.abacus.lib.ui.plaf.generic.GenericBorders;
import ch.abacus.lib.ui.plaf.generic.GenericLookAndFeel;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;

class GenericButtonListener
extends BasicButtonListener {
    private Border mSavedBorder;
    private Color mSavedBackgroundColor;
    private Border mSavedFocuesdBorder;
    private Color mSavedFocusedBackgroundColor;

    public GenericButtonListener(AbstractButton b) {
        super(b);
    }

    public void focusGained(FocusEvent e) {
        if (((JComponent)e.getSource()).isEnabled()) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (!button.getBackground().equals(GenericLookAndFeel.getSelectColor()) && !button.getBackground().equals(GenericLookAndFeel.getFillDown())) {
                if (!button.getModel().isPressed()) {
                    this.mSavedFocusedBackgroundColor = button.getBackground();
                    this.mSavedFocuesdBorder = button.getBorder();
                    button.setBackground(GenericLookAndFeel.getSelectColor());
                } else {
                    button.setBackground(GenericLookAndFeel.getFillDown());
                }
            }
            ((JComponent)e.getSource()).repaint();
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.mSavedFocusedBackgroundColor != null && this.mSavedFocuesdBorder != null) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (button.getParent() != null && button.getParent().getParent() instanceof Catalog) {
                if (!button.getModel().isPressed()) {
                    button.setBackground(this.mSavedFocusedBackgroundColor);
                    button.setBorder(this.mSavedFocuesdBorder);
                    this.mSavedFocusedBackgroundColor = null;
                    this.mSavedFocuesdBorder = null;
                }
            } else {
                button.setBackground(this.mSavedFocusedBackgroundColor);
                button.setBorder(this.mSavedFocuesdBorder);
            }
            ((JComponent)e.getSource()).repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
        AbstractButton button;
        super.mouseEntered(e);
        if (((JComponent)e.getSource()).isEnabled() && !(button = (AbstractButton)e.getSource()).getBackground().equals(GenericLookAndFeel.getSelectColor()) && !button.getBackground().equals(GenericLookAndFeel.getFillDown())) {
            if (!button.getModel().isPressed()) {
                if (button.getModel().isSelected()) {
                    this.mSavedBackgroundColor = button.getBackground();
                    this.mSavedBorder = button.getBorder();
                    button.setBackground(GenericLookAndFeel.getSelectColor());
                } else {
                    this.mSavedBackgroundColor = button.getBackground();
                    this.mSavedBorder = button.getBorder();
                    button.setBackground(GenericLookAndFeel.getSelectColor());
                }
            } else {
                button.setBackground(GenericLookAndFeel.getFillDown());
            }
            button.setBorder(GenericBorders.getHoveredButtonBorder(button));
        }
    }

    public void mouseExited(MouseEvent e) {
        super.mouseExited(e);
        if (this.mSavedBackgroundColor != null && this.mSavedBorder != null) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (!button.getModel().isPressed()) {
                button.setBackground(this.mSavedBackgroundColor);
                button.setBorder(this.mSavedBorder);
                this.mSavedBackgroundColor = null;
                this.mSavedBorder = null;
            } else if (!button.isFocusable()) {
                button.setBorder(this.mSavedBorder);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (((JComponent)e.getSource()).isEnabled()) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (this.mSavedBackgroundColor == null && this.mSavedBorder == null) {
                this.mSavedBackgroundColor = button.getBackground();
                this.mSavedBorder = button.getBorder();
            } else {
                button.setBackground(this.mSavedBackgroundColor);
                button.setBorder(this.mSavedBorder);
            }
            button.setBackground(GenericLookAndFeel.getFillDown());
        }
    }

    public void mouseReleased(MouseEvent e) {
        AbstractButton button;
        super.mouseReleased(e);
        if (this.mSavedBackgroundColor != null && this.mSavedBorder != null && !(button = (AbstractButton)e.getSource()).getModel().isPressed()) {
            if (button.getModel().isSelected()) {
                button.setBackground(GenericLookAndFeel.getSelectColor());
            } else if (button.isFocusOwner()) {
                button.setBackground(GenericLookAndFeel.getSelectColor());
                button.setBorder(GenericBorders.getHoveredButtonBorder(button));
            } else if (!button.isFocusable()) {
                button.setBackground(GenericLookAndFeel.getSelectColor());
                button.setBorder(GenericBorders.getHoveredButtonBorder(button));
            } else {
                button.setBackground(this.mSavedBackgroundColor);
                button.setBorder(this.mSavedBorder);
            }
        }
    }
}

