/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.plaf.generic;

import ch.abacus.lib.ui.plaf.generic.GenericBorders;
import ch.abacus.lib.ui.plaf.generic.GenericLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;

class GenericToggleButtonListener
extends BasicButtonListener {
    private Border mSavedBorder;
    private Color mSavedBackgroundColor;

    public GenericToggleButtonListener(AbstractButton b) {
        super(b);
    }

    public void focusGained(FocusEvent e) {
        Component c = (Component)e.getSource();
        c.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        if (((JComponent)e.getSource()).isEnabled()) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (!button.getModel().isPressed()) {
                this.mSavedBackgroundColor = button.getBackground();
                this.mSavedBorder = button.getBorder();
                button.setBackground(GenericLookAndFeel.getSelectColor());
            } else {
                button.setBackground(GenericLookAndFeel.getFillDown());
            }
            button.setBorder(GenericBorders.getHoveredButtonBorder(button));
        }
    }

    public void mouseExited(MouseEvent e) {
        AbstractButton button;
        if (this.mSavedBackgroundColor != null && this.mSavedBorder != null && !(button = (AbstractButton)e.getSource()).getModel().isPressed()) {
            button.setBackground(this.mSavedBackgroundColor);
            button.setBorder(this.mSavedBorder);
            this.mSavedBackgroundColor = null;
            this.mSavedBorder = null;
        }
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (((JComponent)e.getSource()).isEnabled()) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (this.mSavedBackgroundColor == null && this.mSavedBorder == null) {
                this.mSavedBackgroundColor = button.getBackground();
                this.mSavedBorder = button.getBorder();
            }
            button.setBackground(GenericLookAndFeel.getFillDown());
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        if (this.mSavedBackgroundColor != null && this.mSavedBorder != null) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (!button.getModel().isPressed()) {
                button.setBackground(this.mSavedBackgroundColor);
                button.setBorder(this.mSavedBorder);
            }
            this.mSavedBackgroundColor = null;
            this.mSavedBorder = null;
        }
    }
}

