/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.abaRenderer;

import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.abaRenderer.AbaRendererInterface;
import ch.abacus.lib.ui.renderer.abaRenderer.RendererFocusNode;
import ch.abacus.lib.ui.renderer.abaRenderer.RendererFocusTraversalPolicy;
import ch.abacus.lib.ui.renderer.abaRenderer.StaticRendererData;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerClassLoader;
import ch.abacus.lib.ui.renderer.common.HammerConfigurationManager;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerFileManager;
import ch.abacus.lib.ui.renderer.common.HammerLNF;
import ch.abacus.lib.ui.renderer.common.HammerLogFileAccess;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetaType;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.RenderingProjectInterface;
import ch.abacus.lib.util.CloseInterface;
import ch.abacus.lib.util.GlobalInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.JTextComponent;

public class AbaRenderer
implements AbaMetaDataUser,
CloseInterface,
AbaRendererInterface {
    public String theXMLDocumentName = "";
    public byte[] theProzBuffer = null;
    public String theProzBufferClassName = null;
    public boolean attachedToDesigner = false;
    public String sBufferedXML;
    public String sBaseDir = "";
    public String sUserHome = "";
    public Object theRenderingDestination;
    public String SystemConfigurationPathName = "ch.abacus.lib.ui.renderer.deploy.";
    public String SystemConfigurationDocumentName = "hammer-configuration.xml";
    public String SystemMetadataDocumentName = "metadata.meta";
    public Properties props = null;
    public MetaProject theProject = null;
    public HammerFileManager theFileManager = new HammerFileManager(this);
    public HammerLogFileAccess theLogFile = null;
    public HammerConfigurationManager theConfigurationManager = null;
    public HammerClassLoader theClassLoader = null;
    public String theSeparator = "";
    public int iVersion = 0;
    public int iRevision = 1;
    public int iSubRevision = 1;
    public int iBuild = 1;
    public int theLanguage = 0;
    public PrintStream oldErr = null;
    public GlobalInterface theGlobalInterface = null;
    public static final int NO_MODE = 0;
    public static final int DESIGN_MODE = 1;
    public static final int EXECUTION_MODE = 2;
    public int iInputType = 0;
    public MetadataDispenser theMetadataDispenser;
    protected WeakHashMap theRegisteredInterfaceObjects = new WeakHashMap(0);
    private boolean bNovaState = false;
    private boolean bOpenSourceState = false;
    private boolean bLoaded = false;
    public boolean bAddDefaultPaths = false;

    public String getSystemMetadataDocumentName() {
        return this.SystemMetadataDocumentName;
    }

    public void setSystemMetadataDocumentName(String SystemDocumentName) {
        this.SystemMetadataDocumentName = SystemDocumentName;
    }

    public String getSystemConfigurationPathName() {
        return this.SystemConfigurationPathName;
    }

    public void setSystemConfigurationPathName(String systemConfigurationPathName) {
        this.SystemConfigurationPathName = systemConfigurationPathName;
    }

    public String getSystemConfigurationDocumentName() {
        return this.SystemConfigurationDocumentName;
    }

    public void setSystemConfigurationDocumentName(String systemConfigurationDocumentName) {
        this.SystemConfigurationDocumentName = systemConfigurationDocumentName;
    }

    public boolean getGuruState() {
        return false;
    }

    public void showObject(MetaObject theBottomPanel) {
    }

    public void tellProgress(String s) {
    }

    public Properties getProps() {
        return this.props;
    }

    public String getUserHome() {
        return this.sUserHome;
    }

    public String getBaseDir() {
        return this.sBaseDir;
    }

    public int getVersionNumber() {
        return this.iVersion;
    }

    public int getRevisionNumber() {
        return this.iRevision;
    }

    public int getSubRevisionNumber() {
        return this.iSubRevision;
    }

    public int getBuildNumber() {
        return this.iBuild;
    }

    public HammerLogFileAccess getLogFile() {
        return this.theLogFile;
    }

    public HammerFileManager getFileManager() {
        return this.theFileManager;
    }

    public void setFileManager(HammerFileManager theFileManager) {
        this.theFileManager = theFileManager;
    }

    public HammerConfigurationManager getConfigurationManager() {
        return this.theConfigurationManager;
    }

    public void setConfigurationManager(HammerConfigurationManager theConfigurationManager) {
        this.theConfigurationManager = theConfigurationManager;
    }

    public HammerClassLoader getClassLoader() {
        return this.theClassLoader;
    }

    public void setClassLoader(HammerClassLoader theClassLoader) {
        this.theClassLoader = theClassLoader;
    }

    public void setBufferedXML(String sData) {
        this.sBufferedXML = sData;
    }

    public String getBufferedXML() {
        return this.sBufferedXML;
    }

    public void setAddDefaultPaths(boolean bAddDefaultPaths) {
        this.bAddDefaultPaths = bAddDefaultPaths;
    }

    public boolean getAddDefaultPaths() {
        return this.bAddDefaultPaths;
    }

    public void init(boolean bAssociateWithController) throws HammerException {
        StaticRendererData theController = StaticRendererData.getStaticData();
        String sConfigurationPath = this.getSystemConfigurationPathName() + this.getSystemConfigurationDocumentName();
        this.props = System.getProperties();
        this.theSeparator = this.props.getProperty("file.separator");
        this.oldErr = System.err;
        ClassLoader theSavedClassLoader = this.setupClassLoader();
        if (bAssociateWithController) {
            if (theController == null) {
                theController = new StaticRendererData(this, this.sBaseDir, this.sUserHome, this.theClassLoader, sConfigurationPath);
                StaticRendererData.setSavedClassLoader(theSavedClassLoader);
                StaticRendererData.setStaticData(theController);
            }
            this.theMetadataDispenser = theController.getMetadataDispenser();
            this.theMetadataDispenser.add(this);
            this.theConfigurationManager = theController.getConfigurationManager();
        } else {
            this.theConfigurationManager = new HammerConfigurationManager(this.sBaseDir, this.sUserHome, this.theClassLoader, sConfigurationPath);
        }
        if (!this.theConfigurationManager.bConfigured) {
            throw new HammerException(HammerException.NO_CONFIGURATION_MANAGER_AVAILABLE, "Cannot Load Hammer Configuration");
        }
        this.theLogFile = new HammerLogFileAccess(this);
        if (!this.theLogFile.bConfigured) {
            throw new HammerException(HammerException.NO_LOGFILE_AVAILABLE, "Cannot open or create hammer log file");
        }
        boolean bConsoleLogging = this.theConfigurationManager.checkConfigurationSetting("ConsoleLogging");
        boolean bLogging = false;
        this.bNovaState = this.theConfigurationManager.checkConfigurationSetting("Nova");
        this.bOpenSourceState = this.theConfigurationManager.checkConfigurationSetting("OpenSource");
        if (bConsoleLogging) {
            this.theLogFile.setConsoleLogging(true);
            bLogging = this.theConfigurationManager.checkConfigurationSetting("RedirectErr");
            if (bLogging) {
                System.setErr(this.theLogFile.getLogConsoleStream());
            }
            if (bLogging = this.theConfigurationManager.checkConfigurationSetting("RedirectOut")) {
                System.setOut(this.theLogFile.getLogConsoleStream());
            }
        }
        if (bLogging = this.theConfigurationManager.checkConfigurationSetting("FileLogging")) {
            this.theLogFile.setFileLogging(true);
            if (!bConsoleLogging) {
                bLogging = this.theConfigurationManager.checkConfigurationSetting("RedirectErr");
                if (bLogging) {
                    System.setErr(this.theLogFile.getLogConsoleStream());
                }
                if (bLogging = this.theConfigurationManager.checkConfigurationSetting("RedirectOut")) {
                    System.setOut(this.theLogFile.getLogConsoleStream());
                }
            }
        }
        if (bLogging = this.theConfigurationManager.checkConfigurationSetting("ExtendedLogging")) {
            this.theLogFile.setExtendedLogging(true);
        }
        if (bLogging = this.theConfigurationManager.checkConfigurationSetting("NLSLogging")) {
            this.theLogFile.setNLSLogging(true);
        }
        if (bLogging = this.theConfigurationManager.checkConfigurationSetting("DedicatedLogging")) {
            this.theLogFile.setDedicatedConsole(true);
        }
        if (bLogging = this.theConfigurationManager.checkConfigurationSetting("DebuggingLogging")) {
            this.theLogFile.setDebuggingLogging(true);
        }
        if (bLogging = this.theConfigurationManager.checkConfigurationSetting("ClassLoaderLogging")) {
            this.theLogFile.setClassLoaderLogging(true);
        }
        if (bLogging = this.theConfigurationManager.checkConfigurationSetting("CacheManagerLogging")) {
            this.theLogFile.setCacheManagerLogging(true);
        }
        String sPlaf = this.theConfigurationManager.getConfigurationVariable("PLAF", "ch.abacus.lib.ui.plaf.AbacusLookAndFeel");
        try {
            new HammerLNF(this, sPlaf);
        }
        catch (UnsupportedLookAndFeelException e) {
            sPlaf = UIManager.getSystemLookAndFeelClassName();
        }
        catch (Exception e) {
            throw new HammerException(HammerException.BAD_LNF, "Cannot initialize LNF");
        }
        this.theConfigurationManager.loadNLSDocuments();
        this.setupClassLoader();
        if (this.theGlobalInterface != null) {
            this.theGlobalInterface.addToShutdownCollector(this);
        }
    }

    public void close() {
        this.theProject = null;
        this.theRenderingDestination = null;
        if (this.theClassLoader != null) {
            this.theClassLoader.setUser(null);
        }
        this.theClassLoader = null;
        if (this.theLogFile != null) {
            this.theLogFile.setUser(null);
        }
        this.theLogFile = null;
        this.theRegisteredInterfaceObjects.clear();
        if (this.theMetadataDispenser != null) {
            this.theMetadataDispenser.remove(this);
            if (this.theMetadataDispenser.getCount() == 0) {
                Thread.currentThread().setContextClassLoader(StaticRendererData.getSavedClassLoader());
                StaticRendererData.removeMetadata();
                this.theMetadataDispenser = null;
                this.theConfigurationManager = null;
                StaticRendererData.setStaticData(null);
            }
        }
        if (this.theGlobalInterface != null) {
            this.theGlobalInterface.removeFromShutdownCollector(this);
            this.theGlobalInterface = null;
        }
    }

    public void testRemove() {
        if (this.theMetadataDispenser != null) {
            this.theMetadataDispenser.remove(this);
            if (this.theMetadataDispenser.getCount() == 0) {
                StaticRendererData.removeMetadata();
                this.theMetadataDispenser = null;
            }
        }
    }

    public AbaRenderer(MetaProject theProject, boolean attachedToDesigner, GlobalInterface theGlobalInterface) throws HammerException {
        this.theXMLDocumentName = theProject.sName;
        this.attachedToDesigner = attachedToDesigner;
        this.theGlobalInterface = theGlobalInterface;
        this.init(true);
        this.theProject = new MetaProject(2, theGlobalInterface, this.theClassLoader, this.theMetadataDispenser, theProject);
    }

    public AbaRenderer(String theXMLDocumentName, boolean attachedToDesigner, GlobalInterface theGlobalInterface) throws HammerException {
        this.theXMLDocumentName = theXMLDocumentName;
        this.attachedToDesigner = attachedToDesigner;
        this.theGlobalInterface = theGlobalInterface;
        this.init(true);
    }

    public AbaRenderer(String _ClassName, byte[] theProz, boolean attachedToDesigner, GlobalInterface theGlobalInterface) throws HammerException {
        this.theProzBufferClassName = _ClassName;
        this.theProzBuffer = theProz;
        this.attachedToDesigner = attachedToDesigner;
        this.theGlobalInterface = theGlobalInterface;
        this.init(true);
    }

    public AbaRenderer(MetaProject theProject, boolean attachedToDesigner, GlobalInterface theGlobalInterface, int iInputType) throws HammerException {
        this.theXMLDocumentName = theProject.sName;
        this.attachedToDesigner = attachedToDesigner;
        this.theGlobalInterface = theGlobalInterface;
        this.init(true);
        this.theProject = new MetaProject(2, theGlobalInterface, this.theClassLoader, this.theMetadataDispenser, theProject);
        this.iInputType = iInputType;
        theProject.setInputType(iInputType);
    }

    public AbaRenderer(String theXMLParameter, boolean attachedToDesigner, GlobalInterface theGlobalInterface, int iInputType) throws HammerException {
        if (iInputType == 3) {
            this.theXMLDocumentName = "None";
            this.setBufferedXML(theXMLParameter);
        } else {
            this.theXMLDocumentName = theXMLParameter;
        }
        this.attachedToDesigner = attachedToDesigner;
        this.theGlobalInterface = theGlobalInterface;
        this.iInputType = iInputType;
        this.init(true);
    }

    public AbaRenderer() throws HammerException {
        Object theXMLParameter = null;
        this.attachedToDesigner = false;
        this.theGlobalInterface = null;
        this.init(false);
    }

    public AbaRenderer(boolean _LoadMetadata) throws HammerException {
        Object theXMLParameter = null;
        this.attachedToDesigner = false;
        this.theGlobalInterface = null;
        this.init(_LoadMetadata);
    }

    protected ClassLoader setupClassLoader() {
        String[] sPaths = null;
        if (this.theConfigurationManager != null) {
            sPaths = this.theConfigurationManager.getConfigurationVariableSet("ClassPath");
        }
        String sClassLoaderPath = null;
        String sShortClassPath = null;
        String sAuxiliaryPath = null;
        String sBaseClassPath = System.getProperty("java.class.path");
        String sUserHome = System.getProperty("user.home");
        if (sPaths != null) {
            for (int iAuxPath = 0; iAuxPath < sPaths.length; ++iAuxPath) {
                sAuxiliaryPath = iAuxPath > 0 ? sAuxiliaryPath + File.pathSeparator + sPaths[iAuxPath] : sPaths[iAuxPath];
            }
        }
        if (this.getAddDefaultPaths()) {
            sClassLoaderPath = "." + this.theSeparator;
            if (sUserHome != null) {
                sClassLoaderPath = sClassLoaderPath + File.pathSeparator + sUserHome;
            }
        } else {
            sClassLoaderPath = "";
        }
        if (sAuxiliaryPath != null) {
            sClassLoaderPath = sClassLoaderPath + File.pathSeparator + sAuxiliaryPath;
        }
        sShortClassPath = sClassLoaderPath;
        if (sBaseClassPath != null) {
            sClassLoaderPath = sClassLoaderPath + File.pathSeparator + sBaseClassPath;
        }
        if (sAuxiliaryPath == null) {
            sShortClassPath = sClassLoaderPath;
        }
        if (this.theClassLoader != null) {
            this.theClassLoader.setPaths(sClassLoaderPath, sShortClassPath);
        } else {
            this.theClassLoader = new HammerClassLoader(this, sClassLoaderPath, sShortClassPath);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.theClassLoader.getLoader());
        return oldClassLoader;
    }

    public int getInputType() {
        return this.iInputType;
    }

    public void setInputType(int iInputType) {
        this.iInputType = iInputType;
        if (this.theProject != null) {
            this.theProject.setInputType(iInputType);
        }
    }

    public boolean load() throws HammerException {
        if (this.theGlobalInterface != null) {
            if (this.theGlobalInterface.getUser() != null) {
                if (this.theGlobalInterface.getUser().getLanguage() != null) {
                    this.setLanguage(this.theGlobalInterface.getUser().getLanguage().getId());
                }
            } else if (this.theGlobalInterface.getLanguage() != null) {
                this.setLanguage(this.theGlobalInterface.getLanguage().getId());
            }
        }
        this.theProject = new MetaProject(2, this.theGlobalInterface, this.theClassLoader, this.theMetadataDispenser);
        this.theProject.setMetaDataUser(this);
        String SystemDocumentPath = this.getSystemConfigurationPathName() + this.getSystemMetadataDocumentName();
        if (SystemDocumentPath == null) {
            SystemDocumentPath = "metadata.meta";
        }
        boolean bTest = this.theProject.loadMeta(SystemDocumentPath);
        if (this.bOpenSourceState) {
            this.theProject.loadCustomMeta(SystemDocumentPath, "ch\\abacus\\components\\imported\\");
        }
        if (bTest) {
            switch (this.iInputType) {
                case 0: {
                    bTest = false;
                    if (this.theProzBuffer != null) {
                        bTest = this.theProject.loadProzBuffer(this.theProzBufferClassName, this.theProzBuffer);
                    }
                    if (this.sBufferedXML != null) {
                        bTest = this.theProject.loadXML(this.sBufferedXML);
                    }
                    if (!bTest) {
                        bTest = this.theProject.loadResource(this.theXMLDocumentName);
                    }
                    if (!bTest) {
                        bTest = this.theProject.load(this.theXMLDocumentName);
                    }
                    if (bTest) break;
                    throw new HammerException(HammerException.CANNOT_OPEN_PROJ, "Project " + this.theXMLDocumentName + " cannot be found.");
                }
                case 2: {
                    bTest = this.theProject.loadResource(this.theXMLDocumentName);
                    if (bTest) break;
                    throw new HammerException(HammerException.CANNOT_OPEN_PROJ, "Project " + this.theXMLDocumentName + " cannot be found in jars of classpath.");
                }
                case 3: {
                    if (this.sBufferedXML != null) {
                        bTest = this.theProject.loadXML(this.sBufferedXML);
                    }
                    if (bTest) break;
                    throw new HammerException(HammerException.CANNOT_OPEN_PROJ, "Project cannot be loaded from string.");
                }
                case 1: {
                    bTest = this.theProject.load(this.theXMLDocumentName);
                    if (bTest) break;
                    throw new HammerException(HammerException.CANNOT_OPEN_PROJ, "Project " + this.theXMLDocumentName + " cannot be found.");
                }
            }
        } else {
            throw new HammerException(HammerException.NO_METADATA_AVAILABLE, "Cannot load metadata.meta");
        }
        this.iInputType = this.theProject.getInputType();
        this.theProject.getNLS().Load(this.theProject);
        return bTest;
    }

    public void setLanguage(int iLanguage) {
        this.theLanguage = iLanguage;
    }

    public boolean renderCompiledClass() throws NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        this.theRenderingDestination = null;
        if (this.theProject.renderingClass == null) {
            return false;
        }
        Class cls = this.theProject.renderingClass;
        Object[] theObjects = new Object[1];
        Class[] theClasses = new Class[1];
        theObjects[0] = this;
        theClasses[0] = AbaRendererInterface.class;
        Constructor constr = cls.getConstructor(theClasses);
        RenderingProjectInterface theRenderingProject = (RenderingProjectInterface)constr.newInstance(theObjects);
        this.theRenderingDestination = theRenderingProject.getRenderingDestination();
        if (this.theRenderingDestination != null && this.theRenderingDestination instanceof JFrame) {
            ((JFrame)this.theRenderingDestination).requestFocus();
        }
        return true;
    }

    public boolean renderCompiledClass(JFrame theFrame) throws NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        RenderingProjectInterface theRenderingProject = null;
        if (this.theProject.renderingClass == null) {
            return false;
        }
        this.theRenderingDestination = theFrame;
        if (this.shouldApplyRendererFocusTraversalPolicy()) {
            RendererFocusTraversalPolicy.getInstance().init(theFrame, this.theGlobalInterface);
        }
        Class cls = this.theProject.renderingClass;
        Object[] theObjects = new Object[2];
        Class[] theClasses = new Class[2];
        theObjects[0] = this;
        theClasses[0] = AbaRendererInterface.class;
        theObjects[1] = theFrame;
        theClasses[1] = JFrame.class;
        Constructor constr = cls.getConstructor(theClasses);
        theRenderingProject = (RenderingProjectInterface)constr.newInstance(theObjects);
        this.setFocus(theFrame);
        return true;
    }

    public boolean renderCompiledClass(JComponent theComponent) throws NoSuchMethodException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Container theContainer;
        if (this.theProject.renderingClass == null) {
            return false;
        }
        for (theContainer = theComponent.getParent(); theContainer != null && !(theContainer instanceof JFrame) && !(theContainer instanceof JDialog); theContainer = theContainer.getParent()) {
            if (!this.shouldApplyRendererFocusTraversalPolicy()) continue;
            theContainer.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
        }
        this.theRenderingDestination = theComponent;
        if (theContainer != null) {
            if (this.shouldApplyRendererFocusTraversalPolicy()) {
                theContainer.setFocusTraversalPolicy(RendererFocusTraversalPolicy.getInstance());
            }
            if (theContainer instanceof JFrame) {
                if (this.shouldApplyRendererFocusTraversalPolicy()) {
                    RendererFocusTraversalPolicy.getInstance().init((JFrame)theContainer, this.theGlobalInterface);
                }
            } else if (theContainer instanceof JDialog && this.shouldApplyRendererFocusTraversalPolicy()) {
                RendererFocusTraversalPolicy.getInstance().init((JDialog)theContainer, this.theGlobalInterface);
            }
            this.theRenderingDestination = theContainer;
        }
        Class cls = this.theProject.renderingClass;
        Object[] theObjects = new Object[2];
        Class[] theClasses = new Class[2];
        theObjects[0] = this;
        theClasses[0] = AbaRendererInterface.class;
        theObjects[1] = theComponent;
        theClasses[1] = JComponent.class;
        Constructor constr = cls.getConstructor(theClasses);
        RenderingProjectInterface theRenderingProject = (RenderingProjectInterface)constr.newInstance(theObjects);
        this.setFocus(theContainer);
        return true;
    }

    public boolean renderInterface() {
        block10: {
            this.theProject.setMetaDataUser(this);
            this.theProject.setCurrentLanguage(this.theLanguage);
            if (this.iInputType == 4) {
                try {
                    return this.renderCompiledClass();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    break block10;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    break block10;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    break block10;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    break block10;
                }
            }
            MetaObject theObject = this.theProject.getFirstObject();
            while (theObject != null) {
                theObject.renderObject();
                theObject = theObject.theNextObject;
            }
            if (this.theProject.getFirstObject() != null) {
                Object theSwingObject;
                if (this.shouldApplyRendererFocusTraversalPolicy()) {
                    RendererFocusTraversalPolicy.getInstance().init(this.theProject.getFirstObject(), this.theGlobalInterface);
                }
                if ((theSwingObject = this.theProject.getFirstObject().getSwingObject()) instanceof JFrame) {
                    ((JFrame)theSwingObject).requestFocus();
                }
                this.theRenderingDestination = theSwingObject;
            }
        }
        return true;
    }

    public boolean renderInterface(JFrame theFrame) {
        block8: {
            this.theProject.setMetaDataUser(this);
            this.theProject.setCurrentLanguage(this.theLanguage);
            if (this.iInputType == 4) {
                try {
                    return this.renderCompiledClass(theFrame);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    break block8;
                }
            }
            MetaObject theObject = this.theProject.getFirstObject();
            if (this.theProject.getFirstObject() != null) {
                theObject.renderObject(theFrame);
                if (this.shouldApplyRendererFocusTraversalPolicy()) {
                    RendererFocusTraversalPolicy.getInstance().init(this.theProject.getFirstObject(), this.theGlobalInterface);
                }
            }
        }
        theFrame.requestFocus();
        this.theRenderingDestination = theFrame;
        return true;
    }

    public boolean renderInterface(JComponent theContainer) {
        block8: {
            this.theProject.setMetaDataUser(this);
            this.theProject.setCurrentLanguage(this.theLanguage);
            if (this.iInputType == 4) {
                try {
                    return this.renderCompiledClass(theContainer);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    break block8;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    break block8;
                }
            }
            MetaObject theObject = this.theProject.getFirstObject();
            if (this.theProject.getFirstObject() != null) {
                theObject.renderObject(theContainer);
                if (this.shouldApplyRendererFocusTraversalPolicy()) {
                    RendererFocusTraversalPolicy.getInstance().init(this.theProject.getFirstObject(), this.theGlobalInterface);
                }
                theContainer.requestFocus();
            }
        }
        this.theRenderingDestination = theContainer;
        return true;
    }

    public Object getObject(String sName) {
        Object objMatch = this.theRegisteredInterfaceObjects.get(sName);
        if (objMatch != null) {
            return objMatch;
        }
        MetaObject theMatch = this.theProject.findObject(sName);
        if (theMatch != null) {
            return theMatch.getSwingObject();
        }
        return null;
    }

    public Map getObjects() {
        return this.theRegisteredInterfaceObjects;
    }

    public int getMode() {
        return 1;
    }

    public void setMode(int iMode) {
    }

    public void updateDisplayLayer(MetaObject theObject, int iLayer) {
        String sName = ((AnchoringLayoutManager)theObject.theParentObject.theLayoutManager).getName(theObject.theVisualObject);
        if (sName != null) {
            ((JLayeredPane)theObject.theParentObject.theVisualObject).setLayer(theObject.theVisualObject, iLayer);
            ((AnchoringLayoutManager)theObject.theParentObject.theLayoutManager).addLayoutComponent(sName, theObject.theVisualObject);
            ((AnchoringLayoutManager)theObject.theParentObject.theLayoutManager).setAnchoring(theObject.theVisualObject, theObject.bLeftAnchoring, theObject.bRightAnchoring, theObject.bTopAnchoring, theObject.bBottomAnchoring);
        }
    }

    public void processPlacement(MetaObject theObject) {
        ButtonGroup theGroup;
        Container theContainer = null;
        theContainer = theObject.theParentObject.theVisualObject != null ? theObject.theParentObject.theVisualObject : theObject.theParentObject.theVisualFrame.getContentPane();
        if (theObject.theParentObject.isHorzSplit()) {
            if (theObject.theParentObject.getFirstChild().equals(theObject)) {
                ((JSplitPane)theContainer).setLeftComponent(theObject.theVisualObject);
            } else {
                ((JSplitPane)theContainer).setRightComponent(theObject.theVisualObject);
                int iDividerLocation = 0;
                MetaPropertyValueEx theDividerLocation = theObject.theParentObject.getPropertyValue("DividerLocation", 0);
                if (theDividerLocation != null) {
                    iDividerLocation = (Integer)theDividerLocation.getNativeValue();
                }
                ((JSplitPane)theContainer).resetToPreferredSizes();
                ((JSplitPane)theContainer).setDividerLocation(iDividerLocation);
            }
            Dimension dimSize = theObject.theVisualObject.getSize();
            Point ptLocation = theObject.theVisualObject.getLocation();
            System.out.println("Size of panel inside splitpane: " + dimSize.toString());
            System.out.println("Location of panel inside splitpane: " + ptLocation.toString());
            return;
        }
        if (theObject.theParentObject.isVertSplit()) {
            if (theObject.theParentObject.getFirstChild().equals(theObject)) {
                ((JSplitPane)theContainer).setTopComponent(theObject.theVisualObject);
            } else {
                ((JSplitPane)theContainer).setBottomComponent(theObject.theVisualObject);
                int iDividerLocation = 0;
                MetaPropertyValueEx theDividerLocation = theObject.theParentObject.getPropertyValue("DividerLocation", 0);
                if (theDividerLocation != null) {
                    iDividerLocation = (Integer)theDividerLocation.getNativeValue();
                }
                ((JSplitPane)theContainer).resetToPreferredSizes();
                ((JSplitPane)theContainer).setDividerLocation(iDividerLocation);
            }
            Dimension dimSize = theObject.theVisualObject.getSize();
            Point ptLocation = theObject.theVisualObject.getLocation();
            System.out.println("Size of panel inside splitpane: " + dimSize.toString());
            System.out.println("Location of panel inside splitpane: " + ptLocation.toString());
            return;
        }
        if (theObject.isVertSplit() || theObject.isHorzSplit()) {
            Dimension dimSize = theObject.theVisualObject.getSize();
            Point ptLocation = theObject.theVisualObject.getLocation();
            System.out.println("Size of splitpane: " + dimSize.toString());
            System.out.println("Location of splitpane: " + ptLocation.toString());
            dimSize.width = 0;
        }
        if (theObject.theVisualObject instanceof AbstractButton && theObject.theParentObject.isGroup() && (theGroup = theObject.theParentObject.getButtonGroup()) != null) {
            theGroup.add((AbstractButton)theObject.theVisualObject);
        }
        theObject.theScrollPane = null;
        AnchoringLayoutManager theParentLayout = (AnchoringLayoutManager)theObject.theParentObject.theLayoutManager;
        if (theParentLayout != null) {
            String sComponentName;
            if (theObject.bAutoEmbed) {
                theObject.theScrollPane = new JAScrollPane(theObject.theVisualObject);
                theObject.theScrollPane.setSize(theObject.dimSize);
                theObject.theScrollPane.setLocation(theObject.iXLocation, theObject.iYLocation);
                if (theObject.theVisualObject != null) {
                    theObject.theScrollPane.getViewport().setBackground(theObject.theVisualObject.getBackground());
                }
                sComponentName = theParentLayout.getName(theObject.theScrollPane);
                theContainer.add((Component)theObject.theScrollPane, theObject.getName());
                if (sComponentName != null) {
                    theParentLayout.addLayoutComponent(sComponentName, theObject.theScrollPane);
                }
                theParentLayout.setAnchoring(theObject.theScrollPane, theObject.getAnchorLeft(), theObject.getAnchorRight(), theObject.getAnchorTop(), theObject.getAnchorBottom());
            } else {
                sComponentName = theParentLayout.getName(theObject.theVisualObject);
                theContainer.add((Component)theObject.theVisualObject, theObject.getName());
                if (sComponentName != null) {
                    theParentLayout.addLayoutComponent(sComponentName, theObject.theVisualObject);
                }
                theParentLayout.setAnchoring(theObject.theVisualObject, theObject.getAnchorLeft(), theObject.getAnchorRight(), theObject.getAnchorTop(), theObject.getAnchorBottom());
            }
        }
    }

    public void processMenus(MetaObject theMetaObject) {
        if (theMetaObject.theParentObject.theVisualObject instanceof JMenuBar) {
            JMenuBar theMenuBar = (JMenuBar)theMetaObject.theParentObject.theVisualObject;
            theMenuBar.add(theMetaObject.theVisualObject);
        }
    }

    public void processMenuItems(MetaObject theMetaObject) {
        if (theMetaObject.theParentObject.theVisualObject instanceof JMenu) {
            JMenu theMenu = (JMenu)theMetaObject.theParentObject.theVisualObject;
            theMenu.add(theMetaObject.theVisualObject);
        }
    }

    public void processMenuSeparators(MetaObject theMetaObject) {
        if (theMetaObject.theParentObject.theVisualObject instanceof JSeparator) {
            JMenu theMenu = (JMenu)theMetaObject.theParentObject.theVisualObject;
            theMenu.add(theMetaObject.theVisualObject);
        }
    }

    public void processToolbarItems(MetaObject theMetaObject) {
        if (theMetaObject.theParentObject.theVisualObject instanceof JToolBar) {
            JToolBar theToolBar = (JToolBar)theMetaObject.theParentObject.theVisualObject;
            theToolBar.add(theMetaObject.theVisualObject);
        }
    }

    public void processTabPages(MetaObject theMetaObject) {
        if (theMetaObject.theParentObject.theVisualObject instanceof JTabbedPane) {
            JTabbedPane theTabbedPane = (JTabbedPane)theMetaObject.theParentObject.theVisualObject;
            int iIndex = theTabbedPane.indexOfComponent(theMetaObject.theVisualObject);
            if (iIndex == -1) {
                iIndex = theMetaObject.theParentObject.getChildIndex(theMetaObject);
                MetaPropertyValueEx theTabTitle = theMetaObject.theParentObject.getPropertyValue("TabTitle", iIndex);
                if (theTabTitle == null) {
                    theTabbedPane.addTab("tab", theMetaObject.theVisualObject);
                } else {
                    theTabbedPane.addTab(theTabTitle.getStringValue(), theMetaObject.theVisualObject);
                }
            } else {
                int iTestIndex = theTabbedPane.getSelectedIndex();
                if (iTestIndex != iIndex) {
                    theTabbedPane.setSelectedIndex(iIndex);
                }
            }
        }
    }

    public void doNewVisualObject(MetaObject theObject) {
        if (theObject.theFabricatedObject instanceof JComponent) {
            theObject.theVisualObject = (JComponent)theObject.theFabricatedObject;
        } else if (theObject.theFabricatedObject instanceof JFrame) {
            theObject.theVisualFrame = (JFrame)theObject.theFabricatedObject;
        }
    }

    public boolean getAttachedToDesigner() {
        return this.attachedToDesigner;
    }

    public void processObjectNameChanged(MetaObject metaObject) {
    }

    public void propertyEditedRepaint(MetaObject metaObject) {
    }

    public void processCreateLayout(MetaObject metaObject) {
    }

    public void processDoFrameSizeboxes(MetaObject metaObject) {
    }

    public void processDeleteObject(MetaObject metaObject) {
    }

    public void processProjectChangedState(boolean bState) {
    }

    public MetaObject getSelectedContainer() {
        return null;
    }

    public MetaObject getSelectedObject() {
        return null;
    }

    public Dimension getBaseFrameSize() throws HammerException {
        if (this.theRenderingDestination == null) {
            throw new HammerException(HammerException.NOT_RENDERED_TO_DESTINATION, "getBaseFrameSize has failed because the project has not been rendered.");
        }
        if (this.theRenderingDestination instanceof JFrame) {
            return ((JFrame)this.theRenderingDestination).getSize();
        }
        return ((JComponent)this.theRenderingDestination).getSize();
    }

    public Color getBaseFrameColor() throws HammerException {
        if (this.theRenderingDestination == null) {
            throw new HammerException(HammerException.NOT_RENDERED_TO_DESTINATION, "getBaseFrameColor has failed because the project has not been rendered.");
        }
        if (this.theRenderingDestination instanceof JFrame) {
            return ((JFrame)this.theRenderingDestination).getBackground();
        }
        return ((JComponent)this.theRenderingDestination).getBackground();
    }

    public Dimension getBaseFrameMaxSize() throws HammerException {
        if (this.theRenderingDestination == null) {
            throw new HammerException(HammerException.NOT_RENDERED_TO_DESTINATION, "getBaseFrameMaxSize has failed because the project has not been rendered.");
        }
        if (this.theRenderingDestination instanceof JFrame) {
            return ((JFrame)this.theRenderingDestination).getMaximumSize();
        }
        return ((JComponent)this.theRenderingDestination).getMaximumSize();
    }

    public Dimension getBaseFrameMinSize() throws HammerException {
        if (this.theRenderingDestination == null) {
            throw new HammerException(HammerException.NOT_RENDERED_TO_DESTINATION, "getBaseFrameMinSize has failed because the project has not been rendered.");
        }
        if (this.theRenderingDestination instanceof JFrame) {
            return ((JFrame)this.theRenderingDestination).getMinimumSize();
        }
        return ((JComponent)this.theRenderingDestination).getMinimumSize();
    }

    public String getBaseFrameTitle() throws HammerException {
        if (this.theRenderingDestination == null) {
            throw new HammerException(HammerException.NOT_RENDERED_TO_DESTINATION, "getBaseFrameTitle has failed because the project has not been rendered.");
        }
        if (this.theRenderingDestination instanceof JFrame) {
            return ((JFrame)this.theRenderingDestination).getTitle();
        }
        return null;
    }

    public MetaObject getOriginalFrame() throws HammerException {
        if (!this.bLoaded) {
            throw new HammerException(HammerException.PROJECT_NOT_LOADED, "getOriginalFrame has failed because the project has not been loaded.");
        }
        return this.theProject.getFirstObject();
    }

    public String getOriginalFrameTitle() throws HammerException {
        if (!this.bLoaded) {
            throw new HammerException(HammerException.PROJECT_NOT_LOADED, "getOriginalFrameTitle has failed because the project has not been loaded.");
        }
        MetaPropertyValueEx titleValue = this.getOriginalFrame().getPropertyValue("Title", 0);
        if (titleValue != null) {
            return titleValue.getStringValue();
        }
        return null;
    }

    public Dimension getOriginalFrameSize() throws HammerException {
        if (!this.bLoaded) {
            throw new HammerException(HammerException.PROJECT_NOT_LOADED, "getOriginalFrameSize has failed because the project has not been loaded.");
        }
        MetaPropertyValueEx widthValue = this.getOriginalFrame().getPropertyValue("Size.Width", 0);
        MetaPropertyValueEx heightValue = this.getOriginalFrame().getPropertyValue("Size.Height", 0);
        int width = (Integer)widthValue.getNativeValue();
        int height = (Integer)heightValue.getNativeValue();
        return new Dimension(width, height);
    }

    private Hashtable buildMinimumPropertySet(Object objSwing) {
        if (objSwing == null) {
            return null;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(0);
        Dimension dimSize = new Dimension(0, 0);
        Point ptLocation = new Point(0, 0);
        String sName = "Unknown";
        Font font = null;
        Color clrBackground = null;
        Color clrForeground = null;
        if (objSwing instanceof JFrame) {
            dimSize = ((JFrame)objSwing).getSize();
            ptLocation = ((JFrame)objSwing).getLocation();
            sName = ((JFrame)objSwing).getName();
            String sTitle = ((JFrame)objSwing).getTitle();
            properties.put("Title", sTitle);
            font = ((JFrame)objSwing).getFont();
            clrBackground = ((JFrame)objSwing).getBackground();
            clrForeground = ((JFrame)objSwing).getForeground();
        } else if (objSwing instanceof JComponent) {
            dimSize = ((JComponent)objSwing).getSize();
            ptLocation = ((JComponent)objSwing).getLocation();
            sName = ((JComponent)objSwing).getName();
            String sText = "";
            if (objSwing instanceof AbstractButton) {
                sText = ((AbstractButton)objSwing).getText();
            } else if (objSwing instanceof JTextComponent) {
                sText = ((JTextComponent)objSwing).getText();
            } else if (objSwing instanceof JLabel) {
                sText = ((JLabel)objSwing).getText();
            }
            properties.put("Text", sText);
            font = ((JComponent)objSwing).getFont();
            clrBackground = ((JComponent)objSwing).getBackground();
            clrForeground = ((JComponent)objSwing).getForeground();
        }
        properties.put("Width", new Integer(dimSize.width));
        properties.put("Height", new Integer(dimSize.width));
        properties.put("Left", new Integer(ptLocation.x));
        properties.put("Top", new Integer(ptLocation.y));
        properties.put("Name", sName);
        properties.put("Font", font);
        properties.put("Foreground", clrForeground);
        properties.put("Background", clrBackground);
        return properties;
    }

    public Object createInterfaceObject(String sObjectName, String sClassName) {
        Object theFabricatedObject;
        Hashtable properties = null;
        MetaClass theClass = this.theProject.findClass(sClassName);
        if (theClass == null) {
            JOptionPane.showMessageDialog(null, sClassName + " Class was not found", "Missing jar or wrong meatadata", 0);
        }
        MetaType theType = new MetaType(theClass.getMetadata().sClassName, theClass.getMetadata().sFullClassName, theClass.getMetadata().theFactoryName, this.theProject);
        theType.theFactoryName = theClass.getMetadata().theFactoryName;
        theType.theDesignProject = this.theProject;
        if (theType.theFactoryName != null && theType.theFactoryName.length() > 0) {
            properties = this.buildMinimumPropertySet(null);
        }
        if ((theFabricatedObject = theType.Create(sObjectName, this, properties)) != null) {
            this.theRegisteredInterfaceObjects.put(sObjectName, theFabricatedObject);
        }
        return theFabricatedObject;
    }

    public void createInterfaceObjectEx(String sObjectName, Object newedObject) {
        if (newedObject != null) {
            this.theRegisteredInterfaceObjects.put(sObjectName, newedObject);
        }
    }

    public Object getInterfaceObject(String sObjectName) {
        Object objMatch = this.theRegisteredInterfaceObjects.get(sObjectName);
        if (objMatch != null) {
            return objMatch;
        }
        return null;
    }

    public Object createConstantObject(String sConstantName, String sConstantClass) {
        String sMatch = null;
        MetaConstantGroup theConstantTable = this.theProject.findConstantGroup(sConstantClass);
        if (theConstantTable != null) {
            sMatch = theConstantTable.get(sConstantName);
        } else {
            MetaConstantGroupCollection theConstantTableCollection = this.theProject.findConstantGroupCollection(sConstantClass);
            if (theConstantTableCollection != null) {
                sMatch = theConstantTableCollection.get(sConstantName);
            }
        }
        if (sMatch != null) {
            Object objRetVal = null;
            try {
                objRetVal = MetaConstantGroup.resolve(sMatch, this.theMetadataDispenser, this.theClassLoader.getLoader());
            }
            catch (HammerException e) {
                e.printStackTrace();
            }
            return objRetVal;
        }
        return null;
    }

    public String doNLSTranslation(String sValue) {
        String theResolvedValue = this.theProject.getNLS().getTranslatedValue(sValue, this.theProject.getCurrentLanguage().theLanguage, false);
        return theResolvedValue;
    }

    public String getCurrentLanguageValue(String[] values) {
        int iLangId = this.theProject.getCurrentLanguage().theLanguage;
        if (iLangId > values.length - 1) {
            iLangId = 0;
        }
        return values[iLangId];
    }

    public char doNLSMnemonicTranslation(String sValue) {
        String theResolvedValue = this.theProject.getNLS().getTranslatedValue(sValue, this.theProject.getCurrentLanguage().theLanguage, true);
        if (theResolvedValue != null) {
            return theResolvedValue.charAt(0);
        }
        return '\u0000';
    }

    public Object resolveConstantValue(String sValue) {
        try {
            return MetaConstantGroup.resolve(sValue, this.theMetadataDispenser, this.theClassLoader.getLoader());
        }
        catch (HammerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void addNLSDocument(String sName, String sKey) {
        this.theProject.getNLS().addDocument(sName, sKey);
    }

    public void addFocus(Object oParent, Object oChild) {
        if (oParent == null && oChild instanceof JFrame) {
            if (this.shouldApplyRendererFocusTraversalPolicy()) {
                RendererFocusTraversalPolicy.getInstance().init((JFrame)oChild, this.theGlobalInterface);
            }
        } else {
            if (oParent == null) {
                oParent = this.theRenderingDestination;
            }
            if (this.shouldApplyRendererFocusTraversalPolicy() && RendererFocusTraversalPolicy.getInstance().getTree() != null) {
                RendererFocusTraversalPolicy.getInstance().getTree().addFocus(oParent, oChild);
            }
        }
    }

    public void setNovaState(boolean bState) {
        this.bNovaState = bState;
    }

    public void setOpenSourceState(boolean bState) {
        this.bOpenSourceState = bState;
    }

    public boolean getNovaState() {
        return this.bNovaState;
    }

    public boolean getOpenSourceState() {
        return this.bOpenSourceState;
    }

    public boolean getDropletsState() {
        return false;
    }

    public void setFocus() {
        this.setFocus(this.theRenderingDestination);
    }

    public void setFocus(Object oNewFocus) {
        if (!this.shouldApplyRendererFocusTraversalPolicy()) {
            return;
        }
        if (RendererFocusTraversalPolicy.getInstance().getTree() == null) {
            return;
        }
        RendererFocusNode theNode = RendererFocusTraversalPolicy.getInstance().getTree().getMatchingNode(oNewFocus);
        if (oNewFocus != null) {
            KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window newFocus = focusManager.getFocusedWindow();
            if (theNode != null) {
                Component theFirst = theNode.first();
                theFirst.requestFocus();
            }
        }
    }

    public AbaRenderer makeFakeRenderer() throws HammerException {
        return new AbaRenderer();
    }

    public String getConfigurationPath() {
        return null;
    }

    private boolean shouldApplyRendererFocusTraversalPolicy() {
        return this.theGlobalInterface == null;
    }
}

