/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerJarEntry;

public class HammerJarCollection {
    HammerJarEntry firstJar;
    HammerJarEntry lastJar;
    int iJarCount = 0;

    void addJar(String sName, String sVersion) {
        HammerJarEntry jarEntry = new HammerJarEntry(sName, sVersion);
        if (this.firstJar == null) {
            this.firstJar = jarEntry;
        } else {
            this.lastJar.nextJar = jarEntry;
            jarEntry.prevJar = this.lastJar;
        }
        this.lastJar = jarEntry;
        ++this.iJarCount;
    }

    HammerJarEntry getJarByIndex(int iJarNumber) {
        if (iJarNumber < this.iJarCount) {
            int i = 0;
            HammerJarEntry testJar = this.firstJar;
            while (testJar != null) {
                if (i++ == iJarNumber) {
                    return testJar;
                }
                testJar = testJar.nextJar;
            }
        }
        return null;
    }

    int getJarCount() {
        return this.iJarCount;
    }

    boolean removeJar(String sName, String sVersion) {
        HammerJarEntry testJar = this.firstJar;
        HammerJarEntry prevJar = null;
        while (testJar != null) {
            if (testJar.sName.equals(sName) && testJar.sVersion.equals(sVersion)) {
                if (prevJar == null) {
                    this.firstJar = testJar.nextJar;
                } else {
                    this.lastJar.nextJar = testJar.nextJar;
                }
                if (testJar.nextJar != null) {
                    testJar.nextJar.prevJar = prevJar;
                } else {
                    this.lastJar = prevJar;
                }
                --this.iJarCount;
                return true;
            }
            prevJar = testJar;
            testJar = testJar.nextJar;
        }
        return false;
    }
}

