/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.MetadataProvider;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class MetaConstantGroup {
    public MetaConstantGroup theNextSibling;
    public MetaConstantGroup thePrevSibling;
    public String sClassName;
    public MetadataDispenser theMetadataDispenser;
    HashMap theConstants;
    HashMap theValues;
    ArrayList theSeqConstants = new ArrayList(0);

    public MetaConstantGroup(String sClassName, MetadataDispenser theMetadataDispenser) {
        this.theConstants = new HashMap(1);
        this.theValues = new HashMap(1);
        this.sClassName = sClassName;
        this.theMetadataDispenser = theMetadataDispenser;
    }

    public ArrayList getConstantList() {
        return this.theSeqConstants;
    }

    public void set(String sName, String sValue) {
        String oStoredKey = this.get(sName);
        if (oStoredKey == null) {
            this.theConstants.put(sName, sValue);
        }
        this.theValues.put(sValue, sName);
        if (!this.theSeqConstants.contains(sName)) {
            this.theSeqConstants.add(sName);
        }
    }

    public String get(String sName) {
        if (sName == null) {
            return null;
        }
        return (String)this.theConstants.get(sName);
    }

    public String getKey(String sValue) {
        if (sValue == null) {
            return null;
        }
        return (String)this.theValues.get(sValue);
    }

    public void clearConstants() {
        this.theConstants.clear();
        this.theValues.clear();
        this.theSeqConstants.clear();
    }

    public void removeGroupFromCollections() {
        MetaConstantGroupCollection collection = this.theMetadataDispenser.getFirstMetaConstantGroupCollection();
        while (collection != null) {
            collection.removeGroup(this);
            collection = collection.theNextSibling;
        }
    }

    public static Class resolveClass(Object object, MetadataDispenser theMetadataDispenser, ClassLoader theLoader) throws HammerException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String sDescription = (String)object;
            sDescription = sDescription.trim();
            int iBean = sDescription.indexOf("bean:");
            int iConstruct = sDescription.indexOf("construct:");
            int iInvoke = sDescription.indexOf("invoke:");
            if (iBean != 0 && iConstruct != 0 && iInvoke != 0) {
                Font testFont = MetaConstantGroup.getFontFromString(sDescription);
                if (testFont != null) {
                    return Font.class;
                }
                Color testColor = MetaConstantGroup.getColorFromString(sDescription);
                if (testColor != null) {
                    return Color.class;
                }
                return String.class;
            }
            if (iBean > -1) {
                sDescription = sDescription.substring(iBean + 5);
                Object obj = MetaConstantGroup.getObjectFromBeanDescription(sDescription, theMetadataDispenser, theLoader);
                return obj.getClass();
            }
            if (iInvoke > -1) {
                sDescription = sDescription.substring(iInvoke + 7);
                return MetaConstantGroup.getClassFromInvokeDescription(sDescription, theMetadataDispenser, theLoader);
            }
            sDescription = sDescription.substring(iConstruct + 10);
            Object obj = MetaConstantGroup.getObjectFromConstructionDescription(sDescription, theMetadataDispenser, theLoader);
            return obj.getClass();
        }
        return object.getClass();
    }

    public static Object resolve(Object object, MetadataDispenser theMetadataDispenser, ClassLoader theLoader) throws HammerException {
        if (object == null) {
            return object;
        }
        if (object instanceof String) {
            String sDescription = (String)object;
            sDescription = sDescription.trim();
            int iBean = sDescription.indexOf("bean:");
            int iConstruct = sDescription.indexOf("construct:");
            int iInvoke = sDescription.indexOf("invoke:");
            if (iBean != 0 && iConstruct != 0 && iInvoke != 0) {
                Font testFont = MetaConstantGroup.getFontFromString(sDescription);
                if (testFont != null) {
                    return testFont;
                }
                Color testColor = MetaConstantGroup.getColorFromString(sDescription);
                if (testColor != null) {
                    return testColor;
                }
                return object;
            }
            if (iBean > -1) {
                sDescription = sDescription.substring(iBean + 5);
                return MetaConstantGroup.getObjectFromBeanDescription(sDescription, theMetadataDispenser, theLoader);
            }
            if (iInvoke > -1) {
                sDescription = sDescription.substring(iInvoke + 7);
                return MetaConstantGroup.getObjectFromInvokeDescription(sDescription, theMetadataDispenser, theLoader);
            }
            sDescription = sDescription.substring(iConstruct + 10);
            return MetaConstantGroup.getObjectFromConstructionDescription(sDescription, theMetadataDispenser, theLoader);
        }
        return object;
    }

    public static Method getMethod(Method[] methods, String sKey) {
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] theParams;
            if (!sKey.equals(methods[i].getName()) || (theParams = methods[i].getParameterTypes()).length != 1) continue;
            return methods[i];
        }
        return null;
    }

    public static Object getObjectFromBeanDescription(String sDescription, MetadataDispenser theMetadataDispenser, ClassLoader theLoader) throws HammerException {
        Object obj = null;
        if (sDescription != null && sDescription.trim().length() > 0) {
            int lfbr = sDescription.indexOf("[");
            int rtbr = sDescription.indexOf("]");
            if (lfbr == -1 || rtbr == -1) {
                return null;
            }
            String sClass = sDescription.substring(0, lfbr);
            ArrayList<String> fncs = new ArrayList<String>(0);
            ArrayList<String> vals = new ArrayList<String>(0);
            String sArgList = sDescription.substring(lfbr + 1, rtbr);
            int eq = sArgList.indexOf("=");
            while (eq != -1) {
                String sName = sArgList.substring(0, eq);
                sName = "set" + sName.substring(0, 0).toUpperCase() + sName.substring(1);
                fncs.add(sName);
                sArgList = sArgList.substring(eq + 1);
                sArgList = sArgList.trim();
                int iEnd = sArgList.indexOf(",");
                String sValue = "";
                if (sArgList.startsWith("\"")) {
                    iEnd = sArgList.indexOf("\"");
                    if (iEnd == -1) {
                        return null;
                    }
                    sValue = sArgList.substring(1, iEnd);
                    iEnd = sArgList.indexOf(",", iEnd);
                    ++iEnd;
                } else {
                    sValue = iEnd == -1 ? sArgList : sArgList.substring(0, iEnd);
                    ++iEnd;
                }
                vals.add(sValue);
                if (iEnd != -1) {
                    sArgList = sArgList.substring(iEnd);
                }
                eq = sArgList.indexOf("=");
            }
            try {
                Class<?> cls = Class.forName(sClass, true, theLoader);
                obj = cls.newInstance();
                Method[] methods = cls.getMethods();
                int iPropCount = fncs.size();
                for (int i = 0; i < iPropCount; ++i) {
                    Method m = MetaConstantGroup.getMethod(methods, (String)fncs.get(i));
                    Object[] param = new Object[]{MetaConstantGroup.resolve(vals.get(i), theMetadataDispenser, theLoader)};
                    m.invoke(obj, param);
                }
                return obj;
            }
            catch (Exception e1) {
                throw new HammerException(HammerException.CANNOT_CREATE_CONSTANT, sDescription);
            }
        }
        return null;
    }

    public static Object getObjectFromConstructionDescription(String sDescription, MetadataDispenser theMetadataDispenser, ClassLoader theLoader) throws HammerException {
        Object obj = null;
        if (sDescription != null && sDescription.trim().length() > 0) {
            int lfbr = sDescription.indexOf("[");
            int rtbr = sDescription.indexOf("]");
            if (lfbr == -1 || rtbr == -1) {
                return null;
            }
            String sClass = sDescription.substring(0, lfbr);
            ArrayList<String> types = new ArrayList<String>(0);
            ArrayList<String> vals = new ArrayList<String>(0);
            String sArgList = sDescription.substring(lfbr + 1, rtbr);
            int eq = sArgList.indexOf("=");
            while (eq != -1) {
                String sType = sArgList.substring(0, eq);
                types.add(sType);
                sArgList = sArgList.substring(eq + 1);
                sArgList = sArgList.trim();
                int iEnd = sArgList.indexOf(",");
                String sValue = "";
                if (sArgList.startsWith("\"")) {
                    iEnd = sArgList.indexOf("\"");
                    if (iEnd == -1) {
                        return null;
                    }
                    sValue = sArgList.substring(1, iEnd);
                    iEnd = sArgList.indexOf(",", iEnd);
                    ++iEnd;
                } else {
                    sValue = iEnd == -1 ? sArgList : sArgList.substring(0, iEnd);
                    ++iEnd;
                }
                vals.add(sValue);
                if (iEnd != -1) {
                    sArgList = sArgList.substring(iEnd);
                }
                eq = sArgList.indexOf("=");
            }
            try {
                Class<?> cls = Class.forName(sClass, true, theLoader);
                int iParamCount = types.size();
                Class[] theParamClasses = new Class[iParamCount];
                Object[] theParamObjects = new Object[iParamCount];
                for (int i = 0; i < iParamCount; ++i) {
                    MetaConstantGroupCollection theGroupCollection;
                    String sType = (String)types.get(i);
                    String sValue = (String)vals.get(i);
                    int iType = MetaPropertyValueEx.translateType(sType);
                    if (iType != 0) {
                        Class clsParam;
                        int iTestDot;
                        Object oValue = null;
                        if (iType == 2 && (iTestDot = sValue.lastIndexOf(".")) != -1) {
                            String sClassName = sValue.substring(0, iTestDot);
                            String sField = sValue.substring(iTestDot + 1);
                            try {
                                oValue = MetadataProvider.GetFieldValueAsObject(sClassName, sField);
                            }
                            catch (Exception e1) {
                                // empty catch block
                            }
                        }
                        theParamClasses[i] = clsParam = MetaPropertyValueEx.getTypeAsClass(iType);
                        if (oValue != null) {
                            theParamObjects[i] = oValue;
                            continue;
                        }
                        theParamObjects[i] = MetaPropertyValueEx.getObjectForValue(iType, sValue);
                        continue;
                    }
                    MetaConstantGroup theGroup = theMetadataDispenser.findConstantGroup(sType);
                    if (theGroup != null) {
                        String sStoredValue = theGroup.get(sValue);
                        Object oStoredValue = MetaConstantGroup.resolve(sStoredValue, theMetadataDispenser, theLoader);
                        theParamClasses[i] = MetaConstantGroup.resolveClass(sStoredValue, theMetadataDispenser, theLoader);
                        theParamObjects[i] = oStoredValue;
                    }
                    if ((theGroupCollection = theMetadataDispenser.findConstantGroupCollection(sType)) != null) {
                        String sStoredValue = theGroupCollection.get(sValue);
                        Object oStoredValue = MetaConstantGroup.resolve(sStoredValue, theMetadataDispenser, theLoader);
                        theParamClasses[i] = MetaConstantGroup.resolveClass(sStoredValue, theMetadataDispenser, theLoader);
                        theParamObjects[i] = oStoredValue;
                        continue;
                    }
                    theParamClasses[i] = Class.forName("java.lang.String");
                    theParamObjects[i] = sValue;
                }
                Constructor<?> theConstructor = cls.getConstructor(theParamClasses);
                obj = theConstructor.newInstance(theParamObjects);
                return obj;
            }
            catch (Exception e1) {
                throw new HammerException(HammerException.CANNOT_CREATE_CONSTANT, sDescription);
            }
        }
        return null;
    }

    private static Class getClassFromInvokeDescription(String sDescription, MetadataDispenser theMetadataDispenser, ClassLoader theLoader) throws HammerException {
        int iCastClassBeg = 0;
        int iCastClassEnd = sDescription.indexOf(44);
        String sCastClassName = sDescription.substring(iCastClassBeg, iCastClassEnd);
        Class<?> clsCasted = null;
        try {
            if (sCastClassName != null && sCastClassName.length() > 1) {
                clsCasted = theLoader.loadClass(sCastClassName);
            }
        }
        catch (ClassNotFoundException e1) {
            throw new HammerException(HammerException.CANNOT_CAST_CONSTANT, "Cannot cast constant of " + sDescription + " to unknown class " + sCastClassName);
        }
        return clsCasted;
    }

    private static Object getObjectFromInvokeDescription(String sDescription, MetadataDispenser theMetadataDispenser, ClassLoader theLoader) throws HammerException {
        String sClass = null;
        String sMethod = null;
        String sArgList = null;
        int iCastClassBeg = 0;
        int iCastClassEnd = sDescription.indexOf(44);
        String sCastClassName = sDescription.substring(iCastClassBeg, iCastClassEnd);
        Class<?> clsCasted = null;
        try {
            if (sCastClassName != null && sCastClassName.length() > 1) {
                clsCasted = theLoader.loadClass(sCastClassName);
            }
        }
        catch (ClassNotFoundException e1) {
            throw new HammerException(HammerException.CANNOT_CAST_CONSTANT, "Cannot cast constant of " + sDescription + " to unknown class " + sCastClassName);
        }
        int iPosStart = iCastClassEnd + 1;
        int iPosEnd = sDescription.indexOf(44, iCastClassEnd + 1);
        if (iPosEnd == -1) {
            return null;
        }
        sClass = sDescription.substring(iPosStart, iPosEnd);
        ++iPosEnd;
        iPosStart = iPosEnd;
        if ((iPosEnd = sDescription.indexOf(91, iPosStart)) == -1) {
            return null;
        }
        sMethod = sDescription.substring(iPosStart, iPosEnd);
        ++iPosEnd;
        iPosStart = iPosEnd;
        if ((iPosEnd = sDescription.indexOf(93, iPosStart)) == -1) {
            return null;
        }
        sArgList = sDescription.substring(iPosStart, iPosEnd);
        Class<?> theClass = null;
        try {
            theClass = theLoader.loadClass(sClass);
            ArrayList<String> types = new ArrayList<String>(0);
            ArrayList<String> vals = new ArrayList<String>(0);
            int eq = sArgList.indexOf("=");
            while (eq != -1) {
                String sType = sArgList.substring(0, eq);
                types.add(sType);
                sArgList = sArgList.substring(eq + 1);
                sArgList = sArgList.trim();
                int iEnd = sArgList.indexOf(",");
                String sValue = "";
                if (sArgList.startsWith("\"")) {
                    iEnd = sArgList.indexOf("\"");
                    if (iEnd == -1) {
                        return null;
                    }
                    sValue = sArgList.substring(1, iEnd);
                    iEnd = sArgList.indexOf(",", iEnd);
                    ++iEnd;
                } else {
                    sValue = iEnd == -1 ? sArgList : sArgList.substring(0, iEnd);
                    ++iEnd;
                }
                vals.add(sValue);
                if (iEnd != -1) {
                    sArgList = sArgList.substring(iEnd);
                }
                eq = sArgList.indexOf("=");
            }
            Object[] objects = new Class[types.size()];
            Class[] classes = new Class[vals.size()];
            for (int i = 0; i < vals.size(); ++i) {
                int iType = MetaPropertyValueEx.translateType((String)types.get(i));
                String sValue = (String)vals.get(i);
                objects[i] = MetaConstantGroup.resolve(sValue, theMetadataDispenser, theLoader);
                classes[i] = MetaConstantGroup.resolveClass(sValue, theMetadataDispenser, theLoader);
            }
            Method m = null;
            m = theClass.getMethod(sMethod, classes);
            Object obj = m.invoke(null, objects);
            if (clsCasted != null) {
                Object retval = obj;
                try {
                    retval = MetadataProvider.createBogusObject(clsCasted);
                    retval = obj;
                }
                catch (ClassCastException e1) {
                    throw new HammerException(HammerException.CANNOT_CAST_CONSTANT, "Cannot cast constant of " + sDescription + " to " + sCastClassName);
                }
                return retval;
            }
            return obj;
        }
        catch (Exception e) {
            throw new HammerException(HammerException.CANNOT_CREATE_CONSTANT, sDescription);
        }
    }

    public static Font getFontFromString(String sFont) throws HammerException {
        if (sFont != null && sFont.trim().length() != 0) {
            int iPos1 = sFont.indexOf("family=");
            if (iPos1 == -1) {
                return null;
            }
            int iPos2 = sFont.indexOf(",name");
            if (iPos2 == -1) {
                return null;
            }
            int iPos3 = sFont.indexOf("style=");
            if (iPos3 == -1) {
                return null;
            }
            int iPos4 = sFont.indexOf("size=");
            if (iPos4 == -1) {
                return null;
            }
            int iLength = sFont.length();
            String sFamily = sFont.substring(iPos1 + 7, iPos2);
            String sFontName = sFont.substring(iPos2 + 6, iPos3 - 1);
            String sStyle = sFont.substring(iPos3 + 6, iPos4 - 1);
            String sSize = sFont.substring(iPos4 + 5, iLength - 1);
            int iStyleParam = 0;
            if (sStyle.indexOf("bold") != -1) {
                iStyleParam = sStyle.indexOf("italic") != -1 ? 3 : 1;
            } else if (sStyle.indexOf("italic") != -1) {
                iStyleParam = 2;
            }
            Integer iSize = null;
            try {
                iSize = new Integer(sSize);
            }
            catch (NumberFormatException e1) {
                throw new HammerException(HammerException.CANNOT_CREATE_CONSTANT, "Bad number in " + sFont);
            }
            Font theReturnValue = null;
            if (iSize != null) {
                theReturnValue = new Font(sFamily, iStyleParam, iSize);
            }
            return theReturnValue;
        }
        return null;
    }

    public static Color getColorFromString(String sColor) {
        if (sColor == null) {
            return null;
        }
        if (sColor.trim().length() == 0) {
            return null;
        }
        if (sColor.startsWith("$")) {
            sColor = "0x" + sColor.substring(1);
        }
        if (sColor.startsWith("0x")) {
            int iRgb = Integer.valueOf(sColor.substring(2), 16);
            return new Color(iRgb);
        }
        if (sColor.indexOf("new") != -1) {
            int iPos1 = sColor.indexOf("(");
            if (iPos1 == -1) {
                return null;
            }
            int iPos2 = (sColor = sColor.substring(iPos1 + 1)).indexOf(",");
            if (iPos2 == -1) {
                return null;
            }
            String sRed = sColor.substring(0, iPos2);
            int iPos3 = (sColor = sColor.substring(iPos2 + 1)).indexOf(",");
            if (iPos3 == -1) {
                return null;
            }
            String sGreen = sColor.substring(0, iPos3);
            int iPos4 = (sColor = sColor.substring(iPos3 + 1)).indexOf(")");
            if (iPos4 == -1) {
                return null;
            }
            String sBlue = sColor.substring(0, iPos4);
            Integer iRed = new Integer(sRed.trim());
            Integer iGreen = new Integer(sGreen.trim());
            Integer iBlue = new Integer(sBlue.trim());
            return new Color(iRed, iGreen, iBlue);
        }
        if (sColor.indexOf("java.awt.Color") != -1) {
            int iPos1 = sColor.indexOf("r=");
            int iPos2 = sColor.indexOf(",g=");
            int iPos3 = sColor.indexOf(",b=");
            int iLength = sColor.length();
            Integer iRed = new Integer(sColor.substring(iPos1 + 2, iPos2));
            Integer iGreen = new Integer(sColor.substring(iPos2 + 3, iPos3));
            Integer iBlue = new Integer(sColor.substring(iPos3 + 3, iLength - 1));
            return new Color(iRed, iGreen, iBlue);
        }
        Color clrTest = new Color(0, 0, 0);
        if (sColor != null && !(sColor = sColor.trim()).equals("")) {
            try {
                return (Color)MetadataProvider.GetFieldValueAsObject(clrTest, sColor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String preserveEscapeSequences(String sTestValue) {
        String sNewString = "";
        if (sTestValue == null) {
            return null;
        }
        int iBackslash = sTestValue.indexOf(92);
        int iLength = sTestValue.length();
        String sEscapes = "tnrfb'\"\\";
        int iLastMatch = 0;
        while (iBackslash != -1) {
            if (iBackslash + 1 < iLength) {
                char c = sTestValue.charAt(iBackslash + 1);
                int iFindEscape = sEscapes.indexOf(c);
                if (iFindEscape == -1) {
                    boolean bFoundEscape = false;
                    if (iBackslash + 3 < iLength) {
                        char c2 = sTestValue.charAt(iBackslash + 2);
                        char c3 = sTestValue.charAt(iBackslash + 3);
                        if (c >= '0' && c <= '7' && c2 >= '0' && c2 <= '7' && c3 >= '0' && c3 <= '7') {
                            iBackslash += 3;
                            bFoundEscape = true;
                        } else if (iBackslash + 5 < iLength) {
                            char c4 = sTestValue.charAt(iBackslash + 4);
                            char c5 = sTestValue.charAt(iBackslash + 5);
                            if (c == 'u' && (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 >= 'F') && (c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 >= 'F') && (c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 >= 'F') && (c5 >= '0' && c5 <= '9' || c5 >= 'a' && c5 <= 'f' || c5 >= 'A' && c5 >= 'F')) {
                                iBackslash += 5;
                                bFoundEscape = true;
                            }
                        }
                    }
                    if (bFoundEscape) {
                        sNewString = sNewString + sTestValue.substring(iLastMatch, iBackslash);
                    } else {
                        sNewString = sNewString + sTestValue.substring(iLastMatch, iBackslash);
                        sNewString = sNewString + '\\';
                    }
                } else {
                    sNewString = sNewString + sTestValue.substring(iLastMatch, ++iBackslash);
                }
            } else {
                sNewString = sNewString + sTestValue.substring(iLastMatch, iBackslash);
                sNewString = sNewString + '\\';
            }
            iLastMatch = iBackslash;
            iBackslash = sTestValue.indexOf(92, iBackslash + 1);
        }
        sNewString = sNewString + sTestValue.substring(iLastMatch);
        return sNewString;
    }

    public static String protectQuotes(String sText) {
        if (sText == null) {
            return null;
        }
        int iQuotePos = sText.indexOf(34);
        if (iQuotePos == -1) {
            return sText;
        }
        int iLength = sText.length();
        StringBuffer buffer = new StringBuffer(iLength + 16);
        for (int i = 0; i < sText.length(); ++i) {
            char c = sText.charAt(i);
            if (c == '\"') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        String a = MetaConstantGroup.preserveEscapeSequences(null);
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("\\abcdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abc\\defg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcdefg\\");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("\\\\abcdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcd\\\\efg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcdefg\\\\");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("\tabcdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abc\tdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcdefg\t");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("'abcdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abc'defg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcdefg'");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("\u00dbabcdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abc\u00dbdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcdefg\u00db");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("\uabacabcdefg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abc\uabac333defg");
        System.out.println(a);
        a = MetaConstantGroup.preserveEscapeSequences("abcdefg\uabac");
        System.out.println(a);
    }
}

