/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.layout.AnchoringLayoutManager;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.AbaNLS;
import ch.abacus.lib.ui.renderer.common.HammerClassCustomLoader;
import ch.abacus.lib.ui.renderer.common.HammerClassLoader;
import ch.abacus.lib.ui.renderer.common.ListenerDiscriminator;
import ch.abacus.lib.ui.renderer.common.MetaArgumentList;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaCloneMode;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaConstructor;
import ch.abacus.lib.ui.renderer.common.MetaContainerType;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetaMethodLinkage;
import ch.abacus.lib.ui.renderer.common.MetaParameter;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import ch.abacus.lib.ui.renderer.common.MetaType;
import ch.abacus.lib.ui.renderer.common.ObjectTreeViewNode;
import ch.abacus.lib.ui.renderer.common.ProjectDocument;
import electric.xml.CData;
import electric.xml.Child;
import electric.xml.Children;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.Text;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.MenuElement;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class MetaObject {
    public MetaObject theNextObject = null;
    public MetaObject thePreviousObject = null;
    public MetaObject theNextInstance = null;
    public MetaObject thePreviousInstance = null;
    public MetaObject theFirstChild = null;
    public MetaObject theLastChild = null;
    public MetaObject theParentObject = null;
    public MetaClass theClass = null;
    public int iDisplayLayer = JLayeredPane.DEFAULT_LAYER;
    public boolean bIsDeleted = false;
    private String theName = "";
    public MetaType theType = null;
    public MetaProperty theFirstProperty = null;
    public MetaProperty theLastProperty = null;
    public boolean bAnchoringOff = false;
    public boolean bLeftAnchoring = false;
    public boolean bRightAnchoring = false;
    public boolean bTopAnchoring = false;
    public boolean bBottomAnchoring = false;
    public JComponent theVisualObject = null;
    public JFrame theVisualFrame = null;
    public Object theFabricatedObject = null;
    public boolean bMember = false;
    public boolean bPopup = false;
    public String sCode = "";
    protected Color theForegroundColor = null;
    protected Font theFont = null;
    protected Color theBackgroundColor = null;
    public int iXLocation = 0;
    public int iYLocation = 0;
    public Point ptDrag = null;
    public String psText = "";
    public MetaProject theDesignProject = null;
    public Object theLayoutManager = null;
    MetaConstructor theConstructor = null;
    public static final int RESIZE_CONTEXT_UNKNOWN = 0;
    public static final int RESIZE_CONTEXT_SIZEBOX_RESIZING = 1;
    public static final int RESIZE_CONTEXT_SIZEBOX_RESIZED = 2;
    public static final int RESIZE_CONTEXT_IMPORT_OBJECT = 3;
    public static final int RESIZE_CONTEXT_FROM_LAYOUT = 4;
    public static final int RESIZE_CONTEXT_FROM_PASTE = 5;
    public static final String UDF_OBJECT_CODE = "Object Code";
    public MetaMethodLinkage theFirstMethod = null;
    public MetaMethodLinkage theLastMethod = null;
    int iMethodCount = 0;
    public boolean bAutoEmbed = false;
    public JAScrollPane theScrollPane;
    public Dimension dimViewportSize = null;
    public int iMode = 0;
    public static final int NO_MODE = 0;
    public static final int DESIGN_MODE = 1;
    public static final int EXECUTION_MODE = 2;
    protected ObjectTreeViewNode theTreeNode = null;
    public Object theMouseListener = null;
    public Object theMouseMotionListener = null;
    public Dimension dimSize = new Dimension(0, 0);
    public boolean bDragged = false;
    public boolean bResizing = false;
    private String theConstructorParameters;
    private String thePreConstructionCode;
    private String thePostConstructionCode;
    public ButtonGroup theButtonGroup;
    private MetaClass theInstanceTracker;
    private Object theAdditionalData;
    private String theObjectSource = null;
    private String theObjectSourceDoc = null;
    private String sPatchedClassName = null;
    private boolean bObjectPatched = false;
    private boolean propsLoaded = false;

    public MetaObject(MetaObject theTemplateObject, MetaObject theParentObject, MetaProject theProject, int iMode) {
        this.iMode = iMode;
        this.theParentObject = theParentObject;
        this.theType = new MetaType(theTemplateObject.theClass.theMetadata.sClassName, theTemplateObject.theClass.theMetadata.sFullClassName, theTemplateObject.theClass.theMetadata.theFactoryName, theProject);
        this.theDesignProject = theProject;
        if (this.theDesignProject != null) {
            this.theClass = this.theDesignProject.findClass(theTemplateObject.theClass.theMetadata.sClassName);
            if (this.theClass != null) {
                this.addAllMethods();
            }
            this.theInstanceTracker = this.theDesignProject.findInstanceTracker(theTemplateObject.theClass.theMetadata.sClassName);
            this.theInstanceTracker.addObject(this);
            MetaProperty theProperty = theTemplateObject.theFirstProperty;
            while (theProperty != null) {
                MetaProperty theNewProperty = theProperty.Clone(this);
                this.addProperty(theNewProperty);
                theProperty = theProperty.theNextProperty;
            }
        }
        this.theDesignProject = theProject;
    }

    public String getName() {
        MetaPropertyValueEx pvName = this.getPropertyValue("Name", 0);
        if (pvName == null) {
            return this.theName;
        }
        return this.getPropertyValue("Name", 0).getStringValue();
    }

    public void setName(String sName) {
        this.theName = sName;
        this.setPropertyValue("Name", 0, 0, sName, true);
    }

    public MetaObject(String sObjectName, String sClassName, String sFullClassName, MetaObject theParentObject, MetaProject objDesignProject, int iMode, boolean bCreateMethods) {
        this.iMode = iMode;
        this.theDesignProject = objDesignProject;
        this.theParentObject = theParentObject;
        if (this.theDesignProject != null) {
            this.theClass = this.theDesignProject.findClass(sClassName);
            boolean metadataLoaded = this.theDesignProject.getMetadataDispenser().theMetadataDocument.isCustomMetadataComplete();
            if (this.theClass != null && metadataLoaded) {
                this.setName(sObjectName);
                String theFactoryName = null;
                if (this.theClass.theMetadata != null) {
                    theFactoryName = this.theClass.theMetadata.theFactoryName;
                }
                this.theType = new MetaType(sClassName, sFullClassName, theFactoryName, this.theDesignProject);
                if (bCreateMethods) {
                    this.addAllMethods();
                }
                this.theInstanceTracker = this.theDesignProject.findInstanceTracker(sClassName);
                this.theInstanceTracker.addObject(this);
            }
        }
    }

    public MetaObject() {
    }

    public int getChildIndex(MetaObject someChild) {
        int i = 0;
        MetaObject testChild = this.theFirstChild;
        while (testChild != null) {
            if (someChild.equals(testChild)) {
                return i;
            }
            ++i;
            testChild = testChild.theNextObject;
        }
        return -1;
    }

    public void addProperty(MetaProperty theProperty) {
        if (this.theFirstProperty == null) {
            this.theFirstProperty = theProperty;
        } else {
            theProperty.thePreviousProperty = this.theLastProperty;
            this.theLastProperty.theNextProperty = theProperty;
        }
        this.theLastProperty = theProperty;
    }

    public void addObject(MetaObject theMetaObject) {
        if (this.theFirstChild == null) {
            this.theFirstChild = theMetaObject;
        } else {
            theMetaObject.thePreviousObject = this.theLastChild;
            this.theLastChild.theNextObject = theMetaObject;
        }
        theMetaObject.theParentObject = this;
        this.theLastChild = theMetaObject;
    }

    public boolean save(Element theParent) {
        Element xmlObject = new Element("Object");
        Element xmlName = new Element("Name");
        xmlName.setText(this.theName);
        xmlObject.addElement(xmlName);
        theParent.addElement(xmlObject);
        this.theType.save(xmlObject);
        MetaProperty theProperty = this.theFirstProperty;
        while (theProperty != null) {
            theProperty.save(this.theDesignProject, xmlObject);
            theProperty = theProperty.theNextProperty;
        }
        this.generateObjectEventClasses(xmlObject);
        this.generateObjectSourceCode(xmlObject);
        MetaObject theObject = this.theFirstChild;
        ArrayList DataSourcetheObjects = new ArrayList();
        while (theObject != null) {
            theObject.save(xmlObject);
            theObject = theObject.theNextObject;
        }
        return true;
    }

    public boolean load(Element theElement) {
        Element xmlName = theElement.getElement("Name");
        this.theName = xmlName.getTextString();
        Element xmlType = theElement.getElement("Type");
        this.theType = new MetaType(this.theDesignProject);
        this.theType.load(xmlType);
        this.theClass = this.theDesignProject.findClass(this.theType.theName);
        if (this.theClass == null) {
            return false;
        }
        this.theInstanceTracker = this.theDesignProject.findInstanceTracker(this.theType.theName);
        this.theInstanceTracker.addObject(this);
        Elements theProperties = theElement.getElements("Property");
        Element theProperty = theProperties.next();
        while (theProperty != null) {
            MetaProperty theMetaProperty = new MetaProperty(this);
            theMetaProperty.load(theProperty, this.theDesignProject, this.theClass);
            this.addProperty(theMetaProperty);
            theProperty = theProperties.next();
        }
        this.addAllMethods();
        Element theMethods = theElement.getElement("Methods");
        if (theMethods != null) {
            Elements theListeners = theMethods.getElements();
            for (int i = 0; i < theListeners.size(); ++i) {
                Element theListener = theListeners.next();
                String sListenerName = theListener.getName();
                Elements theMethodList = theListener.getElements("Method");
                for (int j = 0; j < theMethodList.size(); ++j) {
                    Element theMethod = theMethodList.next();
                    Element theName = theMethod.getElement("Name");
                    Element theCode = theMethod.getElement("Code");
                    Children theChildren = theCode.getChildren();
                    CData theCdata = (CData)theChildren.first();
                    String sMethodName = theName.getTextString();
                    String sCode = theCdata.getData();
                    MetaMethodLinkage theMethodLink = this.getMethod(sMethodName);
                    theMethodLink.theMethod.setCode(sCode);
                }
            }
        }
        Elements theObjects = theElement.getElements("Object");
        Element theObject = theObjects.next();
        while (theObject != null) {
            MetaObject theMetaObject = new MetaObject();
            theMetaObject.theDesignProject = this.theDesignProject;
            theMetaObject.load(theObject);
            this.addObject(theMetaObject);
            theObject = theObjects.next();
        }
        Element theUserDefinedCode = theElement.getElement("UserDefinedSourceCode");
        if (theUserDefinedCode != null) {
            Children theChildren = theUserDefinedCode.getChildren();
            CData theCdata = (CData)theChildren.first();
            String sCode = theCdata.getData();
            this.setObjectCode(sCode);
        }
        return true;
    }

    ListenerDiscriminator findDiscriminator(ArrayList theDiscriminators, MetaClassDetail theClass) {
        int iDiscriminators = theDiscriminators.size();
        for (int i = 0; i < iDiscriminators; ++i) {
            ListenerDiscriminator theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (!theDiscriminator.theClass.equals(theClass)) continue;
            return theDiscriminator;
        }
        return null;
    }

    public void generateObjectSourceCode(Element xmlObject) {
        String sObjectCode = this.getObjectCode();
        if (sObjectCode != null) {
            Element xmlUserDefinedCode = new Element("UserDefinedSourceCode");
            xmlUserDefinedCode.setText((Text)new CData(new CData(this.getObjectCode())));
            xmlObject.addElement(xmlUserDefinedCode);
        }
    }

    public void generateObjectEventClasses(Element xmlObject) {
        ListenerDiscriminator theDiscriminator;
        MetaMethodLinkage theMethod = this.theFirstMethod;
        ArrayList<MetaClassDetail> theListeners = new ArrayList<MetaClassDetail>(0);
        ArrayList<ListenerDiscriminator> theDiscriminators = new ArrayList<ListenerDiscriminator>(0);
        ArrayList<ListenerDiscriminator> theSpecialDiscriminators = new ArrayList<ListenerDiscriminator>(0);
        while (theMethod != null) {
            MetaClassDetail theClass = theMethod.theListener;
            if (!theListeners.contains(theClass)) {
                theListeners.add(theMethod.theListener);
                theDiscriminator = new ListenerDiscriminator(theClass);
                theDiscriminators.add(theDiscriminator);
                theDiscriminator.addMethod(theMethod);
            } else {
                theDiscriminator = this.findDiscriminator(theDiscriminators, theClass);
                theDiscriminator.addMethod(theMethod);
            }
            theMethod = theMethod.theNextMethod;
        }
        for (int i = 0; i < theDiscriminators.size(); ++i) {
            theDiscriminator = (ListenerDiscriminator)theDiscriminators.get(i);
            if (!theDiscriminator.isSpecial()) continue;
            theSpecialDiscriminators.add(theDiscriminator);
        }
        Element xmlMethods = new Element("Methods");
        boolean bAppendedToObject = false;
        for (int i = 0; i < theSpecialDiscriminators.size(); ++i) {
            boolean bListenerAppended = false;
            ListenerDiscriminator theDiscriminator2 = (ListenerDiscriminator)theSpecialDiscriminators.get(i);
            MetaClassDetail theListener = theDiscriminator2.theClass;
            String sListenerName = theListener.sClassName;
            Element xmlListener = new Element(sListenerName);
            for (int j = 0; j < theDiscriminator2.theMethods.size(); ++j) {
                MetaMethodLinkage theListenerLink = (MetaMethodLinkage)theDiscriminator2.theMethods.get(j);
                MetaMethod theListenerMethod = theListenerLink.theMethod;
                String sCode = theListenerMethod.getCode();
                if (sCode.trim().length() == 0) continue;
                if (!bListenerAppended) {
                    xmlMethods.addElement(xmlListener);
                    bListenerAppended = true;
                    if (!bAppendedToObject) {
                        xmlObject.addElement(xmlMethods);
                        bAppendedToObject = true;
                    }
                }
                Element xmlMethod = new Element("Method");
                Element xmlName = new Element("Name");
                Element xmlCode = new Element("Code");
                xmlListener.addElement(xmlMethod);
                xmlMethod.addElement(xmlName);
                xmlMethod.addElement(xmlCode);
                xmlName.setText(theListenerMethod.sMethodName);
                xmlCode.addChild((Child)new CData(theListenerMethod.sMethodText));
            }
        }
    }

    public MetaParameter searchProperty(String sLongPropertyName, int iIndex) {
        MetaParameter theParameter = null;
        int iDotPos = sLongPropertyName.indexOf(".");
        String sRedundantKey = null;
        if (iDotPos == -1) {
            String sKey = sLongPropertyName;
            MetaProperty theProperty = this.theFirstProperty;
            while (theProperty != null) {
                if (sKey.equals(theProperty.theName)) {
                    if (iIndex >= theProperty.getValueCount()) {
                        return null;
                    }
                    return (MetaParameter)theProperty.theIndexedValue.get(iIndex);
                }
                theProperty = theProperty.theNextProperty;
            }
            return null;
        }
        String sKey = null;
        sKey = iDotPos != -1 ? sLongPropertyName.substring(0, iDotPos) : sLongPropertyName;
        MetaProperty theProperty = this.theFirstProperty;
        while (theProperty != null && !sKey.equals(theProperty.theName)) {
            theProperty = theProperty.theNextProperty;
        }
        sRedundantKey = sKey;
        if (theProperty != null) {
            theParameter = (MetaParameter)theProperty.theIndexedValue.get(iIndex);
            while (iDotPos != -1) {
                sKey = (iDotPos = (sLongPropertyName = sLongPropertyName.substring(iDotPos + 1)).indexOf(".")) != -1 ? sLongPropertyName.substring(0, iDotPos) : sLongPropertyName;
                if (sKey.equals(sRedundantKey)) continue;
                if (theParameter != null) {
                    theParameter = theParameter.searchParameterTree(sLongPropertyName);
                    continue;
                }
                return null;
            }
            return theParameter;
        }
        return null;
    }

    public MetaPropertyValueEx getPropertyValue(String sLongPropertyName, int iIndex) {
        MetaParameter theMatch = this.searchProperty(sLongPropertyName, iIndex);
        if (theMatch != null) {
            return theMatch.theValue;
        }
        return null;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, MetaPropertyValueEx pvValue) {
        MetaParameter theMatch = this.searchProperty(sLongPropertyName, iIndex);
        if (theMatch != null) {
            theMatch.theValue = pvValue;
            if (sLongPropertyName.equals("Mnemonic")) {
                pvValue.setMnemonic();
            }
            return true;
        }
        return false;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, Object objValue, boolean bGlobal) {
        MetaParameter theMatch = this.searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = "java.lang.String";
        boolean bResolveAsObject = false;
        if (objValue != null) {
            sSimpleType = objValue.getClass().getName();
        }
        if (theMatch == null) {
            MetaPropertyDescriptor theMetadata;
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1) {
                sPiece = sPiece.substring(0, iDotPos);
            }
            if ((theMetadata = this.theClass.getProperty(sPiece, true)) != null) {
                sSimpleType = theMetadata.sClass;
                bResolveAsObject = theMetadata.bObjectReference;
            }
            theMatch = this.makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null) {
            return false;
        }
        theMatch.theOrder = iOrder;
        if (objValue == null) {
            this.setPropertyValueImpl(theMatch, sSimpleType, null, bGlobal);
        } else {
            this.setPropertyValueImpl(theMatch, sSimpleType, objValue.toString(), bGlobal);
        }
        if (sLongPropertyName.equals("Mnemonic")) {
            theMatch.setMnemonic();
        }
        return true;
    }

    public void setPropertyValueImpl(MetaParameter theMatch, String sSimpleType, String strValue, boolean bGlobal) {
        if (theMatch.bAllowMultipleLanguages && bGlobal) {
            int iCurrentLanguage = this.theDesignProject.getCurrentLanguage().theLanguage;
            for (int iLang = 0; iLang <= 3; ++iLang) {
                this.theDesignProject.setCurrentLanguage(iLang);
                theMatch.set(sSimpleType, strValue, this.theDesignProject);
            }
            this.theDesignProject.setCurrentLanguage(iCurrentLanguage);
        } else {
            theMatch.set(sSimpleType, strValue, this.theDesignProject);
        }
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, int iValue, boolean bGlobal) {
        MetaParameter theMatch = this.searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(2);
        if (theMatch == null) {
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1) {
                sPiece = sPiece.substring(0, iDotPos);
            }
            MetaPropertyDescriptor theMetadata = this.theClass.getProperty(sPiece, true);
            theMatch = this.makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null) {
            return false;
        }
        theMatch.theOrder = iOrder;
        this.setPropertyValueImpl(theMatch, sSimpleType, new Integer(iValue).toString(), bGlobal);
        if (sLongPropertyName.equals("Mnemonic")) {
            theMatch.setMnemonic();
        }
        return true;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, char cValue, boolean bGlobal) {
        MetaParameter theMatch = this.searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(5);
        if (theMatch == null) {
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1) {
                sPiece = sPiece.substring(0, iDotPos);
            }
            MetaPropertyDescriptor theMetadata = this.theClass.getProperty(sPiece, true);
            theMatch = this.makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null) {
            return false;
        }
        theMatch.theOrder = iOrder;
        this.setPropertyValueImpl(theMatch, sSimpleType, new Character(cValue).toString(), bGlobal);
        if (sLongPropertyName.equals("Mnemonic")) {
            theMatch.setMnemonic();
        }
        return true;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, float fValue, boolean bGlobal) {
        MetaParameter theMatch = this.searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(4);
        if (theMatch == null) {
            MetaPropertyDescriptor theMetadata = this.theClass.getProperty(sLongPropertyName, true);
            theMatch = this.makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null) {
            return false;
        }
        theMatch.theOrder = iOrder;
        this.setPropertyValueImpl(theMatch, sSimpleType, new Float(fValue).toString(), bGlobal);
        if (sLongPropertyName.equals("Mnemonic")) {
            theMatch.setMnemonic();
        }
        return true;
    }

    public boolean setPropertyValue(String sLongPropertyName, int iIndex, int iOrder, double dValue, boolean bGlobal) {
        MetaParameter theMatch = this.searchProperty(sLongPropertyName, iIndex);
        String sSimpleType = MetaPropertyValueEx.translateType(3);
        if (theMatch == null) {
            int iDotPos = sLongPropertyName.indexOf(".");
            String sPiece = sLongPropertyName;
            if (iDotPos != -1) {
                sPiece = sPiece.substring(0, iDotPos);
            }
            MetaPropertyDescriptor theMetadata = this.theClass.getProperty(sPiece, true);
            theMatch = this.makeProperty(sLongPropertyName, iIndex, iOrder, sSimpleType, theMetadata);
        }
        if (theMatch == null) {
            return false;
        }
        theMatch.theOrder = iOrder;
        this.setPropertyValueImpl(theMatch, sSimpleType, new Double(dValue).toString(), bGlobal);
        if (sLongPropertyName.equals("Mnemonic")) {
            theMatch.setMnemonic();
        }
        return true;
    }

    public MetaParameter makeProperty(String sLongPropertyName, int iIndex, int iOrder, String sSimpleType, MetaPropertyDescriptor thePropertyInfo) {
        boolean bAllowMultipleLanguages = false;
        boolean bObjectReference = false;
        boolean bArrayBased = false;
        if (thePropertyInfo != null) {
            bAllowMultipleLanguages = thePropertyInfo.bAllowMultipleLanguages;
            bObjectReference = thePropertyInfo.bObjectReference;
            bArrayBased = thePropertyInfo.bAllowMultipleValues;
        }
        int iDotPos = sLongPropertyName.lastIndexOf(".");
        String sSpecialization = sLongPropertyName;
        MetaParameter theMatch = null;
        MetaParameter anyMatch = this.searchProperty(sLongPropertyName, 0);
        while (iDotPos != -1 && (theMatch = this.searchProperty(sLongPropertyName = sLongPropertyName.substring(0, iDotPos), iIndex)) == null) {
            iDotPos = sLongPropertyName.lastIndexOf(".");
        }
        if (anyMatch != null && theMatch == null) {
            String sShortName = sLongPropertyName;
            int iDotPos2 = sLongPropertyName.indexOf(".");
            if (iDotPos2 != -1) {
                sShortName = sShortName.substring(0, iDotPos2);
            }
            MetaProperty theProp = this.getPropertyMetadata(sShortName);
            theProp.theIndexedValue.add(iIndex, new MetaParameter(iOrder, sSimpleType, sLongPropertyName, this.theDesignProject, bAllowMultipleLanguages, bObjectReference));
            return (MetaParameter)theProp.theIndexedValue.get(iIndex);
        }
        if (theMatch != null) {
            if (theMatch.theComplexType == null) {
                return null;
            }
            sSpecialization = sSpecialization.substring(iDotPos + 1);
            iDotPos = sSpecialization.indexOf(".");
            String sPiece = "";
            while (iDotPos != -1) {
                sPiece = sSpecialization.substring(0, iDotPos);
                sSpecialization = sSpecialization.substring(iDotPos + 1);
                MetaType theNewMetatype = new MetaType(this.theDesignProject);
                MetaParameter theNewParameter = new MetaParameter(iOrder, theNewMetatype, sPiece, this.theDesignProject, bAllowMultipleLanguages, bObjectReference);
                theMatch.theComplexType.addParameter(theNewParameter);
                theMatch = theNewParameter;
                iDotPos = sSpecialization.indexOf(".");
            }
            MetaParameter theNewParameter = new MetaParameter();
            theNewParameter.theOrder = iOrder;
            theNewParameter.theComplexType = null;
            theNewParameter.theSimpleType = sSimpleType;
            theNewParameter.theName = sSpecialization;
            theNewParameter.bAllowMultipleLanguages = bAllowMultipleLanguages;
            theMatch.theComplexType.addParameter(theNewParameter);
            return theNewParameter;
        }
        sSpecialization = sSpecialization.substring(iDotPos + 1);
        iDotPos = sSpecialization.indexOf(".");
        String sPiece = sSpecialization;
        if (iDotPos != -1) {
            sPiece = sPiece.substring(0, iDotPos);
        }
        MetaPropertyDescriptor theBasePropertyInfo = this.theClass.getProperty(sPiece, true);
        MetaProperty theNewProperty = new MetaProperty(theBasePropertyInfo, this);
        theNewProperty.bAllowMultipleValues = bArrayBased;
        theNewProperty.theName = sPiece;
        sPiece = "";
        while (iDotPos != -1) {
            int iType;
            sPiece = (iDotPos = (sSpecialization = sSpecialization.substring(iDotPos + 1)).indexOf(".")) != -1 ? sSpecialization.substring(0, iDotPos) : sSpecialization;
            MetaType theNewMetatype = new MetaType(this.theDesignProject);
            if (thePropertyInfo.sClass != null && thePropertyInfo.sClass.length() > 0 && (iType = MetaPropertyValueEx.translateType(thePropertyInfo.sClass)) == 0) {
                theNewMetatype.theFullName = thePropertyInfo.sClass;
            }
            MetaParameter theNewParameter = new MetaParameter(iOrder, theNewMetatype, sPiece, this.theDesignProject, bAllowMultipleLanguages, bObjectReference);
            if (theMatch != null) {
                theMatch.theComplexType.addParameter(theNewParameter);
            } else {
                MetaType thePlaceHolderType = new MetaType(this.theDesignProject);
                thePlaceHolderType.theName = theBasePropertyInfo.sClass;
                thePlaceHolderType.theFullName = theBasePropertyInfo.sClass;
                MetaParameter thePlaceHolderParameter = new MetaParameter();
                thePlaceHolderParameter.theName = theNewProperty.theName;
                thePlaceHolderParameter.theComplexType = thePlaceHolderType;
                thePlaceHolderParameter.theComplexType.addParameter(theNewParameter);
                thePlaceHolderParameter.bAllowMultipleLanguages = bAllowMultipleLanguages;
                thePlaceHolderParameter.theDesignProject = this.theDesignProject;
                theNewProperty.theIndexedValue.add(iIndex, thePlaceHolderParameter);
            }
            theMatch = theNewParameter;
        }
        if (theMatch == null) {
            MetaParameter theNewParameter = new MetaParameter();
            theNewParameter.theSimpleType = sSimpleType;
            theNewParameter.theComplexType = null;
            theNewParameter.theName = "";
            theNewParameter.bAllowMultipleLanguages = bAllowMultipleLanguages;
            theNewParameter.theDesignProject = this.theDesignProject;
            theNewProperty.theIndexedValue.add(0, theNewParameter);
            theMatch = theNewParameter;
        } else {
            theMatch.theComplexType = null;
            theMatch.theSimpleType = sSimpleType;
            theMatch.theName = sPiece;
        }
        this.addProperty(theNewProperty);
        theMatch.bObjectReference = bObjectReference;
        return theMatch;
    }

    public MetaProperty getPropertyMetadata(String sPropertyName) {
        MetaProperty theProp = this.theFirstProperty;
        while (theProp != null) {
            if (theProp.theName.trim().equals(sPropertyName)) {
                return theProp;
            }
            theProp = theProp.theNextProperty;
        }
        return null;
    }

    public int getContainerType() {
        MetaPropertyValueEx theProperty = this.getPropertyValue("ContainerType", 0);
        if (theProperty != null) {
            String sContainerType = theProperty.getStringValue();
            MetaContainerType theContainerType = new MetaContainerType(sContainerType);
            return theContainerType.getContainerType();
        }
        return 0;
    }

    public void removeListeners(Component comp) {
        FocusListener[] theFocusListeners = comp.getFocusListeners();
        MouseListener[] theListeners = comp.getMouseListeners();
        MouseMotionListener[] theMotionListeners = comp.getMouseMotionListeners();
        for (int iListener = 0; iListener < theListeners.length; ++iListener) {
            comp.removeMouseListener(theListeners[iListener]);
        }
        for (int iMotionListener = 0; iMotionListener < theMotionListeners.length; ++iMotionListener) {
            comp.removeMouseMotionListener(theMotionListeners[iMotionListener]);
        }
        for (int iFocusListener = 0; iFocusListener < theFocusListeners.length; ++iFocusListener) {
            comp.removeFocusListener(theFocusListeners[iFocusListener]);
        }
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            Component[] childVisualObjects = jcomp.getComponents();
            for (int i = 0; i < childVisualObjects.length; ++i) {
                this.removeListeners(childVisualObjects[i]);
                if (!this.isCompositeComponent() || childVisualObjects[i].equals(this.theVisualObject)) continue;
                childVisualObjects[i].setEnabled(false);
                if (this.theMouseListener != null) {
                    childVisualObjects[i].addMouseListener((MouseListener)this.theMouseListener);
                }
                if (this.theMouseMotionListener == null) continue;
                childVisualObjects[i].addMouseMotionListener((MouseMotionListener)this.theMouseMotionListener);
            }
        }
    }

    public void refreshListeners() {
        if (this.theVisualObject == null) {
            return;
        }
        this.removeListeners(this.theVisualObject);
        if (this.theMouseListener != null) {
            this.theVisualObject.addMouseListener((MouseListener)this.theMouseListener);
        }
        if (this.theMouseMotionListener != null) {
            this.theVisualObject.addMouseMotionListener((MouseMotionListener)this.theMouseMotionListener);
        }
    }

    public void removeListeners() {
        this.removeListeners(this.theVisualObject);
    }

    public boolean getAnchorLeft() {
        return this.bLeftAnchoring;
    }

    public boolean getAnchorRight() {
        return this.bRightAnchoring;
    }

    public boolean getAnchorTop() {
        return this.bTopAnchoring;
    }

    public boolean getAnchorBottom() {
        return this.bBottomAnchoring;
    }

    public void setForegroundColor(Color objColor) {
        this.theForegroundColor = objColor;
        if (this.theVisualObject != null) {
            this.theVisualObject.setForeground(objColor);
        }
        if (this.theVisualFrame != null) {
            this.theVisualFrame.getContentPane().setForeground(objColor);
        }
        this.setPropertyValue("Foreground", 0, 0, objColor.toString(), true);
    }

    public void setBackgroundColor(Color objColor) {
        this.theBackgroundColor = objColor;
        if (this.theVisualObject != null) {
            this.theVisualObject.setBackground(objColor);
        }
        if (this.theVisualFrame != null) {
            this.theVisualFrame.getContentPane().setBackground(objColor);
        }
        this.setPropertyValue("Background", 0, 0, objColor.toString(), true);
    }

    public void setColor(Color objColor, boolean bForeground) {
        if (bForeground) {
            this.setForegroundColor(objColor);
        } else {
            this.setBackgroundColor(objColor);
        }
    }

    public void setFont(Font objFont) {
        if (this.theVisualObject != null && objFont != null) {
            this.theVisualObject.setFont(objFont);
        }
        this.theFont = objFont;
        if (this.theFont == null) {
            this.setPropertyValue("Font", 0, 0, null);
        } else {
            this.setPropertyValue("Font", 0, 0, this.theFont.toString(), true);
        }
    }

    public int getDisplayLayer() {
        return this.iDisplayLayer;
    }

    public void bringForward() {
        MetaObject theObjectBelow = this.theParentObject;
        if (theObjectBelow == null) {
            return;
        }
        ArrayList<MetaObject> theLayers = new ArrayList<MetaObject>(1);
        theLayers.add(this);
        MetaObject theLastObject = this;
        while (theObjectBelow != null) {
            theLayers.add(theObjectBelow);
            theObjectBelow.resetDisplayLayer(theLastObject);
            theLastObject = theObjectBelow;
            theObjectBelow = theObjectBelow.theParentObject;
        }
        int iLayers = theLayers.size();
        if (iLayers > 0) {
            int theLayer = JLayeredPane.DEFAULT_LAYER + 1;
            for (int iLayer = iLayers - 1; iLayer >= 0; --iLayer) {
                theObjectBelow = (MetaObject)theLayers.get(iLayer);
                theObjectBelow.setDisplayLayer(theLayer);
                ++theLayer;
            }
        }
    }

    public void setDisplayLayer(int iLayer) {
        int theTestLayer = this.getDisplayLayer();
        if (theTestLayer != iLayer) {
            this.iDisplayLayer = iLayer;
            if (this.theParentObject == null) {
                return;
            }
            if (this.theParentObject.theVisualObject instanceof JLayeredPane) {
                this.theDesignProject.getMetaDataUser().updateDisplayLayer(this, iLayer);
            }
        }
    }

    public void resetDisplayLayer(MetaObject childToSkip) {
        if (this.iDisplayLayer == JLayeredPane.DEFAULT_LAYER) {
            return;
        }
        this.iDisplayLayer = JLayeredPane.DEFAULT_LAYER;
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            MetaObject theParentBelow = theChild.theParentObject;
            if (!theChild.equals(childToSkip)) {
                if (theParentBelow.theVisualObject instanceof JLayeredPane) {
                    theChild.setDisplayLayer(this.iDisplayLayer);
                }
                theChild.resetDisplayLayer(null);
            }
            theChild = theChild.theNextObject;
        }
    }

    public boolean renderObject() {
        this.create();
        if (this.theFabricatedObject instanceof JFrame) {
            JFrame theFrame = (JFrame)this.theFabricatedObject;
            Dimension dimSize = theFrame.getSize();
            theFrame.setVisible(false);
            theFrame.show();
            Insets theInsets = theFrame.getInsets();
            theFrame.setSize((int)dimSize.getWidth() + theInsets.left + theInsets.right, (int)dimSize.getHeight() + theInsets.top + theInsets.bottom);
        }
        if (this.theVisualObject != null) {
            Dimension dimSize = this.theVisualObject.getSize();
            Dimension dimMaxSize = this.theVisualObject.getMaximumSize();
            if (dimMaxSize.width == 0 && dimMaxSize.height == 0 && dimSize != null) {
                this.theVisualObject.setMaximumSize(dimSize);
            }
            Dimension dimMinSize = this.theVisualObject.getMinimumSize();
            if (dimMinSize.width == 0 && dimMinSize.height == 0 && dimSize != null) {
                this.theVisualObject.setMinimumSize(dimSize);
            }
        }
        MetaObject theObject = this.theFirstChild;
        while (theObject != null) {
            theObject.renderObject();
            theObject = theObject.theNextObject;
        }
        if (this.theFabricatedObject instanceof JFrame) {
            JFrame theFrame = (JFrame)this.theFabricatedObject;
            theFrame.setVisible(true);
        }
        boolean locationX = false;
        if (this.theFabricatedObject instanceof JMenuBar) {
            JMenuBar theMenuBar = (JMenuBar)this.theFabricatedObject;
            if (this.theParentObject.theFabricatedObject instanceof JFrame) {
                JFrame jfm = (JFrame)this.theParentObject.theFabricatedObject;
                jfm.setJMenuBar(theMenuBar);
            }
            MenuElement[] me = theMenuBar.getSubElements();
            for (int i = 0; i < me.length; ++i) {
                JMenu jm = (JMenu)me[i];
            }
        } else if (this.theFabricatedObject instanceof JMenu) {
            JMenu theMenu = (JMenu)this.theFabricatedObject;
            MenuElement[] se = theMenu.getSubElements();
        }
        return true;
    }

    public boolean renderObject(JFrame theFrame) {
        if (theFrame == null) {
            return false;
        }
        this.theFabricatedObject = theFrame;
        this.theVisualFrame = theFrame;
        this.theVisualObject = null;
        Dimension dimSize = theFrame.getSize();
        Point ptLocation = theFrame.getLocation();
        this.setSize((int)dimSize.getWidth(), (int)dimSize.getHeight());
        this.setLocation((int)ptLocation.getX(), (int)ptLocation.getY());
        AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
        this.theLayoutManager = theAnchoringLayoutManager;
        this.theVisualFrame.getContentPane().setLayout(theAnchoringLayoutManager);
        MetaObject theObject = this.theFirstChild;
        while (theObject != null) {
            theObject.renderObject();
            theObject = theObject.theNextObject;
        }
        return true;
    }

    public boolean renderObject(JComponent theComponent) {
        if (theComponent == null) {
            return false;
        }
        this.theFabricatedObject = theComponent;
        this.theVisualFrame = null;
        this.theVisualObject = theComponent;
        Dimension dimSize = theComponent.getSize();
        Point ptLocation = theComponent.getLocation();
        this.setSize((int)dimSize.getWidth(), (int)dimSize.getHeight());
        this.setLocation((int)ptLocation.getX(), (int)ptLocation.getY());
        AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
        this.theLayoutManager = theAnchoringLayoutManager;
        if (this.theVisualObject instanceof Container) {
            this.theVisualObject.setLayout(theAnchoringLayoutManager);
            MetaObject theObject = this.theFirstChild;
            while (theObject != null) {
                theObject.renderObject();
                theObject = theObject.theNextObject;
            }
        }
        return true;
    }

    public boolean addDefaultProperty(String sPrefix, MetaPropertyDescriptor prop) {
        MetaPropertyValueEx pv;
        boolean bRetVal = false;
        MetaPropertyDescriptor theSubprop = prop.theFirstSubproperty;
        int iDotPos = prop.sName.indexOf(".");
        sPrefix = iDotPos == -1 && sPrefix != null && sPrefix.trim().length() > 0 ? sPrefix + "." : "";
        if (theSubprop != null) {
            while (theSubprop != null) {
                this.addDefaultProperty(sPrefix + prop.sName, theSubprop);
                theSubprop = theSubprop.theNextProperty;
            }
        } else if (prop.getDefaultValue() != null && prop.getDefaultValue().trim().length() > 0 && (pv = this.getPropertyValue(sPrefix + prop.sName, 0)) == null) {
            MetaParameter newProp = this.makeProperty(sPrefix + prop.sName, 0, prop.getOrder(), prop.sClass, prop);
            String sDefaultValue = prop.getDefaultValue();
            if (sDefaultValue != null && prop.getIncludeTypeConstants() != null) {
                MetaConstantGroup theConstantTable = this.theDesignProject.findConstantGroup(prop.getIncludeTypeConstants());
                if (theConstantTable != null) {
                    if (sDefaultValue instanceof String) {
                        sDefaultValue = theConstantTable.get(sDefaultValue);
                    }
                } else {
                    MetaConstantGroupCollection theConstantTableGroup = this.theDesignProject.findConstantGroupCollection(prop.getIncludeTypeConstants());
                    if (theConstantTableGroup != null && sDefaultValue instanceof String) {
                        sDefaultValue = theConstantTableGroup.get(sDefaultValue);
                    }
                }
            }
            if (sDefaultValue != null) {
                newProp.set(prop.sClass, sDefaultValue, true, this.theDesignProject);
            }
        }
        return bRetVal;
    }

    public boolean addDefaultProperties() {
        boolean bRetVal = false;
        MetaClass theWorkingClass = this.theClass;
        while (theWorkingClass != null) {
            MetaPropertyDescriptor propChain = theWorkingClass.theMetadata.theFirstProperty;
            while (propChain != null) {
                this.addDefaultProperty(null, propChain);
                propChain = propChain.theNextProperty;
            }
            theWorkingClass = theWorkingClass.theParentClass;
        }
        return bRetVal;
    }

    public boolean doProperties() {
        boolean bRetVal = true;
        String sPropertySetter = "";
        if (!this.propsLoaded) {
            Border theBorder;
            ImageIcon theIcon;
            String sIconName;
            MetaPropertyValueEx pvBitmapNamePressed;
            ImageIcon theIcon2;
            String sIconName2;
            MetaPropertyValueEx pvBitmapName;
            try {
                MetaProperty theProperty = this.theFirstProperty;
                Class<?> cls = this.iMode == 1 ? Class.forName(this.theClass.theMetadata.sDisplayClass) : Class.forName(this.theType.theFullName);
                while (theProperty != null) {
                    block91: {
                        Object[] objects;
                        MetaPropertyValueEx theValue;
                        Class[] classes;
                        Object[] thePropertyValue = theProperty.Create();
                        boolean bMnemonic = false;
                        if (theProperty.theName.equals("Mnemonic")) {
                            bMnemonic = true;
                        }
                        sPropertySetter = "set" + theProperty.theName;
                        Method m = null;
                        if (theProperty.bAllowMultipleValues) {
                            classes = new Class[1];
                            if (thePropertyValue[0] instanceof MetaPropertyValueEx) {
                                theValue = (MetaPropertyValueEx)thePropertyValue[0];
                                Class clsSimpleClass = MetaPropertyValueEx.getTypeAsClass(theValue.getType());
                                String sSimpleType = clsSimpleClass.getName();
                                classes[0] = Class.forName("[L" + sSimpleType + ";");
                                try {
                                    m = cls.getMethod(sPropertySetter, classes);
                                }
                                catch (NoSuchMethodException e69) {
                                    // empty catch block
                                }
                                if (m != null) {
                                    int iNoItems = thePropertyValue.length;
                                    Object theParameter = Array.newInstance(clsSimpleClass, iNoItems);
                                    for (int i = 0; i < iNoItems; ++i) {
                                        MetaPropertyValueEx someValue = (MetaPropertyValueEx)thePropertyValue[i];
                                        HammerClassCustomLoader theLoader = null;
                                        theLoader = ((HammerClassLoader)this.theDesignProject.theClassLoader).getLoader();
                                        Object theNativeValue = someValue.getNativeValue();
                                        Object theResolvedValue = MetaConstantGroup.resolve(theNativeValue, this.theClass.theMetadataDispenser, theLoader);
                                        if (theResolvedValue instanceof String) {
                                            if (this.theDesignProject.iMode == 1) {
                                                theResolvedValue = this.theDesignProject.getNLS().getTranslatedValue((String)theResolvedValue, this.theDesignProject.theCurrentLanguage.theLanguage, bMnemonic);
                                            }
                                            if (clsSimpleClass == Character.TYPE) {
                                                theResolvedValue = new Character(((String)theResolvedValue).charAt(0));
                                            }
                                        }
                                        Array.set(theParameter, i, theResolvedValue);
                                    }
                                    objects = new Object[]{theParameter};
                                    m.invoke(this.theFabricatedObject, objects);
                                }
                            }
                        } else {
                            if (thePropertyValue[0] instanceof MetaArgumentList) {
                                MetaArgumentList theArgs = (MetaArgumentList)thePropertyValue[0];
                                int iArgCount = theArgs.iArgCount;
                                classes = new Class[iArgCount];
                                objects = new Object[iArgCount];
                                for (int i = 0; i < iArgCount; ++i) {
                                    objects[i] = theArgs.getArgument(i);
                                    if (objects[i] instanceof MetaPropertyValueEx) {
                                        MetaPropertyValueEx theValue2 = (MetaPropertyValueEx)objects[i];
                                        classes[i] = MetaPropertyValueEx.getTypeAsClass(theValue2.getType());
                                        HammerClassCustomLoader theLoader = null;
                                        theLoader = ((HammerClassLoader)this.theDesignProject.theClassLoader).getLoader();
                                        Object theNativeValue = theValue2.getNativeValue();
                                        Object theResolvedValue = MetaConstantGroup.resolve(theNativeValue, this.theClass.theMetadataDispenser, theLoader);
                                        if (classes[i] == null || classes[i].equals(String.class)) {
                                            classes[i] = theProperty.getParameterClass();
                                        }
                                        if (theResolvedValue instanceof String) {
                                            AbaNLS theNlsSupport = this.theDesignProject.getNLS();
                                            theResolvedValue = theNlsSupport.getTranslatedValue((String)theResolvedValue, this.theDesignProject.theCurrentLanguage.theLanguage, bMnemonic);
                                            if (classes[i] == Character.TYPE) {
                                                theResolvedValue = new Character(((String)theResolvedValue).charAt(0));
                                            }
                                        }
                                        objects[i] = theResolvedValue;
                                        continue;
                                    }
                                    classes[i] = objects[i] != null ? objects[i].getClass() : Class.forName("java.lang.String");
                                }
                            } else {
                                classes = new Class[1];
                                objects = new Object[]{thePropertyValue[0]};
                                if (objects[0] instanceof MetaPropertyValueEx) {
                                    theValue = (MetaPropertyValueEx)objects[0];
                                    if (theValue.bResolveAsObject) {
                                        classes[0] = theValue.objectClass;
                                        objects[0] = theValue.getNativeValue();
                                    } else {
                                        Object theResolvedValue;
                                        classes[0] = MetaPropertyValueEx.getTypeAsClass(theValue.getType());
                                        if (classes[0] == null) {
                                            classes[0] = theValue.objectClass;
                                        }
                                        HammerClassCustomLoader theLoader = null;
                                        theLoader = ((HammerClassLoader)this.theDesignProject.theClassLoader).getLoader();
                                        Object theNativeValue = theValue.getNativeValue();
                                        if (theNativeValue == null) {
                                            theNativeValue = theValue.getLocalString();
                                        }
                                        if (classes[0] == null || classes[0].equals(String.class)) {
                                            classes[0] = theProperty.getParameterClass();
                                        }
                                        if ((theResolvedValue = MetaConstantGroup.resolve(theNativeValue, this.theClass.theMetadataDispenser, theLoader)) instanceof String) {
                                            if (this.theDesignProject.iMode == 1) {
                                                theResolvedValue = this.theDesignProject.getNLS().getTranslatedValue((String)theResolvedValue, this.theDesignProject.theCurrentLanguage.theLanguage, bMnemonic);
                                            }
                                            if (classes[0] == Character.TYPE) {
                                                if (((String)theResolvedValue).length() > 0) {
                                                    theResolvedValue = new Character(((String)theResolvedValue).charAt(0));
                                                } else {
                                                    theResolvedValue = new Character('\u0000');
                                                    sPropertySetter = "AbaDCSkipInvocation";
                                                }
                                            }
                                        }
                                        objects[0] = theResolvedValue;
                                    }
                                } else {
                                    classes[0] = objects[0].getClass();
                                }
                            }
                            try {
                                m = cls.getMethod(sPropertySetter, classes);
                            }
                            catch (NoSuchMethodException e1) {
                                // empty catch block
                            }
                            try {
                                if (m != null) {
                                    m.invoke(this.theFabricatedObject, objects);
                                }
                            }
                            catch (InvocationTargetException e99) {
                                String sErrMsg = "Illegal Argument For Method " + m.getName() + " of class " + this.theFabricatedObject.getClass().getName();
                                if (this.theDesignProject.iMode == 1) {
                                    if (this.theDesignProject.getMetaDataUser().getLogFile() != null) {
                                        this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Hammer Object Construction Error", sErrMsg);
                                    }
                                }
                                if (this.theDesignProject.getMetaDataUser().getLogFile() == null) break block91;
                                this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry("AbaRenderer Object Construction", sErrMsg);
                            }
                        }
                    }
                    theProperty = theProperty.theNextProperty;
                }
            }
            catch (Exception e1) {
                String sMessage1 = "Error invoking " + sPropertySetter + " for object " + this.getName();
                String sMessage2 = " Message is " + e1.getMessage();
                if (this.theDesignProject.getMetaDataUser().getLogFile() != null) {
                    this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry(sMessage1, sMessage2);
                }
                return false;
            }
            if (this.iMode == 1) {
                this.theDesignProject.getMetaDataUser().processObjectNameChanged(this);
            }
            int iContainerType = this.theClass.theMetadata.containerType.getContainerType();
            this.setPropertyValue("ContainerType", 0, 0, MetaContainerType.getContainerTypeAsString(iContainerType), true);
            MetaPropertyValueEx pvAutoEmbed = this.getPropertyValue("AutoEmbed", 0);
            if (pvAutoEmbed != null) {
                this.bAutoEmbed = true;
            }
            if (!this.isVertSplit() && !this.isHorzSplit()) {
                String sDefaultValue;
                MetaPropertyDescriptor theProperty;
                MetaPropertyValueEx pvYSize;
                int iXSize = 0;
                int iYSize = 0;
                String sXSize = null;
                String sYSize = null;
                MetaPropertyValueEx pvXSize = this.getPropertyValue("Size.Width", 0);
                if (pvXSize != null) {
                    sXSize = pvXSize.getStringValue();
                }
                if ((pvYSize = this.getPropertyValue("Size.Height", 0)) != null) {
                    sYSize = pvYSize.getStringValue();
                }
                if (sXSize != null && sYSize != null) {
                    try {
                        iXSize = Integer.parseInt(sXSize);
                        iYSize = Integer.parseInt(sYSize);
                    }
                    catch (Exception e0) {
                        iXSize = 0;
                        iYSize = 0;
                    }
                }
                if ((sXSize == null || iXSize == 0) && (theProperty = this.theClass.getProperty("Size.Width", true)) != null) {
                    sDefaultValue = theProperty.getDefaultValue();
                    sXSize = sDefaultValue != null ? sDefaultValue : "";
                }
                if ((sYSize == null || iYSize == 0) && (theProperty = this.theClass.getProperty("Size.Height", true)) != null) {
                    sDefaultValue = theProperty.getDefaultValue();
                    sYSize = sDefaultValue != null ? sDefaultValue : "";
                }
                try {
                    iXSize = Integer.parseInt(sXSize);
                    iYSize = Integer.parseInt(sYSize);
                }
                catch (Exception e0) {
                    iXSize = 0;
                    iYSize = 0;
                }
                this.setSize(iXSize, iYSize);
            }
            String sXLoc = null;
            MetaPropertyValueEx pvXLoc = this.getPropertyValue("Location.Left", 0);
            String sYLoc = null;
            MetaPropertyValueEx pvYLoc = this.getPropertyValue("Location.Top", 0);
            if (pvXLoc != null) {
                sXLoc = pvXLoc.getStringValue();
            }
            if (pvYLoc != null) {
                sYLoc = pvYLoc.getStringValue();
            }
            if (this.iMode == 1 && (this.isFrame() || this.isAbalet())) {
                sXLoc = "0";
                sYLoc = "0";
            }
            try {
                this.iXLocation = Integer.parseInt(sXLoc);
                this.iYLocation = Integer.parseInt(sYLoc);
            }
            catch (Exception e0) {
                this.iXLocation = 0;
                this.iYLocation = 0;
            }
            if ((this.isFrame() || this.isAbalet()) && this.iMode == 1) {
                this.iXLocation = 0;
                this.iYLocation = 0;
            }
            if (!(this.theVisualObject != null && (this.isJMenu() || this.isJMenuItem() || this.isJToolBarButton()) || this.theVisualObject == null)) {
                this.theVisualObject.setLocation(this.iXLocation, this.iYLocation);
            }
            if (this.theVisualFrame != null) {
                this.theVisualFrame.setLocation(this.iXLocation, this.iYLocation);
            }
            if ((pvBitmapName = this.getPropertyValue("BitmapName", 0)) != null && (sIconName2 = pvBitmapName.getStringValue()) != null && this.theVisualObject instanceof JButton && (theIcon2 = new ImageIcon(sIconName2)) != null) {
                JButton theButton = (JButton)this.theVisualObject;
                theButton.setIcon(theIcon2);
            }
            if ((pvBitmapNamePressed = this.getPropertyValue("BitmapNamePressed", 0)) != null && (sIconName = pvBitmapNamePressed.getStringValue()) != null && this.theVisualObject instanceof JButton && (theIcon = new ImageIcon(sIconName)) != null) {
                JButton theButton = (JButton)this.theVisualObject;
                theButton.setPressedIcon(theIcon);
            }
            if (this.iMode == 1 && !this.isFrame() && !this.isAbalet() && this.theClass.theMetadata.getDesignBorders() && ((theBorder = this.theVisualObject.getBorder()) == null || theBorder instanceof EmptyBorder)) {
                this.theVisualObject.setBorder(this.theDesignProject.getDesignBorder());
            }
        }
        if (this.isFrame() || this.isTabPage() || this.isPanel() || this.isAbalet() || this.isGroup()) {
            if (this.iMode != 1) {
                AnchoringLayoutManager theAnchoringLayoutManager = new AnchoringLayoutManager();
                theAnchoringLayoutManager = new AnchoringLayoutManager();
                this.theLayoutManager = theAnchoringLayoutManager;
                if (this.isFrame()) {
                    this.theVisualFrame.getContentPane().setLayout(theAnchoringLayoutManager);
                } else {
                    this.theVisualObject.setLayout(theAnchoringLayoutManager);
                }
            } else {
                this.theDesignProject.getMetaDataUser().processCreateLayout(this);
            }
        }
        if (!(this.isFrame() || this.isAbalet() || this.isTabPage() || this.isHorzSplit() || this.isVertSplit() || this.isJToolBarButton())) {
            Object oValue;
            MetaPropertyValueEx pvValue = this.getPropertyValue("AnchorLeft", 0);
            if (pvValue != null && (oValue = pvValue.getNativeValue()) instanceof Boolean) {
                this.bLeftAnchoring = (Boolean)oValue;
            }
            if ((pvValue = this.getPropertyValue("AnchorRight", 0)) != null && (oValue = pvValue.getNativeValue()) instanceof Boolean) {
                this.bRightAnchoring = (Boolean)oValue;
            }
            if ((pvValue = this.getPropertyValue("AnchorTop", 0)) != null && (oValue = pvValue.getNativeValue()) instanceof Boolean) {
                this.bTopAnchoring = (Boolean)oValue;
            }
            if ((pvValue = this.getPropertyValue("AnchorBottom", 0)) != null && (oValue = pvValue.getNativeValue()) instanceof Boolean) {
                this.bBottomAnchoring = (Boolean)oValue;
            }
        }
        if (!this.isFrame() && !this.isAbalet()) {
            if (this.isTabPage()) {
                if (this.theParentObject != null && this.theParentObject.isTabbedPane()) {
                    this.theDesignProject.getMetaDataUser().processTabPages(this);
                }
            } else if (this.isJMenu()) {
                if (this.theParentObject != null && this.theParentObject.isJMenuBar()) {
                    this.theDesignProject.getMetaDataUser().processMenus(this);
                }
            } else if (this.isJMenuItem()) {
                if (this.theParentObject != null && this.theParentObject.isJMenu()) {
                    this.theDesignProject.getMetaDataUser().processMenuItems(this);
                }
            } else if (this.isJMenuSeparator()) {
                if (this.theParentObject != null && this.theParentObject.isJMenu()) {
                    this.theDesignProject.getMetaDataUser().processMenuSeparators(this);
                }
            } else if (this.theParentObject != null) {
                this.theDesignProject.getMetaDataUser().processPlacement(this);
            }
        } else if (this.iMode == 1) {
            this.theDesignProject.getMetaDataUser().processDoFrameSizeboxes(this);
        }
        this.propsLoaded = true;
        return bRetVal;
    }

    public Hashtable getPropertyHashTable(Hashtable hashtable, MetaPropertyDescriptor theProp) {
        MetaPropertyDescriptor theProperty = theProp.theFirstSubproperty;
        while (theProperty != null) {
            MetaPropertyValueEx pv = this.getPropertyValue(theProperty.sName, 0);
            if (pv != null) {
                hashtable.put(theProperty.sName, pv.getStringValue());
            }
            if (theProperty.theFirstSubproperty != null) {
                hashtable = this.getPropertyHashTable(hashtable, theProperty);
            }
            theProperty = theProperty.theNextProperty;
        }
        return hashtable;
    }

    public Hashtable getPropertyHashTable() {
        Hashtable hashtable = new Hashtable(0);
        MetaClass theWorkingClass = this.theClass;
        while (theWorkingClass != null) {
            MetaPropertyDescriptor theProperty = theWorkingClass.theMetadata.theFirstProperty;
            while (theProperty != null) {
                String sValue;
                MetaPropertyValueEx pv = this.getPropertyValue(theProperty.sName, 0);
                if (pv != null && (sValue = pv.getStringValue()) != null) {
                    hashtable.put(theProperty.sName, sValue);
                }
                if (theProperty.theFirstSubproperty != null) {
                    hashtable = this.getPropertyHashTable(hashtable, theProperty);
                }
                theProperty = theProperty.theNextProperty;
            }
            theWorkingClass = theWorkingClass.theParentClass;
        }
        return hashtable;
    }

    public Object getSwingObject() {
        return this.theFabricatedObject;
    }

    public boolean create() {
        MetaClass theMetaClass = this.theDesignProject.findClass(this.theType.theName);
        this.theType.theFactoryName = theMetaClass.theMetadata.theFactoryName;
        this.theType.theDesignProject = this.theDesignProject;
        this.theFabricatedObject = this.theType.Create(this.getName(), this);
        if (this.theFabricatedObject == null) {
            this.theDesignProject.getMetaDataUser().tellProgress("Error: " + this.theType.theName + "(" + this.theType.theFullName + ")" + "Class not found");
            return false;
        }
        try {
            Class<?> c = this.theFabricatedObject.getClass();
            Object m = null;
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                String interfaceName = interfaces[i].getName();
                if (!(interfaceName = interfaceName.substring(interfaceName.lastIndexOf(46) + 1)).equalsIgnoreCase("MetaObjectAccess")) continue;
                try {
                    Method[] methods = interfaces[i].getMethods();
                    for (int mc = 0; mc < methods.length; ++mc) {
                        Object[] args_value = new Object[]{this};
                        if (!methods[mc].getName().equals("setMetaObject")) continue;
                        Class<?>[] params = methods[mc].getParameterTypes();
                        methods[mc].invoke(this.theFabricatedObject, args_value);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.theVisualObject = null;
        this.theVisualFrame = null;
        this.theDesignProject.getMetaDataUser().doNewVisualObject(this);
        if (this.theVisualObject != null || this.theVisualFrame != null) {
            AnchoringLayoutManager theAnchoringLayoutManager;
            this.addDefaultProperties();
            this.doProperties();
            int iContainerType = this.getContainerType();
            if (this.isGroup()) {
                this.theButtonGroup = new ButtonGroup();
            }
            if (this.theFabricatedObject instanceof JFrame) {
                if (this.iMode != 1) {
                    theAnchoringLayoutManager = new AnchoringLayoutManager();
                    this.theLayoutManager = theAnchoringLayoutManager;
                    this.theVisualFrame.getContentPane().setLayout(theAnchoringLayoutManager);
                }
            } else if (this.theVisualObject instanceof Container) {
                if (iContainerType == 1) {
                    this.theVisualObject.setLayout(null);
                } else if (iContainerType != 0 && iContainerType != 4 && iContainerType != 9 && iContainerType != 8 && iContainerType != 14 && iContainerType != 12 && iContainerType != 11 && iContainerType != 6 && this.iMode != 1) {
                    theAnchoringLayoutManager = new AnchoringLayoutManager();
                    this.theLayoutManager = theAnchoringLayoutManager;
                    this.theVisualObject.setLayout(theAnchoringLayoutManager);
                }
            }
        }
        return true;
    }

    public boolean findChildObjectByNameX(String sObjectName) {
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            if (theChild.theName.equals(sObjectName)) {
                return true;
            }
            theChild = theChild.theNextObject;
        }
        return false;
    }

    public boolean isPanel() {
        int iContainerType = this.getContainerType();
        return iContainerType == 2;
    }

    public boolean isTabbedPane() {
        int iContainerType = this.getContainerType();
        return iContainerType == 4;
    }

    public boolean isJMenuBar() {
        int iContainerType = this.getContainerType();
        return iContainerType == 11;
    }

    public boolean isJMenu() {
        int iContainerType = this.getContainerType();
        return iContainerType == 12;
    }

    public boolean isJMenuItem() {
        int iContainerType = this.getContainerType();
        return iContainerType == 13;
    }

    public boolean isJMenuSeparator() {
        return this.theClass.getMetadata().getDisplayName().equalsIgnoreCase("JSeparator");
    }

    public boolean isJToolBarButton() {
        return this.theClass.getMetadata().getDisplayName().equalsIgnoreCase("JToolBarButton");
    }

    public boolean isJToolBar() {
        int iContainerType = this.getContainerType();
        return iContainerType == 14;
    }

    public boolean isHorzSplit() {
        int iContainerType = this.getContainerType();
        return iContainerType == 8;
    }

    public boolean isVertSplit() {
        int iContainerType = this.getContainerType();
        return iContainerType == 9;
    }

    public boolean isTabPage() {
        int iContainerType = this.getContainerType();
        return iContainerType == 7;
    }

    public boolean isScrollingPanel() {
        int iContainerType = this.getContainerType();
        return iContainerType == 10;
    }

    public boolean isScrollPane() {
        int iContainerType = this.getContainerType();
        return iContainerType == 1;
    }

    public boolean isGroup() {
        int iContainerType = this.getContainerType();
        return iContainerType == 6;
    }

    public boolean isFrame() {
        int iContainerType = this.getContainerType();
        return iContainerType == 3;
    }

    public boolean isAbalet() {
        int iContainerType = this.getContainerType();
        return iContainerType == 5;
    }

    public MetaObject getFirstChild() {
        return this.theFirstChild;
    }

    public MetaObject getLastChild() {
        return this.theLastChild;
    }

    public MetaObject getPreviousObject() {
        return this.thePreviousObject;
    }

    public MetaObject getNextObject() {
        return this.theNextObject;
    }

    public void DeleteObject(MetaProject theDesignProject, AbaMetaDataUser theUser) {
        if (theDesignProject != null) {
            if (this.theParentObject == null) {
                if (theDesignProject.getFirstObject().equals(this)) {
                    theDesignProject.setFirstObject(this.theNextObject);
                }
                if (this.thePreviousObject != null) {
                    this.thePreviousObject.theNextObject = this.theNextObject;
                }
                if (this.theNextObject != null) {
                    this.theNextObject.thePreviousObject = this.thePreviousObject;
                }
            } else {
                if (this.theParentObject.theFirstChild.equals(this)) {
                    this.theParentObject.theFirstChild = this.theNextObject;
                } else {
                    this.thePreviousObject.theNextObject = this.theNextObject;
                }
                if (this.theParentObject.theLastChild.equals(this)) {
                    this.theParentObject.theLastChild = this.thePreviousObject;
                } else {
                    this.theNextObject.thePreviousObject = this.thePreviousObject;
                }
            }
            this.theNextObject = null;
            this.thePreviousObject = null;
            theUser.processDeleteObject(this);
        }
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            theChild.DeleteObject(theDesignProject, theUser);
            theChild = theChild.theNextObject;
        }
        this.bIsDeleted = true;
        this.theInstanceTracker.removeObject(this);
    }

    public MetaObject Clone(MetaCloneMode theMode, MetaObject theParent, boolean bPreserveNames) {
        MetaObject theReturnValue = null;
        theReturnValue = theMode.theMode == 3 ? new MetaObject(this.theName, this.theClass.theMetadata.sClassName, this.theClass.theMetadata.sFullClassName, null, this.theDesignProject, 1, true) : new MetaObject(this.theName, this.theClass.theMetadata.sClassName, this.theClass.theMetadata.sFullClassName, null, this.theDesignProject, 1, false);
        theReturnValue.bMember = this.bMember;
        theReturnValue.bPopup = this.bPopup;
        theReturnValue.sCode = this.sCode;
        theReturnValue.iXLocation = this.iXLocation;
        theReturnValue.iYLocation = this.iYLocation;
        if (bPreserveNames) {
            theReturnValue.setName(this.getName());
        }
        while (theParent != null && theParent.getContainerType() == 0) {
            theParent = theParent.theParentObject;
        }
        if (theParent != null) {
            theParent.addObject(theReturnValue);
        }
        if (this.theFirstProperty != null) {
            MetaProperty testProperty = this.theFirstProperty;
            while (testProperty != null) {
                String sPropName = testProperty.theName;
                MetaProperty objPropertyStored = theReturnValue.getPropertyMetadata(sPropName);
                if (objPropertyStored == null) {
                    MetaProperty theNewProperty = testProperty.Clone(this);
                    theReturnValue.addProperty(theNewProperty);
                }
                testProperty = testProperty.theNextProperty;
            }
        }
        if (this.theFirstMethod != null && theMode.theMode != 2) {
            MetaMethodLinkage testMethod = this.theFirstMethod;
            theReturnValue.iMethodCount = 0;
            while (testMethod != null) {
                MetaMethodLinkage theNewMethod = testMethod.Clone();
                theReturnValue.addMethodLinkage(theNewMethod);
                testMethod = testMethod.theNextMethod;
                ++theReturnValue.iMethodCount;
            }
        }
        if (this.theFirstChild != null && theMode.theMode == 0) {
            MetaObject testChild = this.theFirstChild;
            while (testChild != null) {
                testChild.Clone(theMode, theReturnValue, bPreserveNames);
                testChild = testChild.theNextObject;
            }
        }
        return theReturnValue;
    }

    public void removeChild(MetaObject theChild) {
        if (theChild.equals(this.theFirstChild)) {
            this.theFirstChild = theChild.theNextObject;
        }
        if (theChild.equals(this.theLastChild)) {
            this.theLastChild = theChild.thePreviousObject;
        }
        if (theChild.theNextObject != null) {
            theChild.theNextObject.thePreviousObject = theChild.thePreviousObject;
        }
        if (theChild.thePreviousObject != null) {
            theChild.thePreviousObject.theNextObject = theChild.theNextObject;
        }
    }

    public void exchangeChildren(MetaObject objChild1, MetaObject objChild2) {
        this.theDesignProject.setProjectChangedState(true);
        MetaObject objChild1Prev = objChild1.thePreviousObject;
        MetaObject objChild1Next = objChild1.theNextObject;
        MetaObject objChild2Prev = objChild2.thePreviousObject;
        MetaObject objChild2Next = objChild2.theNextObject;
        MetaObject objFirst = this.theFirstChild;
        MetaObject objLast = this.theLastChild;
        if (!objChild1.equals(objChild2Prev)) {
            objChild1.thePreviousObject = objChild2Prev;
            if (objChild2Prev != null) {
                objChild2Prev.theNextObject = objChild1;
            }
        } else {
            objChild1.thePreviousObject = objChild2;
        }
        if (!objChild1.equals(objChild2Next)) {
            objChild1.theNextObject = objChild2Next;
            if (objChild2Next != null) {
                objChild2Next.thePreviousObject = objChild1;
            }
        } else {
            objChild1.theNextObject = objChild2;
        }
        if (!objChild2.equals(objChild1Prev)) {
            objChild2.thePreviousObject = objChild1Prev;
            if (objChild1Prev != null) {
                objChild1Prev.theNextObject = objChild2;
            }
        } else {
            objChild2.thePreviousObject = objChild1;
        }
        if (!objChild2.equals(objChild1Next)) {
            objChild2.theNextObject = objChild1Next;
            if (objChild1Next != null) {
                objChild1Next.thePreviousObject = objChild2;
            }
        } else {
            objChild2.theNextObject = objChild1;
        }
        if (objChild1.equals(objFirst)) {
            this.theFirstChild = objChild2;
        }
        if (objChild1.equals(objLast)) {
            this.theLastChild = objChild2;
        }
        if (objChild2.equals(objFirst)) {
            this.theFirstChild = objChild1;
        }
        if (objChild2.equals(objLast)) {
            this.theLastChild = objChild1;
        }
    }

    public void setParent(MetaObject theParentMetadata) {
        if (this.theParentObject != null) {
            this.theParentObject.removeChild(this);
        }
        this.theParentObject = theParentMetadata;
        if (theParentMetadata.theFirstChild == null) {
            theParentMetadata.theFirstChild = this;
        } else {
            theParentMetadata.theLastChild.theNextObject = this;
        }
        this.thePreviousObject = theParentMetadata.theLastChild;
        theParentMetadata.theLastChild = this;
    }

    public void addMethodLinkage(MetaMethodLinkage theNewMethod) {
        if (this.theFirstMethod == null) {
            this.theFirstMethod = theNewMethod;
        } else {
            this.theLastMethod.theNextMethod = theNewMethod;
        }
        this.theLastMethod = theNewMethod;
    }

    public void attachToProject(MetaProject theProject) {
        MetaProperty theProp = this.theFirstProperty;
        while (theProp != null) {
            theProp.attachToProject(theProject);
            theProp = theProp.theNextProperty;
        }
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            theChild.attachToProject(theProject);
            theChild = theChild.theNextObject;
        }
    }

    public void recursiveModeSet(int iNewMode) {
        this.iMode = iNewMode;
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            theChild.recursiveModeSet(iNewMode);
            theChild = theChild.theNextObject;
        }
    }

    public void addAllMethods(MetaClass objMetaClass) {
        MetaMethod objMethod = null;
        MetaClassDetail objClass = objMetaClass.getMetadata().theFirstListener;
        while (objClass != null) {
            boolean bFound = false;
            MetaMethodLinkage objTestMethod = this.theFirstMethod;
            while (objTestMethod != null) {
                if (objTestMethod.theListener.sClassName.equals(objClass.sClassName)) {
                    bFound = true;
                    break;
                }
                objTestMethod = objTestMethod.theNextMethod;
            }
            if (!bFound) {
                for (objMethod = objClass.theFirstMethod; objMethod != null; objMethod = objMethod.getNextMethod()) {
                    MetaMethod theClonedMethod = new MetaMethod(objMethod);
                    MetaMethodLinkage theNewMethod = new MetaMethodLinkage(theClonedMethod, objClass);
                    ++this.iMethodCount;
                    if (this.theFirstMethod == null) {
                        MetaMethodLinkage tmpNewMethod = theNewMethod;
                        theClonedMethod = new MetaMethod(UDF_OBJECT_CODE, "", "");
                        this.theFirstMethod = theNewMethod = new MetaMethodLinkage(theClonedMethod, objClass);
                        ++this.iMethodCount;
                        this.theFirstMethod.theNextMethod = tmpNewMethod;
                        theNewMethod = tmpNewMethod;
                    } else {
                        this.theLastMethod.theNextMethod = theNewMethod;
                    }
                    this.theLastMethod = theNewMethod;
                }
            }
            objClass = objClass.theNextClass;
        }
    }

    public MetaMethodLinkage getMethod(String sMethodName) {
        MetaMethodLinkage theMethod = this.theFirstMethod;
        while (theMethod != null) {
            if (theMethod.theMethod.getMethodName().equals(sMethodName)) {
                return theMethod;
            }
            theMethod = theMethod.theNextMethod;
        }
        return null;
    }

    public void setMethodCode(String sMethodName, String sCode) {
        MetaMethodLinkage theMethod = this.getMethod(sMethodName);
        if (theMethod != null) {
            theMethod.theMethod.setCode(sCode);
        }
    }

    public void setMethodDoc(String sMethodName, String sDoc) {
        MetaMethodLinkage theMethod = this.getMethod(sMethodName);
        if (theMethod != null) {
            theMethod.theMethod.setDoc(sDoc);
        }
    }

    public void setObjectCode(String sCode) {
        this.theObjectSource = sCode;
    }

    public void setObjectdDoc(String sDoc) {
        this.theObjectSourceDoc = sDoc;
    }

    public String getObjectCode() {
        return this.theObjectSource;
    }

    public String getObjectdDoc() {
        return this.theObjectSourceDoc;
    }

    public int getMethodCount() {
        return this.iMethodCount;
    }

    public void addAllMethods() {
        MetaClass objClass = this.theClass;
        while (objClass != null) {
            this.addAllMethods(objClass);
            objClass = objClass.theParentClass;
        }
    }

    public MetaObject getVisualContainerObject(boolean bSearchFromParent) {
        MetaObject objTest = this;
        if (bSearchFromParent) {
            objTest = this.theParentObject;
        }
        while (!(objTest == null || objTest.isFrame() || objTest.isAbalet() || objTest.isPanel() || objTest.isTabPage() || objTest.isGroup() || objTest.isHorzSplit() || objTest.isVertSplit() || objTest.isScrollingPanel() || objTest.isJMenu() || objTest.isJMenuBar() || objTest.isJMenuItem() || objTest.isJToolBar() || objTest.isTabbedPane())) {
            objTest = objTest.theParentObject;
        }
        return objTest;
    }

    public MetaObject getViewDisplayerContainer(boolean bSearchFromParent) {
        MetaObject objTest = this;
        if (bSearchFromParent) {
            objTest = this.theParentObject;
        }
        while (objTest != null && !objTest.isFrame() && !objTest.isAbalet()) {
            objTest = objTest.theParentObject;
        }
        return objTest;
    }

    public LayoutManager getLayoutManager() {
        try {
            return (LayoutManager)this.theLayoutManager;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public void setLocation(int x, int y) {
        if (x == this.iXLocation && y == this.iYLocation) {
            return;
        }
        this.iXLocation = x;
        this.iYLocation = y;
        if (this.iMode == 1) {
            this.theDesignProject.setProjectChangedState(true);
        }
        this.setPropertyValue("Location.Left", 0, 0, this.iXLocation, true);
        this.setPropertyValue("Location.Top", 0, 1, this.iYLocation, true);
        if ((this.isFrame() || this.isAbalet()) && this.iMode == 1) {
            this.iXLocation = 0;
            x = 0;
            this.iYLocation = 0;
            y = 0;
        }
        if (this.theVisualObject != null) {
            this.theVisualObject.setLocation(x, y);
        }
        if (this.theVisualFrame != null) {
            this.theVisualFrame.setLocation(x, y);
        }
    }

    public void setSize(int x, int y) {
        if (x < 0 || y < 0) {
            return;
        }
        if (this.isHorzSplit() || this.isVertSplit()) {
            return;
        }
        if (this.isTabPage() && this.theParentObject != null) {
            this.dimSize = this.theVisualObject != null && this.iMode == 1 ? this.theVisualObject.getSize() : this.theParentObject.getSize();
            x = (int)this.dimSize.getWidth();
            y = (int)this.dimSize.getHeight();
        }
        if (this.iMode == 1 && ((double)x != this.dimSize.getWidth() || (double)y != this.dimSize.getHeight())) {
            this.theDesignProject.setProjectChangedState(true);
        }
        this.setPropertyValue("Size.Width", 0, 0, x, true);
        this.setPropertyValue("Size.Height", 0, 1, y, true);
        this.dimSize = new Dimension(x, y);
        if (this.theVisualObject != null) {
            this.theVisualObject.setSize(this.dimSize);
        }
        if (this.theVisualFrame != null) {
            this.theVisualFrame.setSize(this.dimSize);
        }
        if (this.theScrollPane != null) {
            this.theScrollPane.setSize(this.dimSize);
        }
    }

    public void refresh() {
        this.setPropLoaded(false);
        this.doProperties();
        MetaObject theChild = this.theFirstChild;
        while (theChild != null) {
            theChild.refresh();
            theChild = theChild.theNextObject;
        }
    }

    public Point getLocation() {
        Object oYLocation;
        Object oXLocation;
        if ((this.isFrame() || this.isAbalet()) && this.iMode == 1) {
            this.iXLocation = 0;
            this.iYLocation = 0;
            return new Point(0, 0);
        }
        MetaPropertyValueEx pvXLocation = this.getPropertyValue("Location.Left", 0);
        MetaPropertyValueEx pvYLocation = this.getPropertyValue("Location.Top", 0);
        int iXLocation = 0;
        int iYLocation = 0;
        if (pvXLocation != null && (oXLocation = pvXLocation.getNativeValue()) instanceof Integer) {
            iXLocation = (Integer)oXLocation;
        }
        if (pvYLocation != null && (oYLocation = pvYLocation.getNativeValue()) instanceof Integer) {
            iYLocation = (Integer)oYLocation;
        }
        Point theReturnValue = new Point(iXLocation, iYLocation);
        return theReturnValue;
    }

    public Dimension getSize() {
        if (this.isTabPage()) {
            this.dimSize = this.theParentObject.getSize();
        }
        return this.dimSize;
    }

    public MetaObject getChildObjectByName(String sName) {
        MetaObject theObject = this.theFirstChild;
        while (theObject != null) {
            if (theObject.theName.equals(this.theName)) {
                return theObject;
            }
            theObject = theObject.theNextObject;
        }
        theObject = this.theFirstChild;
        while (theObject != null) {
            MetaObject theMatch = theObject.getChildObjectByName(sName);
            if (theMatch != null) {
                return theMatch;
            }
            theObject = theObject.theNextObject;
        }
        return null;
    }

    public void writeDeclarations(ProjectDocument theDocumentManager) {
        String sInstancePrefix = this.theDesignProject.getDeclVariablePrefix();
        if (sInstancePrefix == null) {
            sInstancePrefix = "";
        }
        if (!(this.isFrame() || this.isAbalet() || this.theClass.theMetadata.getSkipDecl())) {
            String sClassName = this.theClass.theMetadata.sFullClassName;
            int iLastDot = sClassName.lastIndexOf(".");
            sClassName = sClassName.substring(iLastDot + 1);
            String sDeclaration = "private " + sClassName + " " + sInstancePrefix + this.getName() + ";";
            String sAssignmentBuffer = theDocumentManager.getCodeGenerator().getAssignmentBuffer();
            String sDeclBuffer = theDocumentManager.getCodeGenerator().getDeclarationBuffer();
            sDeclBuffer = sDeclBuffer + sDeclaration;
            sDeclBuffer = sDeclBuffer + "\r\n";
            sDeclaration = sInstancePrefix + this.getName() + " = (" + sClassName + ") m_AbaRenderer.getObject(\"" + this.getName() + "\");";
            sAssignmentBuffer = sAssignmentBuffer + sDeclaration;
            sAssignmentBuffer = sAssignmentBuffer + "\r\n";
            theDocumentManager.getCodeGenerator().setAssignmentBuffer(sAssignmentBuffer);
            theDocumentManager.getCodeGenerator().setDeclarationBuffer(sDeclBuffer);
        }
        MetaObject objTest = this.theFirstChild;
        while (objTest != null) {
            objTest.writeDeclarations(theDocumentManager);
            objTest = objTest.theNextObject;
        }
    }

    public String getPostConstructionCode() {
        return this.thePostConstructionCode;
    }

    public void setPostConstructionCode(String thePostConstructionCode) {
        this.thePostConstructionCode = thePostConstructionCode;
    }

    public void setConstructorParameters(String theConstructorParameters) {
        this.theConstructorParameters = theConstructorParameters;
    }

    public String getPreConstructionCode() {
        return this.thePreConstructionCode;
    }

    public void setPreConstructionCode(String thePreConstructionCode) {
        this.thePreConstructionCode = thePreConstructionCode;
    }

    public String getConstructorParameters() {
        return this.theConstructorParameters;
    }

    public Color getBackgroundColor() {
        return this.theBackgroundColor;
    }

    public ObjectTreeViewNode getTreeNode() {
        return this.theTreeNode;
    }

    public void setTreeNode(ObjectTreeViewNode theNewNode) {
        this.theTreeNode = theNewNode;
    }

    public Font getFont() {
        return this.theFont;
    }

    public ButtonGroup getButtonGroup() {
        return this.theButtonGroup;
    }

    public boolean isWithinTabPane() {
        boolean bRetVal = false;
        if (this.isTabbedPane() || this.isTabPage()) {
            return true;
        }
        if (this.isFrame() || this.isAbalet()) {
            return false;
        }
        if (this.theParentObject == null) {
            return false;
        }
        return this.theParentObject.isWithinTabPane();
    }

    public void doEndDrag() {
    }

    public MetaObject createSplitter(int iMouse, boolean bVertical) {
        MetaClass theSplitterClass;
        String sSuffix2;
        String sSuffix1;
        int iMouseY = 0;
        int iMouseX = 0;
        if (bVertical) {
            iMouseY = iMouse;
            sSuffix1 = "_top";
            sSuffix2 = "_bottom";
            theSplitterClass = this.theClass.theMetadataDispenser.getVerticalSplitterClass();
        } else {
            sSuffix1 = "_left";
            sSuffix2 = "_right";
            iMouseX = iMouse;
            theSplitterClass = this.theClass.theMetadataDispenser.getHorizontalSplitterClass();
        }
        MetaClass theDefaultPanelClass = this.theClass.theMetadataDispenser.getDefaultPanelClass();
        if (theSplitterClass == null || theDefaultPanelClass == null) {
            return null;
        }
        MetaObject theSplitter = new MetaObject(this.getName() + "_split", theSplitterClass.getMetadata().sClassName, theSplitterClass.getMetadata().sFullClassName, this, this.theDesignProject, this.theDesignProject.iMode, true);
        this.addObject(theSplitter);
        MetaObject theFirstPanel = new MetaObject(this.getName() + sSuffix1, theDefaultPanelClass.getMetadata().sClassName, theDefaultPanelClass.getMetadata().sFullClassName, theSplitter, this.theDesignProject, this.theDesignProject.iMode, true);
        theSplitter.addObject(theFirstPanel);
        MetaObject theSecondPanel = new MetaObject(this.getName() + sSuffix2, theDefaultPanelClass.getMetadata().sClassName, theDefaultPanelClass.getMetadata().sFullClassName, theSplitter, this.theDesignProject, this.theDesignProject.iMode, true);
        theSplitter.addObject(theSecondPanel);
        theSplitter.initializeSplitPaneComponents(iMouseX, iMouseY, this.dimSize);
        theFirstPanel.initializeSplitPaneComponents(iMouseX, iMouseY, this.dimSize);
        theSecondPanel.initializeSplitPaneComponents(iMouseX, iMouseY, this.dimSize);
        this.theDesignProject.getMetaDataUser().showObject(theSplitter);
        this.theDesignProject.getMetaDataUser().showObject(theFirstPanel);
        this.theDesignProject.getMetaDataUser().showObject(theSecondPanel);
        return theSplitter;
    }

    public MetaObject createHorizontalSplitter(int iMouseX) {
        return this.createSplitter(iMouseX, false);
    }

    public MetaObject createVerticalSplitter(int iMouseY) {
        return this.createSplitter(iMouseY, true);
    }

    void initializeSplitPaneComponents(int iMouseX, int iMouseY, Dimension dimSize) {
        if (this.theClass.getMetadata().containerType.getContainerType() != 0) {
            this.setPropertyValue("ContainerType", 0, 0, new String(this.theClass.getMetadata().containerType.getContainerTypeAsString()), false);
        }
        this.setPropertyValue("Text", 0, 0, this.getName(), true);
        if (this.isPanel()) {
            this.setPropertyValue("Location.Left", 0, 0, 0, true);
            this.setPropertyValue("Location.Top", 0, 1, 0, true);
        } else {
            this.setPropertyValue("Location.Left", 0, 0, 0, false);
            this.setPropertyValue("Location.Top", 0, 1, 0, false);
            if (this.isHorzSplit()) {
                this.setPropertyValue("DividerLocation", 0, 0, iMouseX, true);
            }
            if (this.isVertSplit()) {
                this.setPropertyValue("DividerLocation", 0, 0, iMouseY, true);
            }
        }
        if (this.isPanel()) {
            this.setPropertyValue("Size.Width", 0, 0, dimSize.width, true);
            this.setPropertyValue("Size.Height", 0, 1, dimSize.height, true);
        }
        this.psText = this.getName();
        this.iMode = 1;
    }

    public Object getAdditionalData() {
        return this.theAdditionalData;
    }

    public void setAdditionalData(Object _theAdditionalData) {
        this.theAdditionalData = _theAdditionalData;
    }

    public String getPatchedClassName() {
        return this.theName;
    }

    public void setPatchedClassName(String theName) {
        this.theName = theName;
    }

    public boolean isPatched() {
        return this.bObjectPatched;
    }

    public void setPatchedStatus(boolean bFlag) {
        this.bObjectPatched = bFlag;
    }

    public boolean isCompositeComponent() {
        return this.theClass.getMetadata().bCompositeComponent;
    }

    public String getConstantValueFromSymbol(String sPropertyName, String sConstantSymbol) {
        String sConstantValue = null;
        MetaClass metaClass = this.theClass;
        MetaPropertyDescriptor theProperty = metaClass.getProperty(sPropertyName, true);
        MetaConstantGroup theConstantTable = this.theDesignProject.findConstantGroup(theProperty.getIncludeTypeConstants());
        MetaConstantGroupCollection theConstantTableGroup = null;
        if (theConstantTable != null) {
            String sMatch = theConstantTable.get(sConstantSymbol);
            if (sMatch != null) {
                sConstantValue = sMatch;
            }
        } else {
            String sMatch;
            theConstantTableGroup = this.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
            if (theConstantTableGroup != null && (sMatch = theConstantTableGroup.get(sConstantSymbol)) != null) {
                sConstantValue = sMatch;
            }
        }
        return sConstantValue;
    }

    public boolean isPropLoaded() {
        return this.propsLoaded;
    }

    public void setPropLoaded(boolean bFlag) {
        this.propsLoaded = bFlag;
    }
}

