/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerClassCustomLoader;
import ch.abacus.lib.ui.renderer.common.HammerClassLoader;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.MetaArgumentList;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaParameter;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import electric.xml.Element;
import electric.xml.Elements;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;

public class MetaType {
    public String theName = "";
    public String theFullName = null;
    public String theFactoryName = null;
    public MetaParameter theFirstParameter = null;
    public MetaParameter theLastParameter = null;
    public int iParameterCount = 0;
    public MetaProject theDesignProject = null;
    private static HashMap HashPropList;

    public MetaType(MetaProject theDesignProject) {
        this.theName = "None";
        this.theDesignProject = theDesignProject;
    }

    public MetaType(String theName, MetaProject theDesignProject) {
        this.theName = theName;
        this.theDesignProject = theDesignProject;
    }

    public MetaType(String theName, String theFullName, MetaProject theDesignProject) {
        this.theName = theName;
        this.theFullName = theFullName;
        this.theDesignProject = theDesignProject;
    }

    public MetaType(String theName, String theFullName, String theFactoryName, MetaProject theDesignProject) {
        this.theName = theName;
        this.theFullName = theFullName;
        this.theFactoryName = theFactoryName;
        this.theDesignProject = theDesignProject;
    }

    public void addParameter(MetaParameter theMetaParameter) {
        if (this.theFirstParameter == null) {
            this.theFirstParameter = theMetaParameter;
        } else {
            theMetaParameter.thePreviousParameter = this.theLastParameter;
            this.theLastParameter.theNextParameter = theMetaParameter;
        }
        ++this.iParameterCount;
        this.theLastParameter = theMetaParameter;
    }

    public boolean save(Element theParent) {
        Element xmlType = new Element("Type");
        theParent.addElement(xmlType);
        Element xmlName = new Element("Name");
        xmlName.setText(this.theName);
        xmlType.addElement(xmlName);
        Element xmlFullName = new Element("FullName");
        xmlFullName.setText(this.theFullName);
        xmlType.addElement(xmlFullName);
        Element xmlFactoryName = new Element("FactoryName");
        xmlFactoryName.setText(this.theFactoryName);
        xmlType.addElement(xmlFactoryName);
        MetaParameter theParameter = this.theFirstParameter;
        while (theParameter != null) {
            theParameter.save(xmlType);
            theParameter = theParameter.theNextParameter;
        }
        return true;
    }

    public boolean load(Element theElement) {
        Element xmlName = theElement.getElement("Name");
        this.theName = xmlName.getTextString();
        Element xmlFullName = theElement.getElement("FullName");
        this.theFullName = xmlFullName.getTextString();
        Element xmlFactoryName = theElement.getElement("FactoryName");
        this.theFactoryName = xmlFactoryName.getTextString();
        Elements xmlParameters = theElement.getElements("Parameter");
        Element xmlParameter = xmlParameters.next();
        int i = 0;
        while (xmlParameter != null) {
            MetaParameter theMetaParameter = new MetaParameter();
            theMetaParameter.theDesignProject = this.theDesignProject;
            theMetaParameter.load(xmlParameter, i++);
            this.addParameter(theMetaParameter);
            xmlParameter = xmlParameters.next();
        }
        return true;
    }

    public MetaType Clone() {
        MetaType theReturnValue = new MetaType(this.theName, this.theFullName, this.theFactoryName, this.theDesignProject);
        MetaParameter theParam = this.theFirstParameter;
        while (theParam != null) {
            MetaParameter theNewParam = theParam.Clone();
            theReturnValue.addParameter(theNewParam);
            theParam = theParam.theNextParameter;
        }
        return theReturnValue;
    }

    public void attachToProject(MetaProject theProj) {
        this.theDesignProject = theProj;
        MetaParameter theParam = this.theFirstParameter;
        while (theParam != null) {
            theParam.attachToProject(theProj);
            theParam = theParam.theNextParameter;
        }
    }

    public Object Create(String theIdentifier, AbaMetaDataUser theCreator, Hashtable properties) {
        String sDisplayClass = null;
        if (this.theFactoryName != null && (sDisplayClass == null || sDisplayClass.indexOf("Design") == -1)) {
            Class<?> clsFactory = null;
            Object objFactory = null;
            try {
                HammerClassLoader clsLoader = (HammerClassLoader)this.theDesignProject.theClassLoader;
                clsFactory = Class.forName(this.theFactoryName, true, clsLoader.theLoader);
                objFactory = clsFactory.newInstance();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            if (objFactory != null) {
                try {
                    Class[] classesFactoryConstructor = new Class[5];
                    Object[] objectsFactoryConstructor = new Object[5];
                    classesFactoryConstructor[0] = Class.forName("ch.abacus.lib.util.GlobalInterface");
                    classesFactoryConstructor[1] = this.theFactoryName.getClass();
                    classesFactoryConstructor[2] = this.theFactoryName.getClass();
                    classesFactoryConstructor[3] = Boolean.TYPE;
                    classesFactoryConstructor[4] = Class.forName("java.util.Hashtable");
                    objectsFactoryConstructor[0] = this.theDesignProject.theGlobalInterface;
                    objectsFactoryConstructor[1] = this.theFullName;
                    objectsFactoryConstructor[2] = theIdentifier;
                    objectsFactoryConstructor[3] = this.theDesignProject.iMode == 1 ? new Boolean(true) : new Boolean(this.theDesignProject.getMetaDataUser().getAttachedToDesigner());
                    objectsFactoryConstructor[4] = properties;
                    Method methodFactoryConstructor = clsFactory.getMethod("createComponent", classesFactoryConstructor);
                    return methodFactoryConstructor.invoke(objFactory, objectsFactoryConstructor);
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        } else {
            Object[] objects;
            Class[] classes;
            Class<?> cls = null;
            try {
                cls = Class.forName(this.theFullName);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
            if (this.theName.equals("JAFrame")) {
                classes = new Class[1];
                objects = new Object[1];
                classes[0] = Boolean.TYPE;
                objects[0] = Boolean.FALSE;
            } else {
                classes = new Class[]{};
                objects = new Object[]{};
            }
            try {
                Constructor<?> theConstructor = cls.getConstructor(classes);
                return theConstructor.newInstance(objects);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }

    public Object Create(String theIdentifier, MetaObject theCreator) {
        if (HashPropList == null) {
            HashPropList = new HashMap();
        }
        String sDisplayClass = null;
        if (theCreator != null && theCreator.iMode == 1) {
            sDisplayClass = theCreator.theClass.theMetadata.sDisplayClass;
        }
        HammerClassCustomLoader theLoader = this.theDesignProject.getMetaDataUser().getClassLoader().getLoader();
        if (this.theFactoryName != null && (sDisplayClass == null || sDisplayClass.indexOf("Design") == -1)) {
            MetaParameter theParameter = this.theFirstParameter;
            Class[] classes = new Class[this.iParameterCount];
            Object[] objects = new Object[this.iParameterCount];
            while (theParameter != null) {
                try {
                    classes[theParameter.theOrder] = theParameter.theComplexType != null ? Class.forName(theParameter.theComplexType.theFullName) : Class.forName(theParameter.theSimpleType);
                }
                catch (ClassNotFoundException e2) {
                    return null;
                }
                if (theParameter.theComplexType != null) {
                    objects[theParameter.theOrder] = theParameter.theComplexType.Create(null, null);
                } else {
                    int iType = theParameter.theValue.iType;
                    classes[theParameter.theOrder] = MetaPropertyValueEx.getTypeAsClass(iType);
                    Object oValue = theParameter.theValue.getNativeValue();
                    Object theResolvedValue = null;
                    try {
                        theResolvedValue = MetaConstantGroup.resolve(oValue, theCreator.theDesignProject.getMetadataDispenser(), theLoader);
                    }
                    catch (HammerException e) {
                        if (this.theDesignProject.getMetaDataUser().getLogFile() != null) {
                            this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot create constant " + oValue);
                        }
                        return null;
                    }
                    if (theResolvedValue instanceof String) {
                        theResolvedValue = theCreator.theDesignProject.getNLS().getTranslatedValue((String)theResolvedValue, theCreator.theDesignProject.theCurrentLanguage.theLanguage, theParameter.theValue.bMnemonic);
                    }
                    if (classes[theParameter.theOrder] == Character.TYPE && theResolvedValue instanceof String) {
                        theResolvedValue = new Character(((String)theResolvedValue).charAt(0));
                    }
                    objects[theParameter.theOrder] = theResolvedValue;
                }
                theParameter = theParameter.theNextParameter;
            }
            Class<?> clsFactory = null;
            Object objFactory = null;
            try {
                HammerClassLoader clsLoader = (HammerClassLoader)theCreator.theDesignProject.theClassLoader;
                clsFactory = Class.forName(this.theFactoryName, true, clsLoader.theLoader);
                objFactory = clsFactory.newInstance();
            }
            catch (Exception e3) {
                if (this.theDesignProject.getMetaDataUser().getLogFile() != null) {
                    this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot find Factory class " + this.theFactoryName);
                }
                return null;
            }
            if (objFactory != null) {
                try {
                    Class[] classesFactoryConstructor = new Class[5];
                    Object[] objectsFactoryConstructor = new Object[5];
                    classesFactoryConstructor[0] = Class.forName("ch.abacus.lib.util.GlobalInterface");
                    classesFactoryConstructor[1] = this.theFactoryName.getClass();
                    classesFactoryConstructor[2] = this.theFactoryName.getClass();
                    classesFactoryConstructor[3] = Boolean.TYPE;
                    classesFactoryConstructor[4] = Class.forName("java.util.Hashtable");
                    objectsFactoryConstructor[0] = theCreator.theDesignProject.theGlobalInterface;
                    objectsFactoryConstructor[1] = this.theFullName;
                    objectsFactoryConstructor[2] = theIdentifier;
                    objectsFactoryConstructor[3] = theCreator.theDesignProject.iMode == 1 ? new Boolean(true) : new Boolean(theCreator.theDesignProject.getMetaDataUser().getAttachedToDesigner());
                    if (HashPropList.get(this.theFullName) == null) {
                        objectsFactoryConstructor[4] = theCreator.getPropertyHashTable();
                        HashPropList.put(this.theFullName, objectsFactoryConstructor[4]);
                    } else {
                        objectsFactoryConstructor[4] = HashPropList.get(this.theFullName);
                    }
                    Method methodFactoryConstructor = clsFactory.getMethod("createComponent", classesFactoryConstructor);
                    return methodFactoryConstructor.invoke(objFactory, objectsFactoryConstructor);
                }
                catch (Exception e4) {
                    if (this.theDesignProject.getMetaDataUser().getLogFile() != null) {
                        this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot invoke Factory class " + this.theFactoryName);
                    }
                    return null;
                }
            }
        } else {
            Object[] objects;
            Class[] classes;
            String invokingClassName;
            Class<?> cls;
            block38: {
                cls = null;
                invokingClassName = null;
                try {
                    if (theCreator != null && theCreator.iMode == 1) {
                        invokingClassName = theCreator.theClass.theMetadata.sDisplayClass;
                        cls = Class.forName(theCreator.theClass.theMetadata.sDisplayClass);
                        break block38;
                    }
                    invokingClassName = this.theFullName;
                    int iType = 0;
                    if (this.theFullName != null) {
                        iType = MetaPropertyValueEx.translateType(this.theFullName);
                    }
                    if (iType == 0 && this.theFullName != null) {
                        cls = Class.forName(this.theFullName);
                        break block38;
                    }
                    MetaArgumentList theArguments = new MetaArgumentList(this.iParameterCount);
                    MetaParameter theParameter = this.theFirstParameter;
                    int i = 0;
                    while (theParameter != null) {
                        theArguments.setArgument(i++, theParameter);
                        theParameter = theParameter.theNextParameter;
                    }
                    return theArguments;
                }
                catch (ClassNotFoundException e1) {
                    if (this.theDesignProject.getMetaDataUser().getLogFile() != null) {
                        this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Cannot find Display class " + invokingClassName);
                    }
                    return null;
                }
            }
            MetaParameter theParameter = this.theFirstParameter;
            if (invokingClassName.endsWith("JAFrame")) {
                classes = new Class[1];
                objects = new Object[1];
                classes[0] = Boolean.TYPE;
                objects[0] = Boolean.FALSE;
            } else {
                classes = new Class[this.iParameterCount];
                objects = new Object[this.iParameterCount];
            }
            while (theParameter != null) {
                try {
                    int iType;
                    classes[theParameter.theOrder] = theParameter.theComplexType != null ? Class.forName(theParameter.theComplexType.theFullName) : ((iType = MetaPropertyValueEx.translateType(theParameter.theSimpleType)) != 0 ? MetaPropertyValueEx.getTypeAsClass(iType) : Class.forName(theParameter.theSimpleType));
                }
                catch (ClassNotFoundException e2) {
                    return null;
                }
                objects[theParameter.theOrder] = theParameter.theComplexType != null ? theParameter.theComplexType.Create(null, null) : theParameter.theValue.getNativeValue();
                theParameter = theParameter.theNextParameter;
            }
            try {
                Constructor<?> theConstructor = cls.getConstructor(classes);
                return theConstructor.newInstance(objects);
            }
            catch (Exception e2) {
                if (this.theDesignProject.getMetaDataUser().getLogFile() != null) {
                    this.theDesignProject.getMetaDataUser().getLogFile().doLogEntry("Create Type", "Error invoking Constructor for " + invokingClassName);
                }
                e2.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String getLiteralValue() {
        String sPrefix = "new " + this.theName + "(";
        String sSuffix = ")";
        String sInsideStuff = "";
        MetaParameter theParameter = this.theFirstParameter;
        while (theParameter != null) {
            if (sInsideStuff.length() > 0) {
                sInsideStuff = sInsideStuff + ",";
            }
            sInsideStuff = sInsideStuff + theParameter.getLiteralValue();
            theParameter = theParameter.theNextParameter;
        }
        return sPrefix + sInsideStuff + sSuffix;
    }

    public void setMnemonic() {
        MetaParameter theParameter = this.theFirstParameter;
        while (theParameter != null) {
            theParameter.setMnemonic();
            theParameter = theParameter.theNextParameter;
        }
    }

    public boolean getMnemonic() {
        MetaParameter theParameter = this.theFirstParameter;
        while (theParameter != null) {
            boolean bMnemonic = theParameter.getMnemonic();
            if (bMnemonic) {
                return true;
            }
            theParameter = theParameter.theNextParameter;
        }
        return false;
    }
}

