/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.UIFactoryException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class MetadataProvider {
    public MetaProject theDesignProject;

    public MetadataProvider(MetaProject theDesignProject) {
        this.theDesignProject = theDesignProject;
    }

    public ArrayList getDefaultPropertyValues(String sObjectClass) {
        ArrayList<String> theReturnValues = new ArrayList<String>();
        MetaClass theClass = this.theDesignProject.findClass(sObjectClass);
        while (theClass != null) {
            MetaPropertyDescriptor theProperty = theClass.theMetadata.theFirstProperty;
            while (theProperty != null) {
                String sDefaultValue = theProperty.getDefaultValue();
                String sSetMethod = theProperty.sSetName;
                String sType = theProperty.sType;
                String sClass = theProperty.sClass;
                if (sDefaultValue != null) {
                    theReturnValues.add(sDefaultValue);
                    theReturnValues.add(sSetMethod);
                    theReturnValues.add(sType);
                    theReturnValues.add(sClass);
                }
                theProperty = theProperty.theNextProperty;
            }
            theClass = theClass.theParentClass;
        }
        return theReturnValues;
    }

    public static String FindMatchingFinalFieldName(Object obj) throws IllegalAccessException {
        Class<?> c = obj.getClass();
        Modifier mod = new Modifier();
        Field[] fields = c.getFields();
        int iFieldCount = fields.length;
        for (int i = iFieldCount - 1; i >= 0; --i) {
            Object objTest;
            Field field = fields[i];
            int iModifiers = field.getModifiers();
            if (!Modifier.isFinal(iModifiers)) continue;
            if (!Modifier.isStatic(iModifiers) || !(objTest = field.get(obj)).equals(obj)) continue;
            return field.getName();
        }
        return null;
    }

    public static int GetFieldValueAsInteger(Class c, String sFieldName) throws NoSuchFieldException, IllegalAccessException, UIFactoryException {
        int value = 0;
        if (c != null) {
            Field fld = c.getField(sFieldName);
            if (fld != null) {
                value = fld.getInt(fld);
            } else {
                throw new UIFactoryException("Bad Integer Value");
            }
        }
        return value;
    }

    public static Object GetFieldValueAsObject(Object objTest, String sFieldName) throws NoSuchFieldException, IllegalAccessException {
        Field fld;
        Class<?> c = objTest.getClass();
        if (c != null && (fld = c.getField(sFieldName)) != null) {
            return fld.get(objTest);
        }
        return null;
    }

    public static Object createBogusObject(Class cls) {
        if (cls.equals(String.class)) {
            return new String("0");
        }
        if (cls.equals(Integer.TYPE)) {
            return new Integer(0);
        }
        if (cls.equals(Double.TYPE)) {
            return new Double(0.0);
        }
        if (cls.equals(Float.TYPE)) {
            return new Float(0.0);
        }
        if (cls.equals(Character.TYPE)) {
            return new Character('0');
        }
        if (cls.equals(Byte.TYPE)) {
            return new Byte(0);
        }
        if (cls.equals(Long.TYPE)) {
            return new Long(0L);
        }
        if (cls.equals(Boolean.TYPE)) {
            return Boolean.FALSE;
        }
        try {
            return cls.newInstance();
        }
        catch (Exception e1) {
            try {
                Class[] classes = new Class[]{String.class};
                Constructor constructorString = cls.getConstructor(classes);
                Object[] objects = new Object[classes.length];
                objects[0] = new String("0");
                return constructorString.newInstance(objects);
            }
            catch (Exception e2) {
                try {
                    Constructor<?>[] constructors = cls.getConstructors();
                    Class<?>[] classes = constructors[0].getParameterTypes();
                    Object[] objects = new Object[classes.length];
                    for (int i = 0; i < classes.length; ++i) {
                        objects[i] = MetadataProvider.createBogusObject(classes[i]);
                    }
                    return constructors[0].newInstance(objects);
                }
                catch (Exception e3) {
                    return null;
                }
            }
        }
    }

    public static Object GetFieldValueAsObject(String sClassName, String sFieldName) throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Class<?> c = Class.forName(sClassName);
        Object objTest = MetadataProvider.createBogusObject(c);
        if (c != null) {
            Field fld = c.getField(sFieldName);
            return fld.get(objTest);
        }
        return null;
    }

    public static boolean IsSimpleClass(Class theClass) {
        try {
            Class[] classes = new Class[]{Class.forName("java.lang.String")};
            theClass.getConstructor(classes);
            return true;
        }
        catch (Exception e1) {
            return false;
        }
    }
}

