/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.CompressedProjectDocument;
import ch.abacus.lib.ui.renderer.common.FileCopy;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerJarAccess;
import ch.abacus.lib.ui.renderer.common.HammerJarFileEx;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProjectHeader;
import ch.abacus.lib.ui.renderer.common.generator.AbacusCodeGenerator;
import ch.abacus.lib.ui.renderer.common.generator.DropletCodeGenerator;
import ch.abacus.lib.ui.renderer.common.generator.ProjectCodeGenerator;
import ch.abacus.lib.ui.renderer.programmableCompiler.CompilationException;
import ch.abacus.lib.ui.renderer.programmableCompiler.ProgrammableCompiler;
import electric.xml.Document;
import electric.xml.Element;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;

public class ProjectDocument {
    private SuperDesignCockpit theCockpit;
    public String sOutputDocumentName = "";
    MetaProject theDesignProject = null;
    private boolean bOpenSource = false;
    private FileOutputStream fostream = null;
    private JarOutputStream jarOutputStream = null;
    private ProjectCodeGenerator theCodeGenerator;

    public ProjectDocument(SuperDesignCockpit theCockpit, String theDocumentName, MetaProject theDesignProject) {
        this.theCockpit = theCockpit;
        boolean bDroplets = theDesignProject.getMetaDataUser().getDropletsState();
        if (!bDroplets) {
            theDesignProject.setCodeGenerator(new AbacusCodeGenerator(this));
        } else {
            theDesignProject.setCodeGenerator(new DropletCodeGenerator(this));
        }
        this.bOpenSource = theDesignProject.getMetaDataUser().getOpenSourceState();
        this.sOutputDocumentName = theDocumentName;
        this.theDesignProject = theDesignProject;
        if (this.bOpenSource) {
            String sFileSeparator = System.getProperty("file.separator");
            int iMatchSlash = this.sOutputDocumentName.lastIndexOf(sFileSeparator);
            if (iMatchSlash != -1) {
                this.sOutputDocumentName = this.sOutputDocumentName.substring(iMatchSlash + sFileSeparator.length());
            }
            this.sOutputDocumentName = theDesignProject.theProgramData.sWorkspace + sFileSeparator + this.sOutputDocumentName;
        }
    }

    public boolean isOpenSource() {
        return this.bOpenSource;
    }

    public boolean save(MetaProjectHeader theProgInfo, boolean bCompileClass) throws HammerException, IOException {
        if (!this.theCockpit.isCustomizing()) {
            this.theDesignProject.getCodeGenerator().reset();
            this.writeDecl();
        }
        if (this.theDesignProject.getInputType() == 2) {
            return this.saveToFile(theProgInfo, this.bOpenSource, bCompileClass);
        }
        return this.saveToFile(theProgInfo, false, bCompileClass);
    }

    public boolean writeDecl() {
        PrintWriter pwOutput = null;
        File fileOutput = new File(this.sOutputDocumentName + ".decl");
        try {
            pwOutput = new PrintWriter(new FileWriter(fileOutput));
        }
        catch (IOException e) {
            return false;
        }
        this.theDesignProject.writeDeclarations(this);
        pwOutput.println("// This file contains declarations of the user interface objects in project " + this.sOutputDocumentName);
        pwOutput.println();
        pwOutput.println("// Declarations of variables for this user interface.");
        pwOutput.println();
        pwOutput.println(this.getDeclarations());
        pwOutput.println();
        pwOutput.println("// Assignments for this user interface");
        pwOutput.println();
        pwOutput.println("public void getReferences(){");
        pwOutput.print(this.getReferences());
        pwOutput.println("}");
        pwOutput.println();
        pwOutput.println("// Using the renderer");
        pwOutput.println();
        pwOutput.println("// Step 1: Declare a variable 'm_abaRenderer' that is a reference to the AbaRenderer");
        pwOutput.println("// For example:  AbaRenderer m_AbaRenderer = new AbaRenderer(sDocumentName, false, theGlobalInterfaceObject);");
        pwOutput.println("// ");
        pwOutput.println("//               First parameter is name of the project document. ");
        pwOutput.println("//               Second parameter is false (unless rendering inside design cockpit. ");
        pwOutput.println("//               Third parameter is the global interface (if NULL, second parameter must be true");
        pwOutput.println("// ");
        pwOutput.println("// Step 2: Load the project.");
        pwOutput.println("// ");
        pwOutput.println("//               boolean bTestLoad = m_AbaRenderer.load();");
        pwOutput.println("// ");
        pwOutput.println("// Step 3: You can set the language of the renderer like this:");
        pwOutput.println("// ");
        pwOutput.println("//               m_AbaRenderer.setLanguage(HammerLanguagePresentation.DEUTSCH);");
        pwOutput.println("// ");
        pwOutput.println("// Step 4: Render the interface.");
        pwOutput.println("// ");
        pwOutput.println("//               m_AbaRenderer.renderInterface();");
        pwOutput.println();
        pwOutput.close();
        return true;
    }

    private String getDeclarations() {
        return this.getCodeGenerator().getDeclarationBuffer();
    }

    private String getReferences() {
        return this.getCodeGenerator().getAssignmentBuffer();
    }

    void createNewJar(String sNewJarName) throws HammerException {
        File newJarFile = null;
        Object newJar = null;
        try {
            newJarFile = new File(sNewJarName + ".jar");
            if (newJarFile.exists()) {
                newJarFile.delete();
            }
            newJarFile.createNewFile();
        }
        catch (IOException e0) {
            System.err.println("Cannot create jar file " + sNewJarName + ".tmp" + ".jar");
        }
        try {
            this.fostream = new FileOutputStream(newJarFile);
            try {
                this.jarOutputStream = new JarOutputStream(this.fostream);
            }
            catch (IOException e1) {
                System.err.println("Cannot create output stream for jar file " + sNewJarName + " " + e1);
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    private void closeNewJarStream() {
        try {
            this.jarOutputStream.finish();
            this.jarOutputStream.close();
            this.fostream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean storeResultInJar() throws HammerException {
        HammerJarAccess theJarAccess = this.theDesignProject.theJarAccess;
        if (theJarAccess != null) {
            JarEntry entry = theJarAccess.theJarEntry;
            JarFile jarf = theJarAccess.theJarFile;
            HammerJarFileEx jarEx = new HammerJarFileEx(jarf);
            jarEx.load();
            jarEx.createJarEntry(entry.getName());
            File fileInput = new File(this.sOutputDocumentName + ".temp");
            FileInputStream in = null;
            try {
                in = new FileInputStream(fileInput);
            }
            catch (FileNotFoundException e) {
                return false;
            }
            BufferedInputStream inStr = new BufferedInputStream(in);
            try {
                int b;
                while ((b = inStr.read()) != -1) {
                    jarEx.write(b);
                }
                in.close();
            }
            catch (IOException e) {
                return false;
            }
            boolean bTest = jarEx.save();
            if (!bTest) {
                throw new HammerException(HammerException.CANNOT_SAVE_TO_OPEN_JAR, "Cannot Save. Access to jar file " + this.sOutputDocumentName + " is not exclusive.");
            }
            jarEx.finishJarSave();
        }
        return true;
    }

    public String convertUTF8(String sConvertMe) throws HammerException {
        ByteArrayOutputStream bytes = null;
        try {
            bytes = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bytes);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, "UTF8");
            writer.write(sConvertMe);
        }
        catch (IOException e) {
            throw new HammerException(HammerException.BAD_UTF8_CONVERSION, "Cannot convert output to UTF8 Bytes");
        }
        return bytes.toString();
    }

    public boolean saveToMainFile(MetaProjectHeader theProgInfo, boolean bJar, boolean bCompileClass) throws HammerException {
        File fDelete;
        String sFileSeparator;
        int iMatchSlash;
        boolean bRetVal = true;
        ByteArrayOutputStream outputProject = new ByteArrayOutputStream();
        Document theDocument = new Document();
        Element theRootElement = new Element("Metadata");
        theDocument.setRoot(theRootElement);
        boolean bNova = this.theDesignProject.getMetaDataUser().getNovaState();
        String jarName = this.sOutputDocumentName;
        this.theDesignProject.save(theProgInfo, theRootElement);
        byte[] bytes = null;
        String sOutput = null;
        if (bNova) {
            try {
                theDocument.write((OutputStream)outputProject);
                bytes = outputProject.toByteArray();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (bytes == null) {
                return false;
            }
        } else {
            try {
                OutputStreamWriter os = new OutputStreamWriter(outputProject);
                theDocument.write((OutputStream)outputProject);
                sOutput = outputProject.toString();
                sOutput = ProjectDocument.stripUTFEncoding(sOutput);
            }
            catch (IOException e) {
                // empty catch block
            }
            OldProjectDocument oldDoc = new OldProjectDocument(this.sOutputDocumentName);
            if (oldDoc == null) {
                throw new HammerException(HammerException.CANNOT_CREATE_PROZ_FILE, "Unable to create old style proz file");
            }
            bRetVal = oldDoc.println(sOutput);
            if (!bRetVal) {
                return bRetVal;
            }
        }
        if (this.sOutputDocumentName.endsWith("proj") || this.bOpenSource) {
            try {
                File fileOutput = new File(this.sOutputDocumentName + (bJar ? ".temp" : ""));
                FileOutputStream os = null;
                os = new FileOutputStream(fileOutput);
                BufferedOutputStream bos = new BufferedOutputStream(os);
                if (bNova) {
                    bos.write(bytes);
                    bos.close();
                } else {
                    PrintWriter writer = new PrintWriter(bos);
                    writer.println(sOutput);
                    writer.close();
                }
                try {
                    os.close();
                    if (bJar) {
                        return this.storeResultInJar();
                    }
                    if (!this.bOpenSource) {
                        return true;
                    }
                }
                catch (FileNotFoundException e) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        if (!bNova && !this.bOpenSource) {
            return true;
        }
        String sClassName = new String();
        CompressedProjectDocument storage = null;
        String sOutputFileName = new String();
        RandomAccessFile fileOutput = null;
        sOutputFileName = this.bOpenSource ? this.sOutputDocumentName + ".proz" : (bJar ? this.sOutputDocumentName + ".temp" : this.sOutputDocumentName);
        try {
            fileOutput = new RandomAccessFile(sOutputFileName, "rw");
        }
        catch (FileNotFoundException e) {
            return false;
        }
        if (fileOutput == null) {
            return false;
        }
        storage = new CompressedProjectDocument(this.theDesignProject);
        storage.open(fileOutput);
        sClassName = this.sOutputDocumentName;
        int iMatchClass = this.sOutputDocumentName.lastIndexOf(46);
        if (iMatchClass != -1) {
            sClassName = sClassName.substring(0, iMatchClass);
        }
        if ((iMatchSlash = sClassName.lastIndexOf(sFileSeparator = System.getProperty("file.separator"))) != -1) {
            sClassName = sClassName.substring(iMatchSlash + sFileSeparator.length());
        }
        sClassName = "AbaRenderer_" + sClassName;
        String sOutputDirectoryName = null;
        if (bCompileClass) {
            sOutputDirectoryName = this.theDesignProject.theProgramData.sOutputDirectory;
            if (sOutputDirectoryName == null) {
                sOutputDirectoryName = "output";
            }
            boolean bJaninoCompile = false;
            if (!this.bOpenSource) {
                bJaninoCompile = this.theCockpit.isJaninoCompilerWanted();
            }
            if (bJaninoCompile) {
                sOutputDirectoryName = System.getProperty("user.home") + File.separator + "abacus" + File.separator + sOutputDirectoryName;
            }
            if (this.theCockpit.isCustomizing()) {
                sOutputDirectoryName = this.theCockpit.theCustomizer.getCompilerOutputDirectory();
            }
            ProgrammableCompiler pc = new ProgrammableCompiler(bJaninoCompile);
            try {
                File[] files = this.compileProject(pc, sClassName, sOutputDirectoryName);
                this.moveCompiledClasses(files, pc, sOutputDirectoryName, storage, bytes);
                pc.cleanup();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.theDesignProject.getMetaDataUser().tellProgress(throwable.getMessage());
                try {
                    pc.cleanup();
                    storage.writeProjSource(bytes);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
                bRetVal = false;
            }
        } else {
            try {
                storage.writeProjSource(bytes);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.theCockpit.isCustomizing()) {
            OutputStream os = this.theCockpit.theCustomizer.getSaveProjectOutputStream();
            boolean bClosedOk = storage.close(sOutputFileName, os);
            this.theCockpit.theCustomizer.projectSaved(bClosedOk);
            if (sOutputDirectoryName != null) {
                this.theCockpit.theCustomizer.removeFiles(sOutputDirectoryName, sClassName);
            }
            if (!bClosedOk) {
                return false;
            }
        } else if (this.bOpenSource ? !storage.close() : !storage.close(sOutputFileName)) {
            return false;
        }
        try {
            fileOutput.close();
        }
        catch (IOException e) {
            return false;
        }
        if (bJar) {
            return this.storeResultInJar();
        }
        bRetVal = true;
        if (this.bOpenSource && sOutputFileName.endsWith("proz") && (fDelete = new File(sOutputFileName)).exists()) {
            fDelete.delete();
        }
        return bRetVal;
    }

    public boolean saveToFile(MetaProjectHeader theProgInfo, boolean bJar, boolean bCompileClass) throws HammerException {
        boolean bDroplets;
        boolean bRetVal = true;
        bRetVal = this.saveToMainFile(theProgInfo, bJar, bCompileClass);
        if (bRetVal && (bDroplets = this.theDesignProject.getMetaDataUser().getDropletsState())) {
            DropletCodeGenerator theGenerator = (DropletCodeGenerator)this.theDesignProject.getCodeGenerator();
            theGenerator.doTemplateFiles(this.sOutputDocumentName);
        }
        return bRetVal;
    }

    File[] compileProject(ProgrammableCompiler pc, String sClassName, String sOutputDirectoryName) throws HammerException {
        this.theDesignProject.getCodeGenerator().reset();
        this.theDesignProject.getMetaDataUser().tellProgress("Generating source for " + sClassName);
        this.theDesignProject.getCodeGenerator().generateProjectCode(sClassName, this.theDesignProject);
        String sSource = this.theDesignProject.getCodeGenerator().getFormattedSource();
        String[] defns = new String[]{sSource};
        String sClassPath = System.getProperty("java.class.path");
        int iOtherClassPaths = this.theDesignProject.theProgramData.getAdditionalClassPathCount();
        String sPathSeparator = System.getProperty("path.separator");
        for (int iClassPath = 0; iClassPath < iOtherClassPaths; ++iClassPath) {
            sClassPath = sClassPath + sPathSeparator + this.theDesignProject.theProgramData.getAdditionalClassPath(iClassPath);
        }
        String sTransientDirectory = this.theDesignProject.theProgramData.sTransientDirectory;
        pc.setProperty("javaClassPath", sClassPath);
        if (sTransientDirectory != null) {
            pc.setProperty("tempDirNameRoot", sTransientDirectory);
        }
        File[] files = new File[]{};
        this.theDesignProject.getMetaDataUser().tellProgress("Compiling Class " + sClassName);
        try {
            files = pc.compileClassesToFiles(defns);
            this.theDesignProject.getMetaDataUser().tellProgress("Finish Compiling" + sClassName);
        }
        catch (CompilationException e) {
            throw new HammerException(HammerException.COMPILATION_ERRORS_OCCURRED, e.getMessage(), e.getLocalizedMessage());
        }
        this.theDesignProject.getMetaDataUser().tellProgress("Saving Compiled Class " + sClassName);
        return files;
    }

    boolean moveCompiledClasses(File[] files, ProgrammableCompiler pc, String sOutputDirectoryName, CompressedProjectDocument storage, byte[] bytes) {
        boolean bRetVal = true;
        int iFilesToWrite = files.length;
        String sTempDir = pc.getProperty("tempDirNameRoot");
        Object jarOutPut = null;
        if (this.bOpenSource) {
            try {
                String sNewJarFileName = this.sOutputDocumentName;
                String sFileSeparator = ".";
                Object newJarFile = null;
                int iMatchSlash = sNewJarFileName.lastIndexOf(sFileSeparator);
                if (iMatchSlash != -1) {
                    sNewJarFileName = this.sOutputDocumentName.substring(0, iMatchSlash);
                }
                try {
                    this.createNewJar(sNewJarFileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < iFilesToWrite; ++i) {
            int iMatch = files[i].getPath().indexOf(sTempDir);
            if (iMatch <= 0) continue;
            String sSeparator = files[i].getPath().substring(iMatch - 1, iMatch);
            String sFileSubName = files[i].getPath().substring(iMatch);
            iMatch = sFileSubName.indexOf(sSeparator);
            sFileSubName = sFileSubName.substring(iMatch);
            String sOldClassFileName = files[i].getPath();
            if (sOutputDirectoryName.trim().length() == 0) {
                sOutputDirectoryName = "." + sSeparator;
            }
            String sNewClassFileName = sOutputDirectoryName + sFileSubName;
            int iSuffix = sNewClassFileName.lastIndexOf(".class");
            String sNewJavaFileName = sNewClassFileName.substring(0, iSuffix) + ".java";
            iSuffix = sOldClassFileName.lastIndexOf(".class");
            String sOldJavaFileName = sOldClassFileName.substring(0, iSuffix) + ".java";
            iSuffix = sNewClassFileName.lastIndexOf(sSeparator);
            String sOutputDirectoryFullPath = sNewClassFileName.substring(0, iSuffix);
            new File(sOutputDirectoryFullPath).mkdirs();
            try {
                FileCopy.copyFile(sOldClassFileName, sNewClassFileName);
            }
            catch (IOException e) {
                return false;
            }
            try {
                FileCopy.copyFile(sOldJavaFileName, sNewJavaFileName);
            }
            catch (IOException e) {
                return false;
            }
            File oldFile = new File(sOldClassFileName);
            oldFile.delete();
            oldFile = new File(sOldJavaFileName);
            oldFile.delete();
            try {
                String defaultConfPath;
                File newFile = new File(sNewClassFileName);
                FileInputStream in = new FileInputStream(newFile);
                BufferedInputStream inStr = new BufferedInputStream(in);
                int iSize = (int)newFile.length();
                byte[] classBytes = new byte[iSize];
                inStr.read(classBytes, 0, iSize);
                String sEntryClassFileName = new String();
                if (this.bOpenSource) {
                    String sFileSeparator = System.getProperty("file.separator");
                    int iMatchSlash = sNewJavaFileName.lastIndexOf(sFileSeparator);
                    if (iMatchSlash != -1) {
                        sEntryClassFileName = sNewClassFileName.substring(iMatchSlash + sFileSeparator.length());
                    }
                    ZipEntry ze = new ZipEntry(sEntryClassFileName);
                    this.jarOutputStream.putNextEntry(ze);
                    File fileInput = new File(sNewClassFileName);
                    FileInputStream xin = null;
                    try {
                        xin = new FileInputStream(fileInput);
                    }
                    catch (FileNotFoundException e) {
                        return false;
                    }
                    BufferedInputStream xinStr = new BufferedInputStream(xin);
                    try {
                        int b;
                        while ((b = xinStr.read()) != -1) {
                            this.jarOutputStream.write(b);
                        }
                        xin.close();
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                inStr.close();
                in.close();
                storage.writeClass(classBytes);
                storage.writeProjSource(bytes);
                String repoPath = this.theCockpit.theConfigurationManager.getConfigurationVariable("RepositoryPath");
                if (repoPath != null && (defaultConfPath = this.theCockpit.thePreferences.getRepositPath()) != null) {
                    repoPath = repoPath + ";" + defaultConfPath;
                }
                if (repoPath == null) continue;
                storage.writeCustomMetadata(repoPath);
                continue;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.jarOutputStream != null && this.bOpenSource) {
            this.closeNewJarStream();
        }
        return bRetVal;
    }

    public boolean load() {
        return true;
    }

    public static String stripUTFEncoding(String s) {
        InputStreamReader reader;
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(s.getBytes());
        try {
            reader = new InputStreamReader((InputStream)bytesIn, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        try {
            int ch;
            StringBuffer buffer = new StringBuffer();
            while ((ch = reader.read()) > -1) {
                buffer.append((char)ch);
            }
            reader.close();
            s = buffer.toString();
        }
        catch (IOException e) {
            return null;
        }
        return s;
    }

    public ProjectCodeGenerator getCodeGenerator() {
        return this.theDesignProject.getCodeGenerator();
    }

    class OldProjectDocument {
        HammerJarFileEx jarEx;
        String sOutputEntryName = "";
        ByteArrayOutputStream pwByteOutput;
        GZIPOutputStream fzip;
        FileOutputStream fon = null;
        File fileXMLOutput;
        HammerJarAccess theJarAccess;
        BufferedOutputStream jar_os;

        public OldProjectDocument(String sOutputDocumentName) throws HammerException {
            if (ProjectDocument.this.theDesignProject.iInputType == 1) {
                this.fileXMLOutput = new File(sOutputDocumentName);
                if (sOutputDocumentName.endsWith("proz")) {
                    try {
                        this.fon = new FileOutputStream(this.fileXMLOutput);
                    }
                    catch (FileNotFoundException e) {
                        throw new HammerException(HammerException.CANNOT_CREATE_PROZ_FILE, "Cannot open file: " + sOutputDocumentName);
                    }
                    try {
                        this.fzip = new GZIPOutputStream(this.fon);
                    }
                    catch (IOException e) {
                        throw new HammerException(HammerException.CANNOT_CREATE_PROZ_FILE, "Cannot open gzip file: " + sOutputDocumentName);
                    }
                }
                try {
                    this.fon = new FileOutputStream(this.fileXMLOutput);
                }
                catch (IOException e) {
                    throw new HammerException(HammerException.CANNOT_CREATE_PROJ_FILE, "Cannot create proj file: " + sOutputDocumentName);
                }
            }
            this.theJarAccess = ProjectDocument.this.theDesignProject.theJarAccess;
            if (this.theJarAccess != null) {
                JarEntry entry = this.theJarAccess.theJarEntry;
                JarFile jarf = this.theJarAccess.theJarFile;
                this.jarEx = new HammerJarFileEx(jarf);
                this.jarEx.load();
                this.jarEx.removeJarEntry(entry);
                this.sOutputEntryName = entry.getName();
                this.pwByteOutput = new ByteArrayOutputStream(4096);
                this.jar_os = new BufferedOutputStream(this.pwByteOutput);
                if (sOutputDocumentName.endsWith("proz")) {
                    try {
                        this.fzip = new GZIPOutputStream(this.jar_os);
                    }
                    catch (IOException e) {
                        throw new HammerException(HammerException.CANNOT_CREATE_PROZ_FILE, "Cannot open gzip file: " + sOutputDocumentName);
                    }
                }
            }
        }

        public boolean println(String s) throws HammerException {
            try {
                OutputStreamWriter writer = null;
                if (this.fzip != null) {
                    writer = new OutputStreamWriter(this.fzip);
                } else if (this.fon != null) {
                    writer = new OutputStreamWriter(this.fon);
                }
                String sEncoding = writer.getEncoding();
                writer.write(s);
                writer.close();
                if (this.fzip != null) {
                    this.fzip.close();
                }
                if (this.fon != null) {
                    this.fon.close();
                }
                if (this.jar_os != null) {
                    this.jar_os.close();
                }
            }
            catch (IOException e1) {
                throw new HammerException(HammerException.CANNOT_SAVE_PROZ_FILE, "Error writing " + ProjectDocument.this.sOutputDocumentName);
            }
            return true;
        }
    }
}

