/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common;

import ch.abacus.lib.ui.renderer.common.ListenerDiscriminator;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaContainerType;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.UIFactoryBlueprintProperty;
import ch.abacus.lib.ui.renderer.common.UIFactoryCodeGenerator;
import ch.abacus.lib.ui.renderer.common.UIFactoryException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class UIFactoryBlueprint {
    Class cClassObjectGone = null;
    String theClassName = "";
    String sIdentifier;
    UIFactoryBlueprintProperty theFirstProperty = null;
    UIFactoryBlueprintProperty theLastProperty = null;
    String sCustomCode;
    boolean bDeclareAsMember = true;
    String sConstructorParameterList = "";
    String sPreConstructionCode = "";
    String sContainerName = "";
    String sLayoutName = "";
    boolean bActivateAsPopup = false;
    boolean bAddActionListener = false;
    boolean bAddWindowEventListener = false;
    String sActionListenerTarget = "";
    String sActionListenerClass = "";
    String sActionListenerMessage = "";
    Object objParentMeta = null;
    MetaObject theObject;
    public ArrayList theDiscriminators;

    public UIFactoryBlueprintProperty findProperty(String sPropertyName) {
        UIFactoryBlueprintProperty theProperty = this.theFirstProperty;
        while (theProperty != null) {
            if (theProperty.sPropertyName.equals(sPropertyName)) {
                return theProperty;
            }
            theProperty = theProperty.theNextProperty;
        }
        return null;
    }

    public Object getPropertyValue(String sPropertyName, int iIndex) {
        UIFactoryBlueprintProperty theProperty = this.findProperty(sPropertyName);
        if (theProperty != null) {
            return theProperty.getValue(iIndex);
        }
        return null;
    }

    public int getPropertyValueCount(String sPropertyName) {
        UIFactoryBlueprintProperty theProperty = this.findProperty(sPropertyName);
        int iCount = 0;
        if (theProperty != null) {
            iCount = theProperty.getValueCount();
        }
        return iCount;
    }

    public Integer getIntegerPropertyValue(String sPropertyName, int iIndex) {
        Object objReturned = this.getPropertyValue(sPropertyName, iIndex);
        if (objReturned instanceof Integer) {
            return (Integer)objReturned;
        }
        if (objReturned instanceof Boolean) {
            if (objReturned.equals(new Boolean(true))) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        if (objReturned instanceof String) {
            try {
                Integer retval = new Integer((String)objReturned);
                return retval;
            }
            catch (NumberFormatException e1) {
                return new Integer(0);
            }
        }
        return (Integer)objReturned;
    }

    public Boolean getBooleanPropertyValue(String sPropertyName, int iIndex) {
        Object objReturned = this.getPropertyValue(sPropertyName, iIndex);
        if (objReturned instanceof Boolean) {
            return (Boolean)objReturned;
        }
        if (objReturned instanceof String) {
            return new Boolean((String)objReturned);
        }
        return null;
    }

    public String getMultilinePropertyValue(String sPropertyName, int iIndex) {
        String sPropertyValue = (String)this.getPropertyValue(sPropertyName, iIndex);
        if (sPropertyValue != null) {
            StringReader theReader = new StringReader(sPropertyValue);
            BufferedReader theBufferedReader = new BufferedReader(theReader);
            String sReturnValue = null;
            try {
                String sThisLine;
                while ((sThisLine = theBufferedReader.readLine()) != null) {
                    if (sThisLine.length() == 0) continue;
                    if (sReturnValue != null) {
                        sReturnValue = sReturnValue + "+\"";
                        sReturnValue = sReturnValue + sThisLine;
                    } else {
                        sReturnValue = "\"" + sThisLine;
                    }
                    sReturnValue = sReturnValue + "\"";
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            if (sReturnValue == null) {
                return "";
            }
            return sReturnValue;
        }
        return "";
    }

    public UIFactoryBlueprintProperty addProperty(String sPropertyName) {
        UIFactoryBlueprintProperty theProperty = new UIFactoryBlueprintProperty(sPropertyName);
        if (this.theFirstProperty == null) {
            this.theFirstProperty = theProperty;
        } else {
            this.theLastProperty.theNextProperty = theProperty;
        }
        this.theLastProperty = theProperty;
        return theProperty;
    }

    public void setPropertyValue(String sPropertyName, int iIndex, Object oTheValue) {
        UIFactoryBlueprintProperty theProperty = this.findProperty(sPropertyName);
        if (theProperty == null) {
            theProperty = this.addProperty(sPropertyName);
        }
        if (theProperty != null) {
            int iValueCount = theProperty.getValueCount();
            if (iIndex < iValueCount) {
                theProperty.setValue(iIndex, oTheValue);
            } else if (iIndex == iValueCount) {
                theProperty.addValue(oTheValue);
            }
        }
    }

    public Object getParentMeta() {
        return this.objParentMeta;
    }

    public Boolean getActivateAsPopup() {
        return new Boolean(this.bActivateAsPopup);
    }

    public Boolean getDeclareAsMember() {
        return new Boolean(this.bDeclareAsMember);
    }

    public Boolean getAddWindowEventListener() {
        return new Boolean(this.bAddWindowEventListener);
    }

    public Boolean getAddActionListener() {
        return new Boolean(this.bAddActionListener);
    }

    public String getActionListenerTarget() {
        return this.sActionListenerTarget;
    }

    public String getActionListenerClass() {
        return this.sActionListenerClass;
    }

    public String getActionListenerMessage() {
        return this.sActionListenerMessage;
    }

    public String getContainerName() {
        return this.sContainerName;
    }

    public String getLayoutName() {
        return this.sLayoutName;
    }

    public void setParentMeta(Object theObject) {
        this.objParentMeta = theObject;
    }

    public void setActivateAsPopup(Boolean bFlag) {
        this.bActivateAsPopup = bFlag;
    }

    public void setAddWindowEventListener(Boolean bFlag) {
        this.bAddWindowEventListener = bFlag;
    }

    public void setAddActionListener(Boolean bFlag) {
        this.bAddActionListener = bFlag;
    }

    public void setDeclareAsMember(Boolean bFlag) {
        this.bDeclareAsMember = bFlag;
    }

    public void setContainerName(String sContainer) {
        this.sContainerName = sContainer;
    }

    public void setLayoutName(String sLayout) {
        this.sLayoutName = sLayout;
    }

    public void setActionListenerTarget(String sTarget) {
        this.sActionListenerTarget = sTarget;
    }

    public void setActionListenerClass(String sTargetClass) {
        this.sActionListenerClass = sTargetClass;
    }

    public void setActionListenerMessage(String sTargetMessage) {
        this.sActionListenerMessage = sTargetMessage;
    }

    public void setCustomCode(String sCode) {
        this.sCustomCode = sCode;
    }

    public void setPreConstructionCode(String sCode) {
        this.sPreConstructionCode = sCode;
    }

    public void setConstructorParameterList(String sParams) {
        this.sConstructorParameterList = sParams;
    }

    public String getConstructorParameterList() {
        return this.sConstructorParameterList;
    }

    public static String formatColorString(String sColor) {
        if (sColor == null) {
            return "";
        }
        if (sColor.trim().length() == 0) {
            return "";
        }
        if (sColor.indexOf("new") != -1) {
            return sColor;
        }
        if (sColor.indexOf("java.awt.Color") != -1) {
            int iPos1 = sColor.indexOf("r=");
            int iPos2 = sColor.indexOf(",g=");
            int iPos3 = sColor.indexOf(",b=");
            int iLength = sColor.length();
            String sRed = sColor.substring(iPos1 + 2, iPos2);
            String sGreen = sColor.substring(iPos2 + 3, iPos3);
            String sBlue = sColor.substring(iPos3 + 3, iLength - 1);
            return "new Color(" + sRed + "," + sGreen + "," + sBlue + ")";
        }
        return "Color." + sColor;
    }

    public void SwingCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        String sBackgroundColor = (String)this.getPropertyValue("Background", 0);
        String sForegroundColor = (String)this.getPropertyValue("Foreground", 0);
        String sSize = (String)this.getPropertyValue("Size", 0);
        String sLocation = (String)this.getPropertyValue("Location", 0);
        boolean bSkipDeclaration = false;
        Boolean bTest = this.getBooleanPropertyValue("NoDeclaration", 0);
        if (bTest != null) {
            bSkipDeclaration = bTest;
        }
        sBackgroundColor = UIFactoryBlueprint.formatColorString(sBackgroundColor);
        sForegroundColor = UIFactoryBlueprint.formatColorString(sForegroundColor);
        String sFont = (String)this.getPropertyValue("Font", 0);
        String sFontName = null;
        if (sFont != null && sFont.trim().length() != 0) {
            int iPos1 = sFont.indexOf("family=");
            int iPos2 = sFont.indexOf(",name");
            int iPos3 = sFont.indexOf("style=");
            int iPos4 = sFont.indexOf("size=");
            int iLength = sFont.length();
            String sFamily = sFont.substring(iPos1 + 7, iPos2);
            sFontName = sFont.substring(iPos2 + 6, iPos3 - 1);
            String sStyle = sFont.substring(iPos3 + 6, iPos4 - 1);
            String sFontSize = sFont.substring(iPos4 + 5, iLength - 1);
            String sStyleParam = "Font.PLAIN";
            if (sStyle.indexOf("bold") != -1) {
                sStyleParam = sStyle.indexOf("italic") != -1 ? "Font.BOLD + Font.ITALIC" : "Font.BOLD";
            } else if (sStyle.indexOf("italic") != -1) {
                sStyleParam = "Font.ITALIC";
            }
            sFontName = "font$$$" + sName;
            outputJava.println("Font " + sFontName + " = new Font(\"" + sFamily + "\"," + sStyleParam + "," + sFontSize + ");");
        }
        if (bSkipDeclaration) {
            if (sBackgroundColor != null && sBackgroundColor.trim().length() != 0) {
                outputJava.println("setBackground(" + sBackgroundColor + ");");
            }
            if (sForegroundColor != null && sForegroundColor.trim().length() != 0) {
                outputJava.println("setForeground(" + sForegroundColor + ");");
            }
            outputJava.println("setLocation(" + sLocation + ");");
            outputJava.println("setSize(" + sSize + ");");
        } else {
            if (sBackgroundColor != null && sBackgroundColor.trim().length() != 0) {
                outputJava.println(sName + ".setBackground(" + sBackgroundColor + ");");
            }
            if (sForegroundColor != null && sForegroundColor.trim().length() != 0) {
                outputJava.println(sName + ".setForeground(" + sForegroundColor + ");");
            }
            outputJava.println(sName + ".setLocation(" + sLocation + ");");
            outputJava.println(sName + ".setSize(" + sSize + ");");
            if (sFontName != null) {
                outputJava.println(sName + ".setFont(" + sFontName + ");");
            }
        }
    }

    public void ControlCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        this.SwingCodeGenerator(outputJava, sName);
        String sText = (String)this.getPropertyValue("Text", 0);
        if (sText != null) {
            outputJava.println(sName + ".setText(\"" + sText + "\");");
        }
    }

    public void PanelCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        String sBackgroundColor = (String)this.getPropertyValue("Background", 0);
        String sForegroundColor = (String)this.getPropertyValue("Foreground", 0);
        String sSize = (String)this.getPropertyValue("Size", 0);
        String sLocation = (String)this.getPropertyValue("Location", 0);
        boolean bSkipDeclaration = false;
        Boolean bTest = this.getBooleanPropertyValue("NoDeclaration", 0);
        if (bTest != null) {
            bSkipDeclaration = bTest;
        }
        sBackgroundColor = UIFactoryBlueprint.formatColorString(sBackgroundColor);
        sForegroundColor = UIFactoryBlueprint.formatColorString(sForegroundColor);
        if (bSkipDeclaration) {
            if (sBackgroundColor != null && sBackgroundColor.trim().length() != 0) {
                outputJava.println("setBackground(" + sBackgroundColor + ");");
            }
            if (sForegroundColor != null && sForegroundColor.trim().length() != 0) {
                outputJava.println("setForeground(" + sForegroundColor + ");");
            }
            outputJava.println("setLocation(" + sLocation + ");");
            outputJava.println("setSize(" + sSize + ");");
        } else {
            if (sBackgroundColor != null && sBackgroundColor.trim().length() != 0) {
                outputJava.println(sName + ".setBackground(" + sBackgroundColor + ");");
            }
            if (sForegroundColor != null && sForegroundColor.trim().length() != 0) {
                outputJava.println(sName + ".setForeground(" + sForegroundColor + ");");
            }
            outputJava.println(sName + ".setLocation(" + sLocation + ");");
            outputJava.println(sName + ".setSize(" + sSize + ");");
        }
    }

    public void FrameCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        boolean bSkipDeclaration = false;
        Boolean bTest = this.getBooleanPropertyValue("NoDeclaration", 0);
        if (bTest != null) {
            bSkipDeclaration = bTest;
        }
        this.SwingCodeGenerator(outputJava, sName);
        String sText = (String)this.getPropertyValue("Text", 0);
        if (sText != null) {
            if (bSkipDeclaration) {
                outputJava.println("setTitle(\"" + sText + "\");");
            } else {
                outputJava.println(sName + ".setTitle(\"" + sText + "\");");
            }
        }
    }

    public void ButtonCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        this.ControlCodeGenerator(outputJava, sName);
        String sBitmapName = (String)this.getPropertyValue("BitmapName", 0);
        if (sBitmapName != null && sBitmapName.trim().length() != 0) {
            outputJava.println("Icon icon" + sName + " = new ImageIcon(\"" + sBitmapName + "\");");
            outputJava.print(sName + ".setIcon(icon" + sName + ");");
        }
    }

    public void CheckBoxCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        this.ControlCodeGenerator(outputJava, sName);
    }

    public void ComboBoxCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        String sModelObject = (String)this.getPropertyValue("Model", 0);
        if (sModelObject != null && sModelObject.trim().length() != 0) {
            outputJava.print(sName + ".");
            outputJava.println("setModel(" + sModelObject + ");");
        } else {
            int iCount = this.getPropertyValueCount("initValues");
            for (int i = 0; i < iCount; ++i) {
                String sValue = (String)this.getPropertyValue("initValues", i);
                outputJava.print(sName + ".");
                outputJava.println("addItem(new String(\"" + sValue + "\"));");
            }
        }
        this.SwingCodeGenerator(outputJava, sName);
    }

    public void TextFieldCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        this.ControlCodeGenerator(outputJava, sName);
        Integer iColumns = this.getIntegerPropertyValue("Columns", 0);
        if (iColumns != null) {
            outputJava.println(sName + ".setColumns(" + iColumns.toString() + ");");
        }
    }

    public void ListCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        String sModelObject = (String)this.getPropertyValue("Model", 0);
        if (sModelObject != null && sModelObject.trim().length() != 0) {
            outputJava.print(sName + ".");
            outputJava.println("setModel(" + sModelObject + ");");
        } else {
            int iCount = this.getPropertyValueCount("initValues");
            outputJava.print("Object[] " + sName + "ListData = {");
            for (int i = 0; i < iCount; ++i) {
                String sValue = (String)this.getPropertyValue("initValues", i);
                if (i == iCount - 1) {
                    outputJava.println("\"" + sValue + "\"};");
                    continue;
                }
                outputJava.print("\"" + sValue + "\", ");
            }
            outputJava.print(sName + ".");
            outputJava.println("setListData(" + sName + "ListData );");
        }
        this.SwingCodeGenerator(outputJava, sName);
    }

    public void RadioButtonCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        this.ControlCodeGenerator(outputJava, sName);
    }

    public void ScrollBarCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        Integer iMax = this.getIntegerPropertyValue("Maximum", 0);
        Integer iMin = this.getIntegerPropertyValue("Minimum", 0);
        Integer iUnitInc = this.getIntegerPropertyValue("UnitIncrement", 0);
        String sOrientation = (String)this.getPropertyValue("Orientation", 0);
        this.SwingCodeGenerator(outputJava, sName);
        if (iMax != null) {
            outputJava.println(sName + ".setMaximum(" + iMax.toString() + ");");
        }
        if (iMin != null) {
            outputJava.println(sName + ".setMinimum(" + iMin.toString() + ");");
        }
        if (iUnitInc != null) {
            outputJava.println(sName + ".setUnitIncrement(" + iUnitInc.toString() + ");");
        }
        if (sOrientation != null) {
            outputJava.println(sName + ".setOrientation(" + sOrientation + ");");
        }
    }

    public void ScrollPaneCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        this.ControlCodeGenerator(outputJava, sName);
    }

    public void SliderCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        Integer iMax = this.getIntegerPropertyValue("Maximum", 0);
        Integer iMin = this.getIntegerPropertyValue("Minimum", 0);
        this.SwingCodeGenerator(outputJava, sName);
        if (iMax != null) {
            outputJava.println(sName + ".setMaximum(" + iMax.toString() + ");");
        }
        if (iMin != null) {
            outputJava.println(sName + ".setMinimum(" + iMin.toString() + ");");
        }
    }

    public void TextAreaCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        UIFactoryBlueprint theParentObject;
        this.ControlCodeGenerator(outputJava, sName);
        Integer iRows = this.getIntegerPropertyValue("Rows", 0);
        Integer iColumns = this.getIntegerPropertyValue("Columns", 0);
        if (iRows != null) {
            outputJava.println(sName + ".setRows(" + iRows.toString() + ");");
        }
        if (iColumns != null) {
            outputJava.println(sName + ".setColumns(" + iColumns.toString() + ");");
        }
        if ((theParentObject = (UIFactoryBlueprint)this.objParentMeta) != null) {
            String sContainerType = (String)theParentObject.getPropertyValue("ContainerType", 0);
            MetaContainerType theContainerType = new MetaContainerType();
            if (sContainerType != null && sContainerType.trim().length() != 0) {
                theContainerType.setContainerType(sContainerType);
                if (theContainerType.getContainerType() == 1) {
                    outputJava.println(sName + ".thePane = (JScrollPane) " + theParentObject.sIdentifier + ";");
                    outputJava.println(sName + ".fixupSize();");
                }
            }
        }
    }

    public void EntryCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        this.ControlCodeGenerator(outputJava, sName);
        String sPromptFieldList = (String)this.getPropertyValue("PromptFieldList", 0);
        String sTableName = (String)this.getPropertyValue("TableName", 0);
        String sTableEntryData = (String)this.getPropertyValue("TableEntryData", 0);
        String sTableIndex = (String)this.getPropertyValue("TableIndex", 0);
        String sEntryType = (String)this.getPropertyValue("EntryType", 0);
        String sSelectionEntryTo = (String)this.getPropertyValue("SelectionEntryTo", 0);
        String sSelectionEntryFrom = (String)this.getPropertyValue("SelectionEntryFrom", 0);
        String sEntryValue = (String)this.getPropertyValue("EntryValue", 0);
        if (sEntryType != null) {
            outputJava.println(sName + ".setEntryType(" + sEntryType + ");");
        }
        if (sTableEntryData != null) {
            outputJava.println("TableEntryData tblData_" + sName + " = new TableEntryData(" + sTableEntryData + ");");
            if (sTableName != null) {
                outputJava.println(sName + ".setModel(" + sTableName + ".createTableModel( 2, tblData_" + sName + "));");
            }
        }
        if (sEntryValue != null) {
            outputJava.println(sName + ".setEntryValue(" + sEntryValue + ");");
        }
        if (sSelectionEntryTo != null) {
            outputJava.println(sName + ".setSelectionEntryTo(" + sSelectionEntryTo + ");");
        }
        if (sSelectionEntryFrom != null) {
            outputJava.println(sName + ".setSelectionEntryFrom(" + sSelectionEntryFrom + ");");
        }
        if (sPromptFieldList != null) {
            outputJava.println(sName + ".initPrompt(" + sTableName + ", " + sTableIndex + ", " + sPromptFieldList + ");");
        }
    }

    public void TableCodeGenerator(UIFactoryCodeGenerator outputJava, String sName) throws UIFactoryException {
        String sFieldList = (String)this.getPropertyValue("FieldList", 0);
        outputJava.println(sName + ".setFieldList(" + sFieldList + ");");
        outputJava.println(sName + ".open();");
    }

    public Object getDefaultPropertyValue(String sPropertyName, ArrayList theGenerateProperties) {
        int iSize = theGenerateProperties.size();
        for (int i = 0; i < iSize; i += 5) {
            String sCompareName = (String)theGenerateProperties.get(i);
            if (!sCompareName.equals(sPropertyName)) continue;
            return theGenerateProperties.get(i + 1);
        }
        return null;
    }

    public String getSetPropertyMethod(String sPropertyName, ArrayList theGenerateProperties) {
        int iSize = theGenerateProperties.size();
        for (int i = 0; i < iSize; i += 5) {
            String sCompareName = (String)theGenerateProperties.get(i);
            if (!sCompareName.equals(sPropertyName)) continue;
            return (String)theGenerateProperties.get(i + 2);
        }
        return null;
    }

    public String getPropertyType(String sPropertyName, ArrayList theGenerateProperties) {
        int iSize = theGenerateProperties.size();
        for (int i = 0; i < iSize; i += 5) {
            String sCompareName = (String)theGenerateProperties.get(i);
            if (!sCompareName.equals(sPropertyName)) continue;
            return (String)theGenerateProperties.get(i + 3);
        }
        return null;
    }

    public String getPropertyClass(String sPropertyName, ArrayList theGenerateProperties) {
        int iSize = theGenerateProperties.size();
        for (int i = 0; i < iSize; i += 5) {
            String sCompareName = (String)theGenerateProperties.get(i);
            if (!sCompareName.equals(sPropertyName)) continue;
            return (String)theGenerateProperties.get(i + 4);
        }
        return null;
    }

    public void generateProperties(UIFactoryCodeGenerator outputJava, String sName) throws Throwable {
        boolean bSkipDeclaration = false;
        Boolean bTest = this.getBooleanPropertyValue("NoDeclaration", 0);
        if (bTest != null) {
            bSkipDeclaration = bTest;
        }
        UIFactoryBlueprintProperty theProperty = this.theFirstProperty;
        String sFullClassName = this.theClassName;
        String sClassName = sFullClassName.substring(sFullClassName.lastIndexOf(46) + 1);
        ArrayList theDefaultValues = outputJava.metadataProvider.getDefaultPropertyValues(sClassName);
        while (theProperty != null) {
            String sCompareName = theProperty.sPropertyName;
            Object objValue = theProperty.getValue(0);
            Object objDefaultValue = this.getDefaultPropertyValue(sCompareName, theDefaultValues);
            String sSetName = this.getSetPropertyMethod(sCompareName, theDefaultValues);
            String sPropTypeName = this.getPropertyType(sCompareName, theDefaultValues);
            String sPropClassName = this.getPropertyClass(sCompareName, theDefaultValues);
            if (sSetName != null) {
                if (sPropTypeName.equalsIgnoreCase("string") || sPropClassName.equalsIgnoreCase("string")) {
                    if (!objValue.equals(objDefaultValue)) {
                        if (bSkipDeclaration) {
                            outputJava.println(sSetName + "(\"" + objValue.toString() + "\");");
                        } else {
                            outputJava.println(sName + "." + sSetName + "(\"" + objValue.toString() + "\");");
                        }
                    }
                } else if (!objValue.equals(objDefaultValue)) {
                    if (bSkipDeclaration) {
                        outputJava.println(sSetName + "(" + objValue.toString() + ");");
                    } else {
                        outputJava.println(sName + "." + sSetName + "(" + objValue.toString() + ");");
                    }
                }
            }
            theProperty = theProperty.theNextProperty;
        }
    }

    public String getLayoutDeclaration() {
        String sLayoutDeclaration = "null";
        String sLayoutName = (String)this.getPropertyValue("LayoutName", 0);
        if (sLayoutName != null && sLayoutName.length() != 0) {
            sLayoutDeclaration = "new " + sLayoutName + "(";
            int iLayoutParamCount = this.getPropertyValueCount("LayoutParameter");
            for (int i = 0; i < iLayoutParamCount; ++i) {
                sLayoutDeclaration = sLayoutDeclaration + this.getPropertyValue("LayoutParameter", i);
            }
        }
        return sLayoutDeclaration;
    }

    public void generateCode(UIFactoryCodeGenerator outputJava, String sName) throws Throwable {
        String sCustomCodeGenerator;
        boolean bSkipDeclaration = false;
        boolean bFrame = false;
        boolean bAbalet = false;
        boolean bPanel = false;
        boolean bGroup = false;
        boolean bAttached = false;
        boolean bTabbedPane = false;
        boolean bTabPage = false;
        boolean bScrollPane = false;
        boolean bMenu = false;
        boolean bMenuItem = false;
        UIFactoryBlueprint theParentObject = null;
        theParentObject = this.objParentMeta instanceof UIFactoryBlueprint ? (UIFactoryBlueprint)this.objParentMeta : null;
        Boolean bTest = this.getBooleanPropertyValue("NoDeclaration", 0);
        if (bTest != null) {
            bSkipDeclaration = bTest;
        }
        if (!bSkipDeclaration) {
            outputJava.generateDeclaration(this, sName, this.sPreConstructionCode, this.bDeclareAsMember);
        }
        if ((bTest = this.getBooleanPropertyValue("Attached", 0)) != null) {
            bAttached = bTest;
        }
        bTest = this.getBooleanPropertyValue("AnchorLeft", 0);
        boolean bAnchorLeft = false;
        if (bTest != null) {
            bAnchorLeft = bTest;
        }
        bTest = this.getBooleanPropertyValue("AnchorRight", 0);
        boolean bAnchorRight = false;
        if (bTest != null) {
            bAnchorRight = bTest;
        }
        bTest = this.getBooleanPropertyValue("AnchorTop", 0);
        boolean bAnchorTop = false;
        if (bTest != null) {
            bAnchorTop = bTest;
        }
        bTest = this.getBooleanPropertyValue("AnchorBottom", 0);
        boolean bAnchorBottom = false;
        if (bTest != null) {
            bAnchorBottom = bTest;
        }
        String sContainerType = (String)this.getPropertyValue("ContainerType", 0);
        MetaContainerType theContainerType = new MetaContainerType();
        if (sContainerType != null && sContainerType.trim().length() != 0) {
            theContainerType.setContainerType(sContainerType);
        }
        if (theContainerType.getContainerType() == 3) {
            bFrame = true;
        }
        if (theContainerType.getContainerType() == 5) {
            bAbalet = true;
            bFrame = true;
        }
        if (theContainerType.getContainerType() == 2) {
            bPanel = true;
        }
        if (theContainerType.getContainerType() == 6) {
            bGroup = true;
        }
        if (theContainerType.getContainerType() == 1) {
            bScrollPane = true;
        }
        if (theContainerType.getContainerType() == 4) {
            bTabbedPane = true;
        }
        if (theContainerType.getContainerType() == 7) {
            bTabPage = true;
        }
        if (theContainerType.getContainerType() == 11) {
            bMenu = true;
        }
        if (theContainerType.getContainerType() == 12) {
            bMenuItem = true;
        }
        String sLayoutDeclaration = this.getLayoutDeclaration();
        if (bSkipDeclaration && !bAbalet) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, "getContentPane()");
            outputJava.println("//  Set the layout.");
            outputJava.print("AnchoringLayoutManager layoutManager" + sName + " = new AnchoringLayoutManager();");
            outputJava.println("getContentPane().setLayout( layoutManager" + sName + " );");
        } else if (bTabbedPane) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, sName);
            outputJava.generateBasicTabbedPaneInitialization(sName);
        } else if (bScrollPane) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, sName);
        } else if (bFrame) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, "contentPane" + sName);
            outputJava.generateBasicContainerInitialization(sName, sLayoutDeclaration);
        } else if (bPanel || bTabPage) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, sName);
            outputJava.generateBasicPanelInitialization(sName, sLayoutDeclaration);
        } else if (bMenu) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, sName);
        } else if (bMenuItem) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, sName);
        } else if (bGroup) {
            this.setPropertyValue("PanelName", 0, sName);
            this.setPropertyValue("ContentPane", 0, sName);
            outputJava.generateBasicGroupInitialization(sName, sLayoutDeclaration);
        }
        String sSettingName = (String)this.getPropertyValue("SettingName", 0);
        Boolean pbSelected = this.getBooleanPropertyValue("Selected", 0);
        if (sSettingName != null) {
            outputJava.println(sName + ".setSettingName(" + sSettingName + ");");
        }
        if (pbSelected != null) {
            outputJava.println(sName + ".setSelected(" + pbSelected.toString() + ");");
        }
        if ((sCustomCodeGenerator = outputJava.getCustomCodeGenerator(this.theClassName)) != null && (sCustomCodeGenerator = sCustomCodeGenerator.trim()).length() > 0) {
            Class[] cList = new Class[]{outputJava.getClass(), sName.getClass()};
            Object[] objArgList = new Object[]{outputJava, sName};
            Method m = this.getClass().getMethod(sCustomCodeGenerator, cList);
            if (m != null) {
                m.invoke((Object)this, objArgList);
            }
        }
        if (bAttached && theParentObject != null) {
            boolean bParentIsGroup = false;
            String sParentContainerType = (String)theParentObject.getPropertyValue("ContainerType", 0);
            MetaContainerType theParentContainerType = new MetaContainerType();
            if (sParentContainerType != null && sParentContainerType.trim().length() != 0) {
                theParentContainerType.setContainerType(sParentContainerType);
            }
            if (theParentContainerType.getContainerType() == 6) {
                bParentIsGroup = true;
            }
            if (bParentIsGroup) {
                outputJava.generateBasicControlToGroupAttachment(sName, this.sContainerName);
                if (theParentObject.objParentMeta == null) {
                    throw new UIFactoryException("Parent of group is null.  Groups cannot be top level!");
                }
                theParentObject = (UIFactoryBlueprint)theParentObject.objParentMeta;
                sParentContainerType = (String)theParentObject.getPropertyValue("ContainerType", 0);
                theParentContainerType = new MetaContainerType();
                if (sParentContainerType != null && sParentContainerType.trim().length() != 0) {
                    theParentContainerType.setContainerType(sParentContainerType);
                }
            }
            String sPanelName = (String)theParentObject.getPropertyValue("PanelName", 0);
            String sContentPane = (String)theParentObject.getPropertyValue("ContentPane", 0);
            if (theParentContainerType.getContainerType() == 1) {
                outputJava.generateBasicControlToScrollPaneAttachment(sName, sPanelName);
            } else if (theParentContainerType.getContainerType() == 4) {
                String sTabTitle;
                Integer iTabs = (Integer)theParentObject.getPropertyValue("TabsGenerated", 0);
                if (iTabs == null) {
                    iTabs = new Integer(0);
                }
                if ((sTabTitle = (String)theParentObject.getPropertyValue("TabTitle", iTabs)) == null) {
                    sTabTitle = sName;
                }
                outputJava.generateBasicControlToTabbedPaneAttachment(sName, sPanelName, sTabTitle);
                iTabs = new Integer(iTabs + 1);
                theParentObject.setPropertyValue("TabsGenerated", 0, iTabs);
            } else if (theParentContainerType.getContainerType() == 11 || theParentContainerType.getContainerType() == 12) {
                outputJava.generateBasicControlToMenuAttachment(sName, sPanelName);
            } else {
                outputJava.generateBasicControlToContentPaneAttachment(sName, sContentPane, sPanelName, bAnchorLeft, bAnchorRight, bAnchorTop, bAnchorBottom);
            }
        }
        this.generateProperties(outputJava, sName);
        if (this.sCustomCode != null) {
            outputJava.generateAdditionalCustomCode(this.sCustomCode);
        }
        if (this.theDiscriminators != null) {
            int iSize = this.theDiscriminators.size();
            for (int iListener = 0; iListener < iSize; ++iListener) {
                ListenerDiscriminator theDiscriminator = (ListenerDiscriminator)this.theDiscriminators.get(iListener);
                MetaClassDetail theListener = theDiscriminator.theClass;
                String sListenerName = theListener.sClassName;
                int bMatch = sListenerName.lastIndexOf("Adapter");
                String sAttachMethodName = "";
                sAttachMethodName = bMatch != -1 ? "add" + sListenerName.substring(0, bMatch) + "Listener" : "add" + sListenerName;
                if (bSkipDeclaration) {
                    outputJava.println(sAttachMethodName + "( new " + sName + "$$$" + sListenerName + "() );");
                    continue;
                }
                outputJava.println(sName + "." + sAttachMethodName + "( new " + sName + "$$$" + sListenerName + "() );");
            }
        }
        if (bAbalet) {
            outputJava.generateAbaletLinkage();
        }
        if (bTabbedPane) {
            outputJava.generateTabbedPaneListener();
        }
    }

    public UIFactoryBlueprint(MetaObject theObject) {
        this.sIdentifier = theObject.getName();
        this.theClassName = theObject.theClass.getMetadata().sClassName;
        this.theObject = theObject;
    }

    public String getClassName() {
        return this.theClassName;
    }
}

