/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.lib.ui.renderer.common.jdbc;

import ch.abacus.lib.ui.renderer.common.jdbc.JSSDataSource;
import com.nqadmin.swingSet.SSTextDocument;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import javax.sql.RowSet;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class JSSCheckBox
extends JCheckBox {
    private JTextField textField = null;
    private JSSCheckBoxListener checkBoxListener = new JSSCheckBoxListener();
    private JSSTextFieldListener textFieldListener = new JSSTextFieldListener();
    private int language = 0;
    public String FieldName = null;
    public RowSet rs = null;
    private SSTextDocument sstxdoc = null;
    private JSSDataSource editDataSource = null;
    private int dbFieldType = -1;
    private int CHECKED = 1;
    private int UNCHECKED = 0;
    private String DE_CHECKED = "J";
    private String DE_UNCHECKED = "N";
    private String EN_CHECKED = "Y";
    private String EN_UNCHECKED = "N";
    private String FR_CHECKED = "O";
    private String FR_UNCHECKED = "N";
    private char[][] multiLangOptions = new char[][]{{'J', 'N'}, {'Y', 'N'}, {'O', 'N'}};

    public JSSCheckBox() {
        this.textField = new JTextField();
        this.initCheckBox();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    private void initCheckBox() {
        this.textField.getDocument().addDocumentListener(this.textFieldListener);
        if (this.textField.getText().equals(String.valueOf(this.CHECKED))) {
            this.setSelected(true);
        } else {
            this.setSelected(false);
        }
        this.addChangeListener(this.checkBoxListener);
    }

    private void setRowSet() {
        if (this.rs != null && this.FieldName != null) {
            this.sstxdoc = new SSTextDocument(this.rs, this.FieldName);
            this.textField.setDocument((Document)this.sstxdoc);
            this.textField.getDocument().removeDocumentListener(this.textFieldListener);
            this.textField.getDocument().addDocumentListener(this.textFieldListener);
            try {
                int colNum = this.rs.findColumn(this.FieldName);
                ResultSetMetaData rm = this.rs.getMetaData();
                this.dbFieldType = rm.getColumnType(colNum);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setDataSource(JSSDataSource ds) {
        this.editDataSource = ds;
        this.rs = ds.getRowSet();
        this.setRowSet();
    }

    public void setFieldName(String sData) {
        this.FieldName = sData;
        this.setRowSet();
    }

    public ArrayList getFieldNames() {
        return this.editDataSource.getFieldNames();
    }

    private void setTextDataFromCheckBox(ChangeEvent changeEvent) {
        switch (this.dbFieldType) {
            case 4: {
                if (((JCheckBox)changeEvent.getSource()).isSelected()) {
                    this.textField.setText(String.valueOf(this.CHECKED));
                    break;
                }
                this.textField.setText(String.valueOf(this.UNCHECKED));
                break;
            }
            case 1: {
                if (((JCheckBox)changeEvent.getSource()).isSelected()) {
                    this.textField.setText(String.valueOf(this.multiLangOptions[this.language][0]));
                    break;
                }
                this.textField.setText(String.valueOf(this.multiLangOptions[this.language][1]));
                break;
            }
            case 16: {
                if (((JCheckBox)changeEvent.getSource()).isSelected()) {
                    this.textField.setText(String.valueOf(true));
                    break;
                }
                this.textField.setText(String.valueOf(false));
            }
        }
    }

    private void setCheckBoxFromTextData(DocumentEvent docEvent) {
        switch (this.dbFieldType) {
            case 4: {
                if (this.textField.getText().equals(String.valueOf(this.CHECKED))) {
                    this.setSelected(true);
                    break;
                }
                this.setSelected(false);
                break;
            }
            case 1: {
                char tmpChar = this.multiLangOptions[this.language][0];
                if (this.textField.getText().equals(String.valueOf(tmpChar))) {
                    this.setSelected(true);
                    break;
                }
                this.setSelected(false);
                break;
            }
            case 16: {
                if (this.textField.getText().equals("true")) {
                    this.setSelected(true);
                    break;
                }
                this.setSelected(false);
            }
        }
    }

    private class JSSCheckBoxListener
    implements ChangeListener {
        private JSSCheckBoxListener() {
        }

        public void stateChanged(ChangeEvent ce) {
            JSSCheckBox.this.textField.getDocument().removeDocumentListener(JSSCheckBox.this.textFieldListener);
            JSSCheckBox.this.setTextDataFromCheckBox(ce);
            JSSCheckBox.this.textField.getDocument().addDocumentListener(JSSCheckBox.this.textFieldListener);
        }
    }

    private class JSSTextFieldListener
    implements DocumentListener {
        private JSSTextFieldListener() {
        }

        public void changedUpdate(DocumentEvent de) {
        }

        public void insertUpdate(DocumentEvent de) {
            JSSCheckBox.this.removeChangeListener(JSSCheckBox.this.checkBoxListener);
            JSSCheckBox.this.setCheckBoxFromTextData(de);
            JSSCheckBox.this.addChangeListener(JSSCheckBox.this.checkBoxListener);
        }

        public void removeUpdate(DocumentEvent de) {
            JSSCheckBox.this.removeChangeListener(JSSCheckBox.this.checkBoxListener);
            JSSCheckBox.this.setCheckBoxFromTextData(de);
            JSSCheckBox.this.addChangeListener(JSSCheckBox.this.checkBoxListener);
        }
    }
}

