/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf.plastic;

import com.jgoodies.plaf.ExtBasicArrowButtonHandler;
import com.jgoodies.plaf.plastic.PlasticArrowButton;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public final class PlasticSpinnerUI
extends BasicSpinnerUI {
    private static final Border EMPTY_BORDER = new BorderUIResource(new EmptyBorder(0, 0, 0, 0));
    private static final ExtBasicArrowButtonHandler nextButtonHandler = new ExtBasicArrowButtonHandler("increment", true);
    private static final ExtBasicArrowButtonHandler previousButtonHandler = new ExtBasicArrowButtonHandler("decrement", false);

    public static ComponentUI createUI(JComponent b) {
        return new PlasticSpinnerUI();
    }

    protected Component createPreviousButton() {
        int width = UIManager.getInt("ScrollBar.width");
        PlasticArrowButton b = new PlasticArrowButton(5, width, true);
        b.addActionListener(previousButtonHandler);
        b.addMouseListener(previousButtonHandler);
        return b;
    }

    protected Component createNextButton() {
        int width = UIManager.getInt("ScrollBar.width");
        PlasticArrowButton b = new PlasticArrowButton(1, width, true);
        b.addActionListener(nextButtonHandler);
        b.addMouseListener(nextButtonHandler);
        return b;
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.configureEditor(editor);
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.configureEditor(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private void configureEditor(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
            defaultEditor.getTextField().setBorder(EMPTY_BORDER);
        }
    }
}

