/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.classEditor;

import ch.abacus.designcockpit.classEditor.LizardMethodComboBox;
import ch.abacus.designcockpit.classEditor.LizardMethodComboBoxModel;
import ch.abacus.designcockpit.classEditor.LizardMethodDetailViewer;
import ch.abacus.lib.ui.JAButton;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaMethod;
import ch.abacus.lib.ui.renderer.common.MetadataDispenser;
import ch.abacus.lib.ui.renderer.common.ProjectToolPanel;
import ch.abacus.lib.ui.renderer.common.ProjectToolPanelNextButtonAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LizardClassMethodViewer
extends ProjectToolPanel {
    MetaClass theMetaClass = null;
    LizardMethodComboBoxModel theMethodComboBoxModel = new LizardMethodComboBoxModel();
    LizardMethodComboBox theMethodComboBox = new LizardMethodComboBox(this.theMethodComboBoxModel, (Object)this);
    KillButtonAction theKillButtonAction = new KillButtonAction();
    JAButton theDeleteButton = new JAButton("Delete Method");
    LizardMethodDetailViewer theMethodDetailTabs;
    JAButton theSubmitButton = new JAButton("Save Method");
    ProjectToolPanelNextButtonAction theNextButtonAction = new ProjectToolPanelNextButtonAction((ProjectToolPanel)this);
    MetadataDispenser theMetadataDispenser;

    public LizardClassMethodViewer(MetaClass objMetaClass, MetadataDispenser theMetadataDispenser) {
        this.setLocation(100, 0);
        this.setSize(400, 400);
        Border loweredetched = BorderFactory.createEtchedBorder();
        TitledBorder titledDescborder = new TitledBorder(loweredetched, "Methods");
        this.setBorder(titledDescborder);
        this.theMetaClass = objMetaClass;
        this.theMethodComboBox.theMetadataDispenser = theMetadataDispenser;
        this.theMethodDetailTabs = new LizardMethodDetailViewer(this.theMetaClass, theMetadataDispenser);
        this.add((Component)new JALabel("Method Name"), 1, 1, 3, 1);
        this.add(this.theMethodComboBox, 4, 1, 3, 1);
        this.add((Component)((Object)this.theMethodDetailTabs), 1, 3, 16, 10);
        this.add((Component)this.theDeleteButton, 1, 11, 3, 1);
        this.add((Component)this.theSubmitButton, 4, 11, 3, 1);
        this.theMethodComboBox.Load(objMetaClass);
        this.theDeleteButton.addActionListener((ActionListener)new KillButtonAction());
        this.theSubmitButton.addActionListener((ActionListener)new ProjectToolPanelNextButtonAction((ProjectToolPanel)this));
    }

    public Boolean getExitingComboBox(String sText, Object objLosingFocus) {
        if (sText.trim().length() != 0) {
            MetaMethod match = this.theMetaClass.getMethod(sText, false);
            if (match == null) {
                int messageType;
                int optionType;
                String sConfirmationTitle;
                String sConfirmationText = "Do you wish to add the new method '" + sText + "'?";
                int iChoice = JOptionPane.showConfirmDialog((Component)((Object)this), sConfirmationText, sConfirmationTitle = "New Method", optionType = 0, messageType = 3);
                if (iChoice == 0) {
                    this.theMethodComboBox.appendItem(sText);
                    return new Boolean(true);
                }
                return new Boolean(false);
            }
            return new Boolean(true);
        }
        return new Boolean(true);
    }

    public void selectMethod(MetaMethod oldMethod, MetaMethod newMethod) {
        if (oldMethod != null) {
            oldMethod.setCode(this.theMethodDetailTabs.theCodeWindow.getText());
            oldMethod.setDoc(this.theMethodDetailTabs.theDocWindow.getText());
        }
        this.theMethodDetailTabs.theCodeWindow.setCode(newMethod.getCode());
        this.theMethodDetailTabs.theDocWindow.setText(newMethod.getDoc());
        this.theMethodComboBox.setSelectedItem(newMethod.getMethodName());
    }

    public void selectMethod(String sMethodName) {
        MetaMethod newMethod = this.theMetaClass.getMethod(sMethodName, false);
        this.selectMethod(null, newMethod);
    }

    public void deleteSelectedMethod() {
        String sMethodName = (String)this.theMethodComboBox.getSelectedItem();
        this.theMetaClass.getMetadata().removeMethod(sMethodName);
        this.Reset();
        this.theMethodComboBox.Reload(this.theMetaClass);
        this.theMethodComboBox.setSelectedItem("");
        this.theMethodComboBox.resetEditor();
    }

    public void SaveAndClear() {
        MetaMethod theMethod = this.theMethodComboBox.theMethod;
        if (theMethod != null) {
            theMethod.setCode(this.theMethodDetailTabs.theCodeWindow.getText());
            theMethod.setDoc(this.theMethodDetailTabs.theDocWindow.getText());
        }
        this.theMethodComboBox.theMethod = null;
        this.Reset();
        this.theMethodComboBox.Reload(this.theMetaClass);
        this.theMethodComboBox.setSelectedItem("");
        this.theMethodComboBox.resetEditor();
    }

    public void Reset() {
        this.theMethodDetailTabs.theCodeWindow.setCode("");
        this.theMethodDetailTabs.theDocWindow.setText("");
        this.theMethodComboBox.setSelectedItem("");
        this.theMethodComboBox.resetEditor();
    }

    class KillButtonAction
    implements ActionListener {
        KillButtonAction() {
        }

        public void actionPerformed(ActionEvent evt) {
            LizardClassMethodViewer.this.deleteSelectedMethod();
        }
    }
}

