/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.FileTreeNode;
import ch.abacus.designcockpit.ide.IDEImporter;
import ch.abacus.lib.ui.renderer.common.ListenerCollection;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class HierarchyBrowserUpdater
implements TreeExpansionListener,
TreeSelectionListener,
MouseListener {
    FileTreeNode root;
    JTree jtree;
    DefaultTreeModel treemodel;
    IDEImporter frame;

    public HierarchyBrowserUpdater(JTree tree, FileTreeNode node, DefaultTreeModel tmodel, IDEImporter theFrame) {
        this.root = node;
        this.jtree = tree;
        this.treemodel = tmodel;
        this.frame = theFrame;
    }

    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        FileTreeNode node = (FileTreeNode)path.getLastPathComponent();
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.frame.setEnabled(false);
        if (node.readTree()) {
            int[] childrenIdx = new int[node.getChildCount()];
            int i = 0;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode obj = e.nextElement();
                childrenIdx[i] = node.getIndex(obj);
                ++i;
            }
            this.treemodel.nodesWereInserted(node, childrenIdx);
        }
        this.frame.setEnabled(true);
        this.frame.setCursor(Cursor.getDefaultCursor());
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    static String getTypeName(Class type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    boolean isSupportedPropertyType(Class propClass) {
        return propClass != null && (propClass.equals(String.class) || propClass.equals(Border.class) || propClass.equals(Font.class) || propClass.equals(Color.class) || propClass.equals(Point.class) || propClass.equals(Long.class) || propClass.getName().equals("byte") || propClass.equals(Byte.class) || propClass.getName().equals("short") || propClass.equals(Short.class) || propClass.getName().equals("float") || propClass.equals(Float.class) || propClass.getName().equals("long") || propClass.equals(Double.class) || propClass.getName().equals("double") || propClass.equals(Integer.class) || propClass.getName().equals("int") || propClass.equals(Boolean.class) || propClass.getName().equals("boolean"));
    }

    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.jtree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        String rawClassString = nodeInfo.toString().replace(File.separatorChar, '.');
        String classFileName = null;
        if (rawClassString.startsWith(File.pathSeparator, 1)) {
            String tmp = nodeInfo.toString().replace(File.separatorChar, '.');
            classFileName = tmp.substring(3, tmp.length());
        } else {
            classFileName = nodeInfo.toString().replace(File.separatorChar, '.');
        }
        DefaultListModel model = new DefaultListModel();
        DefaultListModel eventListModel = new DefaultListModel();
        String normalizedClsName = classFileName.substring(0, classFileName.length() - 6);
        Class<?> tmpClass = null;
        try {
            tmpClass = Class.forName(normalizedClsName);
            this.fillPropertiesList(tmpClass, model);
            this.fillEventList(tmpClass, eventListModel);
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (tmpClass != null) {
            this.frame.btnImport.setEnabled(true);
        } else {
            this.frame.btnImport.setEnabled(false);
        }
        this.frame.propList.setModel(model);
        this.frame.eventList.setModel(eventListModel);
    }

    private void fillPropertiesList(Class tmpClass, DefaultListModel model) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(tmpClass);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            Class<?> propClass = pds[i].getPropertyType();
            if (!this.isSupportedPropertyType(propClass)) continue;
            String propName = pds[i].getName();
            model.addElement(propName);
        }
    }

    boolean isDefaultListener(String sListenerName) {
        ListenerCollection listenerCollection = this.frame.theDesignCockpit.theMetadataDispenser.getListenerCollection();
        int iBasicSwingListeners = listenerCollection.iListenerCount;
        for (int iListener = 0; iListener < iBasicSwingListeners; ++iListener) {
            String sName = listenerCollection.getDefaultListenerName(iListener);
            if (!sName.equalsIgnoreCase(sListenerName)) continue;
            return true;
        }
        return false;
    }

    private void fillEventList(Class tmpClass, DefaultListModel model) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(tmpClass);
        EventSetDescriptor[] eds = bi.getEventSetDescriptors();
        for (int i = 0; i < eds.length; ++i) {
            String propName = eds[i].getListenerType().getSimpleName();
            if (this.isDefaultListener(propName)) continue;
            model.addElement(propName);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int index = this.frame.propList.locationToIndex(e.getPoint());
            System.out.println("Double clicked on Item " + index);
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

