/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignProject;
import ch.abacus.designcockpit.ide.ExceptionWriter;
import ch.abacus.designcockpit.ide.IDEAboutBox;
import ch.abacus.designcockpit.ide.IDEImporter;
import ch.abacus.designcockpit.ide.IDEMultiSelectAlignmentDialog;
import ch.abacus.designcockpit.ide.IDEMultiSelectSizeDialog;
import ch.abacus.designcockpit.ide.IDEObjectColorChooser;
import ch.abacus.designcockpit.ide.IDEObjectPopupMenu;
import ch.abacus.designcockpit.ide.IDEProjectTool;
import ch.abacus.designcockpit.ide.IDESourceEditor;
import ch.abacus.designcockpit.ide.IDEWindowClosingEventHandler;
import ch.abacus.designcockpit.ide.JarContentsTreeNode;
import ch.abacus.designcockpit.ide.JarOpenFileDialog;
import ch.abacus.designcockpit.ide.ProjFileFilter;
import ch.abacus.designcockpit.ide.ProjFileView;
import ch.abacus.designcockpit.ide.SelectProjectAction;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JATextArea;
import ch.abacus.lib.ui.JATextField;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.HammerClassLoader;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;
import ch.abacus.lib.ui.renderer.common.HammerJarAccess;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaCloneMode;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProject;
import ch.abacus.lib.ui.renderer.common.MetaProjectHeader;
import ch.abacus.lib.ui.renderer.common.UIFactoryAssemblyLine;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;

public class IDEActionManager {
    private final SuperDesignCockpit theCockpit;
    private final HammerImageIconFactory theIconFactory;
    ResourceBundle theResourceBundle = null;
    private AboutAction aboutAction;
    private BackgroundColorChooserAction backgroundColorChooserAction;
    private ForegroundColorChooserAction foregroundColorChooserAction;
    private FontChooserAction fontChooserAction;
    private UndoAction undoAction;
    private NewAction newAction;
    private PasteAction pasteAction;
    private PasteSelectedObjectAction pasteSelectedObjectAction;
    private RedoAction redoAction;
    private SaveAction saveAction;
    private SaveWithCompileAction saveWithCompileAction;
    private OpenAction openAction;
    private SaveAllAction saveAllAction;
    private RunAction runAction;
    private CompileAction compileAction;
    private CutAction cutAction;
    private CopyAction copyAction;
    private DatabaseSelectionAction databaseSelectionAction;
    private ImporterAction importerAction;
    private ProjectPreferencesAction projectPreferencesAction;
    private PointModeAction pointModeAction;
    private SaveAsAction saveAsAction;
    private SaveMetadataAction saveMetadataAction;
    private CloseAction closeAction;
    private ExitAction exitAction;
    private ClassEditorAction classEditorAction;
    private DeleteAction deleteAction;
    private DuplicateObjectNamesAction duplicateObjectNamesAction;
    private LanguageChooserAction languageDeutschAction;
    private LanguageChooserAction languageFrancaisAction;
    private LanguageChooserAction languageItalianAction;
    private LanguageChooserAction languageEnglishAction;
    private MultiObjectAlignmentAction multiObjectAlignmentAction;
    private MultiObjectSizeAction multiObjectSizeAction;
    private InsertHorzSplitterAction insertHorzSplitterAction;
    private InsertVertSplitterAction insertVertSplitterAction;

    public IDEActionManager(SuperDesignCockpit theCockpit) {
        this.theCockpit = theCockpit;
        this.theIconFactory = new HammerImageIconFactory(theCockpit.theClassLoader);
        this.theResourceBundle = theCockpit.theLanguageManager.getActionsBundle();
        this.initializeActions();
    }

    private void initializeActions() {
        ActionInitializer initializer = new ActionInitializer();
        this.aboutAction = initializer.initAboutAction();
        this.undoAction = initializer.initUndoAction();
        this.pasteAction = initializer.initPasteAction();
        this.pasteSelectedObjectAction = initializer.initPasteSelectedObjectAction();
        this.redoAction = initializer.initRedoAction();
        this.saveAction = initializer.initSaveAction();
        this.cutAction = initializer.initCutAction();
        this.copyAction = initializer.initCopyAction();
        this.exitAction = initializer.initExitAction();
        this.classEditorAction = initializer.initClassEditorAction();
        this.deleteAction = initializer.initDeleteAction();
        this.languageDeutschAction = initializer.initLanguageDeutschAction();
        this.languageFrancaisAction = initializer.initLanguageFrancaisAction();
        this.languageItalianAction = initializer.initLanguageItalianAction();
        this.languageEnglishAction = initializer.initLanguageEnglishAction();
        this.multiObjectAlignmentAction = initializer.initMultiObjectAlignmentAction();
        this.multiObjectSizeAction = initializer.initMultiObjectSizeAction();
        this.insertHorzSplitterAction = initializer.initInsertHorzSplitterAction();
        this.insertVertSplitterAction = initializer.initInsertVertSplitterAction();
        this.runAction = initializer.initRunAction();
        if (!this.theCockpit.isCustomizing()) {
            this.saveWithCompileAction = initializer.initSaveWithCompileAction();
            this.duplicateObjectNamesAction = initializer.initDuplicateObjectNamesAction();
            this.newAction = initializer.initNewAction();
            this.saveAsAction = initializer.initSaveAsAction();
            this.saveMetadataAction = initializer.initSaveMetadataAction();
            this.openAction = initializer.initOpenAction();
            this.saveAllAction = initializer.initSaveAllAction();
            this.closeAction = initializer.initCloseAction();
            this.databaseSelectionAction = initializer.initDatabaseSelectionAction();
            this.pointModeAction = initializer.initPointModeAction();
            this.backgroundColorChooserAction = initializer.initBackgroundColorChooserAction();
            this.foregroundColorChooserAction = initializer.initForegroundColorChooserAction();
            this.fontChooserAction = initializer.initFontChooserAction();
            this.projectPreferencesAction = initializer.initProjectPreferencesAction();
            if (this.theCockpit.getProgramMode() == SuperDesignCockpit.JAVABUILDER) {
                this.importerAction = initializer.initImporterAction();
                this.compileAction = initializer.initCompileAction();
            }
        }
    }

    private boolean isFocusTextOriented(Component theFocus) {
        return theFocus instanceof JATextField || theFocus instanceof JATextArea || theFocus instanceof IDESourceEditor || this.theCockpit.getLastFocussedComponent() instanceof IDESourceEditor;
    }

    private Icon getIcon(String sIconName) {
        if (sIconName == null) {
            return null;
        }
        ImageIcon icon = this.theIconFactory.getHammerImageIcon(this.theCockpit.sImageDirectory + sIconName);
        return icon;
    }

    public AboutAction getAboutAction() {
        return this.aboutAction;
    }

    public BackgroundColorChooserAction getBackgroundColorChooserAction() {
        return this.backgroundColorChooserAction;
    }

    public ForegroundColorChooserAction getForegroundColorChooserAction() {
        return this.foregroundColorChooserAction;
    }

    public FontChooserAction getFontChooserAction() {
        return this.fontChooserAction;
    }

    public UndoAction getUndoAction() {
        return this.undoAction;
    }

    public NewAction getNewAction() {
        return this.newAction;
    }

    public PasteAction getPasteAction() {
        return this.pasteAction;
    }

    public PasteSelectedObjectAction getPasteSelectedObjectAction() {
        return this.pasteSelectedObjectAction;
    }

    public RedoAction getRedoAction() {
        return this.redoAction;
    }

    public SaveAction getSaveAction() {
        return this.saveAction;
    }

    public SaveAsAction getSaveAsAction() {
        return this.saveAsAction;
    }

    public SaveMetadataAction getSaveMetadataAction() {
        return this.saveMetadataAction;
    }

    public SaveWithCompileAction getSaveWithCompileAction() {
        return this.saveWithCompileAction;
    }

    public OpenAction getOpenAction() {
        return this.openAction;
    }

    public SaveAllAction getSaveAllAction() {
        return this.saveAllAction;
    }

    public RunAction getRunAction() {
        return this.runAction;
    }

    public CompileAction getCompileAction() {
        return this.compileAction;
    }

    public CutAction getCutAction() {
        return this.cutAction;
    }

    public CopyAction getCopyAction() {
        return this.copyAction;
    }

    public DatabaseSelectionAction getDatabaseSelectionAction() {
        return this.databaseSelectionAction;
    }

    public ImporterAction getImporterAction() {
        return this.importerAction;
    }

    public ProjectPreferencesAction getProjectPreferencesAction() {
        return this.projectPreferencesAction;
    }

    public PointModeAction getPointModeAction() {
        return this.pointModeAction;
    }

    public CloseAction getCloseAction() {
        return this.closeAction;
    }

    public ExitAction getExitAction() {
        return this.exitAction;
    }

    public ClassEditorAction getClassEditorAction() {
        return this.classEditorAction;
    }

    public DeleteAction getDeleteAction() {
        return this.deleteAction;
    }

    public InsertHorzSplitterAction getInsertHorzSplitterAction() {
        return this.insertHorzSplitterAction;
    }

    public InsertVertSplitterAction getInsertVertSplitterAction() {
        return this.insertVertSplitterAction;
    }

    public MultiObjectAlignmentAction getMultiObjectAlignmentAction() {
        return this.multiObjectAlignmentAction;
    }

    public MultiObjectSizeAction getMultiObjectSizeAction() {
        return this.multiObjectSizeAction;
    }

    public DuplicateObjectNamesAction getDuplicateObjectNamesAction() {
        return this.duplicateObjectNamesAction;
    }

    AbstractAction createCopySelectedObjectAction(String sLabel, SuperDesignCockpit theCockpit, int iProgramMode) {
        return new CopySelectedObjectAction(sLabel, this.getIcon("glp_copy.png"), theCockpit, iProgramMode);
    }

    public void updateUndoStatus(String sLabel, boolean bEnabled) {
        this.getUndoAction().setEnabled(bEnabled);
        this.getUndoAction().putValue("Name", sLabel);
    }

    public void updateRedoStatus(String sLabel, boolean bEnabled) {
        this.getRedoAction().setEnabled(bEnabled);
        this.getRedoAction().putValue("Name", sLabel);
    }

    public LanguageChooserAction getLanguageDeutschAction() {
        return this.languageDeutschAction;
    }

    public LanguageChooserAction getLanguageFrancaisAction() {
        return this.languageFrancaisAction;
    }

    public LanguageChooserAction getLanguageItalianAction() {
        return this.languageItalianAction;
    }

    public LanguageChooserAction getLanguageEnglishAction() {
        return this.languageEnglishAction;
    }

    class ActionDescription {
        private String theLabel;
        private char theMnemonic;
        private KeyStroke theAccelerator;
        private String theImageName;
        private String theTooltip;

        ActionDescription() {
        }

        public String getLabel() {
            return this.theLabel;
        }

        public void setLabel(String theLabel) {
            this.theLabel = theLabel;
        }

        public char getMnemonic() {
            return this.theMnemonic;
        }

        public void setMnemonic(char mnemonic) {
            this.theMnemonic = mnemonic;
        }

        public KeyStroke getAccelerator() {
            return this.theAccelerator;
        }

        public void setAccelerator(String sAccelerator) {
            this.theAccelerator = KeyStroke.getKeyStroke(sAccelerator);
        }

        public void setAccelerator(KeyStroke keyStroke) {
            this.theAccelerator = keyStroke;
        }

        public String getImageName() {
            return this.theImageName;
        }

        public void setImageName(String theImageName) {
            this.theImageName = theImageName;
        }

        public String getTooltip() {
            return this.theTooltip;
        }

        public void setTooltip(String theTooltip) {
            this.theTooltip = theTooltip;
        }

        public void overrideWithExternalResources(ResourceBundle bundle, String sKeyRoot) {
            if (bundle == null) {
                return;
            }
            try {
                this.theLabel = bundle.getString(sKeyRoot + ".label");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                String sMnemonic = bundle.getString(sKeyRoot + ".mnemonic");
                if (sMnemonic.length() > 0) {
                    this.theMnemonic = sMnemonic.charAt(0);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                String sAccelerator = bundle.getString(sKeyRoot + ".accelerator");
                if (sAccelerator.length() > 0) {
                    this.theAccelerator = KeyStroke.getKeyStroke(sAccelerator);
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                this.theTooltip = bundle.getString(sKeyRoot + ".tooltip");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
            try {
                this.theImageName = bundle.getString(sKeyRoot + ".image");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    private class ActionInitializer {
        private ActionInitializer() {
        }

        LanguageChooserAction initLanguageEnglishAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("English");
            actionDescription.setMnemonic('E');
            actionDescription.setImageName("glp_language_english.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "English");
            return new LanguageChooserAction(actionDescription, 3);
        }

        LanguageChooserAction initLanguageItalianAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Italiano");
            actionDescription.setMnemonic('I');
            actionDescription.setImageName("glp_language_italian.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Italian");
            return new LanguageChooserAction(actionDescription, 2);
        }

        LanguageChooserAction initLanguageFrancaisAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Francais");
            actionDescription.setMnemonic('F');
            actionDescription.setImageName("glp_language_french.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "French");
            return new LanguageChooserAction(actionDescription, 1);
        }

        LanguageChooserAction initLanguageDeutschAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Deutsch (Default)");
            actionDescription.setMnemonic('D');
            actionDescription.setImageName("glp_language_german.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "German");
            return new LanguageChooserAction(actionDescription, 0);
        }

        CompileAction initCompileAction() {
            String sLabel = "Compile";
            char mnemonic = 'C';
            KeyStroke keyStroke = null;
            String sImageName = "glp_compile.png";
            String sTooltip = "Compile";
            return new CompileAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        SaveMetadataAction initSaveMetadataAction() {
            String sLabel = "Save Metadata";
            char mnemonic = 'M';
            KeyStroke keyStroke = null;
            String sImageName = "glp_savemetadata.png";
            String sTooltip = null;
            return new SaveMetadataAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        SaveAsAction initSaveAsAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Save As");
            actionDescription.setMnemonic('A');
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "SaveAs");
            return new SaveAsAction(actionDescription);
        }

        DuplicateObjectNamesAction initDuplicateObjectNamesAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Detect Duplicate Object Names");
            actionDescription.setMnemonic('N');
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "DuplicateNames");
            return new DuplicateObjectNamesAction(actionDescription);
        }

        CloseAction initCloseAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Close");
            actionDescription.setMnemonic('C');
            actionDescription.setTooltip("Closes the current project");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Close");
            return new CloseAction(actionDescription);
        }

        ExitAction initExitAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Exit");
            actionDescription.setMnemonic('X');
            actionDescription.setImageName("glp_exit.png");
            actionDescription.setTooltip("Exits the program");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Exit");
            return new ExitAction(actionDescription);
        }

        ClassEditorAction initClassEditorAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Object Editor");
            actionDescription.setMnemonic('J');
            actionDescription.setImageName("glp_gear.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "ObjectEditor");
            return new ClassEditorAction(actionDescription);
        }

        DeleteAction initDeleteAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Delete");
            actionDescription.setMnemonic('D');
            actionDescription.setImageName("glp_delete.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Delete");
            return new DeleteAction(actionDescription);
        }

        InsertHorzSplitterAction initInsertHorzSplitterAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Insert Horizontal Splitter");
            actionDescription.setMnemonic('H');
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "InsertHorizontalSplitter");
            return new InsertHorzSplitterAction(actionDescription);
        }

        InsertVertSplitterAction initInsertVertSplitterAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Insert Vertical Splitter");
            actionDescription.setMnemonic('V');
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "InsertVerticalSplitter");
            return new InsertVertSplitterAction(actionDescription);
        }

        MultiObjectAlignmentAction initMultiObjectAlignmentAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Alignment");
            actionDescription.setMnemonic('A');
            actionDescription.setTooltip("Configure the alignment of the selected components");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "MultiObjectAlignment");
            return new MultiObjectAlignmentAction(actionDescription);
        }

        MultiObjectSizeAction initMultiObjectSizeAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Size");
            actionDescription.setMnemonic('S');
            actionDescription.setTooltip("Configure the sizet of the selected components");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "MultiObjectSize");
            return new MultiObjectSizeAction(actionDescription);
        }

        PointModeAction initPointModeAction() {
            String sLabel = "Select Objects";
            char mnemonic = 'S';
            KeyStroke keyStroke = null;
            String sImageName = "glp_arrow.png";
            String sTooltip = "Select";
            return new PointModeAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        ProjectPreferencesAction initProjectPreferencesAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Project Preferences");
            actionDescription.setMnemonic('P');
            actionDescription.setImageName("preferences.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "ProjectPreferences");
            return new ProjectPreferencesAction(actionDescription);
        }

        ImporterAction initImporterAction() {
            String sLabel = "Import Classes";
            char mnemonic = 'I';
            KeyStroke keyStroke = null;
            String sImageName = "import2.png";
            String sTooltip = sLabel;
            return new ImporterAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        DatabaseSelectionAction initDatabaseSelectionAction() {
            String sLabel = "Data Base";
            char mnemonic = 'D';
            KeyStroke keyStroke = null;
            String sImageName = "glp_dbselect.png";
            String sTooltip = "Choose Table and Field Values";
            return new DatabaseSelectionAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        CopyAction initCopyAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Copy");
            actionDescription.setMnemonic('C');
            actionDescription.setImageName("glp_copy.png");
            actionDescription.setTooltip("Copy");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Copy");
            return new CopyAction(actionDescription);
        }

        CutAction initCutAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Cut");
            actionDescription.setMnemonic('T');
            actionDescription.setImageName("glp_cut.png");
            actionDescription.setTooltip("Cut");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Cut");
            return new CutAction(actionDescription);
        }

        RunAction initRunAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Run");
            actionDescription.setMnemonic('R');
            actionDescription.setImageName("media_play.png");
            actionDescription.setTooltip("Render");
            actionDescription.setAccelerator(KeyStroke.getKeyStroke(120, 0));
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Run");
            return new RunAction(actionDescription);
        }

        SaveAllAction initSaveAllAction() {
            String sLabel = "Save All";
            char mnemonic = 'L';
            KeyStroke keyStroke = null;
            String sImageName = "glp_saveall.png";
            String sTooltip = "Save all open projects";
            return new SaveAllAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        OpenAction initOpenAction() {
            String sLabel = "Open";
            char mnemonic = 'O';
            KeyStroke keyStroke = null;
            String sImageName = "folder.png";
            String sTooltip = "Open an existing project";
            return new OpenAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        SaveWithCompileAction initSaveWithCompileAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Save (With Compile)");
            actionDescription.setMnemonic('P');
            actionDescription.setAccelerator("ctrl shift S");
            actionDescription.setImageName("save_compile.png");
            actionDescription.setTooltip("Save and Compile current project");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "SaveWithCompile");
            return new SaveWithCompileAction(actionDescription);
        }

        SaveAction initSaveAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Save");
            actionDescription.setMnemonic('S');
            actionDescription.setAccelerator("ctrl S");
            actionDescription.setImageName("glp_save.png");
            actionDescription.setTooltip("Save current project");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Save");
            return new SaveAction(actionDescription);
        }

        RedoAction initRedoAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Redo");
            actionDescription.setMnemonic('R');
            actionDescription.setImageName("glp_redo.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Redo");
            return new RedoAction(actionDescription);
        }

        PasteSelectedObjectAction initPasteSelectedObjectAction() {
            String sLabel = IDEActionManager.this.getPasteAction().getLabel();
            char mnemonic = IDEActionManager.this.getPasteAction().getMnemonicKey();
            String sImageName = "glp_paste.png";
            return new PasteSelectedObjectAction(sLabel, mnemonic, null, sImageName, null);
        }

        PasteAction initPasteAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Paste");
            actionDescription.setMnemonic('P');
            actionDescription.setImageName("glp_paste.png");
            actionDescription.setTooltip("Paste");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Paste");
            return new PasteAction(actionDescription);
        }

        NewAction initNewAction() {
            String sLabel = "New";
            char mnemonic = 'N';
            KeyStroke keyStroke = null;
            String sImageName = "document_new.png";
            String sTooltip = "Create a new project";
            return new NewAction(sLabel, mnemonic, keyStroke, sImageName, sTooltip);
        }

        UndoAction initUndoAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Undo");
            actionDescription.setMnemonic('U');
            actionDescription.setImageName("glp_undo.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "Undo");
            return new UndoAction(actionDescription);
        }

        FontChooserAction initFontChooserAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Set Font");
            actionDescription.setMnemonic('F');
            actionDescription.setImageName("font.png");
            actionDescription.setTooltip("Set the font of the selected object");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "ChooseFont");
            return new FontChooserAction(actionDescription);
        }

        ForegroundColorChooserAction initForegroundColorChooserAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Set Foreground Color");
            actionDescription.setMnemonic('O');
            actionDescription.setImageName("palette2.png");
            actionDescription.setTooltip("Set the foreground color of the selected object");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "ForegroundColor");
            return new ForegroundColorChooserAction(actionDescription);
        }

        BackgroundColorChooserAction initBackgroundColorChooserAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("Set Background Color");
            actionDescription.setMnemonic('B');
            actionDescription.setImageName("colors.png");
            actionDescription.setTooltip("Set the background color of the selected object");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "BackgroundColor");
            return new BackgroundColorChooserAction(actionDescription);
        }

        AboutAction initAboutAction() {
            ActionDescription actionDescription = new ActionDescription();
            actionDescription.setLabel("About");
            actionDescription.setMnemonic('A');
            actionDescription.setImageName("glp_about.png");
            actionDescription.overrideWithExternalResources(IDEActionManager.this.theResourceBundle, "About");
            return new AboutAction(actionDescription);
        }
    }

    class LanguageChooserAction
    extends IDEInterfaceAction {
        private int language;

        public LanguageChooserAction(ActionDescription actionDescription, int iLanguageId) {
            super(actionDescription);
            this.language = 0;
            this.language = iLanguageId;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEActionManager.this.theCockpit.getDesignProject().setCurrentLanguage(this.language);
            ((IDEActionManager)IDEActionManager.this).theCockpit.theStatusPanel.setLanguage((String)this.getValue("Name"));
            IDEActionManager.this.theCockpit.getIDEToolBar().setLangauge(this.language);
            MetaObject theSelectedFrame = IDEActionManager.this.theCockpit.getSelectedFrame();
            MetaObject theSelectedObject = IDEActionManager.this.theCockpit.getSelectedObject();
            IDEActionManager.this.theCockpit.SelectObject(null, false);
            if (theSelectedFrame != null) {
                theSelectedFrame.refresh();
            }
            IDEActionManager.this.theCockpit.SelectObject(theSelectedObject, false);
            if (IDEActionManager.this.theCockpit.isCustomizing()) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theCustomizer.languageChanged(this.language);
            }
        }

        public int getLanguage() {
            return this.language;
        }
    }

    class DuplicateObjectNamesAction
    extends IDEInterfaceAction {
        public DuplicateObjectNamesAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            MetaProject currentProject = ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theMetaProject;
            if (currentProject != null) {
                String sMessage;
                ArrayList list = currentProject.getDuplicateObjectNames();
                String sObjects = null;
                if (list == null || list.size() == 0) {
                    sMessage = "There are no duplicate object names in this project";
                } else {
                    for (int iObject = 0; iObject < list.size(); ++iObject) {
                        String sObject = (String)list.get(iObject) + "\n";
                        sObjects = sObjects == null ? sObject : sObjects + sObject;
                    }
                    sMessage = "The following Objects names are used by more than one object:\n" + sObjects;
                }
                JOptionPane.showMessageDialog((Component)((Object)IDEActionManager.this.theCockpit), sMessage, "Detect Duplicate Object Names", 1);
            }
        }
    }

    class MultiObjectSizeAction
    extends IDEInterfaceAction {
        public MultiObjectSizeAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            new IDEMultiSelectSizeDialog(IDEActionManager.this.theCockpit);
        }
    }

    class MultiObjectAlignmentAction
    extends IDEInterfaceAction {
        public MultiObjectAlignmentAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            new IDEMultiSelectAlignmentDialog(IDEActionManager.this.theCockpit);
        }
    }

    class InsertVertSplitterAction
    extends IDEInterfaceAction {
        public InsertVertSplitterAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            JMenuItem menuItem = (JMenuItem)evt.getSource();
            IDEObjectPopupMenu menu = (IDEObjectPopupMenu)menuItem.getParent();
            MetaObject theTarget = menu.theTarget;
            MetaObject theSplitter = theTarget.createVerticalSplitter(((IDEActionManager)IDEActionManager.this).theCockpit.theViewDisplayer.iMouseY);
            if (theSplitter == null) {
                return;
            }
            IDEActionManager.this.theCockpit.SelectObject(theSplitter, false);
            JSplitPane theSplitterVisualObject = (JSplitPane)theSplitter.theVisualObject;
            int iDividerLocation = (Integer)theSplitter.getPropertyValue("DividerLocation", 0).getNativeValue();
            theSplitterVisualObject.resetToPreferredSizes();
            theSplitterVisualObject.setDividerLocation(iDividerLocation);
        }
    }

    class InsertHorzSplitterAction
    extends IDEInterfaceAction {
        public InsertHorzSplitterAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            JMenuItem menuItem = (JMenuItem)evt.getSource();
            IDEObjectPopupMenu menu = (IDEObjectPopupMenu)menuItem.getParent();
            MetaObject theTarget = menu.theTarget;
            MetaObject theSplitter = theTarget.createHorizontalSplitter(((IDEActionManager)IDEActionManager.this).theCockpit.theViewDisplayer.iMouseY);
            if (theSplitter == null) {
                return;
            }
            IDEActionManager.this.theCockpit.SelectObject(theSplitter, false);
            JSplitPane theSplitterVisualObject = (JSplitPane)theSplitter.theVisualObject;
            int iDividerLocation = (Integer)theSplitter.getPropertyValue("DividerLocation", 0).getNativeValue();
            theSplitterVisualObject.resetToPreferredSizes();
            theSplitterVisualObject.setDividerLocation(iDividerLocation);
        }
    }

    class DeleteAction
    extends IDEInterfaceAction {
        public DeleteAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            int i;
            DesignProject theSelectedProject = IDEActionManager.this.theCockpit.getDesignProject();
            if (theSelectedProject == null) {
                return;
            }
            if (IDEActionManager.this.theCockpit.isCustomizing()) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theCustomizer.selectElementGroupElements();
            }
            ArrayList<MetaObject> objsToDelete = new ArrayList<MetaObject>(0);
            ArrayList<MetaObject> objsParents = new ArrayList<MetaObject>(0);
            for (i = 0; i < theSelectedProject.getSelectedObjectCount(); ++i) {
                objsToDelete.add(theSelectedProject.getSelectedObject(i));
                objsParents.add(theSelectedProject.getSelectedObject((int)i).theParentObject);
            }
            theSelectedProject.theUndoRedoController.createDeleteObjectsEvent(objsParents, objsToDelete);
            for (i = 0; i < objsToDelete.size(); ++i) {
                MetaObject theSelectedObject = (MetaObject)objsToDelete.get(i);
                if (theSelectedObject == null || theSelectedObject.isFrame() || theSelectedObject.isAbalet()) continue;
                theSelectedProject.deselectObject(theSelectedObject);
                theSelectedObject.DeleteObject(((IDEActionManager)IDEActionManager.this).theCockpit.theCurrentDesignProject.theMetaProject, (AbaMetaDataUser)IDEActionManager.this.theCockpit);
            }
            IDEActionManager.this.theCockpit.deselectObjects();
            ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class ClassEditorAction
    extends IDEInterfaceAction {
        public ClassEditorAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            MetaObject theSelectedObject = IDEActionManager.this.theCockpit.getDesignProject().getSelectedObject();
            if (theSelectedObject != null) {
                MetaClass theMetaClass = theSelectedObject.theClass;
                String theEditorClassName = theMetaClass.getMetadata().theDesignEditor;
                if (theEditorClassName != null) {
                    HammerClassLoader clsLoader = ((IDEActionManager)IDEActionManager.this).theCockpit.theClassLoader;
                    Class<?> clsEditor = null;
                    try {
                        clsEditor = Class.forName(theEditorClassName, true, (ClassLoader)clsLoader.getLoader());
                    }
                    catch (ClassNotFoundException e1) {
                        System.out.print("Cannot find class editor " + theEditorClassName);
                        return;
                    }
                    Object[] theParams = new Object[1];
                    Class[] theParamClasses = new Class[1];
                    theParams[0] = theSelectedObject;
                    theParamClasses[0] = theSelectedObject.getClass();
                    try {
                        Constructor<?> theConstructor = clsEditor.getConstructor(theParamClasses);
                        try {
                            theConstructor.newInstance(theParams);
                        }
                        catch (Exception e2) {
                            System.out.println(e2.getMessage());
                            return;
                        }
                    }
                    catch (Exception e3) {
                        System.out.println(e3.getMessage());
                        return;
                    }
                }
            }
        }
    }

    class ExitAction
    extends IDEInterfaceAction {
        public ExitAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            IDEWindowClosingEventHandler exitHandler = new IDEWindowClosingEventHandler(IDEActionManager.this.theCockpit);
            exitHandler.windowClosing(new WindowEvent((Window)((Object)IDEActionManager.this.theCockpit), 0));
        }
    }

    class CloseAction
    extends IDEInterfaceAction {
        public CloseAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            DesignProject theProject = IDEActionManager.this.theCockpit.getDesignProject();
            boolean bTest = theProject.close(true);
            if (!bTest) {
                return;
            }
            if (((IDEActionManager)IDEActionManager.this).theCockpit.theObjectTreeViewPane != null) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theObjectTreeViewPane.clear();
            }
            if (((IDEActionManager)IDEActionManager.this).theCockpit.theViewDisplayer != null) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theViewDisplayer.resetContents();
            }
            if (IDEActionManager.this.theCockpit.getPropertyInspectorController() != null) {
                IDEActionManager.this.theCockpit.getPropertyInspectorController().resetContents();
            }
            if (((IDEActionManager)IDEActionManager.this).theCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER && ((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer != null) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer.setCodeText("");
            }
            if (theProject.theMetaProject.sName != null && !theProject.theMetaProject.sName.startsWith("New Project") && theProject.theMetaProject.sName.trim().length() != 0 && theProject.theMetaProject.getInputType() == 1 && !IDEActionManager.this.theCockpit.isCustomizing()) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.mruList.fileClosed(theProject.theMetaProject.getProjectDirectory() + theProject.theMetaProject.sName);
            }
            DesignProject thePrevProject = theProject.thePreviousDesignProject;
            DesignProject theNextProject = theProject.theNextDesignProject;
            IDEActionManager.this.theCockpit.removeDesignProject(theProject);
            DesignProject theChoice = theNextProject;
            if (theChoice == null) {
                theChoice = thePrevProject;
            }
            if (theChoice != null) {
                theChoice.theAssociatedAction.actionPerformed(new ActionEvent(this, 0, theChoice.theMetaProject.sName));
            }
            Component[] theProjectWindowMenuItems = IDEActionManager.this.theCockpit.getIDEMenuBar().getWindowMenu().getMenuComponents();
            for (int i = 0; i < theProjectWindowMenuItems.length; ++i) {
                JMenuItem theMenuItem;
                if (!(theProjectWindowMenuItems[i] instanceof JMenuItem) || !(theMenuItem = (JMenuItem)theProjectWindowMenuItems[i]).getText().equals(theProject.theMetaProject.sName)) continue;
                IDEActionManager.this.theCockpit.getIDEMenuBar().getWindowMenu().remove(theMenuItem);
                break;
            }
            if (theChoice == null) {
                SelectProjectAction actionProject = null;
                try {
                    theChoice = IDEActionManager.this.theCockpit.loadProject((String)null, (String)null, IDEActionManager.this.theCockpit, 0);
                    if (theChoice != null) {
                        theChoice.setCurrentLanguage(0);
                        actionProject = new SelectProjectAction(theChoice, IDEActionManager.this.theCockpit);
                        actionProject.actionPerformed(new ActionEvent(this, 0, actionProject.theDesignProject.theMetaProject.getName()));
                        theChoice.theMetaProject.setProjectChangedState(false);
                        IDEActionManager.this.theCockpit.getIDEMenuBar().addProjectItem(actionProject);
                    }
                }
                catch (HammerException e1) {
                    return;
                }
            }
            IDEActionManager.this.theCockpit.setCurrentDesignProject(theChoice);
        }
    }

    class SaveMetadataAction
    extends IDEInterfaceAction {
        public SaveMetadataAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
            this.enabled = IDEActionManager.this.theCockpit.isCanSaveMetadata();
        }

        public void actionPerformed(ActionEvent evt) {
            ((IDEActionManager)IDEActionManager.this).theCockpit.theCurrentDesignProject.theMetaProject.getMetadataDispenser().theMetadataDocument.writeMetaDocument();
        }
    }

    class SaveAsAction
    extends IDEInterfaceAction {
        public SaveAsAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            IDEActionManager.this.theCockpit;
            String sProjectName = SuperDesignCockpit.theProjectName;
            if (IDEActionManager.this.theCockpit.getDesignProject() == null || IDEActionManager.this.theCockpit.getDesignProject().getFirstObject() == null) {
                return;
            }
            IDEActionManager.this.theCockpit;
            SuperDesignCockpit.theProjectName = null;
            boolean bSavedOk = IDEActionManager.this.theCockpit.SaveProject(false);
            if (!bSavedOk) {
                IDEActionManager.this.theCockpit;
                SuperDesignCockpit.theProjectName = sProjectName;
            }
        }
    }

    class CopySelectedObjectAction
    extends AbstractAction {
        SuperDesignCockpit theCockpit;
        MetaCloneMode theMode;

        public CopySelectedObjectAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit, int mode) {
            super(label, icon);
            this.theCockpit = null;
            this.theMode = new MetaCloneMode(0);
            this.theCockpit = objDesignCockpit;
            this.theMode = new MetaCloneMode(mode);
        }

        public void actionPerformed(ActionEvent evt) {
            DesignProject theSelectedProject = this.theCockpit.getDesignProject();
            if (theSelectedProject == null) {
                return;
            }
            this.theCockpit.theClipboardController.removeAllClipboardObjects();
            for (int i = 0; i < theSelectedProject.getSelectedObjectCount(); ++i) {
                boolean bPreserveNames;
                MetaObject theMetaObject = theSelectedProject.getSelectedObject(i);
                if (theMetaObject == null) continue;
                String sClassName = theMetaObject.theClass.getMetadata().sClassName;
                String sObjectName = theMetaObject.getName();
                boolean bl = bPreserveNames = !sObjectName.startsWith(sClassName);
                if (this.theCockpit.getOpenSourceState() && this.theMode.theMode == 2) {
                    this.theMode.theMode = 3;
                }
                this.theCockpit.theClipboardController.addClipboardObject(theMetaObject.Clone(this.theMode, null, bPreserveNames));
            }
            this.theCockpit.theClipboardController.setClipboardContent(2);
            this.theCockpit.theClipboardController.setClipboardBufferingAction(this);
            this.theCockpit.theClipboardController.theCloneMode = this.theMode.theMode;
            theSelectedProject.deselectObjects();
        }
    }

    class PointModeAction
    extends IDEInterfaceAction {
        public PointModeAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            IDEActionManager.this.theCockpit.setMouseSelectState(true);
        }
    }

    class ProjectPreferencesAction
    extends IDEInterfaceAction {
        public ProjectPreferencesAction(ActionDescription actionDescription) {
            super(actionDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                MetaProject theMetaProject;
                if (IDEActionManager.this.theCockpit.getDesignProject() == null) {
                    theMetaProject = new MetaProject(1, ((IDEActionManager)IDEActionManager.this).theCockpit.theGlobalInterface, (Object)((IDEActionManager)IDEActionManager.this).theCockpit.theClassLoader, IDEActionManager.this.theCockpit.getMetadataDispenser());
                    DesignProject theDesignProject = new DesignProject(theMetaProject);
                    IDEActionManager.this.theCockpit.addDesignProject(theDesignProject);
                    IDEActionManager.this.theCockpit.SetDesignProject(theDesignProject);
                } else {
                    theMetaProject = ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theMetaProject;
                }
                new IDEProjectTool(IDEActionManager.this.theCockpit, theMetaProject);
            }
            catch (HammerException e1) {
                System.err.println("Exception: " + e1.getMessage());
            }
        }
    }

    class ImporterAction
    extends IDEInterfaceAction {
        public ImporterAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            new IDEImporter(IDEActionManager.this.theCockpit);
        }
    }

    class DatabaseSelectionAction
    extends IDEInterfaceAction {
        public DatabaseSelectionAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            if (IDEActionManager.this.theCockpit.getSelectedObject() != null) {
                String theDataBaseSelectorClass = IDEActionManager.this.theCockpit.getConfigurationManager().getConfigurationVariable("DataBaseSelectorClass");
                try {
                    Class cls = IDEActionManager.this.theCockpit.getClassLoader().getLoader().loadClass(theDataBaseSelectorClass);
                    if (cls != null) {
                        Class[] paramClasses = new Class[3];
                        Object[] paramObjects = new Object[]{IDEActionManager.this.theCockpit.getSelectedObject(), "DummyPropertyName", IDEActionManager.this.theCockpit};
                        paramClasses[0] = MetaObject.class;
                        paramClasses[1] = String.class;
                        paramClasses[2] = SuperDesignCockpit.class;
                        try {
                            Constructor constr = cls.getConstructor(paramClasses);
                            constr.newInstance(paramObjects);
                        }
                        catch (NoSuchMethodException e) {
                        }
                        catch (SecurityException e) {
                        }
                        catch (InstantiationException e) {
                        }
                        catch (IllegalAccessException e) {
                        }
                        catch (InvocationTargetException e) {}
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    class CopyAction
    extends IDEInterfaceAction {
        public CopyAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            Component theFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (IDEActionManager.this.isFocusTextOriented(theFocus)) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.setClipboardContent(1);
                IDEActionManager.this.theCockpit.editorAction("copy-to-clipboard", evt);
            } else {
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu == null) {
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu = ((IDEActionManager)IDEActionManager.this).theCockpit.theObjectTreeViewPane.thePopupMenu;
                }
                ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.copySelectedObjectAction.actionPerformed(evt);
            }
        }
    }

    class CutAction
    extends IDEInterfaceAction {
        public CutAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            Component theFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (IDEActionManager.this.isFocusTextOriented(theFocus)) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.setClipboardContent(1);
                IDEActionManager.this.theCockpit.editorAction("cut-to-clipboard", evt);
            } else {
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu == null) {
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu = ((IDEActionManager)IDEActionManager.this).theCockpit.theObjectTreeViewPane.thePopupMenu;
                }
                ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.cutSelectedObjectAction.actionPerformed(evt);
            }
        }
    }

    class CompileAction
    extends IDEInterfaceAction {
        public CompileAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            MetaProjectHeader theProgram = null;
            try {
                theProgram = IDEActionManager.this.theCockpit.getProgramMetadata();
            }
            catch (HammerException e1) {
                return;
            }
            if (IDEActionManager.this.theCockpit.getDesignProject() == null || IDEActionManager.this.theCockpit.getDesignProject().getFirstObject() == null) {
                return;
            }
            ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theMetaProject.getNLS().writeAllChangedNlsDocuments();
            theProgram.theMainObject = IDEActionManager.this.theCockpit.getDesignProject().getFirstObject();
            theProgram.sMainClass = ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().getFirstObject().theClass.getMetadata().sClassName;
            theProgram.sPackageName = "ch.abacus.designcockpit.ide";
            UIFactoryAssemblyLine roastThis = null;
            IDEActionManager.this.theCockpit.setEnabled(false);
            try {
                roastThis = new UIFactoryAssemblyLine(((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theMetaProject, ((IDEActionManager)IDEActionManager.this).theCockpit.thePreferences.sWorkingDirectory);
                roastThis.CreateUI();
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer != null) {
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer.theMessagesEditor.setText("Compilation Successful!\n");
                }
            }
            catch (Exception e1) {
                ExceptionWriter writerTemp = new ExceptionWriter(IDEActionManager.this.theCockpit);
                PrintWriter pwTemp = new PrintWriter(writerTemp);
                e1.printStackTrace(pwTemp);
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer != null) {
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer.setMessagesText(writerTemp.getBuffer());
                }
            }
            catch (Throwable e2) {
                ExceptionWriter writerTemp = new ExceptionWriter(IDEActionManager.this.theCockpit);
                PrintWriter pwTemp = new PrintWriter(writerTemp);
                e2.printStackTrace(pwTemp);
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer != null) {
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer.setMessagesText(writerTemp.getBuffer());
                }
            }
            finally {
                IDEActionManager.this.theCockpit.setEnabled(true);
            }
            if (roastThis != null) {
                ((IDEActionManager)IDEActionManager.this).theCockpit.theCodeJumper = roastThis.theCodeJumper;
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer != null) {
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer.theListener.setCodeJumper(((IDEActionManager)IDEActionManager.this).theCockpit.theCodeJumper);
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theSourceViewer.showMessageEditor();
                }
            }
        }
    }

    class RunAction
    extends IDEInterfaceAction {
        public RunAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            IDEActionManager.this.theCockpit.runProject();
        }
    }

    class SaveAllAction
    extends IDEInterfaceAction {
        public SaveAllAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            boolean bTest;
            DesignProject theDesignProject = ((IDEActionManager)IDEActionManager.this).theCockpit.theFirstDesignProject;
            while (theDesignProject != null && (bTest = theDesignProject.store(true))) {
                theDesignProject = theDesignProject.theNextDesignProject;
            }
        }
    }

    class OpenAction
    extends IDEInterfaceAction {
        public OpenAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            JFileChooser theFileChooser = new JFileChooser(IDEActionManager.this.theCockpit.getCurrentDirectory());
            theFileChooser.addChoosableFileFilter(new ProjFileFilter(IDEActionManager.this.theCockpit));
            theFileChooser.setFileView(new ProjFileView(IDEActionManager.this.theCockpit));
            int iOptionSelected = theFileChooser.showOpenDialog(IDEActionManager.this.theCockpit.getContentPane());
            String sFullPath = null;
            if (iOptionSelected == 0) {
                String newProjectName;
                File file = theFileChooser.getSelectedFile();
                try {
                    sFullPath = file.getCanonicalPath();
                    String sSeparator = ((IDEActionManager)IDEActionManager.this).theCockpit.props.getProperty("file.separator");
                    int iSeparator = sFullPath.lastIndexOf(sSeparator);
                    if (iSeparator != -1) {
                        String sDirectoryName = sFullPath.substring(0, iSeparator + 1);
                        IDEActionManager.this.theCockpit.setCurrentDirectory(sDirectoryName);
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                boolean bFromJar = false;
                HammerJarAccess theJarAccess = null;
                String sTestName = file.getName();
                if (sTestName != null && sTestName.toLowerCase().endsWith("jar")) {
                    sTestName = file.getAbsolutePath();
                    JarOpenFileDialog theJarDialog = new JarOpenFileDialog(sTestName);
                    theJarDialog.jarOpenDialog.show();
                    JarContentsTreeNode theComponent = theJarDialog.getSelection();
                    if (theComponent == null) {
                        return;
                    }
                    newProjectName = theComponent.theAccess.sKey;
                    if (newProjectName == null) {
                        return;
                    }
                    theJarAccess = theJarDialog.getSelection().theAccess.theAccess;
                    if (!IDEActionManager.this.theCockpit.getOpenSourceState()) {
                        bFromJar = true;
                    }
                } else {
                    newProjectName = file.getName();
                }
                Component[] theProjectWindowMenuItems = IDEActionManager.this.theCockpit.getIDEMenuBar().getWindowMenu().getMenuComponents();
                for (int i = 0; i < theProjectWindowMenuItems.length; ++i) {
                    JMenuItem theMenuItem;
                    if (!(theProjectWindowMenuItems[i] instanceof JMenuItem) || !(theMenuItem = (JMenuItem)theProjectWindowMenuItems[i]).getText().equals(newProjectName)) continue;
                    SelectProjectAction reopenAction = (SelectProjectAction)theMenuItem.getAction();
                    reopenAction.actionPerformed(new ActionEvent((Object)IDEActionManager.this.theCockpit, 0, reopenAction.theDesignProject.theMetaProject.sName));
                    return;
                }
                DesignProject newProject = null;
                try {
                    newProject = bFromJar ? IDEActionManager.this.theCockpit.loadProject(theJarAccess, newProjectName, IDEActionManager.this.theCockpit, 2) : IDEActionManager.this.theCockpit.loadProject(sFullPath, file.getName(), IDEActionManager.this.theCockpit, 1);
                }
                catch (HammerException e1) {
                    // empty catch block
                }
                if (newProject != null) {
                    SelectProjectAction actionProject = new SelectProjectAction(newProject, IDEActionManager.this.theCockpit);
                    IDEActionManager.this.theCockpit.getIDEMenuBar().addProjectItem(actionProject);
                    actionProject.actionPerformed(new ActionEvent((Object)IDEActionManager.this.theCockpit, 0, actionProject.theDesignProject.theMetaProject.sName));
                    newProject.theMetaProject.setProjectChangedState(false);
                }
            }
        }
    }

    class SaveWithCompileAction
    extends IDEInterfaceAction {
        public SaveWithCompileAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            IDEActionManager.this.theCockpit.SaveProject(true);
        }
    }

    class SaveAction
    extends IDEInterfaceAction {
        public SaveAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            boolean bShouldCompile = IDEActionManager.this.theCockpit.isCustomizing();
            IDEActionManager.this.theCockpit.SaveProject(bShouldCompile);
        }
    }

    class RedoAction
    extends IDEInterfaceAction {
        public RedoAction(ActionDescription description) {
            super(description);
            this.enabled = false;
        }

        public void actionPerformed(ActionEvent evt) {
            ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theUndoRedoController.redo();
            MetaObject theSelectedFrame = IDEActionManager.this.theCockpit.getSelectedFrame();
            MetaObject theSelectedObject = IDEActionManager.this.theCockpit.getSelectedObject();
            IDEActionManager.this.theCockpit.SelectObject(null, false);
            if (theSelectedFrame != null) {
                theSelectedFrame.refresh();
            }
            if (!theSelectedObject.bIsDeleted) {
                IDEActionManager.this.theCockpit.SelectObject(theSelectedObject, false);
            }
        }
    }

    class PasteSelectedObjectAction
    extends IDEInterfaceAction {
        public PasteSelectedObjectAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            DesignProject theSelectedProject = IDEActionManager.this.theCockpit.getDesignProject();
            if (theSelectedProject == null) {
                return;
            }
            IDEActionManager.this.theCockpit.SelectObject(((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget, false);
            Point ptLocation = ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.getLastPopupLocation();
            Point ptActualLocation = ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.getActualStrikePoint();
            Integer X = new Integer(ptLocation.x);
            Integer Y = new Integer(ptLocation.y);
            Integer ActualX = new Integer(ptActualLocation.x);
            Integer ActualY = new Integer(ptActualLocation.y);
            try {
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.getClipboardObjectCount() != 0) {
                    MetaObject theTarget = ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget;
                    ArrayList<MetaObject> objsPasted = new ArrayList<MetaObject>(0);
                    AbstractAction theAction = ((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.getClipboardBufferingAction();
                    boolean bPreserveObjectNames = false;
                    if (theAction instanceof IDEObjectPopupMenu.CutSelectedObjectAction) {
                        bPreserveObjectNames = true;
                    }
                    for (int i = 0; i < ((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.getClipboardObjectCount(); ++i) {
                        MetaObject theClipboardObject = ((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.getClipboardObject(i);
                        MetaObject theNewObject = null;
                        if (((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget != null) {
                            if (((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.equals(((IDEActionManager)IDEActionManager.this).theCockpit.theObjectTreeViewPane.thePopupMenu)) {
                                if (!theClipboardObject.isAbalet() && !theClipboardObject.isFrame()) {
                                    theNewObject = IDEActionManager.this.theCockpit.PasteObject(((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget, theClipboardObject, ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theMetaProject, bPreserveObjectNames);
                                }
                            } else if (!theClipboardObject.isAbalet() && !theClipboardObject.isFrame()) {
                                theNewObject = IDEActionManager.this.theCockpit.PasteObject(((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget, theClipboardObject, ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theMetaProject, X, Y, ActualX, ActualY, i, bPreserveObjectNames);
                            }
                        } else {
                            theNewObject = ((IDEActionManager)IDEActionManager.this).theCockpit.theCurrentDesignProject.PasteObject(theClipboardObject, IDEActionManager.this.theCockpit, bPreserveObjectNames);
                        }
                        if (theNewObject == null) continue;
                        objsPasted.add(theNewObject);
                    }
                    theSelectedProject.theUndoRedoController.createPasteEvent(theTarget, objsPasted);
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theCurrentDesignProject.deselectObjects();
                    MetaObject testObject = ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget;
                    while (testObject != null && !testObject.isFrame() && !testObject.isAbalet()) {
                        testObject = testObject.theParentObject;
                    }
                    if (theTarget != null && !theTarget.isWithinTabPane()) {
                        IDEActionManager.this.theCockpit.FrameSelection(theTarget, true);
                    }
                    if (objsPasted.size() > 0) {
                        MetaObject theSelectedFrame = IDEActionManager.this.theCockpit.getSelectedFrame();
                        IDEActionManager.this.theCockpit.SelectObject(null, false);
                        if (theSelectedFrame != null) {
                            theSelectedFrame.refresh();
                        }
                        for (int iobj = 0; iobj < objsPasted.size(); ++iobj) {
                            IDEActionManager.this.theCockpit.SelectObject((MetaObject)objsPasted.get(iobj), true);
                        }
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    class PasteAction
    extends IDEInterfaceAction {
        public PasteAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            Component theFocus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (IDEActionManager.this.isFocusTextOriented(theFocus)) {
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.getClipboardContent() == 1) {
                    IDEActionManager.this.theCockpit.editorAction("paste-from-clipboard", evt);
                }
            } else if (((IDEActionManager)IDEActionManager.this).theCockpit.theClipboardController.getClipboardContent() == 2) {
                if (((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu != null && ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget != null) {
                    IDEActionManager.this.pasteSelectedObjectAction.actionPerformed(evt);
                } else {
                    MetaObject theTarget;
                    ((IDEActionManager)IDEActionManager.this).theCockpit.theLastPopupMenu.theTarget = theTarget = ((IDEActionManager)IDEActionManager.this).theCockpit.theFirstDesignProject.getSelectedFrame();
                    IDEActionManager.this.pasteSelectedObjectAction.actionPerformed(evt);
                }
            }
        }
    }

    class NewAction
    extends IDEInterfaceAction {
        public NewAction(String label, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(label, mnemonic, keyStroke, sIconName, sDescription);
        }

        public void actionPerformed(ActionEvent evt) {
            DesignProject theDesignProject = null;
            try {
                theDesignProject = IDEActionManager.this.theCockpit.loadProject((String)null, null, IDEActionManager.this.theCockpit, 1);
            }
            catch (HammerException e1) {
                // empty catch block
            }
            if (theDesignProject != null) {
                theDesignProject.setInputType(1);
                SelectProjectAction actionProject = new SelectProjectAction(theDesignProject, IDEActionManager.this.theCockpit);
                IDEActionManager.this.theCockpit.getIDEMenuBar().addProjectItem(actionProject);
                theDesignProject.theAssociatedAction.actionPerformed(new ActionEvent(this, 0, theDesignProject.theMetaProject.sName));
                theDesignProject.theMetaProject.setProjectChangedState(false);
            }
        }
    }

    class UndoAction
    extends IDEInterfaceAction {
        public UndoAction(ActionDescription description) {
            super(description);
            this.enabled = false;
        }

        public void actionPerformed(ActionEvent evt) {
            ((IDEActionManager)IDEActionManager.this).theCockpit.getDesignProject().theUndoRedoController.undo();
            MetaObject theSelectedFrame = IDEActionManager.this.theCockpit.getSelectedFrame();
            MetaObject theSelectedObject = IDEActionManager.this.theCockpit.getSelectedObject();
            IDEActionManager.this.theCockpit.SelectObject(null, false);
            if (theSelectedFrame != null) {
                theSelectedFrame.refresh();
            }
            if (!theSelectedObject.bIsDeleted) {
                IDEActionManager.this.theCockpit.SelectObject(theSelectedObject, false);
            }
        }
    }

    class FontChooserAction
    extends IDEInterfaceAction {
        public FontChooserAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            String sError = "Error displaying the Font Dialog";
            if (IDEActionManager.this.theCockpit.getSelectedObject() != null) {
                String sFontChooserClass = IDEActionManager.this.theCockpit.getConfigurationManager().getConfigurationVariable("FONT_CHOOSER", ((IDEActionManager)IDEActionManager.this).theCockpit.thePreferences.sFontChooserName);
                try {
                    Class cls = IDEActionManager.this.theCockpit.getClassLoader().getLoader().loadClass(sFontChooserClass);
                    if (cls != null) {
                        Object[] parameters = new Object[]{IDEActionManager.this.theCockpit};
                        Class[] parameterTypes = new Class[]{SuperDesignCockpit.class};
                        Constructor constructor = cls.getConstructor(parameterTypes);
                        constructor.newInstance(parameters);
                    }
                }
                catch (ClassNotFoundException e) {
                    JOptionPane.showMessageDialog((Component)((Object)IDEActionManager.this.theCockpit), "Component missing (" + sFontChooserClass + ")", sError, 0);
                }
                catch (NoSuchMethodException e) {
                    JOptionPane.showMessageDialog((Component)((Object)IDEActionManager.this.theCockpit), "Missing Constructor.\n\nThe class does not have a constructor with only one parameter (SuperDesignCockpit - needed as the parent)", sError, 0);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog((Component)((Object)IDEActionManager.this.theCockpit), e.getMessage(), sError, 0);
                    e.printStackTrace();
                }
            }
        }
    }

    class ForegroundColorChooserAction
    extends IDEInterfaceAction {
        public ForegroundColorChooserAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            if (IDEActionManager.this.theCockpit.getSelectedObject() != null) {
                new IDEObjectColorChooser(IDEActionManager.this.theCockpit, true);
            }
        }
    }

    class BackgroundColorChooserAction
    extends IDEInterfaceAction {
        public BackgroundColorChooserAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            if (IDEActionManager.this.theCockpit.getSelectedObject() != null) {
                new IDEObjectColorChooser(IDEActionManager.this.theCockpit, false);
            }
        }
    }

    class AboutAction
    extends IDEInterfaceAction {
        public AboutAction(ActionDescription description) {
            super(description);
        }

        public void actionPerformed(ActionEvent evt) {
            new IDEAboutBox(IDEActionManager.this.theCockpit);
        }
    }

    private abstract class IDEInterfaceAction
    extends AbstractAction {
        public IDEInterfaceAction(String sLabel, char mnemonic, KeyStroke keyStroke, String sIconName, String sDescription) {
            super(sLabel, IDEActionManager.this.getIcon(sIconName));
            if (mnemonic != '\u0000') {
                this.setMnemonicKey(mnemonic);
            }
            if (sDescription != null && sDescription.length() > 0) {
                this.setShortDescription(sDescription);
            }
            if (keyStroke != null) {
                this.setAcceleratorKey(keyStroke);
            }
        }

        public IDEInterfaceAction(ActionDescription desc) {
            this(desc.getLabel(), desc.getMnemonic(), desc.getAccelerator(), desc.getImageName(), desc.getTooltip());
        }

        private void setMnemonicKey(char mnemonic) {
            this.putValue("MnemonicKey", new Integer(mnemonic));
        }

        private void setShortDescription(String sDescription) {
            this.putValue("ShortDescription", sDescription);
        }

        protected void setAcceleratorKey(KeyStroke keyStroke) {
            this.putValue("AcceleratorKey", keyStroke);
        }

        public String getLabel() {
            return (String)this.getValue("Name");
        }

        public char getMnemonicKey() {
            return (char)((Integer)this.getValue("MnemonicKey")).intValue();
        }
    }
}

