/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEComponentPalette;
import ch.abacus.designcockpit.ide.IDETitleBar;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.JAScrollPane;
import ch.abacus.lib.ui.customizer.CustomizerDataConnectionInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataElementInterface;
import ch.abacus.lib.ui.customizer.CustomizerDataTableInterface;
import ch.abacus.lib.ui.renderer.common.HammerException;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaClassDetail;
import ch.abacus.lib.ui.renderer.common.MetaProjectHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class IDEComponentPalettePane
extends JAPanel {
    public SuperDesignCockpit theDesignCockpit;
    DefaultTreeModel theTreeModel;
    IDEComponentPalette theTree;
    IDEComponentPaletteNode baseClass = null;
    JPopupMenu popupMenu = null;

    public IDEComponentPalettePane(SuperDesignCockpit objDesignCockpit) {
        this.theDesignCockpit = objDesignCockpit;
        String sComponentBranchTitle = this.theDesignCockpit.theLanguageManager.getMessage("ComponentsPane.ComponentsBranch.label", "Components");
        this.baseClass = new IDEComponentPaletteNode(sComponentBranchTitle);
        this.theTreeModel = new DefaultTreeModel((TreeNode)this.baseClass);
        this.theTreeModel.addTreeModelListener(new MyTreeModelListener());
        this.theTree = new IDEComponentPalette(this.theTreeModel, this.theDesignCockpit);
        this.theTree.getSelectionModel().setSelectionMode(1);
        this.theTree.setShowsRootHandles(true);
        this.theTree.addKeyListener(new ComponentPaletteKeyListener(this));
        this.theTree.addMouseListener(new ComponentPaletteMouseListener(this.theDesignCockpit));
        JAScrollPane theScrollPane = new JAScrollPane((Component)((Object)this.theTree));
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.GRAY));
        theScrollPane.setBorder(null);
        String sPaneTitle = this.theDesignCockpit.theLanguageManager.getMessage("ComponentsPane.label", "Components");
        this.add((Component)((Object)new IDETitleBar(sPaneTitle)), "North");
        this.add((Component)theScrollPane, "Center");
        this.createContextMenu();
    }

    private void createContextMenu() {
        if (this.theDesignCockpit.isCustomizing()) {
            return;
        }
        this.popupMenu = new JPopupMenu();
        AddClassAction addClassAction = new AddClassAction("Add Class", this.theDesignCockpit);
        JMenuItem addClassItem = new JMenuItem(addClassAction);
        EditClassAction editClassAction = new EditClassAction("Edit Class", this.theDesignCockpit);
        JMenuItem editClassItem = new JMenuItem(editClassAction);
        DeleteClassAction deleteClassAction = new DeleteClassAction("Delete Class", this.theDesignCockpit);
        JMenuItem deleteClassItem = new JMenuItem(deleteClassAction);
        SaveMetadataAction saveMetadataAction = new SaveMetadataAction("Save Classes", this.theDesignCockpit);
        JMenuItem saveMetadataItem = new JMenuItem(saveMetadataAction);
        HelpAction helpAction = new HelpAction("Help", this.theDesignCockpit);
        JMenuItem helpItem = new JMenuItem(helpAction);
        this.popupMenu.add(saveMetadataItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(addClassItem);
        this.popupMenu.add(editClassItem);
        this.popupMenu.add(deleteClassItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(helpItem);
    }

    public void clear() {
        this.baseClass.removeAllChildren();
        this.theTreeModel.reload();
    }

    public void removeCurrentNode() {
        TreePath currentSelection = this.theTree.getSelectionPath();
        if (currentSelection != null) {
            IDEComponentPaletteNode currentNode = (IDEComponentPaletteNode)currentSelection.getLastPathComponent();
            MetaClass theMetaClass = currentNode.getMetaClass();
            theMetaClass.DeleteClass();
            IDEComponentPaletteNode parent = (IDEComponentPaletteNode)currentNode.getParent();
            if (parent != null) {
                this.theTreeModel.removeNodeFromParent((MutableTreeNode)currentNode);
                return;
            }
        }
    }

    public void removeNode(IDEComponentPaletteNode nodeToRemove) {
        MetaClass theMetaClass = nodeToRemove.getMetaClass();
        theMetaClass.DeleteClass();
        IDEComponentPaletteNode parent = (IDEComponentPaletteNode)nodeToRemove.getParent();
        if (parent != null) {
            this.theTreeModel.removeNodeFromParent((MutableTreeNode)nodeToRemove);
        }
    }

    public IDEComponentPaletteNode addClass(String theNodeText) {
        IDEComponentPaletteNode parentNode = null;
        TreePath parentPath = this.theTree.getSelectionPath();
        parentNode = parentPath == null ? this.baseClass : (IDEComponentPaletteNode)parentPath.getLastPathComponent();
        return this.addClass(parentNode, theNodeText, true);
    }

    public IDEComponentPaletteNode addClass(IDEComponentPaletteNode parent, String theNodeText) {
        return this.addClass(parent, theNodeText, false);
    }

    public IDEComponentPaletteNode addClass(IDEComponentPaletteNode parent, String theNodeText, boolean shouldBeVisible) {
        IDEComponentPaletteNode childNode = new IDEComponentPaletteNode(theNodeText);
        if (parent == null) {
            parent = this.baseClass;
        }
        this.theTreeModel.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.theTree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    public IDEComponentPaletteNode addCustomizerDataConnection(IDEComponentPaletteNode parent, CustomizerDataConnectionInterface theDataConnection) {
        IDEComponentPaletteNode childNode = new IDEComponentPaletteNode(theDataConnection);
        if (parent == null) {
            parent = this.baseClass;
        }
        this.theTreeModel.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parent, parent.getChildCount());
        return childNode;
    }

    public IDEComponentPaletteNode addClass(IDEComponentPaletteNode parent, CustomizerDataElementInterface theDataElement, MetaClass metaClass) {
        IDEComponentPaletteNode childNode = new IDEComponentPaletteNode(metaClass, theDataElement);
        if (parent == null) {
            parent = this.baseClass;
        }
        this.theTreeModel.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parent, parent.getChildCount());
        return childNode;
    }

    public IDEComponentPaletteNode addCustomizerDataTable(IDEComponentPaletteNode parent, CustomizerDataTableInterface theDataTable, boolean bMakeVisible, boolean bDeferElements) {
        IDEComponentPaletteNode childNode = new IDEComponentPaletteNode(theDataTable, bDeferElements);
        if (parent == null) {
            parent = this.baseClass;
        }
        this.theTreeModel.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)parent, parent.getChildCount());
        if (bMakeVisible) {
            this.theTree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    boolean loadClass(MetaClass theFirstClass, IDEComponentPaletteNode thisNode) {
        for (MetaClass currClass = theFirstClass; currClass != null; currClass = currClass.getNextSibling()) {
            if (currClass.getMetadata().bHidden) continue;
            IDEComponentPaletteNode theNewNode = new IDEComponentPaletteNode(currClass);
            if (thisNode == null) {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)this.baseClass, this.baseClass.getChildCount());
            } else {
                this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)thisNode, thisNode.getChildCount());
            }
            if (currClass.getFirstClass() == null) continue;
            this.loadClass(currClass.getFirstClass(), theNewNode);
        }
        return true;
    }

    boolean load(MetaClass theFirstClass, IDEComponentPaletteNode thisNode) {
        this.resetContents();
        boolean bClassLoaded = this.loadClass(theFirstClass, thisNode);
        if (this.theDesignCockpit.isCustomizing()) {
            this.theDesignCockpit.theCustomizer.loadFormElements();
        }
        return bClassLoaded;
    }

    public void addClass(MetaClass currClass) {
        if (currClass != null) {
            IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)this.theTree.getLastSelectedPathComponent();
            IDEComponentPaletteNode theNewNode = new IDEComponentPaletteNode(currClass);
            this.theTreeModel.insertNodeInto((MutableTreeNode)theNewNode, (MutableTreeNode)theSelectedNode, theSelectedNode.getChildCount());
            currClass.theTreeNode = theNewNode;
        }
    }

    public void newClassNode() {
        IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)this.theTree.getLastSelectedPathComponent();
        if (theSelectedNode != null) {
            MetaClass theSuperClass = theSelectedNode.getMetaClass();
            MetaClass theSubClass = null;
            MetaProjectHeader theProgram = null;
            try {
                theProgram = this.theDesignCockpit.getProgramMetadata();
            }
            catch (HammerException e1) {
                return;
            }
            if (theSuperClass == null) {
                String sNewClassName = "newClass";
                MetaClassDetail theClassMetadata = new MetaClassDetail(sNewClassName, sNewClassName);
                theSubClass = new MetaClass(theClassMetadata, null, this.theDesignCockpit.getDesignProject().theMetaProject.getMetadataDispenser(), true);
                this.theDesignCockpit.getDesignProject().theMetaProject.addClass(theSubClass);
            } else {
                theSubClass = theSuperClass.subclassClass(theProgram.sPackageName, this.theDesignCockpit.getMode());
            }
            if (theSubClass != null) {
                this.addClass(theSubClass);
                if (theSuperClass == null) {
                    this.theDesignCockpit.getDesignProject().theMetaProject.addInstanceTracker(theSubClass);
                } else {
                    MetaClass theSuperClassTracker = this.theDesignCockpit.getDesignProject().theMetaProject.findInstanceTracker(theSuperClass.getMetadata().sClassName);
                    theSuperClassTracker.addInstanceTracker(theSubClass);
                }
            }
        }
    }

    public void resetContents() {
        this.baseClass.removeAllChildren();
        this.theTreeModel = new DefaultTreeModel((TreeNode)this.baseClass);
        this.theTree.setModel(this.theTreeModel);
    }

    public void clearSelection(IDEComponentPaletteNode theNode) {
        if (theNode.getChildCount() != 0) {
            for (theNode = (IDEComponentPaletteNode)theNode.getFirstChild(); theNode != null; theNode = (IDEComponentPaletteNode)theNode.getNextSibling()) {
                theNode.setSelected(false);
                this.clearSelection(theNode);
            }
        }
    }

    public void clearSelection() {
        IDEComponentPaletteNode theNode = this.baseClass;
        if (theNode != null && theNode.getChildCount() != 0) {
            for (theNode = (IDEComponentPaletteNode)theNode.getFirstChild(); theNode != null; theNode = (IDEComponentPaletteNode)theNode.getNextSibling()) {
                theNode.setSelected(false);
                this.clearSelection(theNode);
            }
        }
        this.repaint();
    }

    int countSelections(IDEComponentPaletteNode theNode, int iInitValue) {
        int iSelectionCount = iInitValue;
        while (theNode != null) {
            if (theNode.isSelected()) {
                ++iSelectionCount;
            }
            if (theNode.getChildCount() != 0) {
                iSelectionCount = this.countSelections((IDEComponentPaletteNode)theNode.getFirstChild(), iSelectionCount);
            }
            theNode = (IDEComponentPaletteNode)theNode.getNextSibling();
        }
        return iSelectionCount;
    }

    int collectSelections(IDEComponentPaletteNode theNode, int iIndex, MetaClass[] theSelections) {
        while (theNode != null) {
            if (theNode.isSelected()) {
                theSelections[iIndex++] = theNode.getMetaClass();
            }
            if (theNode.getChildCount() != 0) {
                iIndex = this.collectSelections((IDEComponentPaletteNode)theNode.getFirstChild(), iIndex, theSelections);
            }
            theNode = (IDEComponentPaletteNode)theNode.getNextSibling();
        }
        return iIndex;
    }

    MetaClass[] getSelections() {
        IDEComponentPaletteNode theCurrentNode = (IDEComponentPaletteNode)this.baseClass.getFirstChild();
        int iSelectionCount = this.countSelections(theCurrentNode, 0);
        MetaClass[] theSelections = new MetaClass[iSelectionCount];
        this.collectSelections(theCurrentNode, 0, theSelections);
        return theSelections;
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            IDEComponentPaletteNode node = (IDEComponentPaletteNode)e.getTreePath().getLastPathComponent();
            try {
                int index = e.getChildIndices()[0];
                node = (IDEComponentPaletteNode)node.getChildAt(index);
                node.getMetaClass().getMetadata().sClassName = (String)node.getUserObject();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    class ComponentPaletteKeyListener
    extends KeyAdapter {
        IDEComponentPalettePane theComponentPalettePane = null;

        public ComponentPaletteKeyListener(IDEComponentPalettePane objComponentPalettePane) {
            this.theComponentPalettePane = objComponentPalettePane;
        }

        public void keyPressed(KeyEvent e) {
            if (this.theComponentPalettePane.theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER) {
                if (e.getKeyCode() == 127) {
                    IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)this.theComponentPalettePane.theTree.getLastSelectedPathComponent();
                    this.theComponentPalettePane.removeNode(theSelectedNode);
                }
            }
        }
    }

    class ComponentPaletteMouseListener
    implements MouseListener {
        SuperDesignCockpit theDesignCockpit = null;

        public ComponentPaletteMouseListener(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void mouseClicked(MouseEvent evt) {
            if (this.theDesignCockpit.isCustomizing()) {
                return;
            }
            if (this.theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER && evt.getClickCount() == 2) {
                IDEComponentPalette theComponentPalette = (IDEComponentPalette)evt.getSource();
                theComponentPalette.PopupClassTool();
            }
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            this.showPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.showPopup(evt);
        }

        private void showPopup(MouseEvent evt) {
            if (this.theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER && evt.isPopupTrigger() && IDEComponentPalettePane.this.popupMenu != null) {
                IDEComponentPalettePane.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    class HelpAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public HelpAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public HelpAction(String label, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class SaveMetadataAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public SaveMetadataAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public SaveMetadataAction(String label, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.theCurrentDesignProject.theMetaProject.getMetadataDispenser().theMetadataDocument.writeMetaDocument();
        }
    }

    class EditClassAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public EditClassAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public EditClassAction(String label, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEComponentPalettePane.this.theTree.PopupClassTool();
        }
    }

    class DeleteClassAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public DeleteClassAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public DeleteClassAction(String label, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)IDEComponentPalettePane.this.theTree.getLastSelectedPathComponent();
            if (theSelectedNode != null) {
                IDEComponentPalettePane.this.removeNode(theSelectedNode);
            }
        }
    }

    class AddClassAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public AddClassAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public AddClassAction(String label, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)IDEComponentPalettePane.this.theTree.getLastSelectedPathComponent();
            if (theSelectedNode != null) {
                IDEComponentPalettePane.this.newClassNode();
            }
        }
    }
}

