/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDEComponentPalette;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.IDEComponentPaletteNode;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class IDEComponentPaletteSelectionListener
implements TreeSelectionListener {
    SuperDesignCockpit theDesignCockpit;
    IDEComponentPaletteNode theLastSelectedNodeForDragging = null;

    public IDEComponentPaletteSelectionListener(IDEComponentPalette theTree) {
        this.theDesignCockpit = theTree.theCockpit;
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath thePath = evt.getPath();
        JComponent theComponent = (JComponent)evt.getSource();
        IDEComponentPalette theTree = (IDEComponentPalette)((Object)theComponent);
        IDEComponentPaletteNode theSelectedNode = (IDEComponentPaletteNode)thePath.getLastPathComponent();
        theTree.clearDragErrorCondition();
        if (theSelectedNode != null && theSelectedNode.isCustomizerDataElement() && theSelectedNode.isCustomizerDataElementGroup()) {
            theTree.setSelectedNode(theSelectedNode);
            this.theDesignCockpit.setMouseSelectState(false);
            return;
        }
        if (theSelectedNode.equals(this.theLastSelectedNodeForDragging)) {
            if (theSelectedNode != null && theSelectedNode.getMetaClass() != null) {
                if (theSelectedNode.getChildCount() == 0) {
                    theTree.setSelectedNode(theSelectedNode);
                    this.theDesignCockpit.setMouseSelectState(false);
                }
                return;
            }
        } else {
            this.theLastSelectedNodeForDragging = theSelectedNode;
        }
        if (theSelectedNode != null && theSelectedNode.getMetaClass() != null) {
            int iContainerType = theSelectedNode.getMetaClass().getMetadata().containerType.getContainerType();
            if (this.theDesignCockpit.getDesignProject().getFirstObject() == null) {
                if (iContainerType != 5 && iContainerType != 3) {
                    theTree.setDragErrorCondition(1);
                }
            } else if (iContainerType == 5) {
                theTree.setDragErrorCondition(2);
            } else if (iContainerType == 7) {
                theTree.setDragErrorCondition(3);
            }
            int iError = theTree.getDragErrorCondition();
            theTree.setSelectedNode(null);
            int iChildCount = theSelectedNode.getChildCount();
            if (iError == 0) {
                if (iChildCount > 0) {
                    this.theDesignCockpit.setMouseSelectState(true);
                    theTree.setDragErrorCondition(IDEComponentPalette.INVALID_SELECTION);
                } else {
                    this.theDesignCockpit.setMouseSelectState(false);
                    theTree.setSelectedNode(theSelectedNode);
                }
            }
        }
    }
}

