/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignProject;
import ch.abacus.designcockpit.ide.IDEMultiSelectMenu;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JAScrollingPanel;
import ch.abacus.lib.ui.renderer.common.AbaMetaDataUser;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaCloneMode;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public class IDEObjectPopupMenu
extends JPopupMenu {
    public MetaObject theTarget = null;
    JMenuItem copySelectedObjectItem;
    JMenuItem cutSelectedObjectItem;
    JMenuItem deleteSelectedObjectItem;
    JMenuItem pasteSelectedObjectItem;
    JMenuItem foregroundColorItem;
    JMenuItem backgroundColorItem;
    JMenuItem fontItem;
    JMenuItem classSpecificItem;
    JMenu addPaneMenu;
    JMenu copyObjectMenu;
    JMenu addJMenuMenu;
    JMenu addJMenuItemMenu;
    JMenuItem addJMenuSeparator;
    JMenuItem scrollingPanelItem;
    JMenu addJToolBarComponents;
    IDEMultiSelectMenu multiSelectMenu;
    AbstractAction copySelectedObjectAction;
    AbstractAction copySelectedObjectActionNested;
    AbstractAction copySelectedObjectActionWithoutCode;
    CutSelectedObjectAction cutSelectedObjectAction;
    AbstractAction deleteSelectedObjectAction;
    AbstractAction classSpecificAction;
    ExpandContractAction expandContractAction;
    SuperDesignCockpit theDesignCockpit = null;
    public Point ptLastPopupLocation = new Point(0, 0);
    public Point ptActualStrikePoint = new Point(0, 0);
    private JMenuItem expandContractItem;
    private JMenuItem splitVerticalItem;
    private JMenuItem splitHorizontalItem;
    AbstractAction splitVerticalAction;
    AbstractAction splitHorizontalAction;

    public IDEObjectPopupMenu(SuperDesignCockpit objDesignCockpit) {
        String sLabel;
        this.theDesignCockpit = objDesignCockpit;
        if (this.theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER) {
            this.copySelectedObjectActionNested = this.theDesignCockpit.theActionManager.createCopySelectedObjectAction("Full Copy (Object and Child Objects - with code)", this.theDesignCockpit, 0);
            this.copySelectedObjectAction = this.theDesignCockpit.theActionManager.createCopySelectedObjectAction("Copy Object (with code)", this.theDesignCockpit, 1);
            this.copySelectedObjectActionWithoutCode = this.theDesignCockpit.theActionManager.createCopySelectedObjectAction("Copy Object (without code)", this.theDesignCockpit, 2);
            this.copyObjectMenu = new JMenu("Copy Object");
            this.copyObjectMenu.add(new JMenuItem(this.copySelectedObjectActionNested));
            this.copyObjectMenu.add(new JMenuItem(this.copySelectedObjectAction));
            this.copyObjectMenu.add(new JMenuItem(this.copySelectedObjectActionWithoutCode));
        } else {
            sLabel = this.theDesignCockpit.theActionManager.getCopyAction().getLabel();
            this.copySelectedObjectAction = this.theDesignCockpit.theActionManager.createCopySelectedObjectAction(sLabel, this.theDesignCockpit, 0);
            this.copySelectedObjectItem = new JMenuItem(this.copySelectedObjectAction);
            this.copySelectedObjectItem.setMnemonic(this.theDesignCockpit.theActionManager.getCopyAction().getMnemonicKey());
        }
        sLabel = this.theDesignCockpit.theActionManager.getCutAction().getLabel();
        this.cutSelectedObjectAction = new CutSelectedObjectAction(sLabel, this.theDesignCockpit.cutIcon, this.theDesignCockpit);
        this.deleteSelectedObjectAction = this.theDesignCockpit.theActionManager.getDeleteAction();
        this.classSpecificAction = this.theDesignCockpit.theActionManager.getClassEditorAction();
        this.expandContractAction = new ExpandContractAction(this.theDesignCockpit);
        this.splitVerticalAction = this.theDesignCockpit.theActionManager.getInsertVertSplitterAction();
        this.splitHorizontalAction = this.theDesignCockpit.theActionManager.getInsertHorzSplitterAction();
        this.scrollingPanelItem = new JMenuItem(this.expandContractAction);
        this.cutSelectedObjectItem = new JMenuItem(this.cutSelectedObjectAction);
        this.cutSelectedObjectItem.setMnemonic(this.theDesignCockpit.theActionManager.getCutAction().getMnemonicKey());
        this.pasteSelectedObjectItem = new JMenuItem(this.theDesignCockpit.theActionManager.getPasteSelectedObjectAction());
        this.deleteSelectedObjectItem = new JMenuItem(this.deleteSelectedObjectAction);
        if (this.theDesignCockpit.theActionManager.getForegroundColorChooserAction() != null) {
            this.foregroundColorItem = new JMenuItem(this.theDesignCockpit.theActionManager.getForegroundColorChooserAction());
        }
        if (this.theDesignCockpit.theActionManager.getBackgroundColorChooserAction() != null) {
            this.backgroundColorItem = new JMenuItem(this.theDesignCockpit.theActionManager.getBackgroundColorChooserAction());
        }
        this.classSpecificItem = new JMenuItem(this.classSpecificAction);
        this.expandContractItem = new JMenuItem(this.expandContractAction);
        this.splitVerticalItem = new JMenuItem(this.splitVerticalAction);
        this.splitHorizontalItem = new JMenuItem(this.splitHorizontalAction);
        this.addPaneMenu = new JMenu(this.theDesignCockpit.theLanguageManager.getMessage("ContextMenu.AddPane.label", "Add Pane"));
        if (this.theDesignCockpit.theActionManager.getFontChooserAction() != null) {
            this.fontItem = new JMenuItem(this.theDesignCockpit.theActionManager.getFontChooserAction());
        }
        this.multiSelectMenu = new IDEMultiSelectMenu(this.theDesignCockpit);
        this.addJMenuMenu = new JMenu("Add Menu");
        this.addJMenuItemMenu = new JMenu("Add MenuItem");
        this.addJMenuSeparator = new JMenu("Add Separator");
        this.addJToolBarComponents = new JMenu("Add Components");
    }

    public Point getLastPopupLocation() {
        return this.ptLastPopupLocation;
    }

    public Point getActualStrikePoint() {
        return this.ptActualStrikePoint;
    }

    public void addTabPageClasses(JMenu theAddPaneMenu, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            if (theClass.getFirstClass() != null) {
                this.addTabPageClasses(theAddPaneMenu, theClass.getFirstClass(), theObject);
            }
            if (theClass.getMetadata().containerType.getContainerType() == 7) {
                String sItemText = this.theDesignCockpit.theLanguageManager.expandMessage("ContextMenu.AddPane.Add.label", "Add {0}", theClass.getMetadata().sClassName);
                AddPaneAction theAction = new AddPaneAction(sItemText, theClass.getMetadata().sClassName, this.theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddPaneMenu.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }

    public void addJMenuClasses(JMenu theAddJMenuBarMenu, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            if (theClass.getFirstClass() != null) {
                this.addJMenuClasses(theAddJMenuBarMenu, theClass.getFirstClass(), theObject);
            }
            if (theClass.getMetadata().containerType.getContainerType() == 12) {
                String sItemText = "Add " + theClass.getMetadata().sClassName;
                AddJMenuAction theAction = new AddJMenuAction(sItemText, theClass.getMetadata().sClassName, this.theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddJMenuBarMenu.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }

    public void addJToolBarClasses(JMenu theAddJToolBar, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            if (theClass.getFirstClass() != null) {
                this.addJToolBarClasses(theAddJToolBar, theClass.getFirstClass(), theObject);
            }
            if (theClass.getMetadata().sClassName.equalsIgnoreCase("JToolBarButton")) {
                String sItemText = "Add " + theClass.getMetadata().sClassName;
                AddJToolBarAction theAction = new AddJToolBarAction(sItemText, theClass.getMetadata().sClassName, this.theDesignCockpit);
                JMenuItem theItem = new JMenuItem(theAction);
                theAddJToolBar.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }

    public void addJItemMenuClasses(JMenuItem theAddJMenuMenu, MetaClass theClass, MetaObject theObject) {
        while (theClass != null) {
            JMenuItem theItem;
            AddJMenuAction theAction;
            String sItemText;
            if (theClass.getFirstClass() != null) {
                this.addJItemMenuClasses(theAddJMenuMenu, theClass.getFirstClass(), theObject);
            }
            if (theClass.getMetadata().containerType.getContainerType() == 13) {
                sItemText = "Add " + theClass.getMetadata().sClassName;
                theAction = new AddJMenuAction(sItemText, theClass.getMetadata().sClassName, this.theDesignCockpit);
                theItem = new JMenuItem(theAction);
                theAddJMenuMenu.add(theItem);
            } else if (theClass.getMetadata().sClassName.equalsIgnoreCase("JSeparator")) {
                sItemText = "Add " + theClass.getMetadata().sClassName;
                theAction = new AddJMenuAction(sItemText, theClass.getMetadata().sClassName, this.theDesignCockpit);
                theItem = new JMenuItem(theAction);
                theAddJMenuMenu.add(theItem);
            }
            theClass = theClass.getNextSibling();
        }
    }

    public void show(Component thePlaceToDisplay, int x, int y, MetaObject theTarget) {
        int lastComponentIndex;
        Component component;
        MetaClass theClass;
        MetaObject theObject = theTarget;
        this.theTarget = theTarget;
        this.removeAll();
        if (theObject != null && theObject.theVisualObject != null && theObject.theVisualObject instanceof JAScrollingPanel) {
            this.expandContractItem.setText(((JAScrollingPanel)theObject.theVisualObject).getExpansionState() ? "Reduce" : "Expand");
            this.insert(this.expandContractItem, 0);
        }
        if (theObject != null && (theObject.isFrame() || theObject.isTabPage() || theObject.isPanel())) {
            this.insert(this.splitVerticalItem, 0);
            this.insert(this.splitHorizontalItem, 0);
        }
        if (theObject != null && theObject.isTabbedPane()) {
            JMenuItem itemTabControlEditor = new JMenuItem(new AddTabControlEditorActionAction(this.theDesignCockpit));
            this.insert(itemTabControlEditor, 0);
            this.insert(this.addPaneMenu, 0);
            this.addPaneMenu.removeAll();
            MetaClass theClass2 = this.theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            this.addTabPageClasses(this.addPaneMenu, theClass2, theObject);
        } else if (theObject != null && theObject.isJMenuBar()) {
            this.insert(this.addJMenuMenu, 0);
            this.addJMenuMenu.removeAll();
            theClass = this.theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            this.addJMenuClasses(this.addJMenuMenu, theClass, theObject);
        } else if (theObject != null && theObject.isJMenu()) {
            this.insert(this.addJMenuItemMenu, 0);
            this.addJMenuItemMenu.removeAll();
            theClass = this.theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            this.addJItemMenuClasses(this.addJMenuItemMenu, theClass, theObject);
        } else if (theObject != null && theObject.isJToolBar()) {
            this.insert(this.addJToolBarComponents, 0);
            this.addJToolBarComponents.removeAll();
            theClass = this.theDesignCockpit.theCurrentDesignProject.theMetaProject.getFirstClass();
            this.addJToolBarClasses(this.addJToolBarComponents, theClass, theObject);
        }
        if (theObject != null && theObject.theClass.getMetadata().theDesignEditor != null) {
            this.insert(this.classSpecificItem, 0);
        }
        this.addSeparator();
        this.add(this.cutSelectedObjectItem);
        if (this.theDesignCockpit.theProgramMode == SuperDesignCockpit.JAVABUILDER) {
            this.add(this.copyObjectMenu);
        } else {
            this.add(this.copySelectedObjectItem);
        }
        this.add(this.pasteSelectedObjectItem);
        this.add(this.deleteSelectedObjectItem);
        this.addSeparator();
        if (this.theDesignCockpit.theCurrentDesignProject.getSelectedObjectCount() > 1) {
            this.add(this.multiSelectMenu);
        } else {
            if (this.foregroundColorItem != null) {
                this.add(this.foregroundColorItem);
            }
            if (this.backgroundColorItem != null) {
                this.add(this.backgroundColorItem);
            }
            if (this.fontItem != null) {
                this.add(this.fontItem);
            }
        }
        if (this.theDesignCockpit.isCustomizing()) {
            this.theDesignCockpit.theCustomizer.addToContextMenu(this, theTarget);
        }
        if ((component = this.getComponent(lastComponentIndex = this.getComponentCount() - 1)) instanceof JSeparator) {
            this.remove(lastComponentIndex);
        }
        super.show(thePlaceToDisplay, x, y);
    }

    class CutSelectedObjectAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;
        MetaCloneMode theMode;

        public CutSelectedObjectAction(String label, Icon icon, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.theMode = new MetaCloneMode(0);
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            int i;
            DesignProject theSelectedProject = this.theDesignCockpit.getDesignProject();
            MetaObject theNewSelectedObject = null;
            if (theSelectedProject == null) {
                return;
            }
            this.theDesignCockpit.theClipboardController.removeAllClipboardObjects();
            ArrayList<MetaObject> objsToDelete = new ArrayList<MetaObject>(0);
            ArrayList<MetaObject> objsParents = new ArrayList<MetaObject>(0);
            for (i = 0; i < theSelectedProject.getSelectedObjectCount(); ++i) {
                if (i == 0) {
                    theNewSelectedObject = theSelectedProject.getSelectedObject((int)i).theParentObject;
                }
                objsToDelete.add(theSelectedProject.getSelectedObject(i));
                objsParents.add(theSelectedProject.getSelectedObject((int)i).theParentObject);
            }
            theSelectedProject.theUndoRedoController.createCutEvent(objsParents, objsToDelete);
            for (i = 0; i < theSelectedProject.getSelectedObjectCount(); ++i) {
                MetaObject theMetaObject = theSelectedProject.getSelectedObject(i);
                if (theMetaObject == null || theMetaObject.isFrame() || theMetaObject.isAbalet()) continue;
                this.theDesignCockpit.theClipboardController.addClipboardObject(theMetaObject.Clone(this.theMode, null, true));
                this.theDesignCockpit.theViewDisplayer.remove(theMetaObject.theVisualObject);
                this.theDesignCockpit.theObjectTreeViewPane.removeObject(theMetaObject);
                theSelectedProject.deselectObject(theMetaObject);
                --i;
                theMetaObject.DeleteObject(this.theDesignCockpit.theCurrentDesignProject.theMetaProject, (AbaMetaDataUser)this.theDesignCockpit);
            }
            this.theDesignCockpit.deselectObjects();
            this.theDesignCockpit.theClipboardController.setClipboardContent(2);
            this.theDesignCockpit.theClipboardController.theCloneMode = 0;
            this.theDesignCockpit.theClipboardController.setClipboardBufferingAction(this);
            theSelectedProject.deselectObjects();
            this.theDesignCockpit.SelectObject(theNewSelectedObject, false);
            this.theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class ExpandContractAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;

        public ExpandContractAction(SuperDesignCockpit theDesignCockpit) {
            this.theDesignCockpit = theDesignCockpit;
        }

        public void actionPerformed(ActionEvent e) {
            if (IDEObjectPopupMenu.this.theTarget.theVisualObject instanceof JAScrollingPanel) {
                JAScrollingPanel thePanel = (JAScrollingPanel)IDEObjectPopupMenu.this.theTarget.theVisualObject;
                boolean bExpansionState = thePanel.getExpansionState();
                if (bExpansionState) {
                    thePanel.reduce();
                } else {
                    thePanel.expand();
                }
            }
        }
    }

    class AddTabControlEditorActionAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;
        String sClassName;
        IDEObjectPopupMenu theMenu;

        public AddTabControlEditorActionAction(SuperDesignCockpit objDesignCockpit) {
            super(objDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.label", "Tab Control Editor"));
            this.theDesignCockpit = null;
            this.sClassName = null;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.showHelper(IDEObjectPopupMenu.this.theTarget, "TabTitle");
        }
    }

    class AddPaneAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;
        String sClassName;
        IDEObjectPopupMenu theMenu;

        public AddPaneAction(String label, Icon icon, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.sClassName = null;
            this.sClassName = theClassName;
            this.theDesignCockpit = objDesignCockpit;
        }

        public AddPaneAction(String label, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.sClassName = null;
            this.sClassName = theClassName;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.SelectObject(IDEObjectPopupMenu.this.theTarget, false);
            this.theDesignCockpit.theViewDisplayer.addObject(this.sClassName, null);
            JTabbedPane tabbedPane = (JTabbedPane)IDEObjectPopupMenu.this.theTarget.theVisualObject;
            tabbedPane.setSelectedIndex(tabbedPane.getTabCount() - 1);
            this.theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class AddJToolBarAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;
        String sClassName;
        IDEObjectPopupMenu theMenu;

        public AddJToolBarAction(String label, Icon icon, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.sClassName = null;
            this.sClassName = theClassName;
            this.theDesignCockpit = objDesignCockpit;
        }

        public AddJToolBarAction(String label, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.sClassName = null;
            this.sClassName = theClassName;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.SelectObject(IDEObjectPopupMenu.this.theTarget, false);
            this.theDesignCockpit.theViewDisplayer.addObject(this.sClassName, null);
            this.theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }

    class AddJMenuAction
    extends AbstractAction {
        SuperDesignCockpit theDesignCockpit;
        String sClassName;
        IDEObjectPopupMenu theMenu;

        public AddJMenuAction(String label, Icon icon, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label, icon);
            this.theDesignCockpit = null;
            this.sClassName = null;
            this.sClassName = theClassName;
            this.theDesignCockpit = objDesignCockpit;
        }

        public AddJMenuAction(String label, String theClassName, SuperDesignCockpit objDesignCockpit) {
            super(label);
            this.theDesignCockpit = null;
            this.sClassName = null;
            this.sClassName = theClassName;
            this.theDesignCockpit = objDesignCockpit;
        }

        public void actionPerformed(ActionEvent evt) {
            this.theDesignCockpit.SelectObject(IDEObjectPopupMenu.this.theTarget, false);
            this.theDesignCockpit.theViewDisplayer.addObject(this.sClassName, null);
            this.theDesignCockpit.getDesignProject().theMetaProject.setProjectChangedState(true);
        }
    }
}

