/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.LanguageManager;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.JALabel;
import ch.abacus.lib.ui.JAPanel;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class IDEStatusBar
extends JAPanel {
    private final SuperDesignCockpit theCockpit;
    private final LanguageManager theLanguageManager;
    JALabel theProjectName = new JALabel();
    JALabel theEditorStatus = new JALabel();
    JALabel theSelectedObject = new JALabel();
    JALabel theLanguage = new JALabel();

    public IDEStatusBar(SuperDesignCockpit theCockpit, LanguageManager theLanguageManager) {
        this.theCockpit = theCockpit;
        this.theLanguageManager = theLanguageManager;
        GridLayout theLayout = new GridLayout(1, 5, 20, 0);
        this.setLayout(theLayout);
        Border lineborder = BorderFactory.createLineBorder(Color.GRAY);
        CompoundBorder paddedLineBorder = BorderFactory.createCompoundBorder(lineborder, BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.setBorder(BorderFactory.createEmptyBorder(2, 1, 1, 1));
        this.theProjectName.setBorder((Border)paddedLineBorder);
        this.add((Component)this.theProjectName);
        this.theEditorStatus.setBorder((Border)paddedLineBorder);
        this.add((Component)this.theEditorStatus);
        this.theSelectedObject.setBorder((Border)paddedLineBorder);
        this.add((Component)this.theSelectedObject);
        this.theLanguage.setBorder((Border)paddedLineBorder);
        this.add((Component)this.theLanguage);
    }

    public void setLanguage(String sLanguage) {
        String sLanguageKey = "StatusBar.Language.label";
        String sMessage = "Language: {0}";
        this.theLanguage.setText(this.theLanguageManager.expandMessage(sLanguageKey, sMessage, sLanguage));
    }

    public void setProjectStatus(String sProjectName) {
        String sLanguageKey = "StatusBar.Project.label";
        String sDefaultMessage = "Project: {0}";
        this.theProjectName.setText(this.theLanguageManager.expandMessage(sLanguageKey, sDefaultMessage, sProjectName));
    }

    public void setEditorStatus(int iPos, int iRow, int iColumn) {
        String sLanguageKey = "StatusBar.TextPosition.label";
        String sMessage = "Pos: {0}, Row: {1}, Col: {2}";
        this.theEditorStatus.setText(this.theLanguageManager.expandMessage(sLanguageKey, sMessage, Integer.toString(iPos), Integer.toString(iRow), Integer.toString(iColumn)));
    }

    public void setSelectedObject(MetaObject theObject) {
        if (theObject == null) {
            String sLanguageKey = "StatusBar.ObjectClass.NoObjectSelected.label";
            String sDefaultMessage = "No Object Selected.";
            this.theSelectedObject.setText(this.theLanguageManager.getMessage(sLanguageKey, sDefaultMessage));
        } else {
            String sLanguageKey = "StatusBar.ObjectClass.label";
            String sDefaultMessage = "Object: {0}, Class: {1}";
            String sObjectName = theObject.getName();
            String sClassName = theObject.theClass.getMetadata().sClassName;
            this.theSelectedObject.setText(this.theLanguageManager.expandMessage(sLanguageKey, sDefaultMessage, sObjectName, sClassName));
        }
    }
}

