/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.IDETabControlEditorTable;
import ch.abacus.designcockpit.ide.IDETabPageDescriptor;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

class IDETabControlEditorTableModel
extends AbstractTableModel {
    MetaObject theMetaObject = null;
    ArrayList theTabPages = null;
    IDETabControlEditorTable theTable = null;
    int[] tabPageIndex = null;
    private final SuperDesignCockpit theDesignCockpit;

    public IDETabControlEditorTableModel(SuperDesignCockpit theDesignCockpit) {
        this.theDesignCockpit = theDesignCockpit;
    }

    public void setArrayIndex(int row, int value) {
        this.tabPageIndex[row] = value;
        TableModelEvent event = new TableModelEvent(this, row, row);
        this.theTable.tableChanged(event);
    }

    public int getRowCount() {
        if (this.theTabPages == null) {
            return 0;
        }
        return this.theTabPages.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        IDETabPageDescriptor theDescriptor = (IDETabPageDescriptor)this.theTabPages.get(row);
        if (theDescriptor != null) {
            if (column == 0) {
                theDescriptor.sObjectName = (String)theNewValue;
            } else {
                theDescriptor.sTitle = (String)theNewValue;
            }
        }
    }

    public Object getValueAt(int row, int column) {
        IDETabPageDescriptor theDescriptor = (IDETabPageDescriptor)this.theTabPages.get(row);
        if (theDescriptor != null) {
            if (column == 0) {
                return theDescriptor.sObjectName;
            }
            return theDescriptor.sTitle;
        }
        return "";
    }

    public Class getColumnClass(int iColumn) {
        String theClassName = "";
        return theClassName.getClass();
    }

    public boolean isCellEditable(int row, int column) {
        return column != 0;
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0) {
            return this.theDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.TabName.label", "Tab Page Name");
        }
        return this.theDesignCockpit.theLanguageManager.getMessage("TabControlEditorDialog.TabTitle.label", "Title (NLS = [Right Click])");
    }

    protected void Load(IDETabControlEditorTable objTable) {
        this.theTabPages = new ArrayList();
        if (this.theMetaObject != null) {
            MetaObject thePage = this.theMetaObject.theFirstChild;
            int iPage = 0;
            while (thePage != null) {
                MetaPropertyValueEx pvValue = this.theMetaObject.getPropertyValue("TabTitle", iPage++);
                String theTitle = "";
                if (pvValue != null) {
                    theTitle = new String(pvValue.getStringValue());
                }
                IDETabPageDescriptor theDescriptor = new IDETabPageDescriptor(thePage, theTitle, thePage.getName());
                this.theTabPages.add(theDescriptor);
                thePage = thePage.theNextObject;
            }
        }
    }

    protected void clear() {
        this.theTabPages = new ArrayList();
    }
}

