/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.external.IDEFocusRequester;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class IDEViewDisplayerComponentKeyListener
implements KeyListener {
    MetaObject theDesignObject;
    SuperDesignCockpit theDesignCockpit;

    public IDEViewDisplayerComponentKeyListener(MetaObject objDesignObject) {
        this.theDesignObject = objDesignObject;
        this.theDesignCockpit = (SuperDesignCockpit)objDesignObject.theDesignProject.getMetaDataUser();
    }

    public void keyPressed(KeyEvent evt) {
        int keyEventCode = evt.getKeyCode();
        if (evt.isControlDown()) {
            this.moveSelectedObjects(evt);
        } else if (evt.isShiftDown()) {
            this.changeObjectOrder(keyEventCode);
        } else {
            this.navigateToAnotherObject(keyEventCode);
        }
        evt.consume();
    }

    public void keyReleased(KeyEvent evt) {
        evt.consume();
    }

    public void keyTyped(KeyEvent evt) {
        evt.consume();
    }

    private void moveSelectedObjects(KeyEvent evt) {
        int xDistance = 1;
        int yDistance = 1;
        if (evt.isShiftDown()) {
            xDistance = this.theDesignCockpit.thePreferences.iViewDisplayerGridX;
            yDistance = this.theDesignCockpit.thePreferences.iViewDisplayerGridY;
        }
        switch (evt.getKeyCode()) {
            case 38: {
                this.moveByDistance(0, -yDistance);
                break;
            }
            case 40: {
                this.moveByDistance(0, yDistance);
                break;
            }
            case 37: {
                this.moveByDistance(-xDistance, 0);
                break;
            }
            case 39: {
                this.moveByDistance(xDistance, 0);
                break;
            }
            case 36: {
                this.moveByDistance(-xDistance, -yDistance);
                break;
            }
            case 33: {
                this.moveByDistance(xDistance, -yDistance);
                break;
            }
            case 34: {
                this.moveByDistance(-xDistance, yDistance);
                break;
            }
            case 35: {
                this.moveByDistance(xDistance, yDistance);
            }
        }
    }

    private void changeObjectOrder(int keyEventCode) {
        if (keyEventCode == 38) {
            this.theDesignCockpit.theObjectTreeViewPane.moveUp();
        } else if (keyEventCode == 40) {
            this.theDesignCockpit.theObjectTreeViewPane.moveDown();
        }
    }

    private void navigateToAnotherObject(int keyEventCode) {
        switch (keyEventCode) {
            case 38: {
                MetaObject newObject = null;
                if (this.theDesignObject.thePreviousObject != null) {
                    newObject = this.theDesignObject.thePreviousObject;
                } else if (this.theDesignObject.theParentObject != null) {
                    newObject = this.theDesignObject.theParentObject.theLastChild;
                }
                if (newObject == null) break;
                this.theDesignCockpit.deselectObjects();
                this.theDesignCockpit.SelectObject(newObject, false);
                IDEFocusRequester.requestFocus(newObject.theVisualObject);
                break;
            }
            case 40: {
                MetaObject newObject = null;
                if (this.theDesignObject.theNextObject != null) {
                    newObject = this.theDesignObject.theNextObject;
                } else if (this.theDesignObject.theParentObject != null) {
                    newObject = this.theDesignObject.theParentObject.theFirstChild;
                }
                if (newObject == null) break;
                this.theDesignCockpit.deselectObjects();
                this.theDesignCockpit.SelectObject(newObject, false);
                IDEFocusRequester.requestFocus(newObject.theVisualObject);
                break;
            }
            case 37: {
                MetaObject newObject = this.theDesignObject.theParentObject;
                if (newObject == null) break;
                this.theDesignCockpit.deselectObjects();
                this.theDesignCockpit.SelectObject(newObject, false);
                IDEFocusRequester.requestFocus(newObject.theVisualObject);
                break;
            }
            case 39: {
                MetaObject newObject = this.theDesignObject.theFirstChild;
                if (newObject == null) break;
                this.theDesignCockpit.deselectObjects();
                this.theDesignCockpit.SelectObject(newObject, false);
                IDEFocusRequester.requestFocus(newObject.theVisualObject);
            }
        }
    }

    private void repaintSizeboxesForMovedObject(MetaObject theObject) {
        Dimension dimSize = theObject.getSize();
        theObject.bAnchoringOff = true;
        if (!theObject.isAbalet() && !theObject.isFrame()) {
            this.theDesignCockpit.theSizeboxes.update(theObject, theObject.iXLocation, theObject.iYLocation, (int)dimSize.getWidth(), (int)dimSize.getHeight());
        }
    }

    private void moveByDistance(int xDistance, int yDistance) {
        int iNumSelectedObjects = this.theDesignCockpit.getDesignProject().getSelectedObjectCount();
        for (int iObject = 0; iObject < iNumSelectedObjects; ++iObject) {
            MetaObject theObject = this.theDesignCockpit.getDesignProject().getSelectedObject(iObject);
            Point ptLocation = theObject.getLocation();
            theObject.setLocation(ptLocation.x + xDistance, ptLocation.y + yDistance);
            this.repaintSizeboxesForMovedObject(theObject);
        }
        this.repaintSizeboxesForMovedObject(this.theDesignObject);
        this.theDesignCockpit.getPropertyInspectorController().refreshPropertyInspector();
    }
}

