/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LanguageManager {
    private final SuperDesignCockpit theCockpit;
    private HashMap theKeys = null;
    private ResourceBundle theFrameComponentsBundle = null;
    private ResourceBundle theActionsBundle = null;
    private ResourceBundle theDialogsBundle = null;
    private ResourceBundle theErrorsBundle = null;

    public LanguageManager(SuperDesignCockpit superDesignCockpit) {
        this.theCockpit = superDesignCockpit;
        if (this.theCockpit.isCustomizing()) {
            String sValue;
            String sKey;
            Enumeration<String> keys;
            String sLanguageId = null;
            Locale locale = null;
            this.theKeys = new HashMap();
            if (this.theCockpit.theGlobalInterface != null) {
                sLanguageId = this.theCockpit.theGlobalInterface.getLanguage().getISOCode();
                locale = new Locale(sLanguageId);
            }
            if (sLanguageId == null) {
                locale = Locale.getDefault();
            }
            try {
                this.theActionsBundle = ResourceBundle.getBundle(this.theCockpit.getCustomizerLanguagePath() + "actions", locale);
                keys = this.theActionsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    sKey = keys.nextElement();
                    sValue = this.theActionsBundle.getString(sKey);
                    this.theKeys.put(sKey, sValue);
                }
            }
            catch (MissingResourceException e) {
                this.theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'actions.properties', which is required to apply language translations");
            }
            try {
                this.theFrameComponentsBundle = ResourceBundle.getBundle(this.theCockpit.getCustomizerLanguagePath() + "frameComponents", locale);
                keys = this.theFrameComponentsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    sKey = keys.nextElement();
                    sValue = this.theFrameComponentsBundle.getString(sKey);
                    this.theKeys.put(sKey, sValue);
                }
            }
            catch (MissingResourceException e) {
                this.theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'frameComponents.properties', which is required to apply language translations");
            }
            try {
                this.theDialogsBundle = ResourceBundle.getBundle(this.theCockpit.getCustomizerLanguagePath() + "dialogs", locale);
                keys = this.theDialogsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    sKey = keys.nextElement();
                    sValue = this.theDialogsBundle.getString(sKey);
                    this.theKeys.put(sKey, sValue);
                }
            }
            catch (MissingResourceException e) {
                this.theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'dialogs.properties', which is required to apply language translations");
            }
            try {
                this.theErrorsBundle = ResourceBundle.getBundle(this.theCockpit.getCustomizerLanguagePath() + "errors", locale);
                keys = this.theErrorsBundle.getKeys();
                while (keys.hasMoreElements()) {
                    sKey = keys.nextElement();
                    sValue = this.theErrorsBundle.getString(sKey);
                    this.theKeys.put(sKey, sValue);
                }
            }
            catch (MissingResourceException e) {
                this.theCockpit.theLogFile.doLogEntry("Missing Language File", "Cannot find 'errors.properties', which is required to apply language translations");
            }
        }
    }

    public String expandMessage(String sLanguageKey, String sDefaultMessage, String arg1) {
        Object[] arguments = new Object[]{arg1};
        return this.expandMessage(sLanguageKey, sDefaultMessage, arguments);
    }

    public String expandMessage(String sLanguageKey, String sDefaultMessage, String arg1, String arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return this.expandMessage(sLanguageKey, sDefaultMessage, arguments);
    }

    public String expandMessage(String sLanguageKey, String sDefaultMessage, String arg1, String arg2, String arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return this.expandMessage(sLanguageKey, sDefaultMessage, arguments);
    }

    public String expandMessage(String sLanguageKey, String sDefaultMessage, Object[] arguments) {
        String sExpandedMessage = null;
        String sMessage = this.getMessage(sLanguageKey, sDefaultMessage);
        try {
            sExpandedMessage = MessageFormat.format(sMessage, arguments);
        }
        catch (IllegalArgumentException e) {
            this.theCockpit.theLogFile.doLogEntry("Could not format language message", "LanguageKey = " + sLanguageKey + " DefaultMessage = " + sDefaultMessage + " Message = " + sMessage);
            return sDefaultMessage;
        }
        return sExpandedMessage;
    }

    public String getMessage(String sLanguageKey, String sDefaultMessage) {
        if (this.theKeys == null) {
            return sDefaultMessage;
        }
        String sMessage = (String)this.theKeys.get(sLanguageKey);
        if (sMessage != null) {
            return sMessage;
        }
        return sDefaultMessage;
    }

    public ResourceBundle getFrameComponentsBundle() {
        return this.theFrameComponentsBundle;
    }

    public ResourceBundle getActionsBundle() {
        return this.theActionsBundle;
    }

    public ResourceBundle getDialogsBundle() {
        return this.theDialogsBundle;
    }

    public ResourceBundle getErrorsBundle() {
        return this.theErrorsBundle;
    }
}

