/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.MruMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

class MruList {
    private ArrayList list;
    private int maxFiles;
    private MruMenu menu;
    private boolean showMnemonics;
    private String mnemonics = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public MruList(int maxFiles) {
        this.list = new ArrayList(maxFiles);
        this.maxFiles = maxFiles;
    }

    public MruList(int maxFiles, boolean bShowMnemonics) {
        this(maxFiles);
        this.showMnemonics = bShowMnemonics;
    }

    public void fileOpened(String sFile) {
        if (this.isInList(sFile)) {
            this.removeFromList(sFile);
        }
        this.updateMenu();
    }

    public void fileClosed(String sFile) {
        if (this.isInList(sFile)) {
            this.removeFromList(sFile);
        }
        if (this.numberOfFiles() >= this.maxFiles) {
            this.removeOldestFile();
        }
        this.insertAtTop(sFile);
        this.updateMenu();
    }

    public void setShowMnemonics(boolean bShowMnemonics) {
        this.showMnemonics = bShowMnemonics;
        this.updateMenu();
    }

    public void setMnemonics(String mnemonics) {
        this.mnemonics = mnemonics;
        this.updateMenu();
    }

    public void clearList() {
        this.list.clear();
        this.updateMenu();
    }

    private void insertAtTop(String sFile) {
        this.list.add(0, sFile);
    }

    private boolean isInList(String sFile) {
        return this.list.contains(sFile);
    }

    private void removeFromList(String sFile) {
        this.list.remove(sFile);
    }

    private void removeOldestFile() {
        this.list.remove(this.list.size() - 1);
    }

    public void setMaxFiles(int iNewMaxFiles) {
        this.list.ensureCapacity(iNewMaxFiles);
        if (iNewMaxFiles < this.maxFiles) {
            this.list.subList(iNewMaxFiles, this.numberOfFiles()).clear();
        }
        this.list.trimToSize();
        this.maxFiles = iNewMaxFiles;
        this.updateMenu();
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public int numberOfFiles() {
        return this.list.size();
    }

    public ArrayList getArrayList() {
        return this.list;
    }

    public void setMruMenu(MruMenu menu) {
        this.menu = menu;
        this.updateMenu();
    }

    private void updateMenu() {
        int iPosition = 0;
        if (this.menu == null) {
            return;
        }
        this.menu.removeAll();
        if (this.numberOfFiles() == 0) {
            return;
        }
        Iterator li = this.list.iterator();
        JMenuItem[] items = new JMenuItem[this.numberOfFiles()];
        while (li.hasNext()) {
            String sFile = (String)li.next();
            File file = new File(sFile);
            String sMenuText = "";
            if (this.showMnemonics && iPosition < this.mnemonics.length()) {
                String sMnemonic = this.mnemonics.substring(iPosition, iPosition + 1);
                sMenuText = sMnemonic + "  " + file.getPath();
            } else {
                sMenuText = file.getPath();
            }
            items[iPosition] = new JMenuItem(sMenuText);
            items[iPosition].setToolTipText(sFile);
            items[iPosition].addActionListener(this.menu);
            if (this.showMnemonics && iPosition < this.mnemonics.length()) {
                char c = this.mnemonics.charAt(iPosition);
                items[iPosition].setMnemonic(c);
            }
            this.menu.add(items[iPosition]);
            ++iPosition;
        }
        JSeparator mruSeparator = new JSeparator();
        JMenuItem mruClear = new JMenuItem("Clear");
        mruClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MruList.this.clearList();
            }
        });
        this.menu.add(mruSeparator);
        this.menu.add(mruClear);
    }
}

