/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.DNDTree;
import ch.abacus.lib.ui.renderer.common.HammerImageIconFactory;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.ObjectTreeViewNode;
import java.awt.Component;
import java.awt.dnd.DragSourceDropEvent;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ObjectTreeView
extends DNDTree {
    public SuperDesignCockpit theCockpit = null;
    public DefaultTreeModel theModel = null;

    public ObjectTreeView(DefaultTreeModel objModel, SuperDesignCockpit objCockpit) {
        super((TreeModel)objModel);
        this.theCockpit = objCockpit;
        this.theModel = objModel;
        if (this.theCockpit.isCustomizing()) {
            this.setRootVisible(false);
        }
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            TreeNode fromParent = this.fromNode.getParent();
            TreeNode toParent = this.dropnode.getParent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.dropnode.getParent();
            int toIndex = parent.getIndex(this.dropnode);
            int fromIndex = parent.getIndex(this.fromNode);
            if (!this.dropnode.equals(this.fromNode) && fromParent.equals(toParent)) {
                ObjectTreeViewNode theParent = (ObjectTreeViewNode)toParent;
                MetaObject objParent = theParent.getMetaObject();
                MetaObject fromObj = ((ObjectTreeViewNode)this.fromNode).getMetaObject();
                if (fromObj.isTabPage()) {
                    return;
                }
                MetaObject toObj = ((ObjectTreeViewNode)this.dropnode).getMetaObject();
                objParent.theDesignProject.setProjectChangedState(true);
                MetaObject fromObjCurrentPrev = fromObj.thePreviousObject;
                MetaObject fromObjCurrentNext = fromObj.theNextObject;
                MetaObject toObjCurrentPrev = toObj.thePreviousObject;
                MetaObject toObjCurrentNext = toObj.theNextObject;
                MetaObject objFirst = objParent.theFirstChild;
                MetaObject objLast = objParent.theLastChild;
                if (fromObj.equals(objFirst)) {
                    objParent.theFirstChild = fromObjCurrentNext;
                }
                if (fromObj.equals(objLast)) {
                    objParent.theLastChild = fromObjCurrentPrev;
                }
                if (toObj.equals(objLast)) {
                    objParent.theLastChild = fromObj;
                }
                if (toObj.equals(objFirst)) {
                    objParent.theFirstChild = fromObj;
                }
                if (fromObjCurrentNext != null) {
                    fromObjCurrentNext.thePreviousObject = fromObjCurrentPrev;
                }
                if (fromObjCurrentPrev != null) {
                    fromObjCurrentPrev.theNextObject = fromObjCurrentNext;
                }
                if (fromIndex > toIndex) {
                    fromObj.thePreviousObject = toObjCurrentPrev;
                    fromObj.theNextObject = toObj;
                    toObj.thePreviousObject = fromObj;
                    if (toObjCurrentPrev != null) {
                        toObjCurrentPrev.theNextObject = fromObj;
                    }
                } else {
                    fromObj.thePreviousObject = toObj;
                    fromObj.theNextObject = toObjCurrentNext;
                    toObj.theNextObject = fromObj;
                    if (toObjCurrentNext != null) {
                        toObjCurrentNext.thePreviousObject = fromObj;
                    }
                }
                super.dragDropEnd(event);
                TreePath path = new TreePath(this.fromNode.getPath());
                if (path != null) {
                    this.setSelectionPath(path);
                }
                this.updateUI();
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.theCockpit != null) {
            this.setFolderIcons();
        }
    }

    public void setFolderIcons() {
        this.setCellRenderer(new TreeCellRenderer());
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
        renderer.setOpenIcon(this.theCockpit.folderCubeIcon);
        renderer.setClosedIcon(this.theCockpit.folderCubeIcon);
        renderer.setLeafIcon(this.theCockpit.CubeIcon);
    }

    class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        TreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ObjectTreeViewNode node = (ObjectTreeViewNode)value;
            MetaObject metaObject = node.getMetaObject();
            ImageIcon objClassIcon = null;
            HammerImageIconFactory theIconFactory = new HammerImageIconFactory(ObjectTreeView.this.theCockpit.getClassLoader());
            if (metaObject != null && !ObjectTreeView.this.theCockpit.isCustomizing()) {
                String metadataIcon = metaObject.theClass.getMetadata().sDisplayClassIcon;
                if (metadataIcon.compareTo("") != 0) {
                    objClassIcon = theIconFactory.getHammerImageIcon(metadataIcon);
                    this.setIcon(objClassIcon);
                }
            } else if (metaObject != null && ObjectTreeView.this.theCockpit.isCustomizing()) {
                if (ObjectTreeView.this.theCockpit.theCustomizer.getInstanceIcon(metaObject) == null) {
                    String metadataIcon = metaObject.theClass.getMetadata().sDisplayClassIcon;
                    if (metadataIcon.compareTo("") != 0) {
                        objClassIcon = theIconFactory.getHammerImageIcon(metadataIcon);
                        this.setIcon(objClassIcon);
                    }
                } else {
                    this.setIcon(ObjectTreeView.this.theCockpit.theCustomizer.getInstanceIcon(metaObject));
                }
                this.setText(ObjectTreeView.this.theCockpit.theCustomizer.getObjectDisplayName(metaObject));
            }
            return this;
        }
    }
}

