/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.LanguageManager;
import ch.abacus.designcockpit.ide.MetaPropertyDescriptorCollection;
import ch.abacus.designcockpit.ide.PropertyTable;
import ch.abacus.designcockpit.ide.SuperDesignCockpit;
import ch.abacus.lib.ui.renderer.common.MetaClass;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroup;
import ch.abacus.lib.ui.renderer.common.MetaConstantGroupCollection;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import ch.abacus.lib.ui.renderer.common.MetaProperty;
import ch.abacus.lib.ui.renderer.common.MetaPropertyDescriptor;
import ch.abacus.lib.ui.renderer.common.MetaPropertyValueEx;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class PropertyTableModel
extends AbstractTableModel {
    MetaObject theMetaObject = null;
    MetaClass theMetaClass = null;
    MetaPropertyDescriptorCollection theClassProperties = null;
    PropertyTable theTable = null;
    int iPropertyCount = 0;
    int[] propArrayIndex = null;
    private final SuperDesignCockpit theCockpit;

    public PropertyTableModel(SuperDesignCockpit theCockpit) {
        this.theCockpit = theCockpit;
    }

    public void setArrayIndex(int row, int value) {
        this.propArrayIndex[row] = value;
        TableModelEvent event = new TableModelEvent(this, row, row);
        this.theTable.tableChanged(event);
    }

    public int getRowCount() {
        if (this.theMetaObject != null) {
            return this.iPropertyCount;
        }
        return 0;
    }

    public int getColumnCount() {
        return 2;
    }

    int getArrayIndexFromString(String sIndex) {
        String sTest;
        int iMatch2;
        int iMatch1 = sIndex.lastIndexOf(91);
        if (iMatch1 != -1 && (iMatch2 = sIndex.lastIndexOf(93)) != -1 && (sTest = sIndex.substring(iMatch1 + 1, iMatch2)).trim().length() != 0) {
            return new Integer(sTest);
        }
        return -1;
    }

    public int getArrayIndex(int row) {
        String sIndex = (String)this.getValueAt(row, 0);
        return this.getArrayIndexFromString(sIndex);
    }

    private boolean isNameChangePermitted(String sNewName) {
        MetaObject mo = this.theTable.theDesignCockpit.getDesignProject().findObject(sNewName);
        return mo == null;
    }

    public void setValueAt(Object theNewValue, int row, int column) {
        String sMatch;
        MetaObject metaObject;
        String sNewName;
        if (this.propertyValueChangeDisallowed(theNewValue, row)) {
            return;
        }
        MetaObject theMetaObject = this.theTable.theDesignCockpit.getDesignProject().getLastObjectSelected();
        MetaPropertyDescriptor theProperty = this.theClassProperties.get(row);
        LanguageManager lm = this.theCockpit.theLanguageManager;
        if (theProperty.getName().equalsIgnoreCase("Name") && !this.isNameChangePermitted(sNewName = (String)theNewValue) && !(metaObject = this.theTable.theDesignCockpit.getDesignProject().findObject(sNewName)).getName().equalsIgnoreCase(theMetaObject.getName())) {
            MetaObject metaObjectParent = metaObject.theParentObject;
            String sMessage = metaObjectParent != null ? lm.expandMessage("DuplcateObjectNames.hasParent.label", "That name is already used by another object, which is a child of \"{0}\"", metaObject.theParentObject.getName()) : lm.getMessage("DuplcateObjectNames.noParent.label", "That name is already used by another object, the project's first object");
            String sTitle = lm.getMessage("DuplcateObjectNames.label", "Duplicate Object Name");
            JOptionPane.showMessageDialog((Component)((Object)this.theTable.theDesignCockpit), sMessage, sTitle, 0);
            return;
        }
        MetaConstantGroup theConstantTable = theMetaObject.theDesignProject.findConstantGroup(theProperty.getIncludeTypeConstants());
        MetaConstantGroupCollection theConstantTableGroup = null;
        if (theConstantTable != null) {
            if (theNewValue instanceof String && (sMatch = theConstantTable.get((String)theNewValue)) != null) {
                theNewValue = sMatch;
            }
        } else {
            theConstantTableGroup = theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
            if (theConstantTableGroup != null && theNewValue instanceof String && (sMatch = theConstantTableGroup.get((String)theNewValue)) != null) {
                theNewValue = sMatch;
            }
        }
        if (column != 0) {
            String sPropertyName = theProperty.getName();
            theMetaObject.theDesignProject.setProjectChangedState(true);
            if ((theMetaObject.isFrame() || theMetaObject.isAbalet()) && sPropertyName.startsWith("Location")) {
                theNewValue = new String("0");
            }
            MetaPropertyValueEx pvOldValue = theMetaObject.getPropertyValue(sPropertyName, 0);
            String sOldValue = null;
            if (pvOldValue != null) {
                sOldValue = pvOldValue.getStringValue();
            }
            String sNewReverseLookup = null;
            String sOldReverseLookup = null;
            if (theConstantTable != null) {
                sNewReverseLookup = theConstantTable.getKey((String)theNewValue);
                sOldReverseLookup = theConstantTable.getKey(sOldValue);
            } else if (theConstantTableGroup != null) {
                sNewReverseLookup = theConstantTableGroup.getKey((String)theNewValue);
                sOldReverseLookup = theConstantTableGroup.getKey(sOldValue);
            } else if (!theNewValue.equals(sOldValue)) {
                this.propertyEdited(theMetaObject, sPropertyName, theProperty.getOrder(), theNewValue);
                return;
            }
            if (!theNewValue.equals(sOldValue) && sNewReverseLookup != null && !sNewReverseLookup.equals(sOldReverseLookup)) {
                this.propertyEdited(theMetaObject, sPropertyName, theProperty.getOrder(), theNewValue);
            }
        }
    }

    private boolean propertyValueChangeDisallowed(Object theNewValue, int iRow) {
        MetaPropertyDescriptor theProperty = this.theClassProperties.get(iRow);
        if (theProperty.getClassName().equalsIgnoreCase("int") && theProperty.getIncludeTypeConstants() == null && theNewValue.getClass() == String.class) {
            try {
                Integer.parseInt((String)theNewValue);
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }

    public MetaPropertyDescriptor getPropertyAt(int row) {
        MetaPropertyDescriptor theProperty = this.theClassProperties.get(row);
        return theProperty;
    }

    public Object getValueAt(int row, int column) {
        Object oValue;
        MetaPropertyDescriptor theProperty = this.theClassProperties.get(row);
        if (theProperty == null) {
            return null;
        }
        String sPropertyName = theProperty.getName();
        if (column == 0) {
            if (theProperty.getName().equals("TableName")) {
                return "TableName = [Right Click]";
            }
            if (!theProperty.bAllowMultipleValues) {
                return theProperty.getName();
            }
            if (theProperty.getHelperClass() != null && theProperty.getHelperClass().length() > 0) {
                return theProperty.getName() + " = [Right Click]";
            }
            return theProperty.getName();
        }
        if ((this.theMetaObject.isFrame() || this.theMetaObject.isAbalet()) && sPropertyName.startsWith("Location")) {
            return new String("0");
        }
        int iDotPos = sPropertyName.indexOf(".");
        String sKey = sPropertyName;
        if (iDotPos != -1) {
            sKey = sPropertyName.substring(0, iDotPos);
        }
        String sType = theProperty.getClassName();
        MetaProperty theProp = this.theMetaObject.getPropertyMetadata(sKey);
        if (theProp == null) {
            if (!sType.endsWith("oolean") && theProperty.getDefaultValue() != null) {
                String sDefault = theProperty.getDefaultValue();
                Object oMatch = theProperty.getExpandedValue(this.theMetaObject.theDesignProject, sDefault);
                return oMatch;
            }
            return null;
        }
        int iIndex = 0;
        MetaPropertyValueEx pvValue = this.theMetaObject.getPropertyValue(sPropertyName, iIndex);
        MetaConstantGroup theConstantTable = this.theMetaObject.theDesignProject.findConstantGroup(theProperty.getIncludeTypeConstants());
        if (theConstantTable != null) {
            if (pvValue != null) {
                String sConstantValue = pvValue.getLocalString();
                String sMatch = theConstantTable.getKey(sConstantValue);
                if (sMatch != null) {
                    if (sType.endsWith("oolean")) {
                        return new Boolean(sMatch);
                    }
                    return sMatch;
                }
                return sConstantValue;
            }
        } else {
            MetaConstantGroupCollection theConstantTableCollection = this.theMetaObject.theDesignProject.findConstantGroupCollection(theProperty.getIncludeTypeConstants());
            if (theConstantTableCollection != null && pvValue != null) {
                String sConstantValue = pvValue.getLocalString();
                String sMatch = theConstantTableCollection.getKey(sConstantValue);
                if (sMatch != null) {
                    if (sType.endsWith("oolean")) {
                        return new Boolean(sMatch);
                    }
                    return sMatch;
                }
                return sConstantValue;
            }
        }
        if (pvValue == null) {
            oValue = theProperty.getDefaultValue();
            if (oValue == null) {
                oValue = theProperty.getValueChoice(0);
            }
        } else {
            oValue = pvValue.getNativeValue();
            return oValue;
        }
        pvValue = new MetaPropertyValueEx(sType, oValue, true, this.theMetaObject.theDesignProject, theProperty.bAllowMultipleLanguages);
        String sRetVal = pvValue.getStringValue();
        if (sType.endsWith("oolean")) {
            return new Boolean(sRetVal);
        }
        return sRetVal;
    }

    public Class getColumnClass(int iColumn) {
        String theClassName = "";
        return theClassName.getClass();
    }

    public Class getCellClass(int iRow, int iColumn) {
        String sClass;
        String sTextString = "";
        Class<?> cls = sTextString.getClass();
        MetaPropertyDescriptor theProperty = this.theClassProperties.get(iRow);
        if (iColumn != 0 && ((sClass = theProperty.getClassName().trim()).endsWith("Boolean") || sClass.equals("boolean"))) {
            Boolean obj = new Boolean(true);
            return obj.getClass();
        }
        return cls;
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        MetaPropertyDescriptor theProperty = this.getPropertyAt(row);
        return !theProperty.isReadOnly();
    }

    public String getColumnName(int iColumn) {
        if (iColumn == 0) {
            return this.theCockpit.theLanguageManager.getMessage("PropertyInspector.PropertyName.label", "Property");
        }
        return this.theCockpit.theLanguageManager.getMessage("PropertyInspector.PropertyValue.label", "Value");
    }

    protected MetaPropertyDescriptorCollection formatClassTable(MetaPropertyDescriptorCollection theClassProperties, MetaPropertyDescriptor theProperty, String thePrefix) {
        int iDotPos;
        if (thePrefix != null && (iDotPos = theProperty.getName().indexOf(".")) == -1) {
            theProperty.setName(thePrefix + "." + theProperty.getName());
        }
        if (theProperty.bVisible) {
            theClassProperties.add(theProperty);
        }
        if (theProperty.theFirstSubproperty != null) {
            for (MetaPropertyDescriptor theSubprop = theProperty.theFirstSubproperty; theSubprop != null; theSubprop = theSubprop.getNextProperty()) {
                theClassProperties = this.formatClassTable(theClassProperties, theSubprop, theProperty.getName());
            }
        }
        return theClassProperties;
    }

    protected void Load(PropertyTable objTable) {
        this.theTable = objTable;
        this.theMetaObject = this.theTable.theDesignCockpit.getDesignProject().getLastObjectSelected();
        if (this.theMetaObject == null) {
            return;
        }
        this.theMetaClass = this.theMetaObject.theClass;
        this.iPropertyCount = this.theMetaClass.getPropertyCount(true);
        this.theClassProperties = new MetaPropertyDescriptorCollection();
        while (this.theMetaClass != null) {
            for (MetaPropertyDescriptor theProperty = this.theMetaClass.getMetadata().theFirstProperty; theProperty != null; theProperty = theProperty.getNextProperty()) {
                this.theClassProperties = this.formatClassTable(this.theClassProperties, theProperty, null);
            }
            this.theMetaClass = this.theMetaClass.getParentClass();
        }
        this.theClassProperties.convert();
        this.iPropertyCount = this.theClassProperties.size();
        this.propArrayIndex = new int[this.iPropertyCount];
        for (int i = 0; i < this.iPropertyCount; ++i) {
            this.propArrayIndex[i] = 0;
        }
    }

    protected void clear() {
        this.iPropertyCount = 0;
        this.theClassProperties = null;
    }

    public void propertyEdited(MetaObject theMetaObject, String sPropertyName, int iOrder, Object theNewValue) {
        this.theTable.theDesignCockpit.getDesignProject().theUndoRedoController.createChangePropertyEvent(theMetaObject, sPropertyName, 0, 0);
        theMetaObject.setPropertyValue(sPropertyName, 0, iOrder, theNewValue, false);
        theMetaObject.refresh();
        if (theMetaObject.theClass.getMetadata().containerType.getContainerType() != 3) {
            if (theMetaObject.theVisualObject != null) {
                theMetaObject.theVisualObject.repaint();
            }
        } else if (theMetaObject.iMode == 1) {
            this.theTable.theDesignCockpit.getDesignProject().getMetaDataUser().propertyEditedRepaint(theMetaObject);
        }
    }
}

