/*
 * Decompiled with CFR 0.152.
 */
package ch.abacus.designcockpit.ide;

import ch.abacus.designcockpit.ide.DesignAnchoringLayoutManager;
import ch.abacus.designcockpit.ide.Sizebox;
import ch.abacus.lib.ui.renderer.common.MetaObject;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

class SizeboxMouseListener
implements MouseListener {
    Sizebox theSizebox = null;
    Cursor savedCursor1 = null;
    Cursor savedCursor2 = null;
    Cursor savedCursor3 = null;

    public SizeboxMouseListener(Sizebox objSizebox) {
        this.theSizebox = objSizebox;
    }

    Cursor getSizeboxCursor() {
        if (this.theSizebox.theOrientation == 0) {
            return new Cursor(8);
        }
        if (this.theSizebox.theOrientation == 4) {
            return new Cursor(9);
        }
        if (this.theSizebox.theOrientation == 7) {
            return new Cursor(6);
        }
        if (this.theSizebox.theOrientation == 1) {
            return new Cursor(7);
        }
        if (this.theSizebox.theOrientation == 5) {
            return new Cursor(4);
        }
        if (this.theSizebox.theOrientation == 3) {
            return new Cursor(5);
        }
        if (this.theSizebox.theOrientation == 2) {
            return new Cursor(11);
        }
        if (this.theSizebox.theOrientation == 6) {
            return new Cursor(10);
        }
        return null;
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
        this.theSizebox.setCursor(this.getSizeboxCursor());
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        LayoutManager lm;
        this.theSizebox.ptDragFrom = evt.getPoint();
        MetaObject theSelectedContainer = this.theSizebox.theDesignCockpit.getSelectedContainer();
        MetaObject metaParent = this.theSizebox.theMetaObject.theParentObject;
        if (metaParent != null && (lm = metaParent.getLayoutManager()) != null && lm instanceof DesignAnchoringLayoutManager) {
            ((DesignAnchoringLayoutManager)lm).bAnchoringEnabled = false;
        }
        if (theSelectedContainer != null && theSelectedContainer.theVisualObject != null) {
            this.savedCursor2 = theSelectedContainer.theVisualObject.getCursor();
            theSelectedContainer.theVisualObject.setCursor(this.getSizeboxCursor());
        }
        this.savedCursor3 = this.theSizebox.theDesignCockpit.theViewDisplayer.getCursor();
        this.theSizebox.theDesignCockpit.theViewDisplayer.setCursor(this.getSizeboxCursor());
    }

    public void mouseReleased(MouseEvent evt) {
        LayoutManager lm;
        MetaObject theSelectedContainer = this.theSizebox.theDesignCockpit.getSelectedContainer();
        MetaObject metaParent = this.theSizebox.theMetaObject.theParentObject;
        if (metaParent != null && (lm = metaParent.getLayoutManager()) != null && lm instanceof DesignAnchoringLayoutManager) {
            ((DesignAnchoringLayoutManager)lm).bAnchoringEnabled = true;
        }
        this.theSizebox.theMetaObject.bAnchoringOff = true;
        if (theSelectedContainer != null && theSelectedContainer.theVisualObject != null) {
            theSelectedContainer.theVisualObject.setCursor(this.savedCursor2);
        }
        this.theSizebox.theDesignCockpit.theViewDisplayer.setCursor(this.savedCursor3);
        this.savedCursor2 = null;
        this.savedCursor3 = null;
        JComponent comp = this.theSizebox.theMetaObject.theVisualObject;
        if (comp != null) {
            Point pt = comp.getLocation();
            Dimension dimSize = comp.getSize();
            boolean bResizeHorizontal = this.theSizebox.isResizingHorizontal();
            boolean bResizeVertical = this.theSizebox.isResizingVertical();
            this.theSizebox.theController.relocate(pt.x, pt.y, (int)dimSize.getWidth(), (int)dimSize.getHeight(), false, bResizeHorizontal, bResizeVertical);
            if (this.theSizebox.theController.theMetaObject.bResizing) {
                this.theSizebox.endResizing(this.theSizebox.theController.theMetaObject);
            }
        }
    }

    public void kill() {
        MetaObject theSelectedContainer = this.theSizebox.theDesignCockpit.getSelectedContainer();
        if (theSelectedContainer != null && theSelectedContainer.theVisualObject != null) {
            theSelectedContainer.theVisualObject.setCursor(this.savedCursor2);
        }
        if (this.theSizebox.theDesignCockpit.theViewDisplayer != null) {
            this.theSizebox.theDesignCockpit.theViewDisplayer.setCursor(this.savedCursor3);
        }
        this.savedCursor2 = null;
        this.savedCursor3 = null;
    }
}

